"use strict";
exports.id = 42040;
exports.ids = [42040];
exports.modules = {

/***/ 70106:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "f": () => (/* binding */ ANIME_KEYWORD_ID)
/* harmony export */ });
const ANIME_KEYWORD_ID = 210024;

/***/ }),

/***/ 59147:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DD": () => (/* binding */ MediaType),
/* harmony export */   "Jp": () => (/* binding */ MediaStatus),
/* harmony export */   "pi": () => (/* binding */ MediaRequestStatus)
/* harmony export */ });
let MediaRequestStatus;

(function (MediaRequestStatus) {
  MediaRequestStatus[MediaRequestStatus["PENDING"] = 1] = "PENDING";
  MediaRequestStatus[MediaRequestStatus["APPROVED"] = 2] = "APPROVED";
  MediaRequestStatus[MediaRequestStatus["DECLINED"] = 3] = "DECLINED";
  MediaRequestStatus[MediaRequestStatus["FAILED"] = 4] = "FAILED";
})(MediaRequestStatus || (MediaRequestStatus = {}));

let MediaType;

(function (MediaType) {
  MediaType["MOVIE"] = "movie";
  MediaType["TV"] = "tv";
})(MediaType || (MediaType = {}));

let MediaStatus;

(function (MediaStatus) {
  MediaStatus[MediaStatus["UNKNOWN"] = 1] = "UNKNOWN";
  MediaStatus[MediaStatus["PENDING"] = 2] = "PENDING";
  MediaStatus[MediaStatus["PROCESSING"] = 3] = "PROCESSING";
  MediaStatus[MediaStatus["PARTIALLY_AVAILABLE"] = 4] = "PARTIALLY_AVAILABLE";
  MediaStatus[MediaStatus["AVAILABLE"] = 5] = "AVAILABLE";
})(MediaStatus || (MediaStatus = {}));

/***/ }),

/***/ 59183:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61439);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80210);
/* harmony import */ var _app_utils_numberHelpers__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(49486);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _server_lib_permissions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(44941);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(61929);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__, _headlessui_react__WEBPACK_IMPORTED_MODULE_3__, swr__WEBPACK_IMPORTED_MODULE_10__]);
([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__, _headlessui_react__WEBPACK_IMPORTED_MODULE_3__, swr__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
/* eslint-disable react-hooks/exhaustive-deps */















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.defineMessages)({
  advancedoptions: {
    "id": "components.RequestModal.AdvancedRequester.advancedoptions",
    "defaultMessage": 'Advanced'
  },
  destinationserver: {
    "id": "components.RequestModal.AdvancedRequester.destinationserver",
    "defaultMessage": 'Destination Server'
  },
  qualityprofile: {
    "id": "components.RequestModal.AdvancedRequester.qualityprofile",
    "defaultMessage": 'Quality Profile'
  },
  rootfolder: {
    "id": "components.RequestModal.AdvancedRequester.rootfolder",
    "defaultMessage": 'Root Folder'
  },
  animenote: {
    "id": "components.RequestModal.AdvancedRequester.animenote",
    "defaultMessage": '* This series is an anime.'
  },
  default: {
    "id": "components.RequestModal.AdvancedRequester.default",
    "defaultMessage": '{name} (Default)'
  },
  folder: {
    "id": "components.RequestModal.AdvancedRequester.folder",
    "defaultMessage": '{path} ({space})'
  },
  requestas: {
    "id": "components.RequestModal.AdvancedRequester.requestas",
    "defaultMessage": 'Request As'
  },
  languageprofile: {
    "id": "components.RequestModal.AdvancedRequester.languageprofile",
    "defaultMessage": 'Language Profile'
  },
  tags: {
    "id": "components.RequestModal.AdvancedRequester.tags",
    "defaultMessage": 'Tags'
  },
  selecttags: {
    "id": "components.RequestModal.AdvancedRequester.selecttags",
    "defaultMessage": 'Select tags'
  },
  notagoptions: {
    "id": "components.RequestModal.AdvancedRequester.notagoptions",
    "defaultMessage": 'No tags.'
  }
});

const AdvancedRequester = ({
  type,
  is4k = false,
  isAnime = false,
  defaultOverrides,
  requestUser,
  onChange
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.useIntl)();
  const {
    user: currentUser,
    hasPermission: currentHasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .useUser */ .aF)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_10__["default"])(`/api/v1/service/${type === 'movie' ? 'radarr' : 'sonarr'}`, {
    refreshInterval: 0,
    refreshWhenHidden: false,
    revalidateOnFocus: false,
    revalidateOnMount: true
  });
  const {
    0: selectedServer,
    1: setSelectedServer
  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(defaultOverrides?.server !== undefined && defaultOverrides?.server >= 0 ? defaultOverrides?.server : null);
  const {
    0: selectedProfile,
    1: setSelectedProfile
  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(defaultOverrides?.profile ?? -1);
  const {
    0: selectedFolder,
    1: setSelectedFolder
  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(defaultOverrides?.folder ?? '');
  const {
    0: selectedLanguage,
    1: setSelectedLanguage
  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(defaultOverrides?.language ?? -1);
  const {
    0: selectedTags,
    1: setSelectedTags
  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(defaultOverrides?.tags ?? []);
  const {
    data: serverData,
    isValidating
  } = (0,swr__WEBPACK_IMPORTED_MODULE_10__["default"])(selectedServer !== null ? `/api/v1/service/${type === 'movie' ? 'radarr' : 'sonarr'}/${selectedServer}` : null, {
    refreshInterval: 0,
    refreshWhenHidden: false,
    revalidateOnFocus: false
  });
  const {
    0: selectedUser,
    1: setSelectedUser
  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(requestUser ?? null);
  const {
    data: userData
  } = (0,swr__WEBPACK_IMPORTED_MODULE_10__["default"])(currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS]) ? '/api/v1/user?take=1000&sort=displayname' : null);
  const filteredUserData = (0,react__WEBPACK_IMPORTED_MODULE_7__.useMemo)(() => userData?.results.filter(user => (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_5__/* .hasPermission */ .F)(is4k ? [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K, type === 'movie' ? _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K_MOVIE */ .y3.REQUEST_4K_MOVIE : _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K_TV */ .y3.REQUEST_4K_TV] : [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST */ .y3.REQUEST, type === 'movie' ? _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_MOVIE */ .y3.REQUEST_MOVIE : _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_TV */ .y3.REQUEST_TV], user.permissions, {
    type: 'or'
  })), [userData?.results]);
  (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    if (filteredUserData && !requestUser) {
      setSelectedUser(filteredUserData.find(u => u.id === currentUser?.id) ?? null);
    }
  }, [filteredUserData]);
  (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    let defaultServer = data?.find(server => server.isDefault && is4k === server.is4k);

    if (!defaultServer && (data ?? []).length > 0) {
      defaultServer = data?.[0];
    }

    if (defaultServer && defaultServer.id !== selectedServer && (!defaultOverrides || defaultOverrides.server === null)) {
      setSelectedServer(defaultServer.id);
    }
  }, [data]);
  (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    if (serverData) {
      const defaultProfile = serverData.profiles.find(profile => profile.id === (isAnime && serverData.server.activeAnimeProfileId ? serverData.server.activeAnimeProfileId : serverData.server.activeProfileId));
      const defaultFolder = serverData.rootFolders.find(folder => folder.path === (isAnime && serverData.server.activeAnimeDirectory ? serverData.server.activeAnimeDirectory : serverData.server.activeDirectory));
      const defaultLanguage = serverData.languageProfiles?.find(language => language.id === (isAnime && serverData.server.activeAnimeLanguageProfileId ? serverData.server.activeAnimeLanguageProfileId : serverData.server.activeLanguageProfileId));
      const defaultTags = isAnime ? serverData.server.activeAnimeTags : serverData.server.activeTags;
      const applyOverrides = defaultOverrides && (defaultOverrides.server === null && serverData.server.isDefault || defaultOverrides.server === serverData.server.id);

      if (defaultProfile && defaultProfile.id !== selectedProfile && (!applyOverrides || defaultOverrides.profile === null)) {
        setSelectedProfile(defaultProfile.id);
      }

      if (defaultFolder && defaultFolder.path !== selectedFolder && (!applyOverrides || !defaultOverrides.folder)) {
        setSelectedFolder(defaultFolder.path ?? '');
      }

      if (defaultLanguage && defaultLanguage.id !== selectedLanguage && (!applyOverrides || defaultOverrides.language === null)) {
        setSelectedLanguage(defaultLanguage.id);
      }

      if (defaultTags && !(0,lodash__WEBPACK_IMPORTED_MODULE_6__.isEqual)(defaultTags, selectedTags) && (!applyOverrides || defaultOverrides.tags === null)) {
        setSelectedTags(defaultTags);
      }
    }
  }, [serverData]);
  (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    if (defaultOverrides && defaultOverrides.server != null) {
      setSelectedServer(defaultOverrides.server);
    }

    if (defaultOverrides && defaultOverrides.profile != null) {
      setSelectedProfile(defaultOverrides.profile);
    }

    if (defaultOverrides && defaultOverrides.folder) {
      setSelectedFolder(defaultOverrides.folder);
    }

    if (defaultOverrides && defaultOverrides.language != null) {
      setSelectedLanguage(defaultOverrides.language);
    }

    if (defaultOverrides && defaultOverrides.tags != null) {
      setSelectedTags(defaultOverrides.tags);
    }
  }, [defaultOverrides?.server, defaultOverrides?.folder, defaultOverrides?.profile, defaultOverrides?.language, defaultOverrides?.tags]);
  (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    if (selectedServer !== null || selectedUser) {
      onChange({
        folder: selectedFolder !== '' ? selectedFolder : undefined,
        profile: selectedProfile !== -1 ? selectedProfile : undefined,
        server: selectedServer ?? undefined,
        user: selectedUser ?? undefined,
        language: selectedLanguage !== -1 ? selectedLanguage : undefined,
        tags: selectedTags
      });
    }
  }, [selectedFolder, selectedServer, selectedProfile, selectedUser, selectedLanguage, selectedTags]);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "mb-2 w-full",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_0__/* .SmallLoadingSpinner */ .e, {})
    });
  }

  if ((!data || selectedServer === null || data.filter(server => server.is4k === is4k).length < 2 && (!serverData || serverData.profiles.length < 2 && serverData.rootFolders.length < 2 && (serverData.languageProfiles ?? []).length < 2 && !serverData.tags?.length)) && (!selectedUser || (filteredUserData ?? []).length < 2)) {
    return null;
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "mt-4 mb-2 flex items-center text-lg font-semibold",
      children: intl.formatMessage(messages.advancedoptions)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "rounded-md",
      children: [!!data && selectedServer !== null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "flex flex-col md:flex-row",
        children: [data.filter(server => server.is4k === is4k).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "mb-3 w-full flex-shrink-0 flex-grow last:pr-0 md:w-1/4 md:pr-4",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
            htmlFor: "server",
            children: intl.formatMessage(messages.destinationserver)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("select", {
            id: "server",
            name: "server",
            value: selectedServer,
            onChange: e => setSelectedServer(Number(e.target.value)),
            onBlur: e => setSelectedServer(Number(e.target.value)),
            className: "border-gray-700 bg-gray-800",
            children: data.filter(server => server.is4k === is4k).map(server => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
              value: server.id,
              children: server.isDefault ? intl.formatMessage(messages.default, {
                name: server.name
              }) : server.name
            }, `server-list-${server.id}`))
          })]
        }), (isValidating || !serverData || serverData.profiles.length > 1) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "mb-3 w-full flex-shrink-0 flex-grow last:pr-0 md:w-1/4 md:pr-4",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
            htmlFor: "profile",
            children: intl.formatMessage(messages.qualityprofile)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("select", {
            id: "profile",
            name: "profile",
            value: selectedProfile,
            onChange: e => setSelectedProfile(Number(e.target.value)),
            onBlur: e => setSelectedProfile(Number(e.target.value)),
            className: "border-gray-700 bg-gray-800",
            disabled: isValidating || !serverData,
            children: [(isValidating || !serverData) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
              value: "",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].loading */ .Z.loading)
            }), !isValidating && serverData && serverData.profiles.map(profile => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
              value: profile.id,
              children: isAnime && serverData.server.activeAnimeProfileId === profile.id ? intl.formatMessage(messages.default, {
                name: profile.name
              }) : !isAnime && serverData.server.activeProfileId === profile.id ? intl.formatMessage(messages.default, {
                name: profile.name
              }) : profile.name
            }, `profile-list${profile.id}`))]
          })]
        }), (isValidating || !serverData || serverData.rootFolders.length > 1) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "mb-3 w-full flex-shrink-0 flex-grow last:pr-0 md:w-1/4 md:pr-4",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
            htmlFor: "folder",
            children: intl.formatMessage(messages.rootfolder)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("select", {
            id: "folder",
            name: "folder",
            value: selectedFolder,
            onChange: e => setSelectedFolder(e.target.value),
            onBlur: e => setSelectedFolder(e.target.value),
            className: "border-gray-700 bg-gray-800",
            disabled: isValidating || !serverData,
            children: [(isValidating || !serverData) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
              value: "",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].loading */ .Z.loading)
            }), !isValidating && serverData && serverData.rootFolders.map(folder => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
              value: folder.path,
              children: isAnime && serverData.server.activeAnimeDirectory === folder.path ? intl.formatMessage(messages.default, {
                name: intl.formatMessage(messages.folder, {
                  path: folder.path,
                  space: (0,_app_utils_numberHelpers__WEBPACK_IMPORTED_MODULE_12__/* .formatBytes */ .t)(folder.freeSpace ?? 0)
                })
              }) : !isAnime && serverData.server.activeDirectory === folder.path ? intl.formatMessage(messages.default, {
                name: intl.formatMessage(messages.folder, {
                  path: folder.path,
                  space: (0,_app_utils_numberHelpers__WEBPACK_IMPORTED_MODULE_12__/* .formatBytes */ .t)(folder.freeSpace ?? 0)
                })
              }) : intl.formatMessage(messages.folder, {
                path: folder.path,
                space: (0,_app_utils_numberHelpers__WEBPACK_IMPORTED_MODULE_12__/* .formatBytes */ .t)(folder.freeSpace ?? 0)
              })
            }, `folder-list${folder.id}`))]
          })]
        }), type === 'tv' && (isValidating || !serverData || (serverData.languageProfiles ?? []).length > 1) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "mb-3 w-full flex-shrink-0 flex-grow last:pr-0 md:w-1/4 md:pr-4",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
            htmlFor: "language",
            children: intl.formatMessage(messages.languageprofile)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("select", {
            id: "language",
            name: "language",
            value: selectedLanguage,
            onChange: e => setSelectedLanguage(parseInt(e.target.value)),
            onBlur: e => setSelectedLanguage(parseInt(e.target.value)),
            className: "border-gray-700 bg-gray-800",
            disabled: isValidating || !serverData,
            children: [(isValidating || !serverData) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
              value: "",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].loading */ .Z.loading)
            }), !isValidating && serverData && serverData.languageProfiles?.map(language => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("option", {
              value: language.id,
              children: isAnime && serverData.server.activeAnimeLanguageProfileId === language.id ? intl.formatMessage(messages.default, {
                name: language.name
              }) : !isAnime && serverData.server.activeLanguageProfileId === language.id ? intl.formatMessage(messages.default, {
                name: language.name
              }) : language.name
            }, `folder-list${language.id}`))]
          })]
        })]
      }), selectedServer !== null && (isValidating || !serverData || !!serverData?.tags?.length) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "mb-2",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("label", {
          htmlFor: "tags",
          children: intl.formatMessage(messages.tags)
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx((react_select__WEBPACK_IMPORTED_MODULE_9___default()), {
          name: "tags",
          options: (serverData?.tags ?? []).map(tag => ({
            label: tag.label,
            value: tag.id
          })),
          isMulti: true,
          isDisabled: isValidating || !serverData,
          placeholder: isValidating || !serverData ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].loading */ .Z.loading) : intl.formatMessage(messages.selecttags),
          className: "react-select-container react-select-container-dark",
          classNamePrefix: "react-select",
          value: selectedTags.map(tagId => {
            const foundTag = serverData?.tags.find(tag => tag.id === tagId);

            if (!foundTag) {
              return undefined;
            }

            return {
              value: foundTag.id,
              label: foundTag.label
            };
          }).filter(option => option !== undefined),
          onChange: value => {
            setSelectedTags(value.map(option => option.value));
          },
          noOptionsMessage: () => intl.formatMessage(messages.notagoptions)
        })]
      }), currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS]) && selectedUser && (filteredUserData ?? []).length > 1 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Listbox, {
        as: "div",
        value: selectedUser,
        onChange: value => setSelectedUser(value),
        className: "space-y-1",
        children: ({
          open
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Listbox.Label, {
            children: intl.formatMessage(messages.requestas)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "relative",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
              className: "inline-block w-full rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Listbox.Button, {
                className: "focus:shadow-outline-blue relative w-full cursor-default rounded-md border border-gray-700 bg-gray-800 py-2 pl-3 pr-10 text-left text-white transition duration-150 ease-in-out focus:border-blue-300 focus:outline-none sm:text-sm sm:leading-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                  className: "flex items-center",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("img", {
                    src: selectedUser.avatar,
                    alt: "",
                    className: "h-6 w-6 flex-shrink-0 rounded-full object-cover"
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                    className: "ml-3 block",
                    children: selectedUser.displayName
                  }), selectedUser.displayName.toLowerCase() !== selectedUser.email && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                    className: "ml-1 truncate text-gray-400",
                    children: ["(", selectedUser.email, ")"]
                  })]
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                  className: "pointer-events-none absolute inset-y-0 right-0 flex items-center pr-2 text-gray-500",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4__.ChevronDownIcon, {
                    className: "h-5 w-5"
                  })
                })]
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Transition, {
              show: open,
              enter: "transition-opacity ease-in duration-300",
              enterFrom: "opacity-0",
              enterTo: "opacity-100",
              leave: "transition-opacity ease-in duration-100",
              leaveFrom: "opacity-100",
              leaveTo: "opacity-0",
              className: "mt-1 w-full rounded-md border border-gray-700 bg-gray-800 shadow-lg",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Listbox.Options, {
                static: true,
                className: "shadow-xs max-h-60 overflow-auto rounded-md py-1 text-base leading-6 focus:outline-none sm:text-sm sm:leading-5",
                children: filteredUserData?.map(user => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Listbox.Option, {
                  value: user,
                  children: ({
                    selected,
                    active
                  }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
                    className: `${active ? 'bg-indigo-600 text-white' : 'text-gray-300'} relative cursor-default select-none py-2 pl-8 pr-4`,
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                      className: `${selected ? 'font-semibold' : 'font-normal'} flex items-center`,
                      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("img", {
                        src: user.avatar,
                        alt: "",
                        className: "h-6 w-6 flex-shrink-0 rounded-full object-cover"
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                        className: "ml-3 block flex-shrink-0",
                        children: user.displayName
                      }), user.displayName.toLowerCase() !== user.email && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
                        className: "ml-1 truncate text-gray-400",
                        children: ["(", user.email, ")"]
                      })]
                    }), selected && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
                      className: `${active ? 'text-white' : 'text-indigo-600'} absolute inset-y-0 left-0 flex items-center pl-1.5`,
                      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4__.CheckIcon, {
                        className: "h-5 w-5"
                      })
                    })]
                  })
                }, user.id))
              })
            })]
          })]
        })
      }), isAnime && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
        className: "mt-4 italic",
        children: intl.formatMessage(messages.animenote)
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AdvancedRequester);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 71907:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7292);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22796);
/* harmony import */ var _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59183);
/* harmony import */ var _app_components_RequestModal_QuotaDisplay__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(42707);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80210);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59147);
/* harmony import */ var _server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(44941);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__, _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, axios__WEBPACK_IMPORTED_MODULE_10__, swr__WEBPACK_IMPORTED_MODULE_14__]);
([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__, _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, axios__WEBPACK_IMPORTED_MODULE_10__, swr__WEBPACK_IMPORTED_MODULE_14__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.defineMessages)({
  requestadmin: {
    "id": "components.RequestModal.requestadmin",
    "defaultMessage": 'This request will be approved automatically.'
  },
  requestSuccess: {
    "id": "components.RequestModal.requestSuccess",
    "defaultMessage": '<strong>{title}</strong> requested successfully!'
  },
  requestcollectiontitle: {
    "id": "components.RequestModal.requestcollectiontitle",
    "defaultMessage": 'Request Collection'
  },
  requestcollection4ktitle: {
    "id": "components.RequestModal.requestcollection4ktitle",
    "defaultMessage": 'Request Collection in 4K'
  },
  requesterror: {
    "id": "components.RequestModal.requesterror",
    "defaultMessage": 'Something went wrong while submitting the request.'
  },
  selectmovies: {
    "id": "components.RequestModal.selectmovies",
    "defaultMessage": 'Select Movie(s)'
  },
  requestmovies: {
    "id": "components.RequestModal.requestmovies",
    "defaultMessage": 'Request {count} {count, plural, one {Movie} other {Movies}}'
  },
  requestmovies4k: {
    "id": "components.RequestModal.requestmovies4k",
    "defaultMessage": 'Request {count} {count, plural, one {Movie} other {Movies}} in 4K'
  }
});

const CollectionRequestModal = ({
  onCancel,
  onComplete,
  tmdbId,
  onUpdating,
  is4k = false
}) => {
  const {
    0: isUpdating,
    1: setIsUpdating
  } = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
  const {
    0: requestOverrides,
    1: setRequestOverrides
  } = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(null);
  const {
    0: selectedParts,
    1: setSelectedParts
  } = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)([]);
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__.useToasts)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_14__["default"])(`/api/v1/collection/${tmdbId}`, {
    revalidateOnMount: true
  });
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.useIntl)();
  const {
    user,
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__/* .useUser */ .aF)();
  const {
    data: quota
  } = (0,swr__WEBPACK_IMPORTED_MODULE_14__["default"])(user && (!requestOverrides?.user?.id || hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.MANAGE_USERS */ .y.MANAGE_USERS)) ? `/api/v1/user/${requestOverrides?.user?.id ?? user.id}/quota` : null);
  const currentlyRemaining = (quota?.movie.remaining ?? 0) - selectedParts.length;

  const getAllParts = () => {
    return (data?.parts ?? []).map(part => part.id);
  };

  const getAllRequestedParts = () => {
    const requestedParts = (data?.parts ?? []).reduce((requestedParts, part) => {
      return [...requestedParts, ...(part.mediaInfo?.requests ?? []).filter(request => request.is4k === is4k && request.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED).map(part => part.id)];
    }, []);
    const availableParts = (data?.parts ?? []).filter(part => part.mediaInfo && (part.mediaInfo[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaStatus.AVAILABLE */ .Jp.AVAILABLE || part.mediaInfo[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaStatus.PROCESSING */ .Jp.PROCESSING) && !requestedParts.includes(part.id)).map(part => part.id);
    return [...requestedParts, ...availableParts];
  };

  const isSelectedPart = tmdbId => selectedParts.includes(tmdbId);

  const togglePart = tmdbId => {
    // If this part already has a pending request, don't allow it to be toggled
    if (getAllRequestedParts().includes(tmdbId)) {
      return;
    } // If there are no more remaining requests available, block toggle


    if (quota?.movie.limit && currentlyRemaining <= 0 && !isSelectedPart(tmdbId)) {
      return;
    }

    if (selectedParts.includes(tmdbId)) {
      setSelectedParts(parts => parts.filter(partId => partId !== tmdbId));
    } else {
      setSelectedParts(parts => [...parts, tmdbId]);
    }
  };

  const unrequestedParts = getAllParts().filter(tmdbId => !getAllRequestedParts().includes(tmdbId));

  const toggleAllParts = () => {
    // If the user has a quota and not enough requests for all parts, block toggleAllParts
    if (quota?.movie.limit && (quota?.movie.remaining ?? 0) < unrequestedParts.length) {
      return;
    }

    if (data && selectedParts.length >= 0 && selectedParts.length < unrequestedParts.length) {
      setSelectedParts(unrequestedParts);
    } else {
      setSelectedParts([]);
    }
  };

  const isAllParts = () => {
    if (!data) {
      return false;
    }

    return selectedParts.length === getAllParts().filter(part => !getAllRequestedParts().includes(part)).length;
  };

  const getPartRequest = tmdbId => {
    const part = (data?.parts ?? []).find(part => part.id === tmdbId);
    return (part?.mediaInfo?.requests ?? []).find(request => request.is4k === is4k && request.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED);
  };

  (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
    if (onUpdating) {
      onUpdating(isUpdating);
    }
  }, [isUpdating, onUpdating]);
  const sendRequest = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)(async () => {
    setIsUpdating(true);

    try {
      let overrideParams = {};

      if (requestOverrides) {
        overrideParams = {
          serverId: requestOverrides.server,
          profileId: requestOverrides.profile,
          rootFolder: requestOverrides.folder,
          userId: requestOverrides.user?.id,
          tags: requestOverrides.tags
        };
      }

      await Promise.all((data?.parts.filter(part => selectedParts.includes(part.id)) ?? []).map(async part => {
        await axios__WEBPACK_IMPORTED_MODULE_10__["default"].post('/api/v1/request', _objectSpread({
          mediaId: part.id,
          mediaType: 'movie',
          is4k
        }, overrideParams));
      }));

      if (onComplete) {
        onComplete(selectedParts.length === (data?.parts ?? []).length ? _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaStatus.UNKNOWN */ .Jp.UNKNOWN : _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaStatus.PARTIALLY_AVAILABLE */ .Jp.PARTIALLY_AVAILABLE);
        (0,swr__WEBPACK_IMPORTED_MODULE_14__.mutate)('/api/v1/request/count');
      }

      addToast( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
        children: intl.formatMessage(messages.requestSuccess, {
          title: data?.name,
          strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("strong", {
            children: msg
          })
        })
      }), {
        appearance: 'success',
        autoDismiss: true
      });
    } catch (e) {
      addToast(intl.formatMessage(messages.requesterror), {
        appearance: 'error',
        autoDismiss: true
      });
    } finally {
      setIsUpdating(false);
    }
  }, [requestOverrides, data?.parts, data?.name, onComplete, addToast, intl, selectedParts, is4k]);
  const hasAutoApprove = hasPermission([_server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS, is4k ? _server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.AUTO_APPROVE_4K */ .y.AUTO_APPROVE_4K : _server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.AUTO_APPROVE */ .y.AUTO_APPROVE, is4k ? _server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.AUTO_APPROVE_4K_MOVIE */ .y.AUTO_APPROVE_4K_MOVIE : _server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.AUTO_APPROVE_MOVIE */ .y.AUTO_APPROVE_MOVIE], {
    type: 'or'
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
    loading: !data && !error || !quota,
    backgroundClickable: true,
    onCancel: onCancel,
    onOk: sendRequest,
    title: intl.formatMessage(is4k ? messages.requestcollection4ktitle : messages.requestcollectiontitle),
    subTitle: data?.name,
    okText: isUpdating ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].requesting */ .Z.requesting) : selectedParts.length === 0 ? intl.formatMessage(messages.selectmovies) : intl.formatMessage(is4k ? messages.requestmovies4k : messages.requestmovies, {
      count: selectedParts.length
    }),
    okDisabled: selectedParts.length === 0,
    okButtonType: 'primary',
    backdrop: `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${data?.backdropPath}`,
    children: [hasAutoApprove && !quota?.movie.restricted && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
      className: "mt-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.requestadmin),
        type: "info"
      })
    }), (quota?.movie.limit ?? 0) > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_RequestModal_QuotaDisplay__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      mediaType: "movie",
      quota: quota?.movie,
      remaining: currentlyRemaining,
      userOverride: requestOverrides?.user && requestOverrides.user.id !== user?.id ? requestOverrides?.user?.id : undefined
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
      className: "flex flex-col",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
        className: "-mx-4 sm:mx-0",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
          className: "inline-block min-w-full py-2 align-middle",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
            className: "overflow-hidden border border-gray-700 backdrop-blur sm:rounded-lg",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("table", {
              className: "min-w-full",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("thead", {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("tr", {
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("th", {
                    className: "w-16 bg-gray-700 bg-opacity-80 px-4 py-3",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("span", {
                      role: "checkbox",
                      tabIndex: 0,
                      "aria-checked": isAllParts(),
                      onClick: () => toggleAllParts(),
                      onKeyDown: e => {
                        if (e.key === 'Enter' || e.key === 'Space') {
                          toggleAllParts();
                        }
                      },
                      className: `relative inline-flex h-5 w-10 flex-shrink-0 cursor-pointer items-center justify-center pt-2 focus:outline-none ${quota?.movie.limit && (quota.movie.remaining ?? 0) < unrequestedParts.length ? 'opacity-50' : ''}`,
                      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                        "aria-hidden": "true",
                        className: `${isAllParts() ? 'bg-indigo-500' : 'bg-gray-800'} absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out`
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                        "aria-hidden": "true",
                        className: `${isAllParts() ? 'translate-x-5' : 'translate-x-0'} absolute left-0 inline-block h-5 w-5 rounded-full border border-gray-200 bg-white shadow transition-transform duration-200 ease-in-out group-focus:border-blue-300 group-focus:ring`
                      })]
                    })
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("th", {
                    className: "bg-gray-700 bg-opacity-80 px-1 py-3 text-left text-xs font-medium uppercase leading-4 tracking-wider text-gray-200 md:px-6",
                    children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].movie */ .Z.movie)
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("th", {
                    className: "bg-gray-700 bg-opacity-80 px-2 py-3 text-left text-xs font-medium uppercase leading-4 tracking-wider text-gray-200 md:px-6",
                    children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].status */ .Z.status)
                  })]
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("tbody", {
                className: "divide-y divide-gray-700",
                children: data?.parts.map(part => {
                  const partRequest = getPartRequest(part.id);
                  const partMedia = part.mediaInfo && part.mediaInfo[is4k ? 'status4k' : 'status'] !== _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaStatus.UNKNOWN */ .Jp.UNKNOWN ? part.mediaInfo : undefined;
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("tr", {
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("td", {
                      className: "whitespace-nowrap px-4 py-4 text-sm font-medium leading-5 text-gray-100",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("span", {
                        role: "checkbox",
                        tabIndex: 0,
                        "aria-checked": !!partMedia || isSelectedPart(part.id),
                        onClick: () => togglePart(part.id),
                        onKeyDown: e => {
                          if (e.key === 'Enter' || e.key === 'Space') {
                            togglePart(part.id);
                          }
                        },
                        className: `relative inline-flex h-5 w-10 flex-shrink-0 cursor-pointer items-center justify-center pt-2 focus:outline-none ${!!partMedia || partRequest || quota?.movie.limit && currentlyRemaining <= 0 && !isSelectedPart(part.id) ? 'opacity-50' : ''}`,
                        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                          "aria-hidden": "true",
                          className: `${!!partMedia || partRequest || isSelectedPart(part.id) ? 'bg-indigo-500' : 'bg-gray-700'} absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out`
                        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                          "aria-hidden": "true",
                          className: `${!!partMedia || partRequest || isSelectedPart(part.id) ? 'translate-x-5' : 'translate-x-0'} absolute left-0 inline-block h-5 w-5 rounded-full border border-gray-200 bg-white shadow transition-transform duration-200 ease-in-out group-focus:border-blue-300 group-focus:ring`
                        })]
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("td", {
                      className: "flex items-center px-1 py-4 text-sm font-medium leading-5 text-gray-100 md:px-6",
                      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
                        className: "relative h-auto w-10 flex-shrink-0 overflow-hidden rounded-md",
                        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                          src: part.posterPath ? `https://image.tmdb.org/t/p/w600_and_h900_bestv2${part.posterPath}` : '/images/overseerr_poster_not_found.png',
                          alt: "",
                          layout: "responsive",
                          width: 600,
                          height: 900,
                          objectFit: "cover"
                        })
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
                        className: "flex flex-col justify-center pl-2",
                        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
                          className: "text-xs font-medium",
                          children: part.releaseDate?.slice(0, 4)
                        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
                          className: "text-base font-bold",
                          children: part.title
                        })]
                      })]
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("td", {
                      className: "whitespace-nowrap py-4 pr-2 text-sm leading-5 text-gray-200 md:px-6",
                      children: [!partMedia && !partRequest && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].notrequested */ .Z.notrequested)
                      }), !partMedia && partRequest?.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaRequestStatus.PENDING */ .pi.PENDING && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        badgeType: "warning",
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].pending */ .Z.pending)
                      }), (!partMedia && partRequest?.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaRequestStatus.APPROVED */ .pi.APPROVED || partMedia?.[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaStatus.PROCESSING */ .Jp.PROCESSING) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        badgeType: "primary",
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].requested */ .Z.requested)
                      }), partMedia?.[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaStatus.AVAILABLE */ .Jp.AVAILABLE && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        badgeType: "success",
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].available */ .Z.available)
                      })]
                    })]
                  }, `part-${part.id}`);
                })
              })]
            })
          })
        })
      })
    }), (hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED) || hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS)) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      type: "movie",
      is4k: is4k,
      onChange: overrides => {
        setRequestOverrides(overrides);
      }
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CollectionRequestModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 99486:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22796);
/* harmony import */ var _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59183);
/* harmony import */ var _app_components_RequestModal_QuotaDisplay__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42707);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80210);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(59147);
/* harmony import */ var _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(44941);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__, _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, axios__WEBPACK_IMPORTED_MODULE_8__, swr__WEBPACK_IMPORTED_MODULE_12__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__, _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, axios__WEBPACK_IMPORTED_MODULE_8__, swr__WEBPACK_IMPORTED_MODULE_12__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_10__.defineMessages)({
  requestadmin: {
    "id": "components.RequestModal.requestadmin",
    "defaultMessage": 'This request will be approved automatically.'
  },
  requestSuccess: {
    "id": "components.RequestModal.requestSuccess",
    "defaultMessage": '<strong>{title}</strong> requested successfully!'
  },
  requestCancel: {
    "id": "components.RequestModal.requestCancel",
    "defaultMessage": 'Request for <strong>{title}</strong> canceled.'
  },
  requestmovietitle: {
    "id": "components.RequestModal.requestmovietitle",
    "defaultMessage": 'Request Movie'
  },
  requestmovie4ktitle: {
    "id": "components.RequestModal.requestmovie4ktitle",
    "defaultMessage": 'Request Movie in 4K'
  },
  edit: {
    "id": "components.RequestModal.edit",
    "defaultMessage": 'Edit Request'
  },
  approve: {
    "id": "components.RequestModal.approve",
    "defaultMessage": 'Approve Request'
  },
  cancel: {
    "id": "components.RequestModal.cancel",
    "defaultMessage": 'Cancel Request'
  },
  pendingrequest: {
    "id": "components.RequestModal.pendingrequest",
    "defaultMessage": 'Pending Movie Request'
  },
  pending4krequest: {
    "id": "components.RequestModal.pending4krequest",
    "defaultMessage": 'Pending 4K Movie Request'
  },
  requestfrom: {
    "id": "components.RequestModal.requestfrom",
    "defaultMessage": "{username}'s request is pending approval."
  },
  errorediting: {
    "id": "components.RequestModal.errorediting",
    "defaultMessage": 'Something went wrong while editing the request.'
  },
  requestedited: {
    "id": "components.RequestModal.requestedited",
    "defaultMessage": 'Request for <strong>{title}</strong> edited successfully!'
  },
  requestApproved: {
    "id": "components.RequestModal.requestApproved",
    "defaultMessage": 'Request for <strong>{title}</strong> approved!'
  },
  requesterror: {
    "id": "components.RequestModal.requesterror",
    "defaultMessage": 'Something went wrong while submitting the request.'
  },
  pendingapproval: {
    "id": "components.RequestModal.pendingapproval",
    "defaultMessage": 'Your request is pending approval.'
  }
});

const MovieRequestModal = ({
  onCancel,
  onComplete,
  tmdbId,
  onUpdating,
  editRequest,
  is4k = false
}) => {
  const {
    0: isUpdating,
    1: setIsUpdating
  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(false);
  const {
    0: requestOverrides,
    1: setRequestOverrides
  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(null);
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_11__.useToasts)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_12__["default"])(`/api/v1/movie/${tmdbId}`, {
    revalidateOnMount: true
  });
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_10__.useIntl)();
  const {
    user,
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .useUser */ .aF)();
  const {
    data: quota
  } = (0,swr__WEBPACK_IMPORTED_MODULE_12__["default"])(user && (!requestOverrides?.user?.id || hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_USERS */ .y.MANAGE_USERS)) ? `/api/v1/user/${requestOverrides?.user?.id ?? user.id}/quota` : null);
  (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    if (onUpdating) {
      onUpdating(isUpdating);
    }
  }, [isUpdating, onUpdating]);
  const sendRequest = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async () => {
    setIsUpdating(true);

    try {
      let overrideParams = {};

      if (requestOverrides) {
        overrideParams = {
          serverId: requestOverrides.server,
          profileId: requestOverrides.profile,
          rootFolder: requestOverrides.folder,
          userId: requestOverrides.user?.id,
          tags: requestOverrides.tags
        };
      }

      const response = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].post('/api/v1/request', _objectSpread({
        mediaId: data?.id,
        mediaType: 'movie',
        is4k
      }, overrideParams));
      (0,swr__WEBPACK_IMPORTED_MODULE_12__.mutate)('/api/v1/request?filter=all&take=10&sort=modified&skip=0');
      (0,swr__WEBPACK_IMPORTED_MODULE_12__.mutate)('/api/v1/request/count');

      if (response.data) {
        if (onComplete) {
          onComplete(hasPermission(is4k ? _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.AUTO_APPROVE_4K */ .y.AUTO_APPROVE_4K : _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.AUTO_APPROVE */ .y.AUTO_APPROVE) || hasPermission(is4k ? _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.AUTO_APPROVE_4K_MOVIE */ .y.AUTO_APPROVE_4K_MOVIE : _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.AUTO_APPROVE_MOVIE */ .y.AUTO_APPROVE_MOVIE) ? _server_constants_media__WEBPACK_IMPORTED_MODULE_6__/* .MediaStatus.PROCESSING */ .Jp.PROCESSING : _server_constants_media__WEBPACK_IMPORTED_MODULE_6__/* .MediaStatus.PENDING */ .Jp.PENDING);
        }

        addToast( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
          children: intl.formatMessage(messages.requestSuccess, {
            title: data?.title,
            strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("strong", {
              children: msg
            })
          })
        }), {
          appearance: 'success',
          autoDismiss: true
        });
      }
    } catch (e) {
      addToast(intl.formatMessage(messages.requesterror), {
        appearance: 'error',
        autoDismiss: true
      });
    } finally {
      setIsUpdating(false);
    }
  }, [requestOverrides, data?.id, data?.title, is4k, onComplete, addToast, intl, hasPermission]);

  const cancelRequest = async () => {
    setIsUpdating(true);

    try {
      const response = await axios__WEBPACK_IMPORTED_MODULE_8__["default"]["delete"](`/api/v1/request/${editRequest?.id}`);
      (0,swr__WEBPACK_IMPORTED_MODULE_12__.mutate)('/api/v1/request?filter=all&take=10&sort=modified&skip=0');
      (0,swr__WEBPACK_IMPORTED_MODULE_12__.mutate)('/api/v1/request/count');

      if (response.status === 204) {
        if (onComplete) {
          onComplete(_server_constants_media__WEBPACK_IMPORTED_MODULE_6__/* .MediaStatus.UNKNOWN */ .Jp.UNKNOWN);
        }

        addToast( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
          children: intl.formatMessage(messages.requestCancel, {
            title: data?.title,
            strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("strong", {
              children: msg
            })
          })
        }), {
          appearance: 'success',
          autoDismiss: true
        });
      }
    } catch (e) {
      setIsUpdating(false);
    }
  };

  const updateRequest = async (alsoApproveRequest = false) => {
    setIsUpdating(true);

    try {
      await axios__WEBPACK_IMPORTED_MODULE_8__["default"].put(`/api/v1/request/${editRequest?.id}`, {
        mediaType: 'movie',
        serverId: requestOverrides?.server,
        profileId: requestOverrides?.profile,
        rootFolder: requestOverrides?.folder,
        userId: requestOverrides?.user?.id,
        tags: requestOverrides?.tags
      });

      if (alsoApproveRequest) {
        await axios__WEBPACK_IMPORTED_MODULE_8__["default"].post(`/api/v1/request/${editRequest?.id}/approve`);
      }

      (0,swr__WEBPACK_IMPORTED_MODULE_12__.mutate)('/api/v1/request?filter=all&take=10&sort=modified&skip=0');
      (0,swr__WEBPACK_IMPORTED_MODULE_12__.mutate)('/api/v1/request/count');
      addToast( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
        children: intl.formatMessage(alsoApproveRequest ? messages.requestApproved : messages.requestedited, {
          title: data?.title,
          strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("strong", {
            children: msg
          })
        })
      }), {
        appearance: 'success',
        autoDismiss: true
      });

      if (onComplete) {
        onComplete(_server_constants_media__WEBPACK_IMPORTED_MODULE_6__/* .MediaStatus.PENDING */ .Jp.PENDING);
      }
    } catch (e) {
      addToast( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
        children: intl.formatMessage(messages.errorediting)
      }), {
        appearance: 'error',
        autoDismiss: true
      });
    } finally {
      setIsUpdating(false);
    }
  };

  if (editRequest) {
    const isOwner = editRequest.requestedBy.id === user?.id;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      loading: !data && !error,
      backgroundClickable: true,
      onCancel: onCancel,
      title: intl.formatMessage(is4k ? messages.pending4krequest : messages.pendingrequest),
      subTitle: data?.title,
      onOk: () => hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS) ? updateRequest(true) : hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED) ? updateRequest() : cancelRequest(),
      okDisabled: isUpdating,
      okText: hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS) ? intl.formatMessage(messages.approve) : hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED) ? intl.formatMessage(messages.edit) : intl.formatMessage(messages.cancel),
      okButtonType: hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS) ? 'success' : hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED) ? 'primary' : 'danger',
      onSecondary: isOwner && hasPermission([_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED, _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS], {
        type: 'or'
      }) ? () => cancelRequest() : undefined,
      secondaryDisabled: isUpdating,
      secondaryText: isOwner && hasPermission([_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED, _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS], {
        type: 'or'
      }) ? intl.formatMessage(messages.cancel) : undefined,
      secondaryButtonType: "danger",
      cancelText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].close */ .Z.close),
      backdrop: `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${data?.backdropPath}`,
      children: [isOwner ? intl.formatMessage(messages.pendingapproval) : intl.formatMessage(messages.requestfrom, {
        username: editRequest.requestedBy.displayName
      }), (hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED) || hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS)) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        type: "movie",
        is4k: is4k,
        requestUser: editRequest.requestedBy,
        defaultOverrides: {
          folder: editRequest.rootFolder,
          profile: editRequest.profileId,
          server: editRequest.serverId,
          tags: editRequest.tags
        },
        onChange: overrides => {
          setRequestOverrides(overrides);
        }
      })]
    });
  }

  const hasAutoApprove = hasPermission([_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS, is4k ? _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.AUTO_APPROVE_4K */ .y.AUTO_APPROVE_4K : _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.AUTO_APPROVE */ .y.AUTO_APPROVE, is4k ? _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.AUTO_APPROVE_4K_MOVIE */ .y.AUTO_APPROVE_4K_MOVIE : _server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.AUTO_APPROVE_MOVIE */ .y.AUTO_APPROVE_MOVIE], {
    type: 'or'
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    loading: !data && !error || !quota,
    backgroundClickable: true,
    onCancel: onCancel,
    onOk: sendRequest,
    okDisabled: isUpdating || quota?.movie.restricted,
    title: intl.formatMessage(is4k ? messages.requestmovie4ktitle : messages.requestmovietitle),
    subTitle: data?.title,
    okText: isUpdating ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].requesting */ .Z.requesting) : intl.formatMessage(is4k ? _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].request4k */ .Z.request4k : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].request */ .Z.request),
    okButtonType: 'primary',
    backdrop: `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${data?.backdropPath}`,
    children: [hasAutoApprove && !quota?.movie.restricted && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
      className: "mt-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.requestadmin),
        type: "info"
      })
    }), (quota?.movie.limit ?? 0) > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_RequestModal_QuotaDisplay__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      mediaType: "movie",
      quota: quota?.movie,
      userOverride: requestOverrides?.user && requestOverrides.user.id !== user?.id ? requestOverrides?.user?.id : undefined
    }), (hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED) || hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS)) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      type: "movie",
      is4k: is4k,
      onChange: overrides => {
        setRequestOverrides(overrides);
      }
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MovieRequestModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 42707:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_ProgressCircle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(72964);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);







const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.defineMessages)({
  requestsremaining: {
    "id": "components.RequestModal.QuotaDisplay.requestsremaining",
    "defaultMessage": '{remaining, plural, =0 {No} other {<strong>#</strong>}} {type} {remaining, plural, one {request} other {requests}} remaining'
  },
  movielimit: {
    "id": "components.RequestModal.QuotaDisplay.movielimit",
    "defaultMessage": '{limit, plural, one {movie} other {movies}}'
  },
  seasonlimit: {
    "id": "components.RequestModal.QuotaDisplay.seasonlimit",
    "defaultMessage": '{limit, plural, one {season} other {seasons}}'
  },
  allowedRequests: {
    "id": "components.RequestModal.QuotaDisplay.allowedRequests",
    "defaultMessage": 'You are allowed to request <strong>{limit}</strong> {type} every <strong>{days}</strong> days.'
  },
  allowedRequestsUser: {
    "id": "components.RequestModal.QuotaDisplay.allowedRequestsUser",
    "defaultMessage": 'This user is allowed to request <strong>{limit}</strong> {type} every <strong>{days}</strong> days.'
  },
  quotaLink: {
    "id": "components.RequestModal.QuotaDisplay.quotaLink",
    "defaultMessage": 'You can view a summary of your request limits on your <ProfileLink>profile page</ProfileLink>.'
  },
  quotaLinkUser: {
    "id": "components.RequestModal.QuotaDisplay.quotaLinkUser",
    "defaultMessage": "You can view a summary of this user's request limits on their <ProfileLink>profile page</ProfileLink>."
  },
  movie: {
    "id": "components.RequestModal.QuotaDisplay.movie",
    "defaultMessage": 'movie'
  },
  season: {
    "id": "components.RequestModal.QuotaDisplay.season",
    "defaultMessage": 'season'
  },
  notenoughseasonrequests: {
    "id": "components.RequestModal.QuotaDisplay.notenoughseasonrequests",
    "defaultMessage": 'Not enough season requests remaining'
  },
  requiredquota: {
    "id": "components.RequestModal.QuotaDisplay.requiredquota",
    "defaultMessage": 'You need to have at least <strong>{seasons}</strong> {seasons, plural, one {season request} other {season requests}} remaining in order to submit a request for this series.'
  },
  requiredquotaUser: {
    "id": "components.RequestModal.QuotaDisplay.requiredquotaUser",
    "defaultMessage": 'This user needs to have at least <strong>{seasons}</strong> {seasons, plural, one {season request} other {season requests}} remaining in order to submit a request for this series.'
  }
});

const QuotaDisplay = ({
  quota,
  mediaType,
  userOverride,
  remaining,
  overLimit
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.useIntl)();
  const {
    0: showDetails,
    1: setShowDetails
  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "my-4 flex flex-col rounded-md border border-gray-700 p-4 backdrop-blur",
    onClick: () => setShowDetails(s => !s),
    onKeyDown: e => {
      if (e.key === 'Enter') {
        setShowDetails(s => !s);
      }
    },
    role: "button",
    tabIndex: 0,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "flex items-center",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Common_ProgressCircle__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        className: "h-8 w-8",
        progress: Math.round((remaining ?? quota?.remaining ?? 0) / (quota?.limit ?? 1) * 100),
        useHeatLevel: true
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: `flex items-end ${(remaining ?? quota?.remaining ?? 0) <= 0 || quota?.restricted ? 'text-red-500' : ''}`,
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
          className: "ml-2 text-lg",
          children: overLimit !== undefined ? intl.formatMessage(messages.notenoughseasonrequests) : intl.formatMessage(messages.requestsremaining, {
            remaining: remaining ?? quota?.remaining ?? 0,
            type: intl.formatMessage(mediaType === 'movie' ? messages.movie : messages.season),
            strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("strong", {
              children: msg
            })
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "flex flex-1 justify-end",
        children: showDetails ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__.ChevronUpIcon, {
          className: "h-6 w-6"
        }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__.ChevronDownIcon, {
          className: "h-6 w-6"
        })
      })]
    }), showDetails && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "mt-4",
      children: [overLimit !== undefined && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "mb-2",
        children: intl.formatMessage(userOverride ? messages.requiredquotaUser : messages.requiredquota, {
          seasons: overLimit,
          strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("strong", {
            children: msg
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        children: intl.formatMessage(userOverride ? messages.allowedRequestsUser : messages.allowedRequests, {
          limit: quota?.limit,
          days: quota?.days,
          type: intl.formatMessage(mediaType === 'movie' ? messages.movielimit : messages.seasonlimit, {
            limit: quota?.limit
          }),
          strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("strong", {
            children: msg
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "mt-2",
        children: intl.formatMessage(userOverride ? messages.quotaLinkUser : messages.quotaLink, {
          ProfileLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx((next_link__WEBPACK_IMPORTED_MODULE_2___default()), {
            href: userOverride ? `/users/${userOverride}` : '/profile',
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("a", {
              className: "text-white transition duration-300 hover:underline",
              children: msg
            })
          })
        })
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (QuotaDisplay);

/***/ }),

/***/ 47456:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22796);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80210);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__, swr__WEBPACK_IMPORTED_MODULE_4__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__, swr__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_3__.defineMessages)({
  notvdbiddescription: {
    "id": "components.RequestModal.SearchByNameModal.notvdbiddescription",
    "defaultMessage": 'We were unable to automatically match this series. Please select the correct match below.'
  },
  nomatches: {
    "id": "components.RequestModal.SearchByNameModal.nomatches",
    "defaultMessage": 'We were unable to find a match for this series.'
  }
});

const SearchByNameModal = ({
  setTvdbId,
  tvdbId,
  onCancel,
  closeModal,
  modalTitle,
  modalSubTitle,
  tmdbId,
  backdrop
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_3__.useIntl)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_4__["default"])(`/api/v1/service/sonarr/lookup/${tmdbId}`);

  const handleClick = tvdbId => {
    setTvdbId(tvdbId);
  };

  if ((data ?? []).length === 0 || error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      loading: !data && !error,
      backgroundClickable: true,
      onOk: onCancel,
      title: modalTitle,
      subTitle: modalSubTitle,
      okText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].close */ .Z.close),
      okButtonType: "primary",
      backdrop: backdrop,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.nomatches),
        type: "info"
      })
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    backgroundClickable: true,
    onCancel: onCancel,
    onOk: closeModal,
    title: modalTitle,
    subTitle: modalSubTitle,
    okText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].next */ .Z.next),
    okDisabled: !tvdbId,
    okButtonType: "primary",
    backdrop: backdrop,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      title: intl.formatMessage(messages.notvdbiddescription),
      type: "info"
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "grid grid-cols-1 gap-4 pb-2 md:grid-cols-2",
      children: data?.slice(0, 6).map(item => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("button", {
        className: "container mx-auto flex h-40 scale-100 transform-gpu cursor-pointer flex-col items-center justify-center space-y-4 rounded-xl outline-none transition hover:scale-105 focus:outline-none focus:ring focus:ring-indigo-500 focus:ring-opacity-70",
        onClick: () => handleClick(item.tvdbId),
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: `flex h-40 w-full items-center overflow-hidden rounded-xl border border-gray-700 bg-gray-700 bg-opacity-20 p-2 shadow backdrop-blur transition ${tvdbId === item.tvdbId ? 'ring ring-indigo-500' : ''} `,
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
            className: "flex w-24 flex-none items-center space-x-4",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("img", {
              src: item.remotePoster ?? '/images/overseerr_poster_not_found.png',
              alt: item.title,
              className: "h-100 w-auto rounded-md"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "flex-grow self-start p-3 text-left",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
              className: "text-sm font-medium leading-tight",
              children: item.year
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
              className: "text-grey-200 text-xl font-bold leading-tight",
              style: {
                WebkitLineClamp: 1,
                display: '-webkit-box',
                overflow: 'hidden',
                WebkitBoxOrient: 'vertical',
                wordBreak: 'break-word'
              },
              children: item.title
            }), item.overview && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
              className: "whitespace-normal text-xs text-gray-400",
              style: {
                WebkitLineClamp: 5,
                display: '-webkit-box',
                overflow: 'hidden',
                WebkitBoxOrient: 'vertical',
                wordBreak: 'break-word'
              },
              children: item.overview
            })]
          })]
        })
      }, item.tvdbId))
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SearchByNameModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 44001:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22796);
/* harmony import */ var _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59183);
/* harmony import */ var _app_components_RequestModal_QuotaDisplay__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(42707);
/* harmony import */ var _app_components_RequestModal_SearchByNameModal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47456);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80210);
/* harmony import */ var _server_api_themoviedb_constants__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(70106);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(59147);
/* harmony import */ var _server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(44941);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_3__, _app_components_RequestModal_SearchByNameModal__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_15__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_3__, _app_components_RequestModal_SearchByNameModal__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_13__.defineMessages)({
  requestadmin: {
    "id": "components.RequestModal.requestadmin",
    "defaultMessage": 'This request will be approved automatically.'
  },
  requestSuccess: {
    "id": "components.RequestModal.requestSuccess",
    "defaultMessage": '<strong>{title}</strong> requested successfully!'
  },
  requestseriestitle: {
    "id": "components.RequestModal.requestseriestitle",
    "defaultMessage": 'Request Series'
  },
  requestseries4ktitle: {
    "id": "components.RequestModal.requestseries4ktitle",
    "defaultMessage": 'Request Series in 4K'
  },
  edit: {
    "id": "components.RequestModal.edit",
    "defaultMessage": 'Edit Request'
  },
  approve: {
    "id": "components.RequestModal.approve",
    "defaultMessage": 'Approve Request'
  },
  cancel: {
    "id": "components.RequestModal.cancel",
    "defaultMessage": 'Cancel Request'
  },
  pendingrequest: {
    "id": "components.RequestModal.pendingrequest",
    "defaultMessage": 'Pending Request'
  },
  pending4krequest: {
    "id": "components.RequestModal.pending4krequest",
    "defaultMessage": 'Pending 4K Request'
  },
  requestfrom: {
    "id": "components.RequestModal.requestfrom",
    "defaultMessage": "{username}'s request is pending approval."
  },
  requestseasons: {
    "id": "components.RequestModal.requestseasons",
    "defaultMessage": 'Request {seasonCount} {seasonCount, plural, one {Season} other {Seasons}}'
  },
  requestseasons4k: {
    "id": "components.RequestModal.requestseasons4k",
    "defaultMessage": 'Request {seasonCount} {seasonCount, plural, one {Season} other {Seasons}} in 4K'
  },
  alreadyrequested: {
    "id": "components.RequestModal.alreadyrequested",
    "defaultMessage": 'Already Requested'
  },
  selectseason: {
    "id": "components.RequestModal.selectseason",
    "defaultMessage": 'Select Season(s)'
  },
  season: {
    "id": "components.RequestModal.season",
    "defaultMessage": 'Season'
  },
  numberofepisodes: {
    "id": "components.RequestModal.numberofepisodes",
    "defaultMessage": '# of Episodes'
  },
  seasonnumber: {
    "id": "components.RequestModal.seasonnumber",
    "defaultMessage": 'Season {number}'
  },
  errorediting: {
    "id": "components.RequestModal.errorediting",
    "defaultMessage": 'Something went wrong while editing the request.'
  },
  requestedited: {
    "id": "components.RequestModal.requestedited",
    "defaultMessage": 'Request for <strong>{title}</strong> edited successfully!'
  },
  requestApproved: {
    "id": "components.RequestModal.requestApproved",
    "defaultMessage": 'Request for <strong>{title}</strong> approved!'
  },
  requestcancelled: {
    "id": "components.RequestModal.requestcancelled",
    "defaultMessage": 'Request for <strong>{title}</strong> canceled.'
  },
  autoapproval: {
    "id": "components.RequestModal.autoapproval",
    "defaultMessage": 'Automatic Approval'
  },
  requesterror: {
    "id": "components.RequestModal.requesterror",
    "defaultMessage": 'Something went wrong while submitting the request.'
  },
  pendingapproval: {
    "id": "components.RequestModal.pendingapproval",
    "defaultMessage": 'Your request is pending approval.'
  }
});

const TvRequestModal = ({
  onCancel,
  onComplete,
  tmdbId,
  onUpdating,
  editRequest,
  is4k = false
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_14__.useToasts)();
  const editingSeasons = (editRequest?.seasons ?? []).map(season => season.seasonNumber);
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_15__["default"])(`/api/v1/tv/${tmdbId}`);
  const {
    0: requestOverrides,
    1: setRequestOverrides
  } = (0,react__WEBPACK_IMPORTED_MODULE_12__.useState)(null);
  const {
    0: selectedSeasons,
    1: setSelectedSeasons
  } = (0,react__WEBPACK_IMPORTED_MODULE_12__.useState)(editRequest ? editingSeasons : []);
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_13__.useIntl)();
  const {
    user,
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .useUser */ .aF)();
  const {
    0: searchModal,
    1: setSearchModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_12__.useState)({
    show: true
  });
  const {
    0: tvdbId,
    1: setTvdbId
  } = (0,react__WEBPACK_IMPORTED_MODULE_12__.useState)(undefined);
  const {
    data: quota
  } = (0,swr__WEBPACK_IMPORTED_MODULE_15__["default"])(user && (!requestOverrides?.user?.id || hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.MANAGE_USERS */ .y.MANAGE_USERS)) ? `/api/v1/user/${requestOverrides?.user?.id ?? user.id}/quota` : null);
  const currentlyRemaining = (quota?.tv.remaining ?? 0) - selectedSeasons.length + (editRequest?.seasons ?? []).length;

  const updateRequest = async (alsoApproveRequest = false) => {
    if (!editRequest) {
      return;
    }

    if (onUpdating) {
      onUpdating(true);
      (0,swr__WEBPACK_IMPORTED_MODULE_15__.mutate)('/api/v1/request/count');
    }

    try {
      if (selectedSeasons.length > 0) {
        await axios__WEBPACK_IMPORTED_MODULE_11__["default"].put(`/api/v1/request/${editRequest.id}`, {
          mediaType: 'tv',
          serverId: requestOverrides?.server,
          profileId: requestOverrides?.profile,
          rootFolder: requestOverrides?.folder,
          languageProfileId: requestOverrides?.language,
          userId: requestOverrides?.user?.id,
          tags: requestOverrides?.tags,
          seasons: selectedSeasons
        });

        if (alsoApproveRequest) {
          await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post(`/api/v1/request/${editRequest.id}/approve`);
        }
      } else {
        await axios__WEBPACK_IMPORTED_MODULE_11__["default"]["delete"](`/api/v1/request/${editRequest.id}`);
      }

      (0,swr__WEBPACK_IMPORTED_MODULE_15__.mutate)('/api/v1/request?filter=all&take=10&sort=modified&skip=0');
      (0,swr__WEBPACK_IMPORTED_MODULE_15__.mutate)('/api/v1/request/count');
      addToast( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
        children: selectedSeasons.length > 0 ? intl.formatMessage(alsoApproveRequest ? messages.requestApproved : messages.requestedited, {
          title: data?.name,
          strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("strong", {
            children: msg
          })
        }) : intl.formatMessage(messages.requestcancelled, {
          title: data?.name,
          strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("strong", {
            children: msg
          })
        })
      }), {
        appearance: 'success',
        autoDismiss: true
      });

      if (onComplete) {
        onComplete(_server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaStatus.PENDING */ .Jp.PENDING);
      }
    } catch (e) {
      addToast( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
        children: intl.formatMessage(messages.errorediting)
      }), {
        appearance: 'error',
        autoDismiss: true
      });
    } finally {
      if (onUpdating) {
        onUpdating(false);
      }
    }
  };

  const sendRequest = async () => {
    if (settings.currentSettings.partialRequestsEnabled && selectedSeasons.length === 0) {
      return;
    }

    if (onUpdating) {
      onUpdating(true);
      (0,swr__WEBPACK_IMPORTED_MODULE_15__.mutate)('/api/v1/request/count');
    }

    try {
      let overrideParams = {};

      if (requestOverrides) {
        overrideParams = {
          serverId: requestOverrides.server,
          profileId: requestOverrides.profile,
          rootFolder: requestOverrides.folder,
          languageProfileId: requestOverrides.language,
          userId: requestOverrides?.user?.id,
          tags: requestOverrides.tags
        };
      }

      const response = await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post('/api/v1/request', _objectSpread({
        mediaId: data?.id,
        tvdbId: tvdbId ?? data?.externalIds.tvdbId,
        mediaType: 'tv',
        is4k,
        seasons: settings.currentSettings.partialRequestsEnabled ? selectedSeasons : getAllSeasons().filter(season => !getAllRequestedSeasons().includes(season))
      }, overrideParams));
      (0,swr__WEBPACK_IMPORTED_MODULE_15__.mutate)('/api/v1/request?filter=all&take=10&sort=modified&skip=0');

      if (response.data) {
        if (onComplete) {
          onComplete(response.data.media.status);
        }

        addToast( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
          children: intl.formatMessage(messages.requestSuccess, {
            title: data?.name,
            strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("strong", {
              children: msg
            })
          })
        }), {
          appearance: 'success',
          autoDismiss: true
        });
      }
    } catch (e) {
      addToast(intl.formatMessage(messages.requesterror), {
        appearance: 'error',
        autoDismiss: true
      });
    } finally {
      if (onUpdating) {
        onUpdating(false);
      }
    }
  };

  const getAllSeasons = () => {
    return (data?.seasons ?? []).filter(season => season.episodeCount !== 0).map(season => season.seasonNumber);
  };

  const getAllRequestedSeasons = () => {
    const requestedSeasons = (data?.mediaInfo?.requests ?? []).filter(request => request.is4k === is4k && request.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED).reduce((requestedSeasons, request) => {
      return [...requestedSeasons, ...request.seasons.filter(season => !editingSeasons.includes(season.seasonNumber)).map(sr => sr.seasonNumber)];
    }, []);
    const availableSeasons = (data?.mediaInfo?.seasons ?? []).filter(season => (season[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaStatus.AVAILABLE */ .Jp.AVAILABLE || season[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaStatus.PARTIALLY_AVAILABLE */ .Jp.PARTIALLY_AVAILABLE || season[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaStatus.PROCESSING */ .Jp.PROCESSING) && !requestedSeasons.includes(season.seasonNumber)).map(season => season.seasonNumber);
    return [...requestedSeasons, ...availableSeasons];
  };

  const isSelectedSeason = seasonNumber => selectedSeasons.includes(seasonNumber);

  const toggleSeason = seasonNumber => {
    // If this season already has a pending request, don't allow it to be toggled
    if (getAllRequestedSeasons().includes(seasonNumber)) {
      return;
    } // If there are no more remaining requests available, block toggle


    if (quota?.tv.limit && currentlyRemaining <= 0 && !isSelectedSeason(seasonNumber)) {
      return;
    }

    if (selectedSeasons.includes(seasonNumber)) {
      setSelectedSeasons(seasons => seasons.filter(sn => sn !== seasonNumber));
    } else {
      setSelectedSeasons(seasons => [...seasons, seasonNumber]);
    }
  };

  const unrequestedSeasons = getAllSeasons().filter(season => !getAllRequestedSeasons().includes(season));

  const toggleAllSeasons = () => {
    // If the user has a quota and not enough requests for all seasons, block toggleAllSeasons
    if (quota?.tv.limit && (quota?.tv.remaining ?? 0) < unrequestedSeasons.length) {
      return;
    }

    if (data && selectedSeasons.length >= 0 && selectedSeasons.length < unrequestedSeasons.length) {
      setSelectedSeasons(unrequestedSeasons);
    } else {
      setSelectedSeasons([]);
    }
  };

  const isAllSeasons = () => {
    if (!data) {
      return false;
    }

    return selectedSeasons.length === getAllSeasons().filter(season => !getAllRequestedSeasons().includes(season)).length;
  };

  const getSeasonRequest = seasonNumber => {
    let seasonRequest;

    if (data?.mediaInfo && (data.mediaInfo.requests || []).filter(request => request.is4k === is4k && request.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED).length > 0) {
      data.mediaInfo.requests.filter(request => request.is4k === is4k).forEach(request => {
        if (!seasonRequest) {
          seasonRequest = request.seasons.find(season => season.seasonNumber === seasonNumber);
        }
      });
    }

    return seasonRequest;
  };

  const isOwner = editRequest && editRequest.requestedBy.id === user?.id;
  return data && !error && !data.externalIds.tvdbId && searchModal.show ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_RequestModal_SearchByNameModal__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
    tvdbId: tvdbId,
    setTvdbId: setTvdbId,
    closeModal: () => setSearchModal({
      show: false
    }),
    onCancel: onCancel,
    modalTitle: intl.formatMessage(is4k ? messages.requestseries4ktitle : messages.requestseriestitle),
    modalSubTitle: data.name,
    tmdbId: tmdbId,
    backdrop: `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${data?.backdropPath}`
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    loading: !data && !error,
    backgroundClickable: true,
    onCancel: tvdbId ? () => setSearchModal({
      show: true
    }) : onCancel,
    onOk: () => editRequest ? hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS) ? updateRequest(true) : updateRequest() : sendRequest(),
    title: intl.formatMessage(editRequest ? is4k ? messages.pending4krequest : messages.pendingrequest : is4k ? messages.requestseries4ktitle : messages.requestseriestitle),
    subTitle: data?.name,
    okText: editRequest ? selectedSeasons.length === 0 ? intl.formatMessage(messages.cancel) : hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS) ? intl.formatMessage(messages.approve) : intl.formatMessage(messages.edit) : getAllRequestedSeasons().length >= getAllSeasons().length ? intl.formatMessage(messages.alreadyrequested) : !settings.currentSettings.partialRequestsEnabled ? intl.formatMessage(is4k ? _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].request4k */ .Z.request4k : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].request */ .Z.request) : selectedSeasons.length === 0 ? intl.formatMessage(messages.selectseason) : intl.formatMessage(is4k ? messages.requestseasons4k : messages.requestseasons, {
      seasonCount: selectedSeasons.length
    }),
    okDisabled: editRequest ? false : !settings.currentSettings.partialRequestsEnabled && quota?.tv.limit && unrequestedSeasons.length > quota.tv.limit ? true : getAllRequestedSeasons().length >= getAllSeasons().length || settings.currentSettings.partialRequestsEnabled && selectedSeasons.length === 0,
    okButtonType: editRequest ? settings.currentSettings.partialRequestsEnabled && selectedSeasons.length === 0 ? 'danger' : hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS) ? 'success' : 'primary' : 'primary',
    cancelText: editRequest ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].close */ .Z.close) : tvdbId ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].back */ .Z.back) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].cancel */ .Z.cancel),
    backdrop: `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${data?.backdropPath}`,
    children: [editRequest ? isOwner ? intl.formatMessage(messages.pendingapproval) : intl.formatMessage(messages.requestfrom, {
      username: editRequest?.requestedBy.displayName
    }) : null, hasPermission([_server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS, is4k ? _server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.AUTO_APPROVE_4K */ .y.AUTO_APPROVE_4K : _server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.AUTO_APPROVE */ .y.AUTO_APPROVE, is4k ? _server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.AUTO_APPROVE_4K_TV */ .y.AUTO_APPROVE_4K_TV : _server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.AUTO_APPROVE_TV */ .y.AUTO_APPROVE_TV], {
      type: 'or'
    }) && !(quota?.tv.limit && !settings.currentSettings.partialRequestsEnabled && unrequestedSeasons.length > (quota?.tv.remaining ?? 0)) && getAllRequestedSeasons().length < getAllSeasons().length && !editRequest && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("p", {
      className: "mt-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.requestadmin),
        type: "info"
      })
    }), (quota?.tv.limit ?? 0) > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_RequestModal_QuotaDisplay__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      mediaType: "tv",
      quota: quota?.tv,
      remaining: !settings.currentSettings.partialRequestsEnabled && unrequestedSeasons.length > (quota?.tv.remaining ?? 0) ? 0 : currentlyRemaining,
      userOverride: requestOverrides?.user && requestOverrides.user.id !== user?.id ? requestOverrides?.user?.id : undefined,
      overLimit: !settings.currentSettings.partialRequestsEnabled && unrequestedSeasons.length > (quota?.tv.remaining ?? 0) ? unrequestedSeasons.length : undefined
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
      className: "flex flex-col",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
        className: "-mx-4 sm:mx-0",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
          className: "inline-block min-w-full py-2 align-middle",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
            className: "overflow-hidden border border-gray-700 shadow backdrop-blur sm:rounded-lg",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("table", {
              className: "min-w-full",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("thead", {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("tr", {
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("th", {
                    className: `w-16 bg-gray-700 bg-opacity-80 px-4 py-3 ${!settings.currentSettings.partialRequestsEnabled && 'hidden'}`,
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("span", {
                      role: "checkbox",
                      tabIndex: 0,
                      "aria-checked": isAllSeasons(),
                      onClick: () => toggleAllSeasons(),
                      onKeyDown: e => {
                        if (e.key === 'Enter' || e.key === 'Space') {
                          toggleAllSeasons();
                        }
                      },
                      className: `relative inline-flex h-5 w-10 flex-shrink-0 cursor-pointer items-center justify-center pt-2 focus:outline-none ${quota?.tv.remaining && quota.tv.limit && quota.tv.remaining < unrequestedSeasons.length ? 'opacity-50' : ''}`,
                      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                        "aria-hidden": "true",
                        className: `${isAllSeasons() ? 'bg-indigo-500' : 'bg-gray-800'} absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out`
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                        "aria-hidden": "true",
                        className: `${isAllSeasons() ? 'translate-x-5' : 'translate-x-0'} absolute left-0 inline-block h-5 w-5 rounded-full border border-gray-200 bg-white shadow transition-transform duration-200 ease-in-out group-focus:border-blue-300 group-focus:ring`
                      })]
                    })
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("th", {
                    className: "bg-gray-700 bg-opacity-80 px-1 py-3 text-left text-xs font-medium uppercase leading-4 tracking-wider text-gray-200 md:px-6",
                    children: intl.formatMessage(messages.season)
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("th", {
                    className: "bg-gray-700 bg-opacity-80 px-5 py-3 text-left text-xs font-medium uppercase leading-4 tracking-wider text-gray-200 md:px-6",
                    children: intl.formatMessage(messages.numberofepisodes)
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("th", {
                    className: "bg-gray-700 bg-opacity-80 px-2 py-3 text-left text-xs font-medium uppercase leading-4 tracking-wider text-gray-200 md:px-6",
                    children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].status */ .Z.status)
                  })]
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("tbody", {
                className: "divide-y divide-gray-700",
                children: data?.seasons.filter(season => season.episodeCount !== 0).map(season => {
                  const seasonRequest = getSeasonRequest(season.seasonNumber);
                  const mediaSeason = data?.mediaInfo?.seasons.find(sn => sn.seasonNumber === season.seasonNumber && sn[is4k ? 'status4k' : 'status'] !== _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaStatus.UNKNOWN */ .Jp.UNKNOWN);
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("tr", {
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("td", {
                      className: `whitespace-nowrap px-4 py-4 text-sm font-medium leading-5 text-gray-100 ${!settings.currentSettings.partialRequestsEnabled && 'hidden'}`,
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("span", {
                        role: "checkbox",
                        tabIndex: 0,
                        "aria-checked": !!mediaSeason || !!seasonRequest && !editingSeasons.includes(season.seasonNumber) || isSelectedSeason(season.seasonNumber),
                        onClick: () => toggleSeason(season.seasonNumber),
                        onKeyDown: e => {
                          if (e.key === 'Enter' || e.key === 'Space') {
                            toggleSeason(season.seasonNumber);
                          }
                        },
                        className: `relative inline-flex h-5 w-10 flex-shrink-0 cursor-pointer items-center justify-center pt-2 focus:outline-none ${mediaSeason || quota?.tv.limit && currentlyRemaining <= 0 && !isSelectedSeason(season.seasonNumber) || !!seasonRequest && !editingSeasons.includes(season.seasonNumber) ? 'opacity-50' : ''}`,
                        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                          "aria-hidden": "true",
                          className: `${!!mediaSeason || !!seasonRequest && !editingSeasons.includes(season.seasonNumber) || isSelectedSeason(season.seasonNumber) ? 'bg-indigo-500' : 'bg-gray-700'} absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out`
                        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                          "aria-hidden": "true",
                          className: `${!!mediaSeason || !!seasonRequest && !editingSeasons.includes(season.seasonNumber) || isSelectedSeason(season.seasonNumber) ? 'translate-x-5' : 'translate-x-0'} absolute left-0 inline-block h-5 w-5 rounded-full border border-gray-200 bg-white shadow transition-transform duration-200 ease-in-out group-focus:border-blue-300 group-focus:ring`
                        })]
                      })
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("td", {
                      className: "whitespace-nowrap px-1 py-4 text-sm font-medium leading-5 text-gray-100 md:px-6",
                      children: season.seasonNumber === 0 ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].specials */ .Z.specials) : intl.formatMessage(messages.seasonnumber, {
                        number: season.seasonNumber
                      })
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("td", {
                      className: "whitespace-nowrap px-5 py-4 text-sm leading-5 text-gray-200 md:px-6",
                      children: season.episodeCount
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("td", {
                      className: "whitespace-nowrap py-4 pr-2 text-sm leading-5 text-gray-200 md:px-6",
                      children: [!seasonRequest && !mediaSeason && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].notrequested */ .Z.notrequested)
                      }), !mediaSeason && seasonRequest?.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaRequestStatus.PENDING */ .pi.PENDING && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        badgeType: "warning",
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].pending */ .Z.pending)
                      }), (!mediaSeason && seasonRequest?.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaRequestStatus.APPROVED */ .pi.APPROVED || mediaSeason?.[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaStatus.PROCESSING */ .Jp.PROCESSING) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        badgeType: "primary",
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].requested */ .Z.requested)
                      }), mediaSeason?.[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaStatus.PARTIALLY_AVAILABLE */ .Jp.PARTIALLY_AVAILABLE && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        badgeType: "success",
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].partiallyavailable */ .Z.partiallyavailable)
                      }), mediaSeason?.[is4k ? 'status4k' : 'status'] === _server_constants_media__WEBPACK_IMPORTED_MODULE_9__/* .MediaStatus.AVAILABLE */ .Jp.AVAILABLE && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                        badgeType: "success",
                        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].available */ .Z.available)
                      })]
                    })]
                  }, `season-${season.id}`);
                })
              })]
            })
          })
        })
      })
    }), (hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.REQUEST_ADVANCED */ .y.REQUEST_ADVANCED) || hasPermission(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_10__/* .Permission.MANAGE_REQUESTS */ .y.MANAGE_REQUESTS)) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_RequestModal_AdvancedRequester__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      type: "tv",
      is4k: is4k,
      isAnime: data?.keywords.some(keyword => keyword.id === _server_api_themoviedb_constants__WEBPACK_IMPORTED_MODULE_17__/* .ANIME_KEYWORD_ID */ .f),
      onChange: overrides => setRequestOverrides(overrides),
      requestUser: editRequest?.requestedBy,
      defaultOverrides: editRequest ? {
        folder: editRequest.rootFolder,
        profile: editRequest.profileId,
        server: editRequest.serverId,
        language: editRequest.languageProfileId,
        tags: editRequest.tags
      } : undefined
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TvRequestModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 42040:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_RequestModal_CollectionRequestModal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71907);
/* harmony import */ var _app_components_RequestModal_MovieRequestModal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99486);
/* harmony import */ var _app_components_RequestModal_TvRequestModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44001);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_RequestModal_CollectionRequestModal__WEBPACK_IMPORTED_MODULE_0__, _app_components_RequestModal_MovieRequestModal__WEBPACK_IMPORTED_MODULE_1__, _app_components_RequestModal_TvRequestModal__WEBPACK_IMPORTED_MODULE_2__, _headlessui_react__WEBPACK_IMPORTED_MODULE_3__]);
([_app_components_RequestModal_CollectionRequestModal__WEBPACK_IMPORTED_MODULE_0__, _app_components_RequestModal_MovieRequestModal__WEBPACK_IMPORTED_MODULE_1__, _app_components_RequestModal_TvRequestModal__WEBPACK_IMPORTED_MODULE_2__, _headlessui_react__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const RequestModal = ({
  type,
  show,
  tmdbId,
  is4k,
  editRequest,
  onComplete,
  onUpdating,
  onCancel
}) => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Transition, {
    as: "div",
    enter: "transition-opacity duration-300",
    enterFrom: "opacity-0",
    enterTo: "opacity-100",
    leave: "transition-opacity duration-300",
    leaveFrom: "opacity-100",
    leaveTo: "opacity-0",
    show: show,
    children: type === 'movie' ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_RequestModal_MovieRequestModal__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      onComplete: onComplete,
      onCancel: onCancel,
      tmdbId: tmdbId,
      onUpdating: onUpdating,
      is4k: is4k,
      editRequest: editRequest
    }) : type === 'tv' ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_RequestModal_TvRequestModal__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      onComplete: onComplete,
      onCancel: onCancel,
      tmdbId: tmdbId,
      onUpdating: onUpdating,
      is4k: is4k,
      editRequest: editRequest
    }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_RequestModal_CollectionRequestModal__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      onComplete: onComplete,
      onCancel: onCancel,
      tmdbId: tmdbId,
      onUpdating: onUpdating,
      is4k: is4k
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;