"use strict";
exports.id = 55535;
exports.ids = [55535];
exports.modules = {

/***/ 93399:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);





const Tag = ({
  children,
  iconSvg
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "inline-flex cursor-pointer items-center rounded-full bg-gray-800 px-2 py-1 text-sm text-gray-200 ring-1 ring-gray-600 transition hover:bg-gray-700",
    children: [iconSvg ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().cloneElement(iconSvg, {
      className: 'mr-1 h-4 w-4'
    }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_0__.TagIcon, {
      className: "mr-1 h-4 w-4"
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("span", {
      children: children
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tag);

/***/ }),

/***/ 95308:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61276);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_intersection_observer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44009);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_4__]);
([_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.defineMessages)({
  seemore: {
    "id": "components.MediaSlider.ShowMoreCard.seemore",
    "defaultMessage": 'See More'
  }
});

const ShowMoreCard = ({
  url,
  posters
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.useIntl)();
  const {
    0: isHovered,
    1: setHovered
  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const {
    ref,
    inView
  } = (0,react_intersection_observer__WEBPACK_IMPORTED_MODULE_4__.useInView)({
    triggerOnce: true
  });

  if (!inView) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
      ref: ref,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"].Placeholder */ .Z.Placeholder, {})
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx((next_link__WEBPACK_IMPORTED_MODULE_2___default()), {
    href: url,
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("a", {
      className: 'w-36 sm:w-36 md:w-44',
      onMouseEnter: () => {
        setHovered(true);
      },
      onMouseLeave: () => setHovered(false),
      onKeyDown: e => {
        if (e.key === 'Enter') {
          setHovered(true);
        }
      },
      role: "link",
      tabIndex: 0,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
        className: `relative w-36 transform-gpu cursor-pointer
         overflow-hidden rounded-xl text-white shadow-lg ring-1 transition duration-150 ease-in-out sm:w-36 md:w-44 ${isHovered ? 'scale-105 bg-gray-600 ring-gray-500' : 'scale-100 bg-gray-800 ring-gray-700'}`,
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          style: {
            paddingBottom: '150%'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: "absolute inset-0 flex h-full w-full flex-col items-center p-2",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "relative z-10 flex h-full flex-wrap items-center justify-center opacity-30",
              children: [posters[0] && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
                className: "w-1/2 p-1",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("img", {
                  src: `//image.tmdb.org/t/p/w300_and_h450_face${posters[0]}`,
                  alt: "",
                  className: "w-full rounded-md"
                })
              }), posters[1] && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
                className: "w-1/2 p-1",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("img", {
                  src: `//image.tmdb.org/t/p/w300_and_h450_face${posters[1]}`,
                  alt: "",
                  className: "w-full rounded-md"
                })
              }), posters[2] && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
                className: "w-1/2 p-1",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("img", {
                  src: `//image.tmdb.org/t/p/w300_and_h450_face${posters[2]}`,
                  alt: "",
                  className: "w-full rounded-md"
                })
              }), posters[3] && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
                className: "w-1/2 p-1",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("img", {
                  src: `//image.tmdb.org/t/p/w300_and_h450_face${posters[3]}`,
                  alt: "",
                  className: "w-full rounded-md"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "absolute inset-0 z-20 flex flex-col items-center justify-center text-white",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__.ArrowRightCircleIcon, {
                className: "w-14"
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
                className: "mt-2 font-extrabold",
                children: intl.formatMessage(messages.seemore)
              })]
            })]
          })
        })
      })
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ShowMoreCard);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 18512:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_MediaSlider_ShowMoreCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(95308);
/* harmony import */ var _app_components_PersonCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(68229);
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11360);
/* harmony import */ var _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61276);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1388);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(59147);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var swr_infinite__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(91448);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_MediaSlider_ShowMoreCard__WEBPACK_IMPORTED_MODULE_0__, _app_components_PersonCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__, _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_4__, swr_infinite__WEBPACK_IMPORTED_MODULE_9__]);
([_app_components_MediaSlider_ShowMoreCard__WEBPACK_IMPORTED_MODULE_0__, _app_components_PersonCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__, _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_4__, swr_infinite__WEBPACK_IMPORTED_MODULE_9__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














const MediaSlider = ({
  title,
  url,
  linkUrl,
  extraParams,
  sliderKey,
  hideWhenEmpty = false,
  onNewTitles
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)();
  const {
    data,
    error,
    setSize,
    size
  } = (0,swr_infinite__WEBPACK_IMPORTED_MODULE_9__["default"])((pageIndex, previousPageData) => {
    if (previousPageData && pageIndex + 1 > previousPageData.totalPages) {
      return null;
    }

    return `${url}?page=${pageIndex + 1}${extraParams ? `&${extraParams}` : ''}`;
  }, {
    initialSize: 2
  });
  let titles = (data ?? []).reduce((a, v) => [...a, ...v.results], []);

  if (settings.currentSettings.hideAvailable) {
    titles = titles.filter(i => (i.mediaType === 'movie' || i.mediaType === 'tv') && i.mediaInfo?.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_6__/* .MediaStatus.AVAILABLE */ .Jp.AVAILABLE && i.mediaInfo?.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_6__/* .MediaStatus.PARTIALLY_AVAILABLE */ .Jp.PARTIALLY_AVAILABLE);
  }

  (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (titles.length < 24 && size < 5 && (data?.[0]?.totalResults ?? 0) > size * 20) {
      setSize(size + 1);
    }

    if (onNewTitles) {
      // We aren't reporting all titles. We just want to know if there are any titles
      // at all for our purposes.
      onNewTitles(titles.length);
    }
  }, [titles, setSize, size, data, onNewTitles]);

  if (hideWhenEmpty && (data?.[0].results ?? []).length === 0) {
    return null;
  }

  const finalTitles = titles.slice(0, 20).map(title => {
    switch (title.mediaType) {
      case 'movie':
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
          id: title.id,
          image: title.posterPath,
          status: title.mediaInfo?.status,
          summary: title.overview,
          title: title.title,
          userScore: title.voteAverage,
          year: title.releaseDate,
          mediaType: title.mediaType,
          inProgress: (title.mediaInfo?.downloadStatus ?? []).length > 0
        });

      case 'tv':
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
          id: title.id,
          image: title.posterPath,
          status: title.mediaInfo?.status,
          summary: title.overview,
          title: title.name,
          userScore: title.voteAverage,
          year: title.firstAirDate,
          mediaType: title.mediaType,
          inProgress: (title.mediaInfo?.downloadStatus ?? []).length > 0
        });

      case 'person':
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_PersonCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          personId: title.id,
          name: title.name,
          profilePath: title.profilePath
        });
    }
  });

  if (linkUrl && titles.length > 20) {
    finalTitles.push( /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_MediaSlider_ShowMoreCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      url: linkUrl,
      posters: titles.slice(20, 24).map(title => title.mediaType !== 'person' ? title.posterPath : undefined)
    }));
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
      className: "slider-header",
      children: linkUrl ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx((next_link__WEBPACK_IMPORTED_MODULE_7___default()), {
        href: linkUrl,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("a", {
          className: "slider-title min-w-0 pr-16",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("span", {
            className: "truncate",
            children: title
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__.ArrowRightCircleIcon, {})]
        })
      }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
        className: "slider-title",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("span", {
          children: title
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      sliderKey: sliderKey,
      isLoading: !data && !error,
      isEmpty: false,
      items: finalTitles
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaSlider);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;