"use strict";
exports.id = 67240;
exports.ids = [67240];
exports.modules = {

/***/ 67240:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7292);
/* harmony import */ var _app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(66234);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const GenreCard = ({
  image,
  url,
  name,
  canExpand = false
}) => {
  const {
    0: isHovered,
    1: setHovered
  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx((next_link__WEBPACK_IMPORTED_MODULE_1___default()), {
    href: url,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("a", {
      className: `relative flex h-32 items-center justify-center sm:h-36 ${canExpand ? 'w-full' : 'w-56 sm:w-72'} transform-gpu cursor-pointer p-8 shadow ring-1 transition duration-300 ease-in-out ${isHovered ? 'scale-105 bg-gray-700 bg-opacity-100 ring-gray-500' : 'scale-100 bg-gray-800 bg-opacity-80 ring-gray-700'} overflow-hidden rounded-xl bg-cover bg-center`,
      onMouseEnter: () => {
        setHovered(true);
      },
      onMouseLeave: () => setHovered(false),
      onKeyDown: e => {
        if (e.key === 'Enter') {
          setHovered(true);
        }
      },
      role: "link",
      tabIndex: 0,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        src: image,
        alt: "",
        layout: "fill",
        objectFit: "cover"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: `absolute inset-0 z-10 h-full w-full bg-gray-800 transition duration-300 ${isHovered ? 'bg-opacity-10' : 'bg-opacity-30'}`
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "relative z-20 w-full truncate whitespace-normal text-center text-2xl font-bold text-white sm:text-3xl",
        children: name
      })]
    })
  });
};

const GenreCardPlaceholder = () => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
    className: `relative h-32 w-56 animate-pulse rounded-xl bg-gray-700 sm:h-40 sm:w-72`
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_4__/* .withProperties */ .W)(GenreCard, {
  Placeholder: GenreCardPlaceholder
}));
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;