"use strict";
exports.id = 68402;
exports.ids = [68402];
exports.modules = {

/***/ 36129:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99073);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86799);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__]);
_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];





const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.defineMessages)({
  estimatedtime: {
    "id": "components.DownloadBlock.estimatedtime",
    "defaultMessage": 'Estimated {time}'
  },
  formattedTitle: {
    "id": "components.DownloadBlock.formattedTitle",
    "defaultMessage": '{title}: Season {seasonNumber} Episode {episodeNumber}'
  }
});

const DownloadBlock = ({
  downloadItem,
  is4k = false,
  title
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.useIntl)();
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .useUser */ .aF)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "p-4",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      className: "mb-2 w-56 truncate text-sm sm:w-80 md:w-full",
      children: hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.ADMIN */ .y3.ADMIN) ? downloadItem.title : downloadItem.episode ? intl.formatMessage(messages.formattedTitle, {
        title,
        seasonNumber: downloadItem?.episode?.seasonNumber,
        episodeNumber: downloadItem?.episode?.episodeNumber
      }) : title
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "relative mb-2 h-6 min-w-0 overflow-hidden rounded-full bg-gray-700",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "h-8 bg-indigo-600 transition-all duration-200 ease-in-out",
        style: {
          width: `${downloadItem.size ? Math.round((downloadItem.size - downloadItem.sizeLeft) / downloadItem.size * 100) : 0}%`
        }
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "absolute inset-0 flex h-6 w-full items-center justify-center text-xs",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
          children: [downloadItem.size ? Math.round((downloadItem.size - downloadItem.sizeLeft) / downloadItem.size * 100) : 0, "%"]
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "flex items-center justify-between text-xs",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
        children: [is4k && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          badgeType: "warning",
          className: "mr-2",
          children: "4K"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          className: "capitalize",
          children: downloadItem.status
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("span", {
        children: downloadItem.estimatedCompletionTime ? intl.formatMessage(messages.estimatedtime, {
          time: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_2__.FormattedRelativeTime, {
            value: Math.floor((new Date(downloadItem.estimatedCompletionTime).getTime() - Date.now()) / 1000),
            updateIntervalInSeconds: 1,
            numeric: "auto"
          })
        }) : ''
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DownloadBlock);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12001:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43907);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63145);
/* harmony import */ var _app_components_DownloadBlock__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36129);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(80210);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(59147);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_DownloadBlock__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__]);
([_app_components_DownloadBlock__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }













const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.defineMessages)({
  status: {
    "id": "components.StatusBadge.status",
    "defaultMessage": '{status}'
  },
  status4k: {
    "id": "components.StatusBadge.status4k",
    "defaultMessage": '4K {status}'
  },
  playonplex: {
    "id": "components.StatusBadge.playonplex",
    "defaultMessage": 'Play on Plex'
  },
  openinarr: {
    "id": "components.StatusBadge.openinarr",
    "defaultMessage": 'Open in {arr}'
  },
  managemedia: {
    "id": "components.StatusBadge.managemedia",
    "defaultMessage": 'Manage {mediaType}'
  },
  seasonepisodenumber: {
    "id": "components.StatusBadge.seasonepisodenumber",
    "defaultMessage": 'S{seasonNumber}E{episodeNumber}'
  }
});

const StatusBadge = ({
  status,
  downloadItem = [],
  is4k = false,
  inProgress = false,
  plexUrl,
  serviceUrl,
  tmdbId,
  mediaType,
  title
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.useIntl)();
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .useUser */ .aF)();
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)();
  let mediaLink;
  let mediaLinkDescription;

  const calculateDownloadProgress = media => {
    return Math.round((media?.size - media?.sizeLeft) / media?.size * 100);
  };

  if (mediaType && plexUrl && hasPermission(is4k ? [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K, mediaType === 'movie' ? _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.REQUEST_4K_MOVIE */ .y3.REQUEST_4K_MOVIE : _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.REQUEST_4K_TV */ .y3.REQUEST_4K_TV] : [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.REQUEST */ .y3.REQUEST, mediaType === 'movie' ? _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.REQUEST_MOVIE */ .y3.REQUEST_MOVIE : _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.REQUEST_TV */ .y3.REQUEST_TV], {
    type: 'or'
  }) && (!is4k || (mediaType === 'movie' ? settings.currentSettings.movie4kEnabled : settings.currentSettings.series4kEnabled))) {
    mediaLink = plexUrl;
    mediaLinkDescription = intl.formatMessage(messages.playonplex);
  } else if (hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS)) {
    if (mediaType && tmdbId) {
      mediaLink = `/${mediaType}/${tmdbId}?manage=1`;
      mediaLinkDescription = intl.formatMessage(messages.managemedia, {
        mediaType: intl.formatMessage(mediaType === 'movie' ? _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].movie */ .Z.movie : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].tvshow */ .Z.tvshow)
      });
    } else if (hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.ADMIN */ .y3.ADMIN) && serviceUrl) {
      mediaLink = serviceUrl;
      mediaLinkDescription = intl.formatMessage(messages.openinarr, {
        arr: mediaType === 'movie' ? 'Radarr' : 'Sonarr'
      });
    }
  }

  const tooltipContent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("ul", {
    children: downloadItem.map((status, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("li", {
      className: "border-b border-gray-700 last:border-b-0",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_DownloadBlock__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        downloadItem: status,
        title: Array.isArray(title) ? title[index] : title,
        is4k: is4k
      })
    }, `dl-status-${status.externalId}-${index}`))
  });

  const badgeDownloadProgress = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
    className: `
      absolute top-0 left-0 z-10 flex h-full bg-opacity-80 ${status === _server_constants_media__WEBPACK_IMPORTED_MODULE_7__/* .MediaStatus.PROCESSING */ .Jp.PROCESSING ? 'bg-indigo-500' : 'bg-green-500'} transition-all duration-200 ease-in-out
    `,
    style: {
      width: `${downloadItem ? calculateDownloadProgress(downloadItem[0]) : 0}%`
    }
  });

  switch (status) {
    case _server_constants_media__WEBPACK_IMPORTED_MODULE_7__/* .MediaStatus.AVAILABLE */ .Jp.AVAILABLE:
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        content: inProgress ? tooltipContent : mediaLinkDescription,
        className: `${inProgress && 'hidden max-h-96 w-96 overflow-y-auto sm:block'}`,
        tooltipConfig: _objectSpread({}, inProgress && {
          interactive: true,
          delayHide: 100
        }),
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          badgeType: "success",
          href: mediaLink,
          className: `${inProgress && 'relative !bg-gray-700 !bg-opacity-80 !px-0 hover:!bg-gray-700'} overflow-hidden`,
          children: [inProgress && badgeDownloadProgress, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: `relative z-20 flex items-center ${inProgress && 'px-2'}`,
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
              children: intl.formatMessage(is4k ? messages.status4k : messages.status, {
                status: inProgress ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].processing */ .Z.processing) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].available */ .Z.available)
              })
            }), inProgress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
              children: [mediaType === 'tv' && downloadItem[0].episode && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                className: "ml-1",
                children: intl.formatMessage(messages.seasonepisodenumber, {
                  seasonNumber: downloadItem[0].episode.seasonNumber,
                  episodeNumber: downloadItem[0].episode.episodeNumber
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                className: "ml-1 h-3 w-3"
              })]
            })]
          })]
        })
      });

    case _server_constants_media__WEBPACK_IMPORTED_MODULE_7__/* .MediaStatus.PARTIALLY_AVAILABLE */ .Jp.PARTIALLY_AVAILABLE:
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        content: inProgress ? tooltipContent : mediaLinkDescription,
        className: `${inProgress && 'hidden max-h-96 w-96 overflow-y-auto sm:block'}`,
        tooltipConfig: _objectSpread({}, inProgress && {
          interactive: true,
          delayHide: 100
        }),
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          badgeType: "success",
          href: mediaLink,
          className: `${inProgress && 'relative !bg-gray-700 !bg-opacity-80 !px-0 hover:!bg-gray-700'} overflow-hidden`,
          children: [inProgress && badgeDownloadProgress, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: `relative z-20 flex items-center ${inProgress && 'px-2'}`,
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
              children: intl.formatMessage(is4k ? messages.status4k : messages.status, {
                status: inProgress ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].processing */ .Z.processing) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].partiallyavailable */ .Z.partiallyavailable)
              })
            }), inProgress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
              children: [mediaType === 'tv' && downloadItem[0].episode && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                className: "ml-1",
                children: intl.formatMessage(messages.seasonepisodenumber, {
                  seasonNumber: downloadItem[0].episode.seasonNumber,
                  episodeNumber: downloadItem[0].episode.episodeNumber
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                className: "ml-1 h-3 w-3"
              })]
            })]
          })]
        })
      });

    case _server_constants_media__WEBPACK_IMPORTED_MODULE_7__/* .MediaStatus.PROCESSING */ .Jp.PROCESSING:
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        content: inProgress ? tooltipContent : mediaLinkDescription,
        className: `${inProgress && 'hidden max-h-96 w-96 overflow-y-auto sm:block'}`,
        tooltipConfig: _objectSpread({}, inProgress && {
          interactive: true,
          delayHide: 100
        }),
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          badgeType: "primary",
          href: mediaLink,
          className: `${inProgress && 'relative !bg-gray-700 !bg-opacity-80 !px-0 hover:!bg-gray-700'} overflow-hidden`,
          children: [inProgress && badgeDownloadProgress, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: `relative z-20 flex items-center ${inProgress && 'px-2'}`,
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
              children: intl.formatMessage(is4k ? messages.status4k : messages.status, {
                status: inProgress ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].processing */ .Z.processing) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].requested */ .Z.requested)
              })
            }), inProgress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
              children: [mediaType === 'tv' && downloadItem[0].episode && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                className: "ml-1",
                children: intl.formatMessage(messages.seasonepisodenumber, {
                  seasonNumber: downloadItem[0].episode.seasonNumber,
                  episodeNumber: downloadItem[0].episode.episodeNumber
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                className: "ml-1 h-3 w-3"
              })]
            })]
          })]
        })
      });

    case _server_constants_media__WEBPACK_IMPORTED_MODULE_7__/* .MediaStatus.PENDING */ .Jp.PENDING:
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        content: mediaLinkDescription,
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          badgeType: "warning",
          href: mediaLink,
          children: intl.formatMessage(is4k ? messages.status4k : messages.status, {
            status: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].pending */ .Z.pending)
          })
        })
      });

    default:
      return null;
  }
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusBadge);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 28299:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "v": () => (/* binding */ refreshIntervalHelper)
/* harmony export */ });
const refreshIntervalHelper = (downloadItem, timer) => {
  if ((downloadItem.downloadStatus ?? []).length > 0 || (downloadItem.downloadStatus4k ?? []).length > 0) {
    return timer;
  } else {
    return 0;
  }
};

/***/ })

};
;