"use strict";
exports.id = 77867;
exports.ids = [77867];
exports.modules = {

/***/ 77867:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80210);
/* harmony import */ var _app_utils_plex__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2705);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_utils_plex__WEBPACK_IMPORTED_MODULE_1__]);
_app_utils_plex__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.defineMessages)({
  signinwithplex: {
    "id": "components.PlexLoginButton.signinwithplex",
    "defaultMessage": 'Sign In'
  },
  signingin: {
    "id": "components.PlexLoginButton.signingin",
    "defaultMessage": 'Signing In…'
  }
});
const plexOAuth = new _app_utils_plex__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z();

const PlexLoginButton = ({
  onAuthToken,
  onError,
  isProcessing
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.useIntl)();
  const {
    0: loading,
    1: setLoading
  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);

  const getPlexLogin = async () => {
    setLoading(true);

    try {
      const authToken = await plexOAuth.login();
      setLoading(false);
      onAuthToken(authToken);
    } catch (e) {
      if (onError) {
        onError(e.message);
      }

      setLoading(false);
    }
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
    className: "block w-full rounded-md shadow-sm",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("button", {
      type: "button",
      onClick: () => {
        plexOAuth.preparePopup();
        setTimeout(() => getPlexLogin(), 1500);
      },
      disabled: loading || isProcessing,
      className: "plex-button",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__.ArrowLeftOnRectangleIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
        children: loading ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_0__/* ["default"].loading */ .Z.loading) : isProcessing ? intl.formatMessage(messages.signingin) : intl.formatMessage(messages.signinwithplex)
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PlexLoginButton);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2705:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99648);
/* harmony import */ var bowser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92793);
/* harmony import */ var bowser__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(bowser__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([axios__WEBPACK_IMPORTED_MODULE_0__]);
axios__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




const uuidv4 = () => {
  return (1e7.toString() + -1e3 + -4e3 + -8e3 + -1e11).replace(/[018]/g, function (c) {
    return (parseInt(c) ^ window.crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> parseInt(c) / 4).toString(16);
  });
};

class PlexOAuth {
  constructor() {
    _defineProperty(this, "plexHeaders", void 0);

    _defineProperty(this, "pin", void 0);

    _defineProperty(this, "popup", void 0);

    _defineProperty(this, "authToken", void 0);
  }

  initializeHeaders() {
    if (!window) {
      throw new Error('Window is not defined. Are you calling this in the browser?');
    }

    let clientId = localStorage.getItem('plex-client-id');

    if (!clientId) {
      const uuid = uuidv4();
      localStorage.setItem('plex-client-id', uuid);
      clientId = uuid;
    }

    const browser = bowser__WEBPACK_IMPORTED_MODULE_1___default().getParser(window.navigator.userAgent);
    this.plexHeaders = {
      Accept: 'application/json',
      'X-Plex-Product': 'Overseerr',
      'X-Plex-Version': 'Plex OAuth',
      'X-Plex-Client-Identifier': clientId,
      'X-Plex-Model': 'Plex OAuth',
      'X-Plex-Platform': browser.getBrowserName(),
      'X-Plex-Platform-Version': browser.getBrowserVersion(),
      'X-Plex-Device': browser.getOSName(),
      'X-Plex-Device-Name': `${browser.getBrowserName()} (Overseerr)`,
      'X-Plex-Device-Screen-Resolution': window.screen.width + 'x' + window.screen.height,
      'X-Plex-Language': 'en'
    };
  }

  async getPin() {
    if (!this.plexHeaders) {
      throw new Error('You must initialize the plex headers clientside to login');
    }

    const response = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].post('https://plex.tv/api/v2/pins?strong=true', undefined, {
      headers: this.plexHeaders
    });
    this.pin = {
      id: response.data.id,
      code: response.data.code
    };
    return this.pin;
  }

  preparePopup() {
    this.openPopup({
      title: 'Plex Auth',
      w: 600,
      h: 700
    });
  }

  async login() {
    this.initializeHeaders();
    await this.getPin();

    if (!this.plexHeaders || !this.pin) {
      throw new Error('Unable to call login if class is not initialized.');
    }

    const params = {
      clientID: this.plexHeaders['X-Plex-Client-Identifier'],
      'context[device][product]': this.plexHeaders['X-Plex-Product'],
      'context[device][version]': this.plexHeaders['X-Plex-Version'],
      'context[device][platform]': this.plexHeaders['X-Plex-Platform'],
      'context[device][platformVersion]': this.plexHeaders['X-Plex-Platform-Version'],
      'context[device][device]': this.plexHeaders['X-Plex-Device'],
      'context[device][deviceName]': this.plexHeaders['X-Plex-Device-Name'],
      'context[device][model]': this.plexHeaders['X-Plex-Model'],
      'context[device][screenResolution]': this.plexHeaders['X-Plex-Device-Screen-Resolution'],
      'context[device][layout]': 'desktop',
      code: this.pin.code
    };

    if (this.popup) {
      this.popup.location.href = `https://app.plex.tv/auth/#!?${this.encodeData(params)}`;
    }

    return this.pinPoll();
  }

  async pinPoll() {
    const executePoll = async (resolve, reject) => {
      try {
        if (!this.pin) {
          throw new Error('Unable to poll when pin is not initialized.');
        }

        const response = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].get(`https://plex.tv/api/v2/pins/${this.pin.id}`, {
          headers: this.plexHeaders
        });

        if (response.data?.authToken) {
          this.authToken = response.data.authToken;
          this.closePopup();
          resolve(this.authToken);
        } else if (!response.data?.authToken && !this.popup?.closed) {
          setTimeout(executePoll, 1000, resolve, reject);
        } else {
          reject(new Error('Popup closed without completing login'));
        }
      } catch (e) {
        this.closePopup();
        reject(e);
      }
    };

    return new Promise(executePoll);
  }

  closePopup() {
    this.popup?.close();
    this.popup = undefined;
  }

  openPopup({
    title,
    w,
    h
  }) {
    if (!window) {
      throw new Error('Window is undefined. Are you running this in the browser?');
    } // Fixes dual-screen position                         Most browsers      Firefox


    const dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : window.screenX;
    const dualScreenTop = window.screenTop != undefined ? window.screenTop : window.screenY;
    const width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    const height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
    const left = width / 2 - w / 2 + dualScreenLeft;
    const top = height / 2 - h / 2 + dualScreenTop; //Set url to login/plex/loading so browser doesn't block popup

    const newWindow = window.open('/login/plex/loading', title, 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + top + ', left=' + left);

    if (newWindow) {
      newWindow.focus();
      this.popup = newWindow;
      return this.popup;
    }
  }

  encodeData(data) {
    return Object.keys(data).map(function (key) {
      return [key, data[key]].map(encodeURIComponent).join('=');
    }).join('&');
  }

}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PlexOAuth);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;