"use strict";
exports.id = 85405;
exports.ids = [85405];
exports.modules = {

/***/ 76631:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);



const Header = ({
  children,
  extraMargin = 0,
  subtext
}) => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    className: "mt-8 md:flex md:items-center md:justify-between",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: `min-w-0 flex-1 mx-${extraMargin}`,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
        className: "mb-4 truncate text-2xl font-bold leading-7 text-gray-100 sm:overflow-visible sm:text-4xl sm:leading-9 md:mb-0",
        "data-testid": "page-header",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
          className: "text-overseerr",
          children: children
        })
      }), subtext && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "mt-2 text-gray-400",
        children: subtext
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 31281:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7292);
/* harmony import */ var _app_components_Common_ConfirmButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10591);
/* harmony import */ var _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(42040);
/* harmony import */ var _app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12001);
/* harmony import */ var _app_hooks_useDeepLinks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(44627);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80210);
/* harmony import */ var _app_utils_refreshIntervalHelper__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(28299);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(59147);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(99648);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react_intersection_observer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(44009);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__, _app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_11__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_14__, swr__WEBPACK_IMPORTED_MODULE_17__]);
([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__, _app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_11__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_14__, swr__WEBPACK_IMPORTED_MODULE_17__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.defineMessages)({
  seasons: {
    "id": "components.RequestList.RequestItem.seasons",
    "defaultMessage": '{seasonCount, plural, one {Season} other {Seasons}}'
  },
  failedretry: {
    "id": "components.RequestList.RequestItem.failedretry",
    "defaultMessage": 'Something went wrong while retrying the request.'
  },
  requested: {
    "id": "components.RequestList.RequestItem.requested",
    "defaultMessage": 'Requested'
  },
  requesteddate: {
    "id": "components.RequestList.RequestItem.requesteddate",
    "defaultMessage": 'Requested'
  },
  modified: {
    "id": "components.RequestList.RequestItem.modified",
    "defaultMessage": 'Modified'
  },
  modifieduserdate: {
    "id": "components.RequestList.RequestItem.modifieduserdate",
    "defaultMessage": '{date} by {user}'
  },
  mediaerror: {
    "id": "components.RequestList.RequestItem.mediaerror",
    "defaultMessage": '{mediaType} Not Found'
  },
  editrequest: {
    "id": "components.RequestList.RequestItem.editrequest",
    "defaultMessage": 'Edit Request'
  },
  deleterequest: {
    "id": "components.RequestList.RequestItem.deleterequest",
    "defaultMessage": 'Delete Request'
  },
  cancelRequest: {
    "id": "components.RequestList.RequestItem.cancelRequest",
    "defaultMessage": 'Cancel Request'
  },
  tmdbid: {
    "id": "components.RequestList.RequestItem.tmdbid",
    "defaultMessage": 'TMDB ID'
  },
  tvdbid: {
    "id": "components.RequestList.RequestItem.tvdbid",
    "defaultMessage": 'TheTVDB ID'
  },
  unknowntitle: {
    "id": "components.RequestList.RequestItem.unknowntitle",
    "defaultMessage": 'Unknown Title'
  }
});

const isMovie = movie => {
  return movie.title !== undefined;
};

const RequestItemError = ({
  requestData,
  revalidateList
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .useUser */ .aF)();

  const deleteRequest = async () => {
    await axios__WEBPACK_IMPORTED_MODULE_11__["default"]["delete"](`/api/v1/media/${requestData?.media.id}`);
    revalidateList();
    (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/request/count');
  };

  const {
    plexUrl,
    plexUrl4k
  } = (0,_app_hooks_useDeepLinks__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)({
    plexUrl: requestData?.media?.plexUrl,
    plexUrl4k: requestData?.media?.plexUrl4k,
    iOSPlexUrl: requestData?.media?.iOSPlexUrl,
    iOSPlexUrl4k: requestData?.media?.iOSPlexUrl4k
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
    className: "flex h-64 w-full flex-col justify-center rounded-xl bg-gray-800 py-4 text-gray-400 shadow-md ring-1 ring-red-500 xl:h-28 xl:flex-row",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      className: "flex w-full flex-col justify-between overflow-hidden sm:flex-row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: "flex w-full flex-col justify-center overflow-hidden pl-4 pr-4 sm:pr-0 xl:w-7/12 2xl:w-2/3",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "flex text-lg font-bold text-white xl:text-xl",
          children: intl.formatMessage(messages.mediaerror, {
            mediaType: intl.formatMessage(requestData?.type ? requestData?.type === 'movie' ? _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].movie */ .Z.movie : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].tvshow */ .Z.tvshow : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].request */ .Z.request)
          })
        }), requestData && hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            className: "card-field",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "card-field-name",
              children: intl.formatMessage(messages.tmdbid)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "flex truncate text-sm text-gray-300",
              children: requestData.media.tmdbId
            })]
          }), requestData.media.tvdbId && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            className: "card-field",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "card-field-name",
              children: intl.formatMessage(messages.tvdbid)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "flex truncate text-sm text-gray-300",
              children: requestData?.media.tvdbId
            })]
          })]
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
        className: "mt-4 ml-4 flex w-full flex-col justify-center overflow-hidden pr-4 text-sm sm:ml-2 sm:mt-0 xl:flex-1 xl:pr-0",
        children: requestData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            className: "card-field",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "card-field-name",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].status */ .Z.status)
            }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED || requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.FAILED */ .pi.FAILED ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
              badgeType: "danger",
              children: requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].declined */ .Z.declined) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].failed */ .Z.failed)
            }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
              status: requestData.media[requestData.is4k ? 'status4k' : 'status'],
              downloadItem: requestData.media[requestData.is4k ? 'downloadStatus4k' : 'downloadStatus'],
              title: intl.formatMessage(messages.unknowntitle),
              inProgress: (requestData.media[requestData.is4k ? 'downloadStatus4k' : 'downloadStatus'] ?? []).length > 0,
              is4k: requestData.is4k,
              mediaType: requestData.type,
              plexUrl: requestData.is4k ? plexUrl4k : plexUrl,
              serviceUrl: requestData.is4k ? requestData.media.serviceUrl4k : requestData.media.serviceUrl
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
            className: "card-field",
            children: hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_VIEW */ .y3.REQUEST_VIEW], {
              type: 'or'
            }) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "card-field-name",
                children: intl.formatMessage(messages.requested)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "flex truncate text-sm text-gray-300",
                children: intl.formatMessage(messages.modifieduserdate, {
                  date: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_15__.FormattedRelativeTime, {
                    value: Math.floor((new Date(requestData.createdAt).getTime() - Date.now()) / 1000),
                    updateIntervalInSeconds: 1,
                    numeric: "auto"
                  }),
                  user: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
                    href: `/users/${requestData.requestedBy.id}`,
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("a", {
                      className: "group flex items-center truncate",
                      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("img", {
                        src: requestData.requestedBy.avatar,
                        alt: "",
                        className: "avatar-sm ml-1.5"
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                        className: "truncate text-sm group-hover:underline",
                        children: requestData.requestedBy.displayName
                      })]
                    })
                  })
                })
              })]
            }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "card-field-name",
                children: intl.formatMessage(messages.requesteddate)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "flex truncate text-sm text-gray-300",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_15__.FormattedRelativeTime, {
                  value: Math.floor((new Date(requestData.createdAt).getTime() - Date.now()) / 1000),
                  updateIntervalInSeconds: 1,
                  numeric: "auto"
                })
              })]
            })
          }), requestData.modifiedBy && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            className: "card-field",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "card-field-name",
              children: intl.formatMessage(messages.modified)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "flex truncate text-sm text-gray-300",
              children: intl.formatMessage(messages.modifieduserdate, {
                date: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_15__.FormattedRelativeTime, {
                  value: Math.floor((new Date(requestData.updatedAt).getTime() - Date.now()) / 1000),
                  updateIntervalInSeconds: 1,
                  numeric: "auto"
                }),
                user: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
                  href: `/users/${requestData.modifiedBy.id}`,
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("a", {
                    className: "group flex items-center truncate",
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("img", {
                      src: requestData.modifiedBy.avatar,
                      alt: "",
                      className: "avatar-sm ml-1.5"
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                      className: "truncate text-sm group-hover:underline",
                      children: requestData.modifiedBy.displayName
                    })]
                  })
                })
              })
            })]
          })]
        })
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: "z-10 mt-4 flex w-full flex-col justify-center pl-4 pr-4 xl:mt-0 xl:w-96 xl:items-end xl:pl-0",
      children: hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && requestData?.media.id && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        className: "w-full",
        buttonType: "danger",
        onClick: () => deleteRequest(),
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.TrashIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
          children: intl.formatMessage(messages.deleterequest)
        })]
      })
    })]
  });
};

const RequestItem = ({
  request,
  revalidateList
}) => {
  const {
    ref,
    inView
  } = (0,react_intersection_observer__WEBPACK_IMPORTED_MODULE_14__.useInView)({
    triggerOnce: true
  });
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__.useToasts)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    user,
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .useUser */ .aF)();
  const {
    0: showEditModal,
    1: setShowEditModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)(false);
  const url = request.type === 'movie' ? `/api/v1/movie/${request.media.tmdbId}` : `/api/v1/tv/${request.media.tmdbId}`;
  const {
    data: title,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])(inView ? url : null);
  const {
    data: requestData,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])(`/api/v1/request/${request.id}`, {
    fallbackData: request,
    refreshInterval: (0,_app_utils_refreshIntervalHelper__WEBPACK_IMPORTED_MODULE_19__/* .refreshIntervalHelper */ .v)({
      downloadStatus: request.media.downloadStatus,
      downloadStatus4k: request.media.downloadStatus4k
    }, 15000)
  });
  const {
    0: isRetrying,
    1: setRetrying
  } = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)(false);

  const modifyRequest = async type => {
    const response = await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post(`/api/v1/request/${request.id}/${type}`);

    if (response) {
      revalidate();
      (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/request/count');
    }
  };

  const deleteRequest = async () => {
    await axios__WEBPACK_IMPORTED_MODULE_11__["default"]["delete"](`/api/v1/request/${request.id}`);
    revalidateList();
    (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/request/count');
  };

  const retryRequest = async () => {
    setRetrying(true);

    try {
      const result = await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post(`/api/v1/request/${request.id}/retry`);
      revalidate(result.data);
    } catch (e) {
      addToast(intl.formatMessage(messages.failedretry), {
        autoDismiss: true,
        appearance: 'error'
      });
    } finally {
      setRetrying(false);
    }
  };

  const {
    plexUrl,
    plexUrl4k
  } = (0,_app_hooks_useDeepLinks__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)({
    plexUrl: requestData?.media?.plexUrl,
    plexUrl4k: requestData?.media?.plexUrl4k,
    iOSPlexUrl: requestData?.media?.iOSPlexUrl,
    iOSPlexUrl4k: requestData?.media?.iOSPlexUrl4k
  });

  if (!title && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: "h-64 w-full animate-pulse rounded-xl bg-gray-800 xl:h-28",
      ref: ref
    });
  }

  if (!title || !requestData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(RequestItemError, {
      requestData: requestData,
      revalidateList: revalidateList
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      show: showEditModal,
      tmdbId: request.media.tmdbId,
      type: request.type,
      is4k: request.is4k,
      editRequest: request,
      onCancel: () => setShowEditModal(false),
      onComplete: () => {
        revalidateList();
        setShowEditModal(false);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      className: "relative flex w-full flex-col justify-between overflow-hidden rounded-xl bg-gray-800 py-4 text-gray-400 shadow-md ring-1 ring-gray-700 xl:h-28 xl:flex-row",
      children: [title.backdropPath && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: "absolute inset-0 z-0 w-full bg-cover bg-center xl:w-2/3",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          src: `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${title.backdropPath}`,
          alt: "",
          layout: "fill",
          objectFit: "cover"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "absolute inset-0",
          style: {
            backgroundImage: 'linear-gradient(90deg, rgba(31, 41, 55, 0.47) 0%, rgba(31, 41, 55, 1) 100%)'
          }
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: "relative flex w-full flex-col justify-between overflow-hidden sm:flex-row",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
          className: "relative z-10 flex w-full items-center overflow-hidden pl-4 pr-4 sm:pr-0 xl:w-7/12 2xl:w-2/3",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
            href: requestData.type === 'movie' ? `/movie/${requestData.media.tmdbId}` : `/tv/${requestData.media.tmdbId}`,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("a", {
              className: "relative h-auto w-12 flex-shrink-0 scale-100 transform-gpu overflow-hidden rounded-md transition duration-300 hover:scale-105",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                src: title.posterPath ? `https://image.tmdb.org/t/p/w600_and_h900_bestv2${title.posterPath}` : '/images/overseerr_poster_not_found.png',
                alt: "",
                layout: "responsive",
                width: 600,
                height: 900,
                objectFit: "cover"
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            className: "flex flex-col justify-center overflow-hidden pl-2 xl:pl-4",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
              className: "pt-0.5 text-xs font-medium text-white sm:pt-1",
              children: (isMovie(title) ? title.releaseDate : title.firstAirDate)?.slice(0, 4)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
              href: requestData.type === 'movie' ? `/movie/${requestData.media.tmdbId}` : `/tv/${requestData.media.tmdbId}`,
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("a", {
                className: "mr-2 min-w-0 truncate text-lg font-bold text-white hover:underline xl:text-xl",
                children: isMovie(title) ? title.title : title.name
              })
            }), !isMovie(title) && request.seasons.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
              className: "card-field",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "card-field-name",
                children: intl.formatMessage(messages.seasons, {
                  seasonCount: title.seasons.length === request.seasons.length ? 0 : request.seasons.length
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
                className: "hide-scrollbar flex flex-nowrap overflow-x-scroll",
                children: request.seasons.map(season => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  className: "mr-2",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                    children: season.seasonNumber === 0 ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].specials */ .Z.specials) : season.seasonNumber
                  })
                }, `season-${season.id}`))
              })]
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
          className: "z-10 mt-4 ml-4 flex w-full flex-col justify-center overflow-hidden pr-4 text-sm sm:ml-2 sm:mt-0 xl:flex-1 xl:pr-0",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            className: "card-field",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "card-field-name",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].status */ .Z.status)
            }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.DECLINED */ .pi.DECLINED ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
              badgeType: "danger",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].declined */ .Z.declined)
            }) : requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.FAILED */ .pi.FAILED ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
              badgeType: "danger",
              href: `/${requestData.type}/${requestData.media.tmdbId}?manage=1`,
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].failed */ .Z.failed)
            }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_StatusBadge__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
              status: requestData.media[requestData.is4k ? 'status4k' : 'status'],
              downloadItem: requestData.media[requestData.is4k ? 'downloadStatus4k' : 'downloadStatus'],
              title: isMovie(title) ? title.title : title.name,
              inProgress: (requestData.media[requestData.is4k ? 'downloadStatus4k' : 'downloadStatus'] ?? []).length > 0,
              is4k: requestData.is4k,
              tmdbId: requestData.media.tmdbId,
              mediaType: requestData.type,
              plexUrl: requestData.is4k ? plexUrl4k : plexUrl,
              serviceUrl: requestData.is4k ? requestData.media.serviceUrl4k : requestData.media.serviceUrl
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
            className: "card-field",
            children: hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_VIEW */ .y3.REQUEST_VIEW], {
              type: 'or'
            }) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "card-field-name",
                children: intl.formatMessage(messages.requested)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "flex truncate text-sm text-gray-300",
                children: intl.formatMessage(messages.modifieduserdate, {
                  date: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_15__.FormattedRelativeTime, {
                    value: Math.floor((new Date(requestData.createdAt).getTime() - Date.now()) / 1000),
                    updateIntervalInSeconds: 1,
                    numeric: "auto"
                  }),
                  user: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
                    href: `/users/${requestData.requestedBy.id}`,
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("a", {
                      className: "group flex items-center truncate",
                      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("img", {
                        src: requestData.requestedBy.avatar,
                        alt: "",
                        className: "avatar-sm ml-1.5 object-cover"
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                        className: "truncate text-sm font-semibold group-hover:text-white group-hover:underline",
                        children: requestData.requestedBy.displayName
                      })]
                    })
                  })
                })
              })]
            }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "card-field-name",
                children: intl.formatMessage(messages.requesteddate)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "flex truncate text-sm text-gray-300",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_15__.FormattedRelativeTime, {
                  value: Math.floor((new Date(requestData.createdAt).getTime() - Date.now()) / 1000),
                  updateIntervalInSeconds: 1,
                  numeric: "auto"
                })
              })]
            })
          }), requestData.modifiedBy && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
            className: "card-field",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "card-field-name",
              children: intl.formatMessage(messages.modified)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              className: "flex truncate text-sm text-gray-300",
              children: intl.formatMessage(messages.modifieduserdate, {
                date: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_15__.FormattedRelativeTime, {
                  value: Math.floor((new Date(requestData.updatedAt).getTime() - Date.now()) / 1000),
                  updateIntervalInSeconds: 1,
                  numeric: "auto"
                }),
                user: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx((next_link__WEBPACK_IMPORTED_MODULE_12___default()), {
                  href: `/users/${requestData.modifiedBy.id}`,
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("a", {
                    className: "group flex items-center truncate",
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("img", {
                      src: requestData.modifiedBy.avatar,
                      alt: "",
                      className: "avatar-sm ml-1.5 object-cover"
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                      className: "truncate text-sm font-semibold group-hover:text-white group-hover:underline",
                      children: requestData.modifiedBy.displayName
                    })]
                  })
                })
              })
            })]
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: "z-10 mt-4 flex w-full flex-col justify-center space-y-2 pl-4 pr-4 xl:mt-0 xl:w-96 xl:items-end xl:pl-0",
        children: [requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.FAILED */ .pi.FAILED && hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          className: "w-full",
          buttonType: "primary",
          disabled: isRetrying,
          onClick: () => retryRequest(),
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.ArrowPathIcon, {
            className: isRetrying ? 'animate-spin' : '',
            style: {
              animationDirection: 'reverse'
            }
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
            children: intl.formatMessage(isRetrying ? _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].retrying */ .Z.retrying : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].retry */ .Z.retry)
          })]
        }), requestData.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.PENDING */ .pi.PENDING && hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_ConfirmButton__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
          onClick: () => deleteRequest(),
          confirmText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].areyousure */ .Z.areyousure),
          className: "w-full",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.TrashIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
            children: intl.formatMessage(messages.deleterequest)
          })]
        }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.PENDING */ .pi.PENDING && hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
          className: "flex w-full flex-row space-x-2",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
            className: "w-full",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              className: "w-full",
              buttonType: "success",
              onClick: () => modifyRequest('approve'),
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.CheckIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].approve */ .Z.approve)
              })]
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
            className: "w-full",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              className: "w-full",
              buttonType: "danger",
              onClick: () => modifyRequest('decline'),
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.XMarkIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].decline */ .Z.decline)
              })]
            })
          })]
        }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.PENDING */ .pi.PENDING && (hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) || requestData.requestedBy.id === user?.id && (requestData.type === 'tv' || hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.REQUEST_ADVANCED */ .y3.REQUEST_ADVANCED))) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
          className: "w-full",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            className: "w-full",
            buttonType: "primary",
            onClick: () => setShowEditModal(true),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.PencilIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              children: intl.formatMessage(messages.editrequest)
            })]
          })
        }), requestData.status === _server_constants_media__WEBPACK_IMPORTED_MODULE_10__/* .MediaRequestStatus.PENDING */ .pi.PENDING && !hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) && requestData.requestedBy.id === user?.id && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_ConfirmButton__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
          onClick: () => deleteRequest(),
          confirmText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].areyousure */ .Z.areyousure),
          className: "w-full",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.XMarkIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
            children: intl.formatMessage(messages.cancelRequest)
          })]
        })]
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestItem);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 85405:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_Header__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76631);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74449);
/* harmony import */ var _app_components_RequestList_RequestItem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31281);
/* harmony import */ var _app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27208);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_RequestList_RequestItem__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_13__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_RequestList_RequestItem__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);

















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.defineMessages)({
  requests: {
    "id": "components.RequestList.requests",
    "defaultMessage": 'Requests'
  },
  showallrequests: {
    "id": "components.RequestList.showallrequests",
    "defaultMessage": 'Show All Requests'
  },
  sortAdded: {
    "id": "components.RequestList.sortAdded",
    "defaultMessage": 'Most Recent'
  },
  sortModified: {
    "id": "components.RequestList.sortModified",
    "defaultMessage": 'Last Modified'
  }
});
var Filter;

(function (Filter) {
  Filter["ALL"] = "all";
  Filter["PENDING"] = "pending";
  Filter["APPROVED"] = "approved";
  Filter["PROCESSING"] = "processing";
  Filter["AVAILABLE"] = "available";
  Filter["UNAVAILABLE"] = "unavailable";
  Filter["FAILED"] = "failed";
})(Filter || (Filter = {}));

const RequestList = () => {
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_10__.useRouter)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.useIntl)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    user: currentUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__/* .useUser */ .aF)();
  const {
    0: currentFilter,
    1: setCurrentFilter
  } = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(Filter.PENDING);
  const {
    0: currentSort,
    1: setCurrentSort
  } = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)('added');
  const {
    0: currentPageSize,
    1: setCurrentPageSize
  } = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(10);
  const page = router.query.page ? Number(router.query.page) : 1;
  const pageIndex = page - 1;
  const updateQueryParams = (0,_app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_5__/* .useUpdateQueryParams */ .BA)({
    page: page.toString()
  });
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_13__["default"])(`/api/v1/request?take=${currentPageSize}&skip=${pageIndex * currentPageSize}&filter=${currentFilter}&sort=${currentSort}${router.pathname.startsWith('/profile') ? `&requestedBy=${currentUser?.id}` : router.query.userId ? `&requestedBy=${router.query.userId}` : ''}`); // Restore last set filter values on component mount

  (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
    const filterString = window.localStorage.getItem('rl-filter-settings');

    if (filterString) {
      const filterSettings = JSON.parse(filterString);
      setCurrentFilter(filterSettings.currentFilter);
      setCurrentSort(filterSettings.currentSort);
      setCurrentPageSize(filterSettings.currentPageSize);
    } // If filter value is provided in query, use that instead


    if (Object.values(Filter).includes(router.query.filter)) {
      setCurrentFilter(router.query.filter);
    }
  }, [router.query.filter]); // Set filter values to local storage any time they are changed

  (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
    window.localStorage.setItem('rl-filter-settings', JSON.stringify({
      currentFilter,
      currentSort,
      currentPageSize
    }));
  }, [currentFilter, currentSort, currentPageSize]);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  const hasNextPage = data.pageInfo.pages > pageIndex + 1;
  const hasPrevPage = pageIndex > 0;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.requests), router.query.userId ? user?.displayName : '']
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
      className: "mb-4 flex flex-col justify-between lg:flex-row lg:items-end",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Header__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        subtext: router.pathname.startsWith('/profile') ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((next_link__WEBPACK_IMPORTED_MODULE_9___default()), {
          href: `/profile`,
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("a", {
            className: "hover:underline",
            children: currentUser?.displayName
          })
        }) : router.query.userId ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((next_link__WEBPACK_IMPORTED_MODULE_9___default()), {
          href: `/users/${user?.id}`,
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("a", {
            className: "hover:underline",
            children: user?.displayName
          })
        }) : '',
        children: intl.formatMessage(messages.requests)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
        className: "mt-2 flex flex-grow flex-col sm:flex-row lg:flex-grow-0",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
          className: "mb-2 flex flex-grow sm:mb-0 sm:mr-2 lg:flex-grow-0",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
            className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-sm text-gray-100",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__.FunnelIcon, {
              className: "h-6 w-6"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("select", {
            id: "filter",
            name: "filter",
            onChange: e => {
              setCurrentFilter(e.target.value);
              router.push({
                pathname: router.pathname,
                query: router.query.userId ? {
                  userId: router.query.userId
                } : {}
              });
            },
            value: currentFilter,
            className: "rounded-r-only",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "all",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].all */ .Z.all)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "pending",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].pending */ .Z.pending)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "approved",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].approved */ .Z.approved)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "processing",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].processing */ .Z.processing)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "failed",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].failed */ .Z.failed)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "available",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].available */ .Z.available)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "unavailable",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].unavailable */ .Z.unavailable)
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
          className: "mb-2 flex flex-grow sm:mb-0 lg:flex-grow-0",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
            className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-gray-100 sm:text-sm",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__.BarsArrowDownIcon, {
              className: "h-6 w-6"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("select", {
            id: "sort",
            name: "sort",
            onChange: e => {
              setCurrentSort(e.target.value);
              router.push({
                pathname: router.pathname,
                query: router.query.userId ? {
                  userId: router.query.userId
                } : {}
              });
            },
            value: currentSort,
            className: "rounded-r-only",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "added",
              children: intl.formatMessage(messages.sortAdded)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: "modified",
              children: intl.formatMessage(messages.sortModified)
            })]
          })]
        })]
      })]
    }), data.results.map(request => {
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
        className: "py-2",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_RequestList_RequestItem__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          request: request,
          revalidateList: () => revalidate()
        })
      }, `request-list-${request.id}`);
    }), data.results.length === 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
      className: "flex w-full flex-col items-center justify-center py-24 text-white",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
        className: "text-2xl text-gray-400",
        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].noresults */ .Z.noresults)
      }), currentFilter !== Filter.ALL && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
        className: "mt-4",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          buttonType: "primary",
          onClick: () => setCurrentFilter(Filter.ALL),
          children: intl.formatMessage(messages.showallrequests)
        })
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
      className: "actions",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("nav", {
        className: "mb-3 flex flex-col items-center space-y-3 sm:flex-row sm:space-y-0",
        "aria-label": "Pagination",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
          className: "hidden lg:flex lg:flex-1",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("p", {
            className: "text-sm",
            children: data.results.length > 0 && intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].showingresults */ .Z.showingresults, {
              from: pageIndex * currentPageSize + 1,
              to: data.results.length < currentPageSize ? pageIndex * currentPageSize + data.results.length : (pageIndex + 1) * currentPageSize,
              total: data.pageInfo.results,
              strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
                className: "font-medium",
                children: msg
              })
            })
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
          className: "flex justify-center sm:flex-1 sm:justify-start lg:justify-center",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
            className: "-mt-3 items-center truncate text-sm sm:mt-0",
            children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].resultsperpage */ .Z.resultsperpage, {
              pageSize: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("select", {
                id: "pageSize",
                name: "pageSize",
                onChange: e => {
                  setCurrentPageSize(Number(e.target.value));
                  router.push({
                    pathname: router.pathname,
                    query: router.query.userId ? {
                      userId: router.query.userId
                    } : {}
                  }).then(() => window.scrollTo(0, 0));
                },
                value: currentPageSize,
                className: "short inline",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
                  value: "5",
                  children: "5"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
                  value: "10",
                  children: "10"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
                  value: "25",
                  children: "25"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
                  value: "50",
                  children: "50"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
                  value: "100",
                  children: "100"
                })]
              })
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
          className: "flex flex-auto justify-center space-x-2 sm:flex-1 sm:justify-end",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            disabled: !hasPrevPage,
            onClick: () => updateQueryParams('page', (page - 1).toString()),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__.ChevronLeftIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].previous */ .Z.previous)
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            disabled: !hasNextPage,
            onClick: () => updateQueryParams('page', (page + 1).toString()),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].next */ .Z.next)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__.ChevronRightIcon, {})]
          })]
        })]
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestList);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 44627:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const useDeepLinks = ({
  plexUrl,
  plexUrl4k,
  iOSPlexUrl,
  iOSPlexUrl4k
}) => {
  const {
    0: returnedPlexUrl,
    1: setReturnedPlexUrl
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(plexUrl);
  const {
    0: returnedPlexUrl4k,
    1: setReturnedPlexUrl4k
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(plexUrl4k);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (/iPad|iPhone|iPod/.test(navigator.userAgent) || navigator.userAgent.includes('Mac') && navigator.maxTouchPoints > 1) {
      setReturnedPlexUrl(iOSPlexUrl);
      setReturnedPlexUrl4k(iOSPlexUrl4k);
    } else {
      setReturnedPlexUrl(plexUrl);
      setReturnedPlexUrl4k(plexUrl4k);
    }
  }, [iOSPlexUrl, iOSPlexUrl4k, plexUrl, plexUrl4k]);
  return {
    plexUrl: returnedPlexUrl,
    plexUrl4k: returnedPlexUrl4k
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDeepLinks);

/***/ })

};
;