"use strict";
exports.id = 92012;
exports.ids = [92012];
exports.modules = {

/***/ 18895:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(95909);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];





const NotificationType = ({
  option,
  currentTypes,
  onUpdate,
  parent
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: `relative mt-4 flex items-start first:mt-0 ${!!parent?.value && (0,_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_0__/* .hasNotificationType */ .hn)(parent.value, currentTypes) ? 'opacity-50' : ''}`,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
        className: "flex h-6 items-center",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("input", {
          id: option.id,
          name: "permissions",
          type: "checkbox",
          disabled: !!parent?.value && (0,_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_0__/* .hasNotificationType */ .hn)(parent.value, currentTypes),
          onClick: () => {
            onUpdate((0,_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_0__/* .hasNotificationType */ .hn)(option.value, currentTypes) ? currentTypes - option.value : currentTypes + option.value);
          },
          checked: (0,_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_0__/* .hasNotificationType */ .hn)(option.value, currentTypes) || !!parent?.value && (0,_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_0__/* .hasNotificationType */ .hn)(parent.value, currentTypes)
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
        className: "ml-3 text-sm leading-6",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("label", {
          htmlFor: option.id,
          className: "block",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
            className: "flex flex-col",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("span", {
              className: "font-medium text-white",
              children: option.name
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("span", {
              className: "font-normal text-gray-400",
              children: option.description
            })]
          })
        })
      })]
    }), (option.children ?? []).map(child => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
      className: "mt-4 pl-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(NotificationType, {
        option: child,
        currentTypes: currentTypes,
        onUpdate: newTypes => onUpdate(newTypes),
        parent: option
      })
    }, `notification-type-child-${child.id}`))]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationType);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 95909:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ZP": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "hn": () => (/* binding */ hasNotificationType),
/* harmony export */   "rK": () => (/* binding */ ALL_NOTIFICATIONS)
/* harmony export */ });
/* unused harmony export Notification */
/* harmony import */ var _app_components_NotificationTypeSelector_NotificationType__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18895);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86799);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector_NotificationType__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__]);
([_app_components_NotificationTypeSelector_NotificationType__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.defineMessages)({
  notificationTypes: {
    "id": "components.NotificationTypeSelector.notificationTypes",
    "defaultMessage": 'Notification Types'
  },
  mediarequested: {
    "id": "components.NotificationTypeSelector.mediarequested",
    "defaultMessage": 'Request Pending Approval'
  },
  mediarequestedDescription: {
    "id": "components.NotificationTypeSelector.mediarequestedDescription",
    "defaultMessage": 'Send notifications when users submit new media requests which require approval.'
  },
  usermediarequestedDescription: {
    "id": "components.NotificationTypeSelector.usermediarequestedDescription",
    "defaultMessage": 'Get notified when other users submit new media requests which require approval.'
  },
  mediaapproved: {
    "id": "components.NotificationTypeSelector.mediaapproved",
    "defaultMessage": 'Request Approved'
  },
  mediaapprovedDescription: {
    "id": "components.NotificationTypeSelector.mediaapprovedDescription",
    "defaultMessage": 'Send notifications when media requests are manually approved.'
  },
  usermediaapprovedDescription: {
    "id": "components.NotificationTypeSelector.usermediaapprovedDescription",
    "defaultMessage": 'Get notified when your media requests are approved.'
  },
  mediaAutoApproved: {
    "id": "components.NotificationTypeSelector.mediaAutoApproved",
    "defaultMessage": 'Request Automatically Approved'
  },
  mediaAutoApprovedDescription: {
    "id": "components.NotificationTypeSelector.mediaAutoApprovedDescription",
    "defaultMessage": 'Send notifications when users submit new media requests which are automatically approved.'
  },
  usermediaAutoApprovedDescription: {
    "id": "components.NotificationTypeSelector.usermediaAutoApprovedDescription",
    "defaultMessage": 'Get notified when other users submit new media requests which are automatically approved.'
  },
  mediaavailable: {
    "id": "components.NotificationTypeSelector.mediaavailable",
    "defaultMessage": 'Request Available'
  },
  mediaavailableDescription: {
    "id": "components.NotificationTypeSelector.mediaavailableDescription",
    "defaultMessage": 'Send notifications when media requests become available.'
  },
  usermediaavailableDescription: {
    "id": "components.NotificationTypeSelector.usermediaavailableDescription",
    "defaultMessage": 'Get notified when your media requests become available.'
  },
  mediafailed: {
    "id": "components.NotificationTypeSelector.mediafailed",
    "defaultMessage": 'Request Processing Failed'
  },
  mediafailedDescription: {
    "id": "components.NotificationTypeSelector.mediafailedDescription",
    "defaultMessage": 'Send notifications when media requests fail to be added to Radarr or Sonarr.'
  },
  usermediafailedDescription: {
    "id": "components.NotificationTypeSelector.usermediafailedDescription",
    "defaultMessage": 'Get notified when media requests fail to be added to Radarr or Sonarr.'
  },
  mediadeclined: {
    "id": "components.NotificationTypeSelector.mediadeclined",
    "defaultMessage": 'Request Declined'
  },
  mediadeclinedDescription: {
    "id": "components.NotificationTypeSelector.mediadeclinedDescription",
    "defaultMessage": 'Send notifications when media requests are declined.'
  },
  usermediadeclinedDescription: {
    "id": "components.NotificationTypeSelector.usermediadeclinedDescription",
    "defaultMessage": 'Get notified when your media requests are declined.'
  },
  issuecreated: {
    "id": "components.NotificationTypeSelector.issuecreated",
    "defaultMessage": 'Issue Reported'
  },
  issuecreatedDescription: {
    "id": "components.NotificationTypeSelector.issuecreatedDescription",
    "defaultMessage": 'Send notifications when issues are reported.'
  },
  userissuecreatedDescription: {
    "id": "components.NotificationTypeSelector.userissuecreatedDescription",
    "defaultMessage": 'Get notified when other users report issues.'
  },
  issuecomment: {
    "id": "components.NotificationTypeSelector.issuecomment",
    "defaultMessage": 'Issue Comment'
  },
  issuecommentDescription: {
    "id": "components.NotificationTypeSelector.issuecommentDescription",
    "defaultMessage": 'Send notifications when issues receive new comments.'
  },
  userissuecommentDescription: {
    "id": "components.NotificationTypeSelector.userissuecommentDescription",
    "defaultMessage": 'Get notified when issues you reported receive new comments.'
  },
  adminissuecommentDescription: {
    "id": "components.NotificationTypeSelector.adminissuecommentDescription",
    "defaultMessage": 'Get notified when other users comment on issues.'
  },
  issueresolved: {
    "id": "components.NotificationTypeSelector.issueresolved",
    "defaultMessage": 'Issue Resolved'
  },
  issueresolvedDescription: {
    "id": "components.NotificationTypeSelector.issueresolvedDescription",
    "defaultMessage": 'Send notifications when issues are resolved.'
  },
  userissueresolvedDescription: {
    "id": "components.NotificationTypeSelector.userissueresolvedDescription",
    "defaultMessage": 'Get notified when issues you reported are resolved.'
  },
  adminissueresolvedDescription: {
    "id": "components.NotificationTypeSelector.adminissueresolvedDescription",
    "defaultMessage": 'Get notified when issues are resolved by other users.'
  },
  issuereopened: {
    "id": "components.NotificationTypeSelector.issuereopened",
    "defaultMessage": 'Issue Reopened'
  },
  issuereopenedDescription: {
    "id": "components.NotificationTypeSelector.issuereopenedDescription",
    "defaultMessage": 'Send notifications when issues are reopened.'
  },
  userissuereopenedDescription: {
    "id": "components.NotificationTypeSelector.userissuereopenedDescription",
    "defaultMessage": 'Get notified when issues you reported are reopened.'
  },
  adminissuereopenedDescription: {
    "id": "components.NotificationTypeSelector.adminissuereopenedDescription",
    "defaultMessage": 'Get notified when issues are reopened by other users.'
  },
  mediaautorequested: {
    "id": "components.NotificationTypeSelector.mediaautorequested",
    "defaultMessage": 'Request Automatically Submitted'
  },
  mediaautorequestedDescription: {
    "id": "components.NotificationTypeSelector.mediaautorequestedDescription",
    "defaultMessage": 'Get notified when new media requests are automatically submitted for items on your Plex Watchlist.'
  }
});
const hasNotificationType = (types, value) => {
  let total = 0; // If we are not checking any notifications, bail out and return true

  if (types === 0) {
    return true;
  }

  if (Array.isArray(types)) {
    // Combine all notification values into one
    total = types.reduce((a, v) => a + v, 0);
  } else {
    total = types;
  } // Test notifications don't need to be enabled


  if (!(value & Notification.TEST_NOTIFICATION)) {
    value += Notification.TEST_NOTIFICATION;
  }

  return !!(value & total);
};
let Notification;

(function (Notification) {
  Notification[Notification["NONE"] = 0] = "NONE";
  Notification[Notification["MEDIA_PENDING"] = 2] = "MEDIA_PENDING";
  Notification[Notification["MEDIA_APPROVED"] = 4] = "MEDIA_APPROVED";
  Notification[Notification["MEDIA_AVAILABLE"] = 8] = "MEDIA_AVAILABLE";
  Notification[Notification["MEDIA_FAILED"] = 16] = "MEDIA_FAILED";
  Notification[Notification["TEST_NOTIFICATION"] = 32] = "TEST_NOTIFICATION";
  Notification[Notification["MEDIA_DECLINED"] = 64] = "MEDIA_DECLINED";
  Notification[Notification["MEDIA_AUTO_APPROVED"] = 128] = "MEDIA_AUTO_APPROVED";
  Notification[Notification["ISSUE_CREATED"] = 256] = "ISSUE_CREATED";
  Notification[Notification["ISSUE_COMMENT"] = 512] = "ISSUE_COMMENT";
  Notification[Notification["ISSUE_RESOLVED"] = 1024] = "ISSUE_RESOLVED";
  Notification[Notification["ISSUE_REOPENED"] = 2048] = "ISSUE_REOPENED";
  Notification[Notification["MEDIA_AUTO_REQUESTED"] = 4096] = "MEDIA_AUTO_REQUESTED";
})(Notification || (Notification = {}));

const ALL_NOTIFICATIONS = Object.values(Notification).filter(v => !isNaN(Number(v))).reduce((a, v) => a + Number(v), 0);

const NotificationTypeSelector = ({
  user,
  enabledTypes = ALL_NOTIFICATIONS,
  currentTypes,
  onUpdate,
  error
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.useIntl)();
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)();
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .useUser */ .aF)({
    id: user?.id
  });
  const {
    0: allowedTypes,
    1: setAllowedTypes
  } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(enabledTypes);
  const availableTypes = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
    const allRequestsAutoApproved = user && ( // Has Manage Requests perm, which grants all Auto-Approve perms
    hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS) || // Cannot submit requests of any type
    !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST */ .y3.REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_MOVIE */ .y3.REQUEST_MOVIE, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_TV */ .y3.REQUEST_TV, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_4K_MOVIE */ .y3.REQUEST_4K_MOVIE, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_4K_TV */ .y3.REQUEST_4K_TV], {
      type: 'or'
    }) || // Cannot submit non-4K movie requests OR has Auto-Approve perms for non-4K movies
    (!hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST */ .y3.REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_MOVIE */ .y3.REQUEST_MOVIE], {
      type: 'or'
    }) || hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_APPROVE */ .y3.AUTO_APPROVE, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_APPROVE_MOVIE */ .y3.AUTO_APPROVE_MOVIE], {
      type: 'or'
    })) && ( // Cannot submit non-4K series requests OR has Auto-Approve perms for non-4K series
    !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST */ .y3.REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_TV */ .y3.REQUEST_TV], {
      type: 'or'
    }) || hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_APPROVE */ .y3.AUTO_APPROVE, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_APPROVE_TV */ .y3.AUTO_APPROVE_TV], {
      type: 'or'
    })) && ( // Cannot submit 4K movie requests OR has Auto-Approve perms for 4K movies
    !settings.currentSettings.movie4kEnabled || !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_4K_MOVIE */ .y3.REQUEST_4K_MOVIE], {
      type: 'or'
    }) || hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_APPROVE_4K */ .y3.AUTO_APPROVE_4K, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_APPROVE_4K_MOVIE */ .y3.AUTO_APPROVE_4K_MOVIE], {
      type: 'or'
    })) && ( // Cannot submit 4K series requests OR has Auto-Approve perms for 4K series
    !settings.currentSettings.series4kEnabled || !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.REQUEST_4K_TV */ .y3.REQUEST_4K_TV], {
      type: 'or'
    }) || hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_APPROVE_4K */ .y3.AUTO_APPROVE_4K, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_APPROVE_4K_TV */ .y3.AUTO_APPROVE_4K_TV], {
      type: 'or'
    })));
    const types = [{
      id: 'media-auto-requested',
      name: intl.formatMessage(messages.mediaautorequested),
      description: intl.formatMessage(messages.mediaautorequestedDescription),
      value: Notification.MEDIA_AUTO_REQUESTED,
      hidden: !user || !user.settings?.watchlistSyncMovies && !user.settings?.watchlistSyncTv || !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_REQUEST */ .y3.AUTO_REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_REQUEST_MOVIE */ .y3.AUTO_REQUEST_MOVIE, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.AUTO_REQUEST_TV */ .y3.AUTO_REQUEST_TV], {
        type: 'or'
      }),
      hasNotifyUser: true
    }, {
      id: 'media-requested',
      name: intl.formatMessage(messages.mediarequested),
      description: intl.formatMessage(user ? messages.usermediarequestedDescription : messages.mediarequestedDescription),
      value: Notification.MEDIA_PENDING,
      hasNotifyUser: false,
      hidden: user && !hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS)
    }, {
      id: 'media-auto-approved',
      name: intl.formatMessage(messages.mediaAutoApproved),
      description: intl.formatMessage(user ? messages.usermediaAutoApprovedDescription : messages.mediaAutoApprovedDescription),
      value: Notification.MEDIA_AUTO_APPROVED,
      hasNotifyUser: false,
      hidden: user && !hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS)
    }, {
      id: 'media-approved',
      name: intl.formatMessage(messages.mediaapproved),
      description: intl.formatMessage(user ? messages.usermediaapprovedDescription : messages.mediaapprovedDescription),
      value: Notification.MEDIA_APPROVED,
      hasNotifyUser: true,
      hidden: allRequestsAutoApproved
    }, {
      id: 'media-declined',
      name: intl.formatMessage(messages.mediadeclined),
      description: intl.formatMessage(user ? messages.usermediadeclinedDescription : messages.mediadeclinedDescription),
      value: Notification.MEDIA_DECLINED,
      hasNotifyUser: true,
      hidden: allRequestsAutoApproved
    }, {
      id: 'media-available',
      name: intl.formatMessage(messages.mediaavailable),
      description: intl.formatMessage(user ? messages.usermediaavailableDescription : messages.mediaavailableDescription),
      value: Notification.MEDIA_AVAILABLE,
      hasNotifyUser: true
    }, {
      id: 'media-failed',
      name: intl.formatMessage(messages.mediafailed),
      description: intl.formatMessage(user ? messages.usermediafailedDescription : messages.mediafailedDescription),
      value: Notification.MEDIA_FAILED,
      hidden: user && !hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS),
      hasNotifyUser: false
    }, {
      id: 'issue-created',
      name: intl.formatMessage(messages.issuecreated),
      description: intl.formatMessage(user ? messages.userissuecreatedDescription : messages.issuecreatedDescription),
      value: Notification.ISSUE_CREATED,
      hidden: user && !hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES),
      hasNotifyUser: false
    }, {
      id: 'issue-comment',
      name: intl.formatMessage(messages.issuecomment),
      description: intl.formatMessage(user ? hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES) ? messages.adminissuecommentDescription : messages.userissuecommentDescription : messages.issuecommentDescription),
      value: Notification.ISSUE_COMMENT,
      hidden: user && !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.CREATE_ISSUES */ .y3.CREATE_ISSUES], {
        type: 'or'
      }),
      hasNotifyUser: !user || hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES) ? false : true
    }, {
      id: 'issue-resolved',
      name: intl.formatMessage(messages.issueresolved),
      description: intl.formatMessage(user ? hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES) ? messages.adminissueresolvedDescription : messages.userissueresolvedDescription : messages.issueresolvedDescription),
      value: Notification.ISSUE_RESOLVED,
      hidden: user && !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.CREATE_ISSUES */ .y3.CREATE_ISSUES], {
        type: 'or'
      }),
      hasNotifyUser: !user || hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES) ? false : true
    }, {
      id: 'issue-reopened',
      name: intl.formatMessage(messages.issuereopened),
      description: intl.formatMessage(user ? hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES) ? messages.adminissuereopenedDescription : messages.userissuereopenedDescription : messages.issuereopenedDescription),
      value: Notification.ISSUE_REOPENED,
      hidden: user && !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.CREATE_ISSUES */ .y3.CREATE_ISSUES], {
        type: 'or'
      }),
      hasNotifyUser: !user || hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES) ? false : true
    }];
    const filteredTypes = types.filter(type => !type.hidden && hasNotificationType(type.value, enabledTypes));
    const newAllowedTypes = filteredTypes.reduce((a, v) => a + v.value, 0);

    if (newAllowedTypes !== allowedTypes) {
      setAllowedTypes(newAllowedTypes);
    }

    return user ? (0,lodash__WEBPACK_IMPORTED_MODULE_3__.sortBy)(filteredTypes, 'hasNotifyUser', 'DESC') : filteredTypes;
  }, [user, hasPermission, settings, intl, allowedTypes, enabledTypes]);

  if (!availableTypes.length) {
    return null;
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
    role: "group",
    "aria-labelledby": "group-label",
    className: "form-group",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "form-row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("span", {
        id: "group-label",
        className: "group-label",
        children: [intl.formatMessage(messages.notificationTypes), !user && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
          className: "label-required",
          children: "*"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "form-input-area",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "max-w-lg",
          children: availableTypes.map(type => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_app_components_NotificationTypeSelector_NotificationType__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            option: type,
            currentTypes: currentTypes,
            onUpdate: onUpdate
          }, `notification-type-${type.id}`))
        }), error && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "error",
          children: error
        })]
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationTypeSelector);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;