"use strict";
exports.id = 96157;
exports.ids = [96157];
exports.modules = {

/***/ 96157:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86799);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__]);
_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.defineMessages)({
  settings: {
    "id": "components.UserProfile.ProfileHeader.settings",
    "defaultMessage": 'Edit Settings'
  },
  profile: {
    "id": "components.UserProfile.ProfileHeader.profile",
    "defaultMessage": 'View Profile'
  },
  joindate: {
    "id": "components.UserProfile.ProfileHeader.joindate",
    "defaultMessage": 'Joined {joindate}'
  },
  userid: {
    "id": "components.UserProfile.ProfileHeader.userid",
    "defaultMessage": 'User ID: {userid}'
  }
});

const ProfileHeader = ({
  user,
  isSettingsPage
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.useIntl)();
  const {
    user: loggedInUser,
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .useUser */ .aF)();
  const subtextItems = [intl.formatMessage(messages.joindate, {
    joindate: intl.formatDate(user.createdAt, {
      year: 'numeric',
      month: 'long',
      day: 'numeric'
    })
  })];

  if (hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS)) {
    subtextItems.push(intl.formatMessage(messages.userid, {
      userid: user.id
    }));
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "relative z-40 mt-6 mb-12 lg:flex lg:items-end lg:justify-between lg:space-x-5",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "flex items-end justify-items-end space-x-5",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "flex-shrink-0",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "relative",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("img", {
            className: "h-24 w-24 rounded-full bg-gray-600 object-cover ring-1 ring-gray-700",
            src: user.avatar,
            alt: ""
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
            className: "absolute inset-0 rounded-full shadow-inner",
            "aria-hidden": "true"
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "pt-1.5",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("h1", {
          className: "mb-1 flex flex-col sm:flex-row sm:items-center",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx((next_link__WEBPACK_IMPORTED_MODULE_3___default()), {
            href: user.id === loggedInUser?.id ? '/profile' : `/users/${user.id}`,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("a", {
              className: "text-overseerr text-lg font-bold hover:to-purple-200 sm:text-2xl",
              children: user.displayName
            })
          }), user.email && user.displayName.toLowerCase() !== user.email && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("span", {
            className: "text-sm text-gray-400 sm:ml-2 sm:text-lg",
            children: ["(", user.email, ")"]
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("p", {
          className: "text-sm font-medium text-gray-400",
          children: subtextItems.reduce((prev, curr) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
            children: [prev, " | ", curr]
          }))
        })]
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "justify-stretch mt-6 flex flex-col-reverse space-y-4 space-y-reverse lg:flex-row lg:justify-end lg:space-y-0 lg:space-x-3 lg:space-x-reverse",
      children: (loggedInUser?.id === user.id || user.id !== 1 && hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS)) && !isSettingsPage ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx((next_link__WEBPACK_IMPORTED_MODULE_3___default()), {
        href: loggedInUser?.id === user.id ? `/profile/settings` : `/users/${user.id}/settings`,
        passHref: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          as: "a",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.CogIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
            children: intl.formatMessage(messages.settings)
          })]
        })
      }) : isSettingsPage && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx((next_link__WEBPACK_IMPORTED_MODULE_3___default()), {
        href: loggedInUser?.id === user.id ? `/profile` : `/users/${user.id}`,
        passHref: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          as: "a",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.UserIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
            children: intl.formatMessage(messages.profile)
          })]
        })
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProfileHeader);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;