"use strict";
exports.id = 99073;
exports.ids = [99073];
exports.modules = {

/***/ 99073:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);




const Badge = ({
  badgeType = 'default',
  className,
  href,
  children
}, ref) => {
  const badgeStyle = ['px-2 inline-flex text-xs leading-5 font-semibold rounded-full whitespace-nowrap'];

  if (href) {
    badgeStyle.push('transition cursor-pointer !no-underline');
  } else {
    badgeStyle.push('cursor-default');
  }

  switch (badgeType) {
    case 'danger':
      badgeStyle.push('bg-red-600 bg-opacity-80 border-red-500 border !text-red-100');

      if (href) {
        badgeStyle.push('hover:bg-red-500 bg-opacity-100');
      }

      break;

    case 'warning':
      badgeStyle.push('bg-yellow-500 bg-opacity-80 border-yellow-500 border !text-yellow-100');

      if (href) {
        badgeStyle.push('hover:bg-yellow-500 hover:bg-opacity-100');
      }

      break;

    case 'success':
      badgeStyle.push('bg-green-500 bg-opacity-80 border border-green-500 !text-green-100');

      if (href) {
        badgeStyle.push('hover:bg-green-500 hover:bg-opacity-100');
      }

      break;

    case 'dark':
      badgeStyle.push('bg-gray-900 !text-gray-400');

      if (href) {
        badgeStyle.push('hover:bg-gray-800');
      }

      break;

    case 'light':
      badgeStyle.push('bg-gray-700 !text-gray-300');

      if (href) {
        badgeStyle.push('hover:bg-gray-600');
      }

      break;

    default:
      badgeStyle.push('bg-indigo-500 bg-opacity-80 border border-indigo-500 !text-indigo-100');

      if (href) {
        badgeStyle.push('hover:bg-indigo-500 hover:bg-opacity-100');
      }

  }

  if (className) {
    badgeStyle.push(className);
  }

  if (href?.includes('://')) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("a", {
      href: href,
      target: "_blank",
      rel: "noopener noreferrer",
      className: badgeStyle.join(' '),
      ref: ref,
      children: children
    });
  } else if (href) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_link__WEBPACK_IMPORTED_MODULE_0___default()), {
      href: href,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("a", {
        className: badgeStyle.join(' '),
        ref: ref,
        children: children
      })
    });
  } else {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("span", {
      className: badgeStyle.join(' '),
      ref: ref,
      children: children
    });
  }
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default().forwardRef(Badge));

/***/ })

};
;