"use strict";
(() => {
var exports = {};
exports.id = 10307;
exports.ids = [10307,64820];
exports.modules = {

/***/ 25944:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(63145);
/* harmony import */ var _app_hooks_useDebouncedState__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29303);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);






const MultiRangeSlider = ({
  min,
  max,
  defaultMinValue,
  defaultMaxValue,
  subText,
  onUpdateMin,
  onUpdateMax
}) => {
  const touched = (0,react__WEBPACK_IMPORTED_MODULE_2__.useRef)(false);
  const [valueMin, finalValueMin, setValueMin] = (0,_app_hooks_useDebouncedState__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(defaultMinValue ?? min);
  const [valueMax, finalValueMax, setValueMax] = (0,_app_hooks_useDebouncedState__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(defaultMaxValue ?? max);
  const minThumb = (valueMin - min) / (max - min) * 100;
  const maxThumb = (valueMax - min) / (max - min) * 100;
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (touched.current) {
      onUpdateMin(finalValueMin);
    }
  }, [finalValueMin, onUpdateMin]);
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (touched.current) {
      onUpdateMax(finalValueMax);
    }
  }, [finalValueMax, onUpdateMax]);
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    touched.current = false;
    setValueMax(defaultMaxValue ?? max);
    setValueMin(defaultMinValue ?? min);
  }, [defaultMinValue, defaultMaxValue, setValueMax, setValueMin, min, max]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: `relative ${subText ? 'h-8' : 'h-4'} w-full`,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      content: valueMin.toString(),
      tooltipConfig: {
        placement: 'top'
      },
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("input", {
        type: "range",
        min: min,
        max: max,
        value: valueMin,
        className: `pointer-events-none absolute h-2 w-full cursor-pointer appearance-none rounded-lg bg-gray-700 ${valueMin >= valueMax && valueMin !== min ? 'z-30' : 'z-10'}`,
        onChange: e => {
          const value = Number(e.target.value);

          if (value <= valueMax) {
            touched.current = true;
            setValueMin(value);
          }
        }
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      content: valueMax,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("input", {
        type: "range",
        min: min,
        max: max,
        value: valueMax,
        step: "1",
        className: `pointer-events-none absolute top-0 left-0 right-0 z-20 h-2 w-full cursor-pointer appearance-none rounded-lg bg-transparent`,
        onChange: e => {
          const value = Number(e.target.value);

          if (value >= valueMin) {
            touched.current = true;
            setValueMax(value);
          }
        }
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      className: "pointer-events-none absolute top-0 z-30 ml-1 mr-1 h-2 bg-indigo-500",
      style: {
        left: `${minThumb}%`,
        right: `${100 - maxThumb}%`
      }
    }), subText && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      className: "relative top-4 z-30 flex w-full justify-center text-sm text-gray-400",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("span", {
        children: subText
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MultiRangeSlider);

/***/ }),

/***/ 16374:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_Header__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76631);
/* harmony import */ var _app_components_Common_ListView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5339);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(64468);
/* harmony import */ var _app_components_Discover_FilterSlideover__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(94338);
/* harmony import */ var _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38242);
/* harmony import */ var _app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(27208);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(35635);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_ListView__WEBPACK_IMPORTED_MODULE_2__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_4__, _app_components_Discover_FilterSlideover__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_6__, _app_pages_error__WEBPACK_IMPORTED_MODULE_8__]);
([_app_components_Common_ListView__WEBPACK_IMPORTED_MODULE_2__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_4__, _app_components_Discover_FilterSlideover__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_6__, _app_pages_error__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.defineMessages)({
  discovermovies: {
    "id": "components.Discover.DiscoverMovies.discovermovies",
    "defaultMessage": 'Movies'
  },
  activefilters: {
    "id": "components.Discover.DiscoverMovies.activefilters",
    "defaultMessage": '{count, plural, one {# Active Filter} other {# Active Filters}}'
  },
  sortPopularityAsc: {
    "id": "components.Discover.DiscoverMovies.sortPopularityAsc",
    "defaultMessage": 'Popularity Ascending'
  },
  sortPopularityDesc: {
    "id": "components.Discover.DiscoverMovies.sortPopularityDesc",
    "defaultMessage": 'Popularity Descending'
  },
  sortReleaseDateAsc: {
    "id": "components.Discover.DiscoverMovies.sortReleaseDateAsc",
    "defaultMessage": 'Release Date Ascending'
  },
  sortReleaseDateDesc: {
    "id": "components.Discover.DiscoverMovies.sortReleaseDateDesc",
    "defaultMessage": 'Release Date Descending'
  },
  sortTmdbRatingAsc: {
    "id": "components.Discover.DiscoverMovies.sortTmdbRatingAsc",
    "defaultMessage": 'TMDB Rating Ascending'
  },
  sortTmdbRatingDesc: {
    "id": "components.Discover.DiscoverMovies.sortTmdbRatingDesc",
    "defaultMessage": 'TMDB Rating Descending'
  },
  sortTitleAsc: {
    "id": "components.Discover.DiscoverMovies.sortTitleAsc",
    "defaultMessage": 'Title (A-Z) Ascending'
  },
  sortTitleDesc: {
    "id": "components.Discover.DiscoverMovies.sortTitleDesc",
    "defaultMessage": 'Title (Z-A) Descending'
  }
});
const SortOptions = {
  PopularityAsc: 'popularity.asc',
  PopularityDesc: 'popularity.desc',
  ReleaseDateAsc: 'release_date.asc',
  ReleaseDateDesc: 'release_date.desc',
  TmdbRatingAsc: 'vote_average.asc',
  TmdbRatingDesc: 'vote_average.desc',
  TitleAsc: 'original_title.asc',
  TitleDesc: 'original_title.desc'
};

const DiscoverMovies = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.useIntl)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_10__.useRouter)();
  const updateQueryParams = (0,_app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_7__/* .useUpdateQueryParams */ .BA)({});
  const preparedFilters = (0,_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_4__/* .prepareFilterValues */ .Wm)(router.query);
  const {
    isLoadingInitialData,
    isEmpty,
    isLoadingMore,
    isReachingEnd,
    titles,
    fetchMore,
    error
  } = (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)('/api/v1/discover/movies', preparedFilters);
  const {
    0: showFilters,
    1: setShowFilters
  } = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(false);

  if (error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_8__["default"], {
      statusCode: 500
    });
  }

  const title = intl.formatMessage(messages.discovermovies);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      title: title
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "mb-4 flex flex-col justify-between lg:flex-row lg:items-end",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Header__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "mt-2 flex flex-grow flex-col sm:flex-row lg:flex-grow-0",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "mb-2 flex flex-grow sm:mb-0 sm:mr-2 lg:flex-grow-0",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
            className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-gray-100 sm:text-sm",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.BarsArrowDownIcon, {
              className: "h-6 w-6"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("select", {
            id: "sortBy",
            name: "sortBy",
            className: "rounded-r-only",
            value: preparedFilters.sortBy,
            onChange: e => updateQueryParams('sortBy', e.target.value),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
              value: SortOptions.PopularityDesc,
              children: intl.formatMessage(messages.sortPopularityDesc)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
              value: SortOptions.PopularityAsc,
              children: intl.formatMessage(messages.sortPopularityAsc)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
              value: SortOptions.ReleaseDateDesc,
              children: intl.formatMessage(messages.sortReleaseDateDesc)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
              value: SortOptions.ReleaseDateAsc,
              children: intl.formatMessage(messages.sortReleaseDateAsc)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
              value: SortOptions.TmdbRatingDesc,
              children: intl.formatMessage(messages.sortTmdbRatingDesc)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
              value: SortOptions.TmdbRatingAsc,
              children: intl.formatMessage(messages.sortTmdbRatingAsc)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
              value: SortOptions.TitleAsc,
              children: intl.formatMessage(messages.sortTitleAsc)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
              value: SortOptions.TitleDesc,
              children: intl.formatMessage(messages.sortTitleDesc)
            })]
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Discover_FilterSlideover__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
          type: "movie",
          currentFilters: preparedFilters,
          onClose: () => setShowFilters(false),
          show: showFilters
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
          className: "mb-2 flex flex-grow sm:mb-0 lg:flex-grow-0",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            onClick: () => setShowFilters(true),
            className: "w-full",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.FunnelIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              children: intl.formatMessage(messages.activefilters, {
                count: (0,_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_4__/* .countActiveFilters */ .GR)(preparedFilters)
              })
            })]
          })
        })]
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_ListView__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      items: titles,
      isEmpty: isEmpty,
      isLoading: isLoadingInitialData || isLoadingMore && (titles?.length ?? 0) > 0,
      isReachingEnd: isReachingEnd,
      onScrollBottom: fetchMore
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscoverMovies);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 94338:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_MultiRangeSlider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25944);
/* harmony import */ var _app_components_Common_SlideOver__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55946);
/* harmony import */ var _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(64468);
/* harmony import */ var _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41466);
/* harmony import */ var _app_components_Selector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31627);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(27208);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_tailwindcss_datepicker_sct__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(69247);
/* harmony import */ var react_tailwindcss_datepicker_sct__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_tailwindcss_datepicker_sct__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_SlideOver__WEBPACK_IMPORTED_MODULE_2__, _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_3__, _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_4__, _app_components_Selector__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__]);
([_app_components_Common_SlideOver__WEBPACK_IMPORTED_MODULE_2__, _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_3__, _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_4__, _app_components_Selector__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.defineMessages)({
  filters: {
    "id": "components.Discover.FilterSlideover.filters",
    "defaultMessage": 'Filters'
  },
  activefilters: {
    "id": "components.Discover.FilterSlideover.activefilters",
    "defaultMessage": '{count, plural, one {# Active Filter} other {# Active Filters}}'
  },
  releaseDate: {
    "id": "components.Discover.FilterSlideover.releaseDate",
    "defaultMessage": 'Release Date'
  },
  firstAirDate: {
    "id": "components.Discover.FilterSlideover.firstAirDate",
    "defaultMessage": 'First Air Date'
  },
  from: {
    "id": "components.Discover.FilterSlideover.from",
    "defaultMessage": 'From'
  },
  to: {
    "id": "components.Discover.FilterSlideover.to",
    "defaultMessage": 'To'
  },
  studio: {
    "id": "components.Discover.FilterSlideover.studio",
    "defaultMessage": 'Studio'
  },
  genres: {
    "id": "components.Discover.FilterSlideover.genres",
    "defaultMessage": 'Genres'
  },
  keywords: {
    "id": "components.Discover.FilterSlideover.keywords",
    "defaultMessage": 'Keywords'
  },
  originalLanguage: {
    "id": "components.Discover.FilterSlideover.originalLanguage",
    "defaultMessage": 'Original Language'
  },
  runtimeText: {
    "id": "components.Discover.FilterSlideover.runtimeText",
    "defaultMessage": '{minValue}-{maxValue} minute runtime'
  },
  ratingText: {
    "id": "components.Discover.FilterSlideover.ratingText",
    "defaultMessage": 'Ratings between {minValue} and {maxValue}'
  },
  clearfilters: {
    "id": "components.Discover.FilterSlideover.clearfilters",
    "defaultMessage": 'Clear Active Filters'
  },
  tmdbuserscore: {
    "id": "components.Discover.FilterSlideover.tmdbuserscore",
    "defaultMessage": 'TMDB User Score'
  },
  tmdbuservotecount: {
    "id": "components.Discover.FilterSlideover.tmdbuservotecount",
    "defaultMessage": 'TMDB User Vote Count'
  },
  runtime: {
    "id": "components.Discover.FilterSlideover.runtime",
    "defaultMessage": 'Runtime'
  },
  streamingservices: {
    "id": "components.Discover.FilterSlideover.streamingservices",
    "defaultMessage": 'Streaming Services'
  },
  voteCount: {
    "id": "components.Discover.FilterSlideover.voteCount",
    "defaultMessage": 'Number of votes between {minValue} and {maxValue}'
  }
});

const FilterSlideover = ({
  show,
  onClose,
  type,
  currentFilters
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const {
    currentSettings
  } = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)();
  const updateQueryParams = (0,_app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_7__/* .useUpdateQueryParams */ .BA)({});
  const batchUpdateQueryParams = (0,_app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_7__/* .useBatchUpdateQueryParams */ .HE)({});
  const dateGte = type === 'movie' ? 'primaryReleaseDateGte' : 'firstAirDateGte';
  const dateLte = type === 'movie' ? 'primaryReleaseDateLte' : 'firstAirDateLte';
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_SlideOver__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    show: show,
    title: intl.formatMessage(messages.filters),
    subText: intl.formatMessage(messages.activefilters, {
      count: (0,_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_3__/* .countActiveFilters */ .GR)(currentFilters)
    }),
    onClose: () => onClose(),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "flex flex-col space-y-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
          className: "mb-2 text-lg font-semibold",
          children: intl.formatMessage(type === 'movie' ? messages.releaseDate : messages.firstAirDate)
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "relative z-40 flex space-x-2",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "flex flex-col",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
              className: "mb-2",
              children: intl.formatMessage(messages.from)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx((react_tailwindcss_datepicker_sct__WEBPACK_IMPORTED_MODULE_10___default()), {
              primaryColor: "indigo",
              value: {
                startDate: currentFilters[dateGte] ?? null,
                endDate: currentFilters[dateGte] ?? null
              },
              onChange: value => {
                updateQueryParams(dateGte, value?.startDate ? value.startDate : undefined);
              },
              inputName: "fromdate",
              useRange: false,
              asSingle: true,
              containerClassName: "datepicker-wrapper",
              inputClassName: "pr-1 sm:pr-4 text-base leading-5"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "flex flex-col",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
              className: "mb-2",
              children: intl.formatMessage(messages.to)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx((react_tailwindcss_datepicker_sct__WEBPACK_IMPORTED_MODULE_10___default()), {
              primaryColor: "indigo",
              value: {
                startDate: currentFilters[dateLte] ?? null,
                endDate: currentFilters[dateLte] ?? null
              },
              onChange: value => {
                updateQueryParams(dateLte, value?.startDate ? value.startDate : undefined);
              },
              inputName: "todate",
              useRange: false,
              asSingle: true,
              containerClassName: "datepicker-wrapper",
              inputClassName: "pr-1 sm:pr-4 text-base leading-5"
            })]
          })]
        })]
      }), type === 'movie' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
          className: "text-lg font-semibold",
          children: intl.formatMessage(messages.studio)
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Selector__WEBPACK_IMPORTED_MODULE_5__/* .CompanySelector */ .tz, {
          defaultValue: currentFilters.studio,
          onChange: value => {
            updateQueryParams('studio', value?.value.toString());
          }
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
        className: "text-lg font-semibold",
        children: intl.formatMessage(messages.genres)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Selector__WEBPACK_IMPORTED_MODULE_5__/* .GenreSelector */ .DC, {
        type: type,
        defaultValue: currentFilters.genre,
        isMulti: true,
        onChange: value => {
          updateQueryParams('genre', value?.map(v => v.value).join(','));
        }
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
        className: "text-lg font-semibold",
        children: intl.formatMessage(messages.keywords)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Selector__WEBPACK_IMPORTED_MODULE_5__/* .KeywordSelector */ .oW, {
        defaultValue: currentFilters.keywords,
        isMulti: true,
        onChange: value => {
          updateQueryParams('keywords', value?.map(v => v.value).join(','));
        }
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
        className: "text-lg font-semibold",
        children: intl.formatMessage(messages.originalLanguage)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        value: currentFilters.language,
        serverValue: currentSettings.originalLanguage,
        isUserSettings: true,
        setFieldValue: (_key, value) => {
          updateQueryParams('language', value);
        }
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
        className: "text-lg font-semibold",
        children: intl.formatMessage(messages.runtime)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
        className: "relative z-0",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_MultiRangeSlider__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          min: 0,
          max: 400,
          onUpdateMin: min => {
            updateQueryParams('withRuntimeGte', min !== 0 && Number(currentFilters.withRuntimeLte) !== 400 ? min.toString() : undefined);
          },
          onUpdateMax: max => {
            updateQueryParams('withRuntimeLte', max !== 400 && Number(currentFilters.withRuntimeGte) !== 0 ? max.toString() : undefined);
          },
          defaultMaxValue: currentFilters.withRuntimeLte ? Number(currentFilters.withRuntimeLte) : undefined,
          defaultMinValue: currentFilters.withRuntimeGte ? Number(currentFilters.withRuntimeGte) : undefined,
          subText: intl.formatMessage(messages.runtimeText, {
            minValue: currentFilters.withRuntimeGte ?? 0,
            maxValue: currentFilters.withRuntimeLte ?? 400
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
        className: "text-lg font-semibold",
        children: intl.formatMessage(messages.tmdbuserscore)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
        className: "relative z-0",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_MultiRangeSlider__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          min: 1,
          max: 10,
          defaultMaxValue: currentFilters.voteAverageLte ? Number(currentFilters.voteAverageLte) : undefined,
          defaultMinValue: currentFilters.voteAverageGte ? Number(currentFilters.voteAverageGte) : undefined,
          onUpdateMin: min => {
            updateQueryParams('voteAverageGte', min !== 1 && Number(currentFilters.voteAverageLte) !== 10 ? min.toString() : undefined);
          },
          onUpdateMax: max => {
            updateQueryParams('voteAverageLte', max !== 10 && Number(currentFilters.voteAverageGte) !== 1 ? max.toString() : undefined);
          },
          subText: intl.formatMessage(messages.ratingText, {
            minValue: currentFilters.voteAverageGte ?? 1,
            maxValue: currentFilters.voteAverageLte ?? 10
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
        className: "text-lg font-semibold",
        children: intl.formatMessage(messages.tmdbuservotecount)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
        className: "relative z-0",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_MultiRangeSlider__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          min: 0,
          max: 1000,
          defaultMaxValue: currentFilters.voteCountLte ? Number(currentFilters.voteCountLte) : undefined,
          defaultMinValue: currentFilters.voteCountGte ? Number(currentFilters.voteCountGte) : undefined,
          onUpdateMin: min => {
            updateQueryParams('voteCountGte', min !== 0 && Number(currentFilters.voteCountLte) !== 1000 ? min.toString() : undefined);
          },
          onUpdateMax: max => {
            updateQueryParams('voteCountLte', max !== 1000 && Number(currentFilters.voteCountGte) !== 0 ? max.toString() : undefined);
          },
          subText: intl.formatMessage(messages.voteCount, {
            minValue: currentFilters.voteCountGte ?? 0,
            maxValue: currentFilters.voteCountLte ?? 1000
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
        className: "text-lg font-semibold",
        children: intl.formatMessage(messages.streamingservices)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Selector__WEBPACK_IMPORTED_MODULE_5__/* .WatchProviderSelector */ .l5, {
        type: type,
        region: currentFilters.watchRegion,
        activeProviders: currentFilters.watchProviders?.split('|').map(v => Number(v)) ?? [],
        onChange: (region, providers) => {
          if (providers.length) {
            batchUpdateQueryParams({
              watchRegion: region,
              watchProviders: providers.join('|')
            });
          } else {
            batchUpdateQueryParams({
              watchRegion: undefined,
              watchProviders: undefined
            });
          }
        }
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
        className: "pt-4",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          className: "w-full",
          disabled: Object.keys(currentFilters).length === 0,
          onClick: () => {
            const copyCurrent = Object.assign({}, currentFilters);
            Object.keys(copyCurrent).forEach(k => {
              copyCurrent[k] = undefined;
            });
            batchUpdateQueryParams(copyCurrent);
            onClose();
          },
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__.XCircleIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
            children: intl.formatMessage(messages.clearfilters)
          })]
        })
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FilterSlideover);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 31627:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DC": () => (/* binding */ GenreSelector),
/* harmony export */   "l5": () => (/* binding */ WatchProviderSelector),
/* harmony export */   "oW": () => (/* binding */ KeywordSelector),
/* harmony export */   "tz": () => (/* binding */ CompanySelector)
/* harmony export */ });
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7292);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63145);
/* harmony import */ var _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(72134);
/* harmony import */ var _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38242);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1388);
/* harmony import */ var _heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(59476);
/* harmony import */ var _heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(99648);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_select_async__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(23618);
/* harmony import */ var react_select_async__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_select_async__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__, _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__, axios__WEBPACK_IMPORTED_MODULE_8__, swr__WEBPACK_IMPORTED_MODULE_13__]);
([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__, _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__, axios__WEBPACK_IMPORTED_MODULE_8__, swr__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);

















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.defineMessages)({
  searchKeywords: {
    "id": "components.Selector.searchKeywords",
    "defaultMessage": 'Search keywords…'
  },
  searchGenres: {
    "id": "components.Selector.searchGenres",
    "defaultMessage": 'Select genres…'
  },
  searchStudios: {
    "id": "components.Selector.searchStudios",
    "defaultMessage": 'Search studios…'
  },
  starttyping: {
    "id": "components.Selector.starttyping",
    "defaultMessage": 'Starting typing to search.'
  },
  nooptions: {
    "id": "components.Selector.nooptions",
    "defaultMessage": 'No results.'
  },
  showmore: {
    "id": "components.Selector.showmore",
    "defaultMessage": 'Show More'
  },
  showless: {
    "id": "components.Selector.showless",
    "defaultMessage": 'Show Less'
  }
});
const CompanySelector = ({
  defaultValue,
  isMulti,
  onChange
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    0: defaultDataValue,
    1: setDefaultDataValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    const loadDefaultCompany = async () => {
      if (!defaultValue) {
        return;
      }

      const response = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get(`/api/v1/studio/${defaultValue}`);
      const studio = response.data;
      setDefaultDataValue([{
        label: studio.name ?? '',
        value: studio.id ?? 0
      }]);
    };

    loadDefaultCompany();
  }, [defaultValue]);

  const loadCompanyOptions = async inputValue => {
    if (inputValue === '') {
      return [];
    }

    const results = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get('/api/v1/search/company', {
      params: {
        query: (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__/* .encodeURIExtraParams */ .p)(inputValue)
      }
    });
    return results.data.results.map(result => ({
      label: result.name,
      value: result.id
    }));
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_12___default()), {
    className: "react-select-container",
    classNamePrefix: "react-select",
    isMulti: isMulti,
    defaultValue: defaultDataValue,
    defaultOptions: true,
    cacheOptions: true,
    isClearable: true,
    noOptionsMessage: ({
      inputValue
    }) => inputValue === '' ? intl.formatMessage(messages.starttyping) : intl.formatMessage(messages.nooptions),
    loadOptions: loadCompanyOptions,
    placeholder: intl.formatMessage(messages.searchStudios),
    onChange: value => {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      onChange(value);
    }
  }, `company-selector-${defaultDataValue}`);
};
const GenreSelector = ({
  isMulti,
  defaultValue,
  onChange,
  type
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    0: defaultDataValue,
    1: setDefaultDataValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    const loadDefaultGenre = async () => {
      if (!defaultValue) {
        return;
      }

      const genres = defaultValue.split(',');
      const response = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get(`/api/v1/genres/${type}`);
      const genreData = genres.filter(genre => response.data.find(gd => gd.id === Number(genre))).map(g => response.data.find(gd => gd.id === Number(g))).map(g => ({
        label: g?.name ?? '',
        value: g?.id ?? 0
      }));
      setDefaultDataValue(genreData);
    };

    loadDefaultGenre();
  }, [defaultValue, type]);

  const loadGenreOptions = async inputValue => {
    const results = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get(`/api/v1/discover/genreslider/${type}`);
    return results.data.map(result => ({
      label: result.name,
      value: result.id
    })).filter(({
      label
    }) => label.toLowerCase().includes(inputValue.toLowerCase()));
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_12___default()), {
    className: "react-select-container",
    classNamePrefix: "react-select",
    defaultValue: isMulti ? defaultDataValue : defaultDataValue?.[0],
    defaultOptions: true,
    cacheOptions: true,
    isMulti: isMulti,
    loadOptions: loadGenreOptions,
    placeholder: intl.formatMessage(messages.searchGenres),
    onChange: value => {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      onChange(value);
    }
  }, `genre-select-${defaultDataValue}`);
};
const KeywordSelector = ({
  isMulti,
  defaultValue,
  onChange
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    0: defaultDataValue,
    1: setDefaultDataValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    const loadDefaultKeywords = async () => {
      if (!defaultValue) {
        return;
      }

      const keywords = await Promise.all(defaultValue.split(',').map(async keywordId => {
        const keyword = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get(`/api/v1/keyword/${keywordId}`);
        return keyword.data;
      }));
      setDefaultDataValue(keywords.map(keyword => ({
        label: keyword.name,
        value: keyword.id
      })));
    };

    loadDefaultKeywords();
  }, [defaultValue]);

  const loadKeywordOptions = async inputValue => {
    const results = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get('/api/v1/search/keyword', {
      params: {
        query: (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__/* .encodeURIExtraParams */ .p)(inputValue)
      }
    });
    return results.data.results.map(result => ({
      label: result.name,
      value: result.id
    }));
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_12___default()), {
    inputId: "data",
    isMulti: isMulti,
    className: "react-select-container",
    classNamePrefix: "react-select",
    noOptionsMessage: ({
      inputValue
    }) => inputValue === '' ? intl.formatMessage(messages.starttyping) : intl.formatMessage(messages.nooptions),
    defaultValue: defaultDataValue,
    loadOptions: loadKeywordOptions,
    placeholder: intl.formatMessage(messages.searchKeywords),
    onChange: value => {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      onChange(value);
    }
  }, `keyword-select-${defaultDataValue}`);
};
const WatchProviderSelector = ({
  type,
  onChange,
  region,
  activeProviders
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    currentSettings
  } = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)();
  const {
    0: showMore,
    1: setShowMore
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const {
    0: watchRegion,
    1: setWatchRegion
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(region ? region : currentSettings.region ? currentSettings.region : 'US');
  const {
    0: activeProvider,
    1: setActiveProvider
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(activeProviders ?? []);
  const {
    data,
    isLoading
  } = (0,swr__WEBPACK_IMPORTED_MODULE_13__["default"])(`/api/v1/watchproviders/${type === 'movie' ? 'movies' : 'tv'}?watchRegion=${watchRegion}`);
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    onChange(watchRegion, activeProvider); // removed onChange as a dependency as we only need to call it when the value(s) change
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [activeProvider, watchRegion]);
  const orderedData = (0,react__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => {
    if (!data) {
      return [];
    }

    return (0,lodash__WEBPACK_IMPORTED_MODULE_9__.orderBy)(data, ['display_priority'], ['asc']);
  }, [data]);

  const toggleProvider = id => {
    if (activeProvider.includes(id)) {
      setActiveProvider(activeProvider.filter(p => p !== id));
    } else {
      setActiveProvider([...activeProvider, id]);
    }
  };

  const initialProviders = orderedData.slice(0, 24);
  const otherProviders = orderedData.slice(24);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      value: watchRegion,
      name: "watchRegion",
      onChange: (_name, value) => {
        if (value !== watchRegion) {
          setActiveProvider([]);
        }

        setWatchRegion(value);
      },
      disableAll: true,
      watchProviders: true
    }), isLoading ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* .SmallLoadingSpinner */ .e, {}) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
      className: "grid",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
        className: "provider-icons grid gap-2",
        children: initialProviders.map(provider => {
          const isActive = activeProvider.includes(provider.id);
          return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
            content: provider.name,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
              className: `provider-container relative w-full cursor-pointer rounded-lg p-2 ring-1 ${isActive ? 'bg-gray-600 ring-indigo-500 hover:bg-gray-500' : 'bg-gray-700 ring-gray-500 hover:bg-gray-600'}`,
              onClick: () => toggleProvider(provider.id),
              onKeyDown: e => {
                if (e.key === 'Enter') {
                  toggleProvider(provider.id);
                }
              },
              role: "button",
              tabIndex: 0,
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                src: `https://image.tmdb.org/t/p/original${provider.logoPath}`,
                alt: "",
                layout: "responsive",
                width: "100%",
                height: "100%",
                className: "rounded-lg"
              }), isActive && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
                className: "pointer-events-none absolute -top-1 -left-1 flex items-center justify-center text-indigo-100 opacity-90",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__.CheckCircleIcon, {
                  className: "h-6 w-6"
                })
              })]
            })
          }, `prodiver-${provider.id}`);
        })
      }), showMore && otherProviders.length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
        className: "provider-icons relative top-2 grid gap-2",
        children: otherProviders.map(provider => {
          const isActive = activeProvider.includes(provider.id);
          return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
            content: provider.name,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
              className: `provider-container relative w-full cursor-pointer rounded-lg p-2 ring-1 transition ${isActive ? 'bg-gray-600 ring-indigo-500 hover:bg-gray-500' : 'bg-gray-700 ring-gray-500 hover:bg-gray-600'}`,
              onClick: () => toggleProvider(provider.id),
              onKeyDown: e => {
                if (e.key === 'Enter') {
                  toggleProvider(provider.id);
                }
              },
              role: "button",
              tabIndex: 0,
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                src: `https://image.tmdb.org/t/p/original${provider.logoPath}`,
                alt: "",
                layout: "responsive",
                width: "100%",
                height: "100%",
                className: "rounded-lg"
              }), isActive && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
                className: "pointer-events-none absolute -top-1 -left-1 flex items-center justify-center text-indigo-100 opacity-90",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__.CheckCircleIcon, {
                  className: "h-6 w-6"
                })
              })]
            })
          }, `prodiver-${provider.id}`);
        })
      }), otherProviders.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("button", {
        className: "relative top-4 flex items-center justify-center space-x-2 text-sm text-gray-400 transition hover:text-gray-200",
        type: "button",
        onClick: () => setShowMore(!showMore),
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
          className: "h-0.5 flex-1 bg-gray-600"
        }), showMore ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__.ArrowUpIcon, {
            className: "h-4 w-4"
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
            children: intl.formatMessage(messages.showless)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__.ArrowUpIcon, {
            className: "h-4 w-4"
          })]
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__.ArrowDownIcon, {
            className: "h-4 w-4"
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
            children: intl.formatMessage(messages.showmore)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__.ArrowDownIcon, {
            className: "h-4 w-4"
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
          className: "h-0.5 flex-1 bg-gray-600"
        })]
      })]
    })]
  });
};
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 29303:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/**
 * A hook to help with debouncing state
 *
 * This hook basically acts the same as useState except it is also
 * returning a deobuncedValue that can be used for things like
 * debouncing input into a search field
 *
 * @param initialValue Initial state value
 * @param debounceTime Debounce time in ms
 */

const useDebouncedState = (initialValue, debounceTime = 300) => {
  const {
    0: value,
    1: setValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialValue);
  const {
    0: finalValue,
    1: setFinalValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialValue);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const timeout = setTimeout(() => {
      setFinalValue(value);
    }, debounceTime);
    return () => {
      clearTimeout(timeout);
    };
  }, [value, debounceTime]);
  return [value, finalValue, setValue];
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDebouncedState);

/***/ }),

/***/ 91357:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Discover_DiscoverMovies__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16374);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Discover_DiscoverMovies__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_Discover_DiscoverMovies__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const DiscoverMoviesPage = () => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_app_components_Discover_DiscoverMovies__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {});
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscoverMoviesPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 59476:
/***/ ((module) => {

module.exports = require("@heroicons/react/20/solid");

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 46517:
/***/ ((module) => {

module.exports = require("lodash");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 66405:
/***/ ((module) => {

module.exports = require("react-dom");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 30616:
/***/ ((module) => {

module.exports = require("react-popper-tooltip");

/***/ }),

/***/ 61929:
/***/ ((module) => {

module.exports = require("react-select");

/***/ }),

/***/ 23618:
/***/ ((module) => {

module.exports = require("react-select/async");

/***/ }),

/***/ 69247:
/***/ ((module) => {

module.exports = require("react-tailwindcss-datepicker-sct");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 31856:
/***/ ((module) => {

module.exports = import("country-flag-icons");;

/***/ }),

/***/ 44009:
/***/ ((module) => {

module.exports = import("react-intersection-observer");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ }),

/***/ 91448:
/***/ ((module) => {

module.exports = import("swr/infinite");;

/***/ }),

/***/ 9926:
/***/ ((module) => {

module.exports = import("zod");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,1388,61439,19998,80210,86799,35635,13555,99073,7292,22796,72964,24115,42040,71473,61276,68229,33056,38242,48490,63145,72134,41466,27208,64468,55946], () => (__webpack_exec__(91357)));
module.exports = __webpack_exports__;

})();