"use strict";
(() => {
var exports = {};
exports.id = 95405;
exports.ids = [95405,64820,67240];
exports.modules = {

/***/ 75341:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_": () => (/* binding */ DiscoverSliderType)
/* harmony export */ });
/* unused harmony export defaultSliders */
let DiscoverSliderType;

(function (DiscoverSliderType) {
  DiscoverSliderType[DiscoverSliderType["RECENTLY_ADDED"] = 1] = "RECENTLY_ADDED";
  DiscoverSliderType[DiscoverSliderType["RECENT_REQUESTS"] = 2] = "RECENT_REQUESTS";
  DiscoverSliderType[DiscoverSliderType["PLEX_WATCHLIST"] = 3] = "PLEX_WATCHLIST";
  DiscoverSliderType[DiscoverSliderType["TRENDING"] = 4] = "TRENDING";
  DiscoverSliderType[DiscoverSliderType["POPULAR_MOVIES"] = 5] = "POPULAR_MOVIES";
  DiscoverSliderType[DiscoverSliderType["MOVIE_GENRES"] = 6] = "MOVIE_GENRES";
  DiscoverSliderType[DiscoverSliderType["UPCOMING_MOVIES"] = 7] = "UPCOMING_MOVIES";
  DiscoverSliderType[DiscoverSliderType["STUDIOS"] = 8] = "STUDIOS";
  DiscoverSliderType[DiscoverSliderType["POPULAR_TV"] = 9] = "POPULAR_TV";
  DiscoverSliderType[DiscoverSliderType["TV_GENRES"] = 10] = "TV_GENRES";
  DiscoverSliderType[DiscoverSliderType["UPCOMING_TV"] = 11] = "UPCOMING_TV";
  DiscoverSliderType[DiscoverSliderType["NETWORKS"] = 12] = "NETWORKS";
  DiscoverSliderType[DiscoverSliderType["TMDB_MOVIE_KEYWORD"] = 13] = "TMDB_MOVIE_KEYWORD";
  DiscoverSliderType[DiscoverSliderType["TMDB_MOVIE_GENRE"] = 14] = "TMDB_MOVIE_GENRE";
  DiscoverSliderType[DiscoverSliderType["TMDB_TV_KEYWORD"] = 15] = "TMDB_TV_KEYWORD";
  DiscoverSliderType[DiscoverSliderType["TMDB_TV_GENRE"] = 16] = "TMDB_TV_GENRE";
  DiscoverSliderType[DiscoverSliderType["TMDB_SEARCH"] = 17] = "TMDB_SEARCH";
  DiscoverSliderType[DiscoverSliderType["TMDB_STUDIO"] = 18] = "TMDB_STUDIO";
  DiscoverSliderType[DiscoverSliderType["TMDB_NETWORK"] = 19] = "TMDB_NETWORK";
  DiscoverSliderType[DiscoverSliderType["TMDB_MOVIE_STREAMING_SERVICES"] = 20] = "TMDB_MOVIE_STREAMING_SERVICES";
  DiscoverSliderType[DiscoverSliderType["TMDB_TV_STREAMING_SERVICES"] = 21] = "TMDB_TV_STREAMING_SERVICES";
})(DiscoverSliderType || (DiscoverSliderType = {}));

const defaultSliders = [{
  type: DiscoverSliderType.RECENTLY_ADDED,
  enabled: true,
  isBuiltIn: true,
  order: 0
}, {
  type: DiscoverSliderType.RECENT_REQUESTS,
  enabled: true,
  isBuiltIn: true,
  order: 1
}, {
  type: DiscoverSliderType.PLEX_WATCHLIST,
  enabled: true,
  isBuiltIn: true,
  order: 2
}, {
  type: DiscoverSliderType.TRENDING,
  enabled: true,
  isBuiltIn: true,
  order: 3
}, {
  type: DiscoverSliderType.POPULAR_MOVIES,
  enabled: true,
  isBuiltIn: true,
  order: 4
}, {
  type: DiscoverSliderType.MOVIE_GENRES,
  enabled: true,
  isBuiltIn: true,
  order: 5
}, {
  type: DiscoverSliderType.UPCOMING_MOVIES,
  enabled: true,
  isBuiltIn: true,
  order: 6
}, {
  type: DiscoverSliderType.STUDIOS,
  enabled: true,
  isBuiltIn: true,
  order: 7
}, {
  type: DiscoverSliderType.POPULAR_TV,
  enabled: true,
  isBuiltIn: true,
  order: 8
}, {
  type: DiscoverSliderType.TV_GENRES,
  enabled: true,
  isBuiltIn: true,
  order: 9
}, {
  type: DiscoverSliderType.UPCOMING_TV,
  enabled: true,
  isBuiltIn: true,
  order: 10
}, {
  type: DiscoverSliderType.NETWORKS,
  enabled: true,
  isBuiltIn: true,
  order: 11
}];

/***/ }),

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 99678:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);



const SlideCheckbox = ({
  onClick,
  checked = false
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", {
    role: "checkbox",
    tabIndex: 0,
    "aria-checked": false,
    onClick: () => {
      onClick();
    },
    onKeyDown: e => {
      if (e.key === 'Enter' || e.key === 'Space') {
        onClick();
      }
    },
    className: `relative inline-flex h-5 w-10 flex-shrink-0 cursor-pointer items-center justify-center pt-2 focus:outline-none`,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
      "aria-hidden": "true",
      className: `${checked ? 'bg-indigo-500' : 'bg-gray-700'} absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out`
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
      "aria-hidden": "true",
      className: `${checked ? 'translate-x-5' : 'translate-x-0'} absolute left-0 inline-block h-5 w-5 rounded-full border border-gray-200 bg-white shadow transition-transform duration-200 ease-in-out group-focus:border-blue-300 group-focus:ring`
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SlideCheckbox);

/***/ }),

/***/ 28416:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7292);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const CompanyCard = ({
  image,
  url,
  name
}) => {
  const {
    0: isHovered,
    1: setHovered
  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx((next_link__WEBPACK_IMPORTED_MODULE_1___default()), {
    href: url,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("a", {
      className: `relative flex h-32 w-56 transform-gpu cursor-pointer items-center justify-center p-8 shadow ring-1 transition duration-300 ease-in-out sm:h-36 sm:w-72 ${isHovered ? 'scale-105 bg-gray-700 ring-gray-500' : 'scale-100 bg-gray-800 ring-gray-700'} rounded-xl`,
      onMouseEnter: () => {
        setHovered(true);
      },
      onMouseLeave: () => setHovered(false),
      onKeyDown: e => {
        if (e.key === 'Enter') {
          setHovered(true);
        }
      },
      role: "link",
      tabIndex: 0,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "relative h-full w-full",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          src: image,
          alt: name,
          className: "relative z-40 h-full w-full",
          layout: "fill",
          objectFit: "contain"
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: `absolute bottom-0 left-0 right-0 z-0 h-12 rounded-b-xl bg-gradient-to-t ${isHovered ? 'from-gray-800' : 'from-gray-900'}`
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CompanyCard);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 76765:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43907);
/* harmony import */ var _app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93399);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_3__]);
swr__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const CompanyTag = ({
  companyId,
  type
}) => {
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_3__["default"])(`/api/v1/${type}/${companyId}`);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        className: "h-4 w-4"
      })
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    iconSvg: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__.BuildingOffice2Icon, {}),
    children: data?.name
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CompanyTag);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 86031:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63145);
/* harmony import */ var _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(64468);
/* harmony import */ var _app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18512);
/* harmony import */ var _app_components_Selector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31627);
/* harmony import */ var _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(38242);
/* harmony import */ var _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(75341);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_select_async__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(23618);
/* harmony import */ var react_select_async__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_select_async__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__, _app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_3__, _app_components_Selector__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__, axios__WEBPACK_IMPORTED_MODULE_7__]);
([_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__, _app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_3__, _app_components_Selector__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__, axios__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_10__.defineMessages)({
  addSlider: {
    "id": "components.Discover.CreateSlider.addSlider",
    "defaultMessage": 'Add Slider'
  },
  editSlider: {
    "id": "components.Discover.CreateSlider.editSlider",
    "defaultMessage": 'Edit Slider'
  },
  slidernameplaceholder: {
    "id": "components.Discover.CreateSlider.slidernameplaceholder",
    "defaultMessage": 'Slider Name'
  },
  providetmdbkeywordid: {
    "id": "components.Discover.CreateSlider.providetmdbkeywordid",
    "defaultMessage": 'Provide a TMDB Keyword ID'
  },
  providetmdbgenreid: {
    "id": "components.Discover.CreateSlider.providetmdbgenreid",
    "defaultMessage": 'Provide a TMDB Genre ID'
  },
  providetmdbsearch: {
    "id": "components.Discover.CreateSlider.providetmdbsearch",
    "defaultMessage": 'Provide a search query'
  },
  providetmdbstudio: {
    "id": "components.Discover.CreateSlider.providetmdbstudio",
    "defaultMessage": 'Provide TMDB Studio ID'
  },
  providetmdbnetwork: {
    "id": "components.Discover.CreateSlider.providetmdbnetwork",
    "defaultMessage": 'Provide TMDB Network ID'
  },
  addsuccess: {
    "id": "components.Discover.CreateSlider.addsuccess",
    "defaultMessage": 'Created new slider and saved discover customization settings.'
  },
  addfail: {
    "id": "components.Discover.CreateSlider.addfail",
    "defaultMessage": 'Failed to create new slider.'
  },
  editsuccess: {
    "id": "components.Discover.CreateSlider.editsuccess",
    "defaultMessage": 'Edited slider and saved discover customization settings.'
  },
  editfail: {
    "id": "components.Discover.CreateSlider.editfail",
    "defaultMessage": 'Failed to edit slider.'
  },
  needresults: {
    "id": "components.Discover.CreateSlider.needresults",
    "defaultMessage": 'You need to have at least 1 result.'
  },
  validationDatarequired: {
    "id": "components.Discover.CreateSlider.validationDatarequired",
    "defaultMessage": 'You must provide a data value.'
  },
  validationTitlerequired: {
    "id": "components.Discover.CreateSlider.validationTitlerequired",
    "defaultMessage": 'You must provide a title.'
  },
  addcustomslider: {
    "id": "components.Discover.CreateSlider.addcustomslider",
    "defaultMessage": 'Create Custom Slider'
  },
  searchKeywords: {
    "id": "components.Discover.CreateSlider.searchKeywords",
    "defaultMessage": 'Search keywords…'
  },
  searchGenres: {
    "id": "components.Discover.CreateSlider.searchGenres",
    "defaultMessage": 'Search genres…'
  },
  searchStudios: {
    "id": "components.Discover.CreateSlider.searchStudios",
    "defaultMessage": 'Search studios…'
  },
  starttyping: {
    "id": "components.Discover.CreateSlider.starttyping",
    "defaultMessage": 'Starting typing to search.'
  },
  nooptions: {
    "id": "components.Discover.CreateSlider.nooptions",
    "defaultMessage": 'No results.'
  }
});

const CreateSlider = ({
  onCreate,
  slider
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_10__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_12__.useToasts)();
  const {
    0: resultCount,
    1: setResultCount
  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(0);
  const {
    0: defaultDataValue,
    1: setDefaultDataValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    if (slider) {
      const loadDefaultKeywords = async () => {
        if (!slider.data) {
          return;
        }

        const keywords = await Promise.all(slider.data.split(',').map(async keywordId => {
          const keyword = await axios__WEBPACK_IMPORTED_MODULE_7__["default"].get(`/api/v1/keyword/${keywordId}`);
          return keyword.data;
        }));
        setDefaultDataValue(keywords.map(keyword => ({
          label: keyword.name,
          value: keyword.id
        })));
      };

      const loadDefaultGenre = async () => {
        if (!slider.data) {
          return;
        }

        const response = await axios__WEBPACK_IMPORTED_MODULE_7__["default"].get(`/api/v1/genres/${slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_GENRE */ ._.TMDB_MOVIE_GENRE ? 'movie' : 'tv'}`);
        const genre = response.data.find(genre => genre.id === Number(slider.data));
        setDefaultDataValue([{
          label: genre?.name ?? '',
          value: genre?.id ?? 0
        }]);
      };

      const loadDefaultCompany = async () => {
        if (!slider.data) {
          return;
        }

        const response = await axios__WEBPACK_IMPORTED_MODULE_7__["default"].get(`/api/v1/studio/${slider.data}`);
        const studio = response.data;
        setDefaultDataValue([{
          label: studio.name ?? '',
          value: studio.id ?? 0
        }]);
      };

      switch (slider.type) {
        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_KEYWORD */ ._.TMDB_MOVIE_KEYWORD:
        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_KEYWORD */ ._.TMDB_TV_KEYWORD:
          loadDefaultKeywords();
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_GENRE */ ._.TMDB_MOVIE_GENRE:
        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_GENRE */ ._.TMDB_TV_GENRE:
          loadDefaultGenre();
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_STUDIO */ ._.TMDB_STUDIO:
          loadDefaultCompany();
          break;
      }
    }
  }, [slider]);
  const CreateSliderSchema = yup__WEBPACK_IMPORTED_MODULE_13__.object().shape({
    title: yup__WEBPACK_IMPORTED_MODULE_13__.string().required(intl.formatMessage(messages.validationTitlerequired)),
    data: yup__WEBPACK_IMPORTED_MODULE_13__.string().required(intl.formatMessage(messages.validationDatarequired))
  });
  const updateResultCount = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)(count => {
    setResultCount(count);
  }, [setResultCount]);

  const loadKeywordOptions = async inputValue => {
    const results = await axios__WEBPACK_IMPORTED_MODULE_7__["default"].get('/api/v1/search/keyword', {
      params: {
        query: (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__/* .encodeURIExtraParams */ .p)(inputValue)
      }
    });
    return results.data.results.map(result => ({
      label: result.name,
      value: result.id
    }));
  };

  const loadCompanyOptions = async inputValue => {
    if (inputValue === '') {
      return [];
    }

    const results = await axios__WEBPACK_IMPORTED_MODULE_7__["default"].get('/api/v1/search/company', {
      params: {
        query: (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__/* .encodeURIExtraParams */ .p)(inputValue)
      }
    });
    return results.data.results.map(result => ({
      label: result.name,
      value: result.id
    }));
  };

  const loadMovieGenreOptions = async () => {
    const results = await axios__WEBPACK_IMPORTED_MODULE_7__["default"].get('/api/v1/discover/genreslider/movie');
    return results.data.map(result => ({
      label: result.name,
      value: result.id
    }));
  };

  const loadTvGenreOptions = async () => {
    const results = await axios__WEBPACK_IMPORTED_MODULE_7__["default"].get('/api/v1/discover/genreslider/tv');
    return results.data.map(result => ({
      label: result.name,
      value: result.id
    }));
  };

  const options = [{
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_KEYWORD */ ._.TMDB_MOVIE_KEYWORD,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbmoviekeyword */ .o3.tmdbmoviekeyword),
    dataUrl: '/api/v1/discover/movies',
    params: 'keywords=$value',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder),
    dataPlaceholderText: intl.formatMessage(messages.providetmdbkeywordid)
  }, {
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_KEYWORD */ ._.TMDB_TV_KEYWORD,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbtvkeyword */ .o3.tmdbtvkeyword),
    dataUrl: '/api/v1/discover/tv',
    params: 'keywords=$value',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder),
    dataPlaceholderText: intl.formatMessage(messages.providetmdbkeywordid)
  }, {
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_GENRE */ ._.TMDB_MOVIE_GENRE,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbmoviegenre */ .o3.tmdbmoviegenre),
    dataUrl: '/api/v1/discover/movies/genre/$value',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder),
    dataPlaceholderText: intl.formatMessage(messages.providetmdbgenreid)
  }, {
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_GENRE */ ._.TMDB_TV_GENRE,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbtvgenre */ .o3.tmdbtvgenre),
    dataUrl: '/api/v1/discover/tv/genre/$value',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder),
    dataPlaceholderText: intl.formatMessage(messages.providetmdbgenreid)
  }, {
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_STUDIO */ ._.TMDB_STUDIO,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbstudio */ .o3.tmdbstudio),
    dataUrl: '/api/v1/discover/movies/studio/$value',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder),
    dataPlaceholderText: intl.formatMessage(messages.providetmdbstudio)
  }, {
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_NETWORK */ ._.TMDB_NETWORK,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbnetwork */ .o3.tmdbnetwork),
    dataUrl: '/api/v1/discover/tv/network/$value',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder),
    dataPlaceholderText: intl.formatMessage(messages.providetmdbnetwork)
  }, {
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_SEARCH */ ._.TMDB_SEARCH,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbsearch */ .o3.tmdbsearch),
    dataUrl: '/api/v1/search',
    params: 'query=$value',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder),
    dataPlaceholderText: intl.formatMessage(messages.providetmdbsearch)
  }, {
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_STREAMING_SERVICES */ ._.TMDB_MOVIE_STREAMING_SERVICES,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbmoviestreamingservices */ .o3.tmdbmoviestreamingservices),
    dataUrl: '/api/v1/discover/movies',
    params: 'watchRegion=$regionValue&watchProviders=$providersValue',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder)
  }, {
    type: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_STREAMING_SERVICES */ ._.TMDB_TV_STREAMING_SERVICES,
    title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_2__/* .sliderTitles.tmdbtvstreamingservices */ .o3.tmdbtvstreamingservices),
    dataUrl: '/api/v1/discover/tv',
    params: 'watchRegion=$regionValue&watchProviders=$providersValue',
    titlePlaceholderText: intl.formatMessage(messages.slidernameplaceholder)
  }];
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(formik__WEBPACK_IMPORTED_MODULE_8__.Formik, {
    initialValues: slider ? {
      sliderType: slider.type,
      title: slider.title,
      data: slider.data
    } : {
      sliderType: _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_KEYWORD */ ._.TMDB_MOVIE_KEYWORD,
      title: '',
      data: ''
    },
    validationSchema: CreateSliderSchema,
    enableReinitialize: true,
    onSubmit: async (values, {
      resetForm
    }) => {
      try {
        if (slider) {
          await axios__WEBPACK_IMPORTED_MODULE_7__["default"].put(`/api/v1/settings/discover/${slider.id}`, {
            type: Number(values.sliderType),
            title: values.title,
            data: values.data
          });
        } else {
          await axios__WEBPACK_IMPORTED_MODULE_7__["default"].post('/api/v1/settings/discover/add', {
            type: Number(values.sliderType),
            title: values.title,
            data: values.data
          });
        }

        addToast(intl.formatMessage(slider ? messages.editsuccess : messages.addsuccess), {
          appearance: 'success',
          autoDismiss: true
        });
        onCreate();
        resetForm();
      } catch (e) {
        addToast(intl.formatMessage(slider ? messages.editfail : messages.addfail), {
          appearance: 'error',
          autoDismiss: true
        });
      }
    },
    children: ({
      values,
      isValid,
      isSubmitting,
      errors,
      touched,
      setFieldValue
    }) => {
      const activeOption = options.find(option => option.type === Number(values.sliderType));
      let dataInput;

      switch (activeOption?.type) {
        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_KEYWORD */ ._.TMDB_MOVIE_KEYWORD:
        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_KEYWORD */ ._.TMDB_TV_KEYWORD:
          dataInput = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_11___default()), {
            inputId: "data",
            isMulti: true,
            className: "react-select-container",
            classNamePrefix: "react-select",
            noOptionsMessage: ({
              inputValue
            }) => inputValue === '' ? intl.formatMessage(messages.starttyping) : intl.formatMessage(messages.nooptions),
            defaultValue: defaultDataValue,
            loadOptions: loadKeywordOptions,
            placeholder: intl.formatMessage(messages.searchKeywords),
            onChange: value => {
              const keywords = value.map(item => item.value).join(',');
              setFieldValue('data', keywords);
            }
          }, `keyword-select-${defaultDataValue}`);
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_GENRE */ ._.TMDB_MOVIE_GENRE:
          dataInput = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_11___default()), {
            className: "react-select-container",
            classNamePrefix: "react-select",
            defaultValue: defaultDataValue?.[0],
            defaultOptions: true,
            cacheOptions: true,
            loadOptions: loadMovieGenreOptions,
            placeholder: intl.formatMessage(messages.searchGenres),
            onChange: value => {
              setFieldValue('data', value?.value.toString());
            }
          }, `movie-genre-select-${defaultDataValue}`);
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_GENRE */ ._.TMDB_TV_GENRE:
          dataInput = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_11___default()), {
            className: "react-select-container",
            classNamePrefix: "react-select",
            defaultValue: defaultDataValue?.[0],
            defaultOptions: true,
            cacheOptions: true,
            loadOptions: loadTvGenreOptions,
            placeholder: intl.formatMessage(messages.searchGenres),
            onChange: value => {
              setFieldValue('data', value?.value.toString());
            }
          }, `tv-genre-select-${defaultDataValue}}`);
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_STUDIO */ ._.TMDB_STUDIO:
          dataInput = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_11___default()), {
            className: "react-select-container",
            classNamePrefix: "react-select",
            defaultValue: defaultDataValue?.[0],
            defaultOptions: true,
            cacheOptions: true,
            loadOptions: loadCompanyOptions,
            placeholder: intl.formatMessage(messages.searchStudios),
            onChange: value => {
              setFieldValue('data', value?.value.toString());
            }
          }, `studio-select-${defaultDataValue}`);
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_STREAMING_SERVICES */ ._.TMDB_MOVIE_STREAMING_SERVICES:
          dataInput = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Selector__WEBPACK_IMPORTED_MODULE_4__/* .WatchProviderSelector */ .l5, {
            type: 'movie',
            region: slider?.data?.split(',')[0],
            activeProviders: slider?.data?.split(',')[1].split('|').map(v => Number(v)) ?? [],
            onChange: (region, providers) => {
              setFieldValue('data', `${region},${providers.join('|')}`);
            }
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_STREAMING_SERVICES */ ._.TMDB_TV_STREAMING_SERVICES:
          dataInput = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Selector__WEBPACK_IMPORTED_MODULE_4__/* .WatchProviderSelector */ .l5, {
            type: 'tv',
            region: slider?.data?.split(',')[0],
            activeProviders: slider?.data?.split(',')[1].split('|').map(v => Number(v)) ?? [],
            onChange: (region, providers) => {
              setFieldValue('data', `${region},${providers.join('|')}`);
            }
          });
          break;

        default:
          dataInput = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(formik__WEBPACK_IMPORTED_MODULE_8__.Field, {
            type: "text",
            name: "data",
            id: "data",
            placeholder: activeOption?.dataPlaceholderText
          });
      }

      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_8__.Form, {
        "data-testid": "create-discover-option-form",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
          className: "flex flex-col space-y-2 text-gray-100",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(formik__WEBPACK_IMPORTED_MODULE_8__.Field, {
            as: "select",
            id: "sliderType",
            name: "sliderType",
            children: options.map(option => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("option", {
              value: option.type,
              children: option.title
            }, `type-${option.type}`))
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(formik__WEBPACK_IMPORTED_MODULE_8__.Field, {
            type: "text",
            name: "title",
            id: "title",
            placeholder: activeOption?.titlePlaceholderText
          }), errors.title && touched.title && typeof errors.title === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
            className: "error",
            children: errors.title
          }), dataInput, errors.data && touched.data && typeof errors.data === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
            className: "error",
            children: errors.data
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
            className: "flex-1"
          }), resultCount === 0 ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            content: intl.formatMessage(messages.needresults),
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "primary",
                buttonSize: "sm",
                disabled: true,
                children: intl.formatMessage(messages.addSlider)
              })
            })
          }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
              buttonType: "primary",
              buttonSize: "sm",
              disabled: isSubmitting || !isValid,
              children: intl.formatMessage(slider ? messages.editSlider : messages.addSlider)
            })
          })]
        }), activeOption && values.title && values.data && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
          className: "relative py-4",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            sliderKey: `preview-${values.title}`,
            title: values.title,
            url: activeOption?.dataUrl.replace('$value', (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__/* .encodeURIExtraParams */ .p)(values.data)),
            extraParams: activeOption.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_MOVIE_STREAMING_SERVICES */ ._.TMDB_MOVIE_STREAMING_SERVICES || activeOption.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_6__/* .DiscoverSliderType.TMDB_TV_STREAMING_SERVICES */ ._.TMDB_TV_STREAMING_SERVICES ? activeOption.params?.replace('$regionValue', (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__/* .encodeURIExtraParams */ .p)(values?.data.split(',')[0])).replace('$providersValue', (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__/* .encodeURIExtraParams */ .p)(values?.data.split(',')[1])) : activeOption.params?.replace('$value', (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_5__/* .encodeURIExtraParams */ .p)(values.data)),
            onNewTitles: updateResultCount
          })
        })]
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CreateSlider);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 92430:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_SlideCheckbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99678);
/* harmony import */ var _app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(93399);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(63145);
/* harmony import */ var _app_components_CompanyTag__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(76765);
/* harmony import */ var _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(64468);
/* harmony import */ var _app_components_Discover_CreateSlider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86031);
/* harmony import */ var _app_components_GenreTag__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(69823);
/* harmony import */ var _app_components_KeywordTag__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(81988);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(75341);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_aria__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(85049);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_CompanyTag__WEBPACK_IMPORTED_MODULE_4__, _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__, _app_components_Discover_CreateSlider__WEBPACK_IMPORTED_MODULE_6__, _app_components_GenreTag__WEBPACK_IMPORTED_MODULE_7__, _app_components_KeywordTag__WEBPACK_IMPORTED_MODULE_8__, axios__WEBPACK_IMPORTED_MODULE_13__, react_aria__WEBPACK_IMPORTED_MODULE_15__]);
([_app_components_CompanyTag__WEBPACK_IMPORTED_MODULE_4__, _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__, _app_components_Discover_CreateSlider__WEBPACK_IMPORTED_MODULE_6__, _app_components_GenreTag__WEBPACK_IMPORTED_MODULE_7__, _app_components_KeywordTag__WEBPACK_IMPORTED_MODULE_8__, axios__WEBPACK_IMPORTED_MODULE_13__, react_aria__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_16__.defineMessages)({
  deletesuccess: {
    "id": "components.Discover.DiscoverSliderEdit.deletesuccess",
    "defaultMessage": 'Sucessfully deleted slider.'
  },
  deletefail: {
    "id": "components.Discover.DiscoverSliderEdit.deletefail",
    "defaultMessage": 'Failed to delete slider.'
  },
  remove: {
    "id": "components.Discover.DiscoverSliderEdit.remove",
    "defaultMessage": 'Remove'
  },
  enable: {
    "id": "components.Discover.DiscoverSliderEdit.enable",
    "defaultMessage": 'Toggle Visibility'
  }
});
const Position = {
  None: 'None',
  Above: 'Above',
  Below: 'Below'
};

const DiscoverSliderEdit = ({
  slider,
  children,
  onEnable,
  onDelete,
  onPositionUpdate,
  disableUpButton,
  disableDownButton
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_16__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_17__.useToasts)();
  const {
    0: isEditing,
    1: setIsEditing
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_14__.useRef)(null);
  const {
    0: hoverPosition,
    1: setHoverPosition
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(Position.None);
  const {
    dragProps,
    isDragging
  } = (0,react_aria__WEBPACK_IMPORTED_MODULE_15__.useDrag)({
    getItems() {
      return [{
        id: (slider.id ?? -1).toString(),
        title: slider.title ?? ''
      }];
    }

  });

  const deleteSlider = async () => {
    try {
      await axios__WEBPACK_IMPORTED_MODULE_13__["default"]["delete"](`/api/v1/settings/discover/${slider.id}`);
      addToast(intl.formatMessage(messages.deletesuccess), {
        appearance: 'success',
        autoDismiss: true
      });
      onDelete();
    } catch (e) {
      addToast(intl.formatMessage(messages.deletefail), {
        appearance: 'error',
        autoDismiss: true
      });
    }
  };

  const {
    dropProps
  } = (0,react_aria__WEBPACK_IMPORTED_MODULE_15__.useDrop)({
    ref,
    onDropMove: e => {
      if (ref.current) {
        const middlePoint = ref.current.offsetHeight / 2;

        if (e.y < middlePoint) {
          setHoverPosition(Position.Above);
        } else {
          setHoverPosition(Position.Below);
        }
      }
    },
    onDropExit: () => {
      setHoverPosition(Position.None);
    },
    onDrop: async e => {
      const items = await Promise.all(e.items.filter(item => item.kind === 'text' && item.types.has('id')).map(async item => {
        if (item.kind === 'text') {
          return item.getText('id');
        }
      }));

      if (items?.[0]) {
        const dropped = Number(items[0]);
        onPositionUpdate(dropped, hoverPosition, false);
      }
    }
  });

  const getSliderTitle = slider => {
    switch (slider.type) {
      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.RECENTLY_ADDED */ ._.RECENTLY_ADDED:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.recentlyAdded */ .o3.recentlyAdded);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.RECENT_REQUESTS */ ._.RECENT_REQUESTS:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.recentrequests */ .o3.recentrequests);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.PLEX_WATCHLIST */ ._.PLEX_WATCHLIST:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.plexwatchlist */ .o3.plexwatchlist);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TRENDING */ ._.TRENDING:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.trending */ .o3.trending);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.POPULAR_MOVIES */ ._.POPULAR_MOVIES:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.popularmovies */ .o3.popularmovies);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.MOVIE_GENRES */ ._.MOVIE_GENRES:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.moviegenres */ .o3.moviegenres);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.UPCOMING_MOVIES */ ._.UPCOMING_MOVIES:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.upcoming */ .o3.upcoming);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.STUDIOS */ ._.STUDIOS:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.studios */ .o3.studios);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.POPULAR_TV */ ._.POPULAR_TV:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.populartv */ .o3.populartv);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TV_GENRES */ ._.TV_GENRES:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tvgenres */ .o3.tvgenres);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.UPCOMING_TV */ ._.UPCOMING_TV:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.upcomingtv */ .o3.upcomingtv);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.NETWORKS */ ._.NETWORKS:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.networks */ .o3.networks);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_MOVIE_KEYWORD */ ._.TMDB_MOVIE_KEYWORD:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbmoviekeyword */ .o3.tmdbmoviekeyword);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_TV_KEYWORD */ ._.TMDB_TV_KEYWORD:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbtvkeyword */ .o3.tmdbtvkeyword);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_MOVIE_GENRE */ ._.TMDB_MOVIE_GENRE:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbmoviegenre */ .o3.tmdbmoviegenre);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_TV_GENRE */ ._.TMDB_TV_GENRE:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbtvgenre */ .o3.tmdbtvgenre);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_STUDIO */ ._.TMDB_STUDIO:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbstudio */ .o3.tmdbstudio);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_NETWORK */ ._.TMDB_NETWORK:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbnetwork */ .o3.tmdbnetwork);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_SEARCH */ ._.TMDB_SEARCH:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbsearch */ .o3.tmdbsearch);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_MOVIE_STREAMING_SERVICES */ ._.TMDB_MOVIE_STREAMING_SERVICES:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbmoviestreamingservices */ .o3.tmdbmoviestreamingservices);

      case _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_TV_STREAMING_SERVICES */ ._.TMDB_TV_STREAMING_SERVICES:
        return intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.tmdbtvstreamingservices */ .o3.tmdbtvstreamingservices);

      default:
        return 'Unknown Slider';
    }
  };

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", _objectSpread(_objectSpread(_objectSpread({
    "data-testid": "discover-slider-edit-mode",
    className: `relative mb-4 rounded-lg bg-gray-800 shadow-md ${isDragging ? 'opacity-0' : 'opacity-100'}`
  }, dragProps), dropProps), {}, {
    ref: ref,
    children: [hoverPosition === Position.Above && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: `absolute -top-3 left-0 w-full border-t-4 border-indigo-500`
    }), hoverPosition === Position.Below && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: `absolute -bottom-2 left-0 w-full border-t-4 border-indigo-500`
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      className: "flex w-full flex-col rounded-t-lg border-t border-l border-r border-gray-800 bg-gray-900 p-4 text-gray-400 md:flex-row md:items-center md:space-x-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: `${slider.data ? 'mb-4' : 'mb-0'} flex space-x-2 md:mb-0`,
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__.Bars3Icon, {
          className: "h-6 w-6"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "w-7/12 truncate md:w-full",
          children: getSliderTitle(slider)
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: `pointer-events-none ${slider.data ? 'mb-4' : ''} flex-1 md:mb-0`,
        children: [(slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_MOVIE_KEYWORD */ ._.TMDB_MOVIE_KEYWORD || slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_TV_KEYWORD */ ._.TMDB_TV_KEYWORD) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "flex space-x-2",
          children: slider.data?.split(',').map(keywordId => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_KeywordTag__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
            keywordId: Number(keywordId)
          }, `slider-keywords-${slider.id}-${keywordId}`))
        }), (slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_NETWORK */ ._.TMDB_NETWORK || slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_STUDIO */ ._.TMDB_STUDIO) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_CompanyTag__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          type: slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_STUDIO */ ._.TMDB_STUDIO ? 'studio' : 'network',
          companyId: Number(slider.data)
        }), (slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_TV_GENRE */ ._.TMDB_TV_GENRE || slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_MOVIE_GENRE */ ._.TMDB_MOVIE_GENRE) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_GenreTag__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
          type: slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_MOVIE_GENRE */ ._.TMDB_MOVIE_GENRE ? 'movie' : 'tv',
          genreId: Number(slider.data)
        }), slider.type === _server_constants_discover__WEBPACK_IMPORTED_MODULE_12__/* .DiscoverSliderType.TMDB_SEARCH */ ._.TMDB_SEARCH && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          iconSvg: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__.MagnifyingGlassIcon, {}),
          children: slider.data
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
        className: "flex items-center space-x-2",
        children: [!slider.isBuiltIn && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
          children: [!isEditing ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            buttonType: "warning",
            buttonSize: "sm",
            onClick: () => {
              setIsEditing(true);
            },
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__.PencilIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].edit */ .Z.edit)
            })]
          }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            buttonType: "default",
            buttonSize: "sm",
            onClick: () => {
              setIsEditing(false);
            },
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__.ArrowUturnLeftIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].cancel */ .Z.cancel)
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            "data-testid": "discover-slider-remove-button",
            buttonType: "danger",
            buttonSize: "sm",
            onClick: () => {
              deleteSlider();
            },
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__.XMarkIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
              children: intl.formatMessage(messages.remove)
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
          className: "absolute right-14 top-4 flex px-2 md:relative md:top-0 md:right-0",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("button", {
            className: 'hover:text-white disabled:text-gray-800',
            onClick: () => onPositionUpdate(Number(slider.id), Position.Above, true),
            disabled: disableUpButton,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__.ChevronUpIcon, {
              className: "h-7 w-7 md:h-6 md:w-6"
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("button", {
            className: 'hover:text-white disabled:text-gray-800',
            onClick: () => onPositionUpdate(Number(slider.id), Position.Below, true),
            disabled: disableDownButton,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__.ChevronDownIcon, {
              className: "h-7 w-7 md:h-6 md:w-6"
            })
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "absolute top-4 right-4 flex-1 text-right md:relative md:top-0 md:right-0",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            content: intl.formatMessage(messages.enable),
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_SlideCheckbox__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                onClick: () => {
                  onEnable();
                },
                checked: slider.enabled
              })
            })
          })
        })]
      })]
    }), isEditing ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: "p-4",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Discover_CreateSlider__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
        onCreate: () => {
          onDelete();
          setIsEditing(false);
        },
        slider: slider
      })
    }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: `-mt-6 p-4 ${!slider.enabled ? 'opacity-50' : ''}`,
      children: children
    })]
  }), `discover-slider-${slider.id}-editing`);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscoverSliderEdit);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1322:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64468);
/* harmony import */ var _app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67240);
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11360);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__, _app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_7__]);
([_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__, _app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.defineMessages)({
  moviegenres: {
    "id": "components.Discover.MovieGenreSlider.moviegenres",
    "defaultMessage": 'Movie Genres'
  }
});

const MovieGenreSlider = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.useIntl)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_7__["default"])(`/api/v1/discover/genreslider/movie`, {
    refreshInterval: 0,
    revalidateOnFocus: false
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("div", {
      className: "slider-header",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
        href: "/discover/movies/genres",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("a", {
          className: "slider-title",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("span", {
            children: intl.formatMessage(messages.moviegenres)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__.ArrowRightCircleIcon, {})]
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      sliderKey: "movie-genres",
      isLoading: !data && !error,
      isEmpty: false,
      items: (data ?? []).map((genre, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        name: genre.name,
        image: `https://image.tmdb.org/t/p/w1280_filter(duotone,${_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__/* .genreColorMap */ .$V[genre.id] ?? _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__/* .genreColorMap[0] */ .$V[0]})${genre.backdrops[4]}`,
        url: `/discover/movies?genre=${genre.id}`
      }, `genre-${genre.id}-${index}`)),
      placeholder: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"].Placeholder */ .Z.Placeholder, {}),
      emptyMessage: ""
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().memo(MovieGenreSlider));
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 46127:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_CompanyCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28416);
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11360);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_CompanyCard__WEBPACK_IMPORTED_MODULE_0__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_1__]);
([_app_components_CompanyCard__WEBPACK_IMPORTED_MODULE_0__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_1__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.defineMessages)({
  networks: {
    "id": "components.Discover.NetworkSlider.networks",
    "defaultMessage": 'Networks'
  }
});
const networks = [{
  name: 'Netflix',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/wwemzKWzjKYJFfCeiB57q3r4Bcm.png',
  url: '/discover/tv/network/213'
}, {
  name: 'Disney+',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/gJ8VX6JSu3ciXHuC2dDGAo2lvwM.png',
  url: '/discover/tv/network/2739'
}, {
  name: 'Prime Video',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/ifhbNuuVnlwYy5oXA5VIb2YR8AZ.png',
  url: '/discover/tv/network/1024'
}, {
  name: 'Apple TV+',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/4KAy34EHvRM25Ih8wb82AuGU7zJ.png',
  url: '/discover/tv/network/2552'
}, {
  name: 'Hulu',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/pqUTCleNUiTLAVlelGxUgWn1ELh.png',
  url: '/discover/tv/network/453'
}, {
  name: 'HBO',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/tuomPhY2UtuPTqqFnKMVHvSb724.png',
  url: '/discover/tv/network/49'
}, {
  name: 'Discovery+',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/1D1bS3Dyw4ScYnFWTlBOvJXC3nb.png',
  url: '/discover/tv/network/4353'
}, {
  name: 'ABC',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/ndAvF4JLsliGreX87jAc9GdjmJY.png',
  url: '/discover/tv/network/2'
}, {
  name: 'FOX',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/1DSpHrWyOORkL9N2QHX7Adt31mQ.png',
  url: '/discover/tv/network/19'
}, {
  name: 'Cinemax',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/6mSHSquNpfLgDdv6VnOOvC5Uz2h.png',
  url: '/discover/tv/network/359'
}, {
  name: 'AMC',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/pmvRmATOCaDykE6JrVoeYxlFHw3.png',
  url: '/discover/tv/network/174'
}, {
  name: 'Showtime',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/Allse9kbjiP6ExaQrnSpIhkurEi.png',
  url: '/discover/tv/network/67'
}, {
  name: 'Starz',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/8GJjw3HHsAJYwIWKIPBPfqMxlEa.png',
  url: '/discover/tv/network/318'
}, {
  name: 'The CW',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/ge9hzeaU7nMtQ4PjkFlc68dGAJ9.png',
  url: '/discover/tv/network/71'
}, {
  name: 'NBC',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/o3OedEP0f9mfZr33jz2BfXOUK5.png',
  url: '/discover/tv/network/6'
}, {
  name: 'CBS',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/nm8d7P7MJNiBLdgIzUK0gkuEA4r.png',
  url: '/discover/tv/network/16'
}, {
  name: 'Paramount+',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/fi83B1oztoS47xxcemFdPMhIzK.png',
  url: '/discover/tv/network/4330'
}, {
  name: 'BBC One',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/mVn7xESaTNmjBUyUtGNvDQd3CT1.png',
  url: '/discover/tv/network/4'
}, {
  name: 'Cartoon Network',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/c5OC6oVCg6QP4eqzW6XIq17CQjI.png',
  url: '/discover/tv/network/56'
}, {
  name: 'Adult Swim',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/9AKyspxVzywuaMuZ1Bvilu8sXly.png',
  url: '/discover/tv/network/80'
}, {
  name: 'Nickelodeon',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/ikZXxg6GnwpzqiZbRPhJGaZapqB.png',
  url: '/discover/tv/network/13'
}, {
  name: 'Peacock',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/gIAcGTjKKr0KOHL5s4O36roJ8p7.png',
  url: '/discover/tv/network/3353'
}];

const NetworkSlider = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.useIntl)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      className: "slider-header",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "slider-title",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("span", {
          children: intl.formatMessage(messages.networks)
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      sliderKey: "networks",
      isLoading: false,
      isEmpty: false,
      items: networks.map((network, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_CompanyCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        name: network.name,
        image: network.image,
        url: network.url
      }, `network-${index}`)),
      emptyMessage: ""
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NetworkSlider);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 97251:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11360);
/* harmony import */ var _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33056);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86799);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Slider__WEBPACK_IMPORTED_MODULE_0__, _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_6__]);
([_app_components_Slider__WEBPACK_IMPORTED_MODULE_0__, _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.defineMessages)({
  plexwatchlist: {
    "id": "components.Discover.PlexWatchlistSlider.plexwatchlist",
    "defaultMessage": 'Your Plex Watchlist'
  },
  emptywatchlist: {
    "id": "components.Discover.PlexWatchlistSlider.emptywatchlist",
    "defaultMessage": 'Media added to your <PlexWatchlistSupportLink>Plex Watchlist</PlexWatchlistSupportLink> will appear here.'
  }
});

const PlexWatchlistSlider = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.useIntl)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .useUser */ .aF)();
  const {
    data: watchlistItems,
    error: watchlistError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_6__["default"])(user?.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .UserType.PLEX */ .FW.PLEX ? '/api/v1/discover/watchlist' : null, {
    revalidateOnMount: true
  });

  if (user?.userType !== _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .UserType.PLEX */ .FW.PLEX || watchlistItems && watchlistItems.results.length === 0 && !user?.settings?.watchlistSyncMovies && !user?.settings?.watchlistSyncTv || watchlistError) {
    return null;
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
      className: "slider-header",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
        href: "/discover/watchlist",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("a", {
          className: "slider-title",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("span", {
            children: intl.formatMessage(messages.plexwatchlist)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__.ArrowRightCircleIcon, {})]
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      sliderKey: "watchlist",
      isLoading: !watchlistItems,
      isEmpty: !!watchlistItems && watchlistItems.results.length === 0,
      emptyMessage: intl.formatMessage(messages.emptywatchlist, {
        PlexWatchlistSupportLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("a", {
          href: "https://support.plex.tv/articles/universal-watchlist/",
          className: "text-white transition duration-300 hover:underline",
          target: "_blank",
          rel: "noreferrer",
          children: msg
        })
      }),
      items: watchlistItems?.results.map(item => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        id: item.tmdbId,
        tmdbId: item.tmdbId,
        type: item.mediaType
      }, `watchlist-slider-item-${item.ratingKey}`))
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PlexWatchlistSlider);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4619:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64468);
/* harmony import */ var _app_components_RequestCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31601);
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11360);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__, _app_components_RequestCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_6__]);
([_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__, _app_components_RequestCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const RecentRequestsSlider = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.useIntl)();
  const {
    data: requests,
    error: requestError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_6__["default"])('/api/v1/request?filter=all&take=10&sort=modified&skip=0', {
    revalidateOnMount: true
  });

  if (requests && requests.results.length === 0 && !requestError) {
    return null;
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
      className: "slider-header",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
        href: "/requests?filter=all",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("a", {
          className: "slider-title",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("span", {
            children: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__/* .sliderTitles.recentrequests */ .o3.recentrequests)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__.ArrowRightCircleIcon, {})]
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      sliderKey: "requests",
      isLoading: !requests,
      items: (requests?.results ?? []).map(request => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_app_components_RequestCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        request: request
      }, `request-slider-item-${request.id}`)),
      placeholder: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_app_components_RequestCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"].Placeholder */ .Z.Placeholder, {})
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RecentRequestsSlider);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 72193:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11360);
/* harmony import */ var _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33056);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86799);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Slider__WEBPACK_IMPORTED_MODULE_0__, _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_4__]);
([_app_components_Slider__WEBPACK_IMPORTED_MODULE_0__, _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_3__.defineMessages)({
  recentlyAdded: {
    "id": "components.Discover.RecentlyAddedSlider.recentlyAdded",
    "defaultMessage": 'Recently Added'
  }
});

const RecentlyAddedSlider = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_3__.useIntl)();
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .useUser */ .aF)();
  const {
    data: media,
    error: mediaError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_4__["default"])('/api/v1/media?filter=allavailable&take=20&sort=mediaAdded', {
    revalidateOnMount: true
  });

  if (media && !media.results.length && !mediaError || !hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.RECENT_VIEW */ .y3.RECENT_VIEW], {
    type: 'or'
  })) {
    return null;
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "slider-header",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "slider-title",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
          children: intl.formatMessage(messages.recentlyAdded)
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      sliderKey: "media",
      isLoading: !media,
      items: (media?.results ?? []).map(item => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        id: item.id,
        tmdbId: item.tmdbId,
        tvdbId: item.tvdbId,
        type: item.mediaType
      }, `media-slider-item-${item.id}`))
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RecentlyAddedSlider);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 27569:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_CompanyCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28416);
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11360);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_CompanyCard__WEBPACK_IMPORTED_MODULE_0__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_1__]);
([_app_components_CompanyCard__WEBPACK_IMPORTED_MODULE_0__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_1__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.defineMessages)({
  studios: {
    "id": "components.Discover.StudioSlider.studios",
    "defaultMessage": 'Studios'
  }
});
const studios = [{
  name: 'Disney',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/wdrCwmRnLFJhEoH8GSfymY85KHT.png',
  url: '/discover/movies/studio/2'
}, {
  name: '20th Century Studios',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/h0rjX5vjW5r8yEnUBStFarjcLT4.png',
  url: '/discover/movies/studio/127928'
}, {
  name: 'Sony Pictures',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/GagSvqWlyPdkFHMfQ3pNq6ix9P.png',
  url: '/discover/movies/studio/34'
}, {
  name: 'Warner Bros. Pictures',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/ky0xOc5OrhzkZ1N6KyUxacfQsCk.png',
  url: '/discover/movies/studio/174'
}, {
  name: 'Universal',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/8lvHyhjr8oUKOOy2dKXoALWKdp0.png',
  url: '/discover/movies/studio/33'
}, {
  name: 'Paramount',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/fycMZt242LVjagMByZOLUGbCvv3.png',
  url: '/discover/movies/studio/4'
}, {
  name: 'Pixar',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/1TjvGVDMYsj6JBxOAkUHpPEwLf7.png',
  url: '/discover/movies/studio/3'
}, {
  name: 'Dreamworks',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/kP7t6RwGz2AvvTkvnI1uteEwHet.png',
  url: '/discover/movies/studio/521'
}, {
  name: 'Marvel Studios',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/hUzeosd33nzE5MCNsZxCGEKTXaQ.png',
  url: '/discover/movies/studio/420'
}, {
  name: 'DC',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/2Tc1P3Ac8M479naPp1kYT3izLS5.png',
  url: '/discover/movies/studio/9993'
}, {
  name: 'A24',
  image: 'https://image.tmdb.org/t/p/w780_filter(duotone,ffffff,bababa)/1ZXsGaFPgrgS6ZZGS37AqD5uU12.png',
  url: '/discover/movies/studio/41077'
}];

const StudioSlider = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.useIntl)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      className: "slider-header",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "slider-title",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("span", {
          children: intl.formatMessage(messages.studios)
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      sliderKey: "studios",
      isLoading: false,
      isEmpty: false,
      items: studios.map((studio, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_CompanyCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        name: studio.name,
        image: studio.image,
        url: studio.url
      }, `studio-${index}`)),
      emptyMessage: ""
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StudioSlider);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 36808:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64468);
/* harmony import */ var _app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67240);
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11360);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__, _app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_7__]);
([_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__, _app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.defineMessages)({
  tvgenres: {
    "id": "components.Discover.TvGenreSlider.tvgenres",
    "defaultMessage": 'Series Genres'
  }
});

const TvGenreSlider = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.useIntl)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_7__["default"])(`/api/v1/discover/genreslider/tv`, {
    refreshInterval: 0,
    revalidateOnFocus: false
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("div", {
      className: "slider-header",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
        href: "/discover/tv/genres",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("a", {
          className: "slider-title",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("span", {
            children: intl.formatMessage(messages.tvgenres)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__.ArrowRightCircleIcon, {})]
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      sliderKey: "tv-genres",
      isLoading: !data && !error,
      isEmpty: false,
      items: (data ?? []).map((genre, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        name: genre.name,
        image: `https://image.tmdb.org/t/p/w1280_filter(duotone,${_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__/* .genreColorMap */ .$V[genre.id] ?? _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_0__/* .genreColorMap[0] */ .$V[0]})${genre.backdrops[4]}`,
        url: `/discover/tv?genre=${genre.id}`
      }, `genre-tv-${genre.id}-${index}`)),
      placeholder: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_app_components_GenreCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"].Placeholder */ .Z.Placeholder, {}),
      emptyMessage: ""
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().memo(TvGenreSlider));
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 58264:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_ConfirmButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10591);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63145);
/* harmony import */ var _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(64468);
/* harmony import */ var _app_components_Discover_CreateSlider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86031);
/* harmony import */ var _app_components_Discover_DiscoverSliderEdit__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(92430);
/* harmony import */ var _app_components_Discover_MovieGenreSlider__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(1322);
/* harmony import */ var _app_components_Discover_NetworkSlider__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(46127);
/* harmony import */ var _app_components_Discover_PlexWatchlistSlider__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(97251);
/* harmony import */ var _app_components_Discover_RecentlyAddedSlider__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(72193);
/* harmony import */ var _app_components_Discover_RecentRequestsSlider__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(4619);
/* harmony import */ var _app_components_Discover_StudioSlider__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(27569);
/* harmony import */ var _app_components_Discover_TvGenreSlider__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(36808);
/* harmony import */ var _app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(18512);
/* harmony import */ var _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(38242);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(80210);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(75341);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__, _app_components_Discover_CreateSlider__WEBPACK_IMPORTED_MODULE_6__, _app_components_Discover_DiscoverSliderEdit__WEBPACK_IMPORTED_MODULE_7__, _app_components_Discover_MovieGenreSlider__WEBPACK_IMPORTED_MODULE_8__, _app_components_Discover_NetworkSlider__WEBPACK_IMPORTED_MODULE_9__, _app_components_Discover_PlexWatchlistSlider__WEBPACK_IMPORTED_MODULE_10__, _app_components_Discover_RecentlyAddedSlider__WEBPACK_IMPORTED_MODULE_11__, _app_components_Discover_RecentRequestsSlider__WEBPACK_IMPORTED_MODULE_12__, _app_components_Discover_StudioSlider__WEBPACK_IMPORTED_MODULE_13__, _app_components_Discover_TvGenreSlider__WEBPACK_IMPORTED_MODULE_14__, _app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_16__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_17__, _headlessui_react__WEBPACK_IMPORTED_MODULE_19__, axios__WEBPACK_IMPORTED_MODULE_22__, swr__WEBPACK_IMPORTED_MODULE_26__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__, _app_components_Discover_CreateSlider__WEBPACK_IMPORTED_MODULE_6__, _app_components_Discover_DiscoverSliderEdit__WEBPACK_IMPORTED_MODULE_7__, _app_components_Discover_MovieGenreSlider__WEBPACK_IMPORTED_MODULE_8__, _app_components_Discover_NetworkSlider__WEBPACK_IMPORTED_MODULE_9__, _app_components_Discover_PlexWatchlistSlider__WEBPACK_IMPORTED_MODULE_10__, _app_components_Discover_RecentlyAddedSlider__WEBPACK_IMPORTED_MODULE_11__, _app_components_Discover_RecentRequestsSlider__WEBPACK_IMPORTED_MODULE_12__, _app_components_Discover_StudioSlider__WEBPACK_IMPORTED_MODULE_13__, _app_components_Discover_TvGenreSlider__WEBPACK_IMPORTED_MODULE_14__, _app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_16__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_17__, _headlessui_react__WEBPACK_IMPORTED_MODULE_19__, axios__WEBPACK_IMPORTED_MODULE_22__, swr__WEBPACK_IMPORTED_MODULE_26__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






























const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_24__.defineMessages)({
  discover: {
    "id": "components.Discover.discover",
    "defaultMessage": 'Discover'
  },
  emptywatchlist: {
    "id": "components.Discover.emptywatchlist",
    "defaultMessage": 'Media added to your <PlexWatchlistSupportLink>Plex Watchlist</PlexWatchlistSupportLink> will appear here.'
  },
  resettodefault: {
    "id": "components.Discover.resettodefault",
    "defaultMessage": 'Reset to Default'
  },
  resetwarning: {
    "id": "components.Discover.resetwarning",
    "defaultMessage": 'Reset all sliders to default. This will also delete any custom sliders!'
  },
  updatesuccess: {
    "id": "components.Discover.updatesuccess",
    "defaultMessage": 'Updated discover customization settings.'
  },
  updatefailed: {
    "id": "components.Discover.updatefailed",
    "defaultMessage": 'Something went wrong updating the discover customization settings.'
  },
  resetsuccess: {
    "id": "components.Discover.resetsuccess",
    "defaultMessage": 'Sucessfully reset discover customization settings.'
  },
  resetfailed: {
    "id": "components.Discover.resetfailed",
    "defaultMessage": 'Something went wrong resetting the discover customization settings.'
  },
  customizediscover: {
    "id": "components.Discover.customizediscover",
    "defaultMessage": 'Customize Discover'
  },
  stopediting: {
    "id": "components.Discover.stopediting",
    "defaultMessage": 'Stop Editing'
  },
  createnewslider: {
    "id": "components.Discover.createnewslider",
    "defaultMessage": 'Create New Slider'
  }
});

const Discover = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_24__.useIntl)();
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_17__/* .useUser */ .aF)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_25__.useToasts)();
  const {
    data: discoverData,
    error: discoverError,
    mutate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_26__["default"])('/api/v1/settings/discover');
  const {
    0: sliders,
    1: setSliders
  } = (0,react__WEBPACK_IMPORTED_MODULE_23__.useState)([]);
  const {
    0: isEditing,
    1: setIsEditing
  } = (0,react__WEBPACK_IMPORTED_MODULE_23__.useState)(false); // We need to sync the state here so that we can modify the changes locally without commiting
  // anything to the server until the user decides to save the changes

  (0,react__WEBPACK_IMPORTED_MODULE_23__.useEffect)(() => {
    if (discoverData && !isEditing) {
      setSliders(discoverData);
    }
  }, [discoverData, isEditing]);

  const hasChanged = () => !Object.is(discoverData, sliders);

  const updateSliders = async () => {
    try {
      await axios__WEBPACK_IMPORTED_MODULE_22__["default"].post('/api/v1/settings/discover', sliders);
      addToast(intl.formatMessage(messages.updatesuccess), {
        appearance: 'success',
        autoDismiss: true
      });
      setIsEditing(false);
      mutate();
    } catch (e) {
      addToast(intl.formatMessage(messages.updatefailed), {
        appearance: 'error',
        autoDismiss: true
      });
    }
  };

  const resetSliders = async () => {
    try {
      await axios__WEBPACK_IMPORTED_MODULE_22__["default"].get('/api/v1/settings/discover/reset');
      addToast(intl.formatMessage(messages.resetsuccess), {
        appearance: 'success',
        autoDismiss: true
      });
      setIsEditing(false);
      mutate();
    } catch (e) {
      addToast(intl.formatMessage(messages.resetfailed), {
        appearance: 'error',
        autoDismiss: true
      });
    }
  };

  const now = new Date();
  const offset = now.getTimezoneOffset();
  const upcomingDate = new Date(now.getTime() - offset * 60 * 1000).toISOString().split('T')[0];

  if (!discoverData && !discoverError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      title: intl.formatMessage(messages.discover)
    }), hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_17__/* .Permission.ADMIN */ .y3.ADMIN) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.Fragment, {
      children: [isEditing && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
        className: "my-6 rounded-lg bg-gray-800",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
          className: "flex items-center space-x-2 rounded-t-lg border-t border-l border-r border-gray-800 bg-gray-900 p-4 text-lg font-semibold text-gray-400",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_20__.PlusIcon, {
            className: "w-6"
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
            "data-testid": "create-slider-header",
            children: intl.formatMessage(messages.createnewslider)
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
          className: "p-4",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_CreateSlider__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
            onCreate: async () => {
              const newSliders = await mutate();

              if (newSliders) {
                setSliders(newSliders);
              }
            }
          })
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_19__.Transition, {
        show: !isEditing,
        enter: "transition-opacity duration-300",
        enterFrom: "opacity-0",
        enterTo: "opacity-100",
        leave: "transition-opacity duration-300",
        leaveFrom: "opacity-100",
        leaveTo: "opacity-0",
        className: "absolute-bottom-shift fixed right-6 z-50 flex items-center sm:bottom-8",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("button", {
          onClick: () => setIsEditing(true),
          "data-testid": "discover-start-editing",
          className: "h-12 w-12 rounded-full border-2 border-gray-600 bg-gray-700 bg-opacity-90 p-3 text-gray-400 shadow transition-all hover:bg-opacity-100",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_20__.PencilIcon, {
            className: "h-full w-full"
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_19__.Transition, {
        show: isEditing,
        enter: "transition duration-300",
        enterFrom: "opacity-0 translate-y-6",
        enterTo: "opacity-100 translate-y-0",
        leave: "transition duration-300",
        leaveFrom: "opacity-100 translate-y-0",
        leaveTo: "opacity-0 translate-y-6",
        className: "safe-shift-edit-menu fixed right-0 left-0 z-50 flex flex-col items-center justify-end space-x-0 space-y-2 border-t border-gray-700 bg-gray-800 bg-opacity-80 p-4 backdrop-blur sm:bottom-0 sm:flex-row sm:space-y-0 sm:space-x-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          buttonType: "default",
          onClick: () => setIsEditing(false),
          className: "w-full sm:w-auto",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_20__.ArrowUturnLeftIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
            children: intl.formatMessage(messages.stopediting)
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          content: intl.formatMessage(messages.resetwarning),
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_ConfirmButton__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            onClick: () => resetSliders(),
            confirmText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_18__/* ["default"].areyousure */ .Z.areyousure),
            className: "w-full sm:w-auto",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_20__.ArrowPathIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
              children: intl.formatMessage(messages.resettodefault)
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          buttonType: "primary",
          type: "submit",
          disabled: !hasChanged(),
          onClick: () => updateSliders(),
          "data-testid": "discover-customize-submit",
          className: "w-full sm:w-auto",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_20__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
            children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_18__/* ["default"].save */ .Z.save)
          })]
        })]
      })]
    }), (isEditing ? sliders : discoverData)?.map((slider, index) => {
      let sliderComponent;

      switch (slider.type) {
        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.RECENTLY_ADDED */ ._.RECENTLY_ADDED:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_RecentlyAddedSlider__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {});
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.RECENT_REQUESTS */ ._.RECENT_REQUESTS:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_RecentRequestsSlider__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {});
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.PLEX_WATCHLIST */ ._.PLEX_WATCHLIST:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_PlexWatchlistSlider__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {});
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TRENDING */ ._.TRENDING:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: "trending",
            title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.trending */ .o3.trending),
            url: "/api/v1/discover/trending",
            linkUrl: "/discover/trending"
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.POPULAR_MOVIES */ ._.POPULAR_MOVIES:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: "popular-movies",
            title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.popularmovies */ .o3.popularmovies),
            url: "/api/v1/discover/movies",
            linkUrl: "/discover/movies"
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.MOVIE_GENRES */ ._.MOVIE_GENRES:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_MovieGenreSlider__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {});
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.UPCOMING_MOVIES */ ._.UPCOMING_MOVIES:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: "upcoming",
            title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.upcoming */ .o3.upcoming),
            linkUrl: `/discover/movies?primaryReleaseDateGte=${upcomingDate}`,
            url: "/api/v1/discover/movies",
            extraParams: `primaryReleaseDateGte=${upcomingDate}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.STUDIOS */ ._.STUDIOS:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_StudioSlider__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {});
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.POPULAR_TV */ ._.POPULAR_TV:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: "popular-tv",
            title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.populartv */ .o3.populartv),
            url: "/api/v1/discover/tv",
            linkUrl: "/discover/tv"
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TV_GENRES */ ._.TV_GENRES:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_TvGenreSlider__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {});
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.UPCOMING_TV */ ._.UPCOMING_TV:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: "upcoming-tv",
            title: intl.formatMessage(_app_components_Discover_constants__WEBPACK_IMPORTED_MODULE_5__/* .sliderTitles.upcomingtv */ .o3.upcomingtv),
            linkUrl: `/discover/tv?firstAirDateGte=${upcomingDate}`,
            url: "/api/v1/discover/tv",
            extraParams: `firstAirDateGte=${upcomingDate}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.NETWORKS */ ._.NETWORKS:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_NetworkSlider__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {});
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_MOVIE_KEYWORD */ ._.TMDB_MOVIE_KEYWORD:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: "/api/v1/discover/movies",
            extraParams: slider.data ? `keywords=${(0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_16__/* .encodeURIExtraParams */ .p)(slider.data)}` : '',
            linkUrl: `/discover/movies?keywords=${slider.data}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_TV_KEYWORD */ ._.TMDB_TV_KEYWORD:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: "/api/v1/discover/tv",
            extraParams: slider.data ? `keywords=${(0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_16__/* .encodeURIExtraParams */ .p)(slider.data)}` : '',
            linkUrl: `/discover/tv?keywords=${slider.data}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_MOVIE_GENRE */ ._.TMDB_MOVIE_GENRE:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: `/api/v1/discover/movies`,
            extraParams: `genre=${slider.data}`,
            linkUrl: `/discover/movies?genre=${slider.data}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_TV_GENRE */ ._.TMDB_TV_GENRE:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: `/api/v1/discover/tv`,
            extraParams: `genre=${slider.data}`,
            linkUrl: `/discover/tv?genre=${slider.data}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_STUDIO */ ._.TMDB_STUDIO:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: `/api/v1/discover/movies/studio/${slider.data}`,
            linkUrl: `/discover/movies/studio/${slider.data}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_NETWORK */ ._.TMDB_NETWORK:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: `/api/v1/discover/tv/network/${slider.data}`,
            linkUrl: `/discover/tv/network/${slider.data}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_SEARCH */ ._.TMDB_SEARCH:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: "/api/v1/search",
            extraParams: `query=${slider.data}`,
            linkUrl: `/search?query=${slider.data}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_MOVIE_STREAMING_SERVICES */ ._.TMDB_MOVIE_STREAMING_SERVICES:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: "/api/v1/discover/movies",
            extraParams: `watchRegion=${slider.data?.split(',')[0]}&watchProviders=${slider.data?.split(',')[1]}`,
            linkUrl: `/discover/movies?watchRegion=${slider.data?.split(',')[0]}&watchProviders=${slider.data?.split(',')[1]}`
          });
          break;

        case _server_constants_discover__WEBPACK_IMPORTED_MODULE_21__/* .DiscoverSliderType.TMDB_TV_STREAMING_SERVICES */ ._.TMDB_TV_STREAMING_SERVICES:
          sliderComponent = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_MediaSlider__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
            sliderKey: `custom-slider-${slider.id}`,
            title: slider.title ?? '',
            url: "/api/v1/discover/tv",
            extraParams: `watchRegion=${slider.data?.split(',')[0]}&watchProviders=${slider.data?.split(',')[1]}`,
            linkUrl: `/discover/tv?watchRegion=${slider.data?.split(',')[0]}&watchProviders=${slider.data?.split(',')[1]}`
          });
          break;
      }

      if (isEditing) {
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Discover_DiscoverSliderEdit__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
          slider: slider,
          onDelete: async () => {
            const newSliders = await mutate();

            if (newSliders) {
              setSliders(newSliders);
            }
          },
          onEnable: () => {
            const tempSliders = sliders.slice();
            tempSliders[index].enabled = !tempSliders[index].enabled;
            setSliders(tempSliders);
          },
          onPositionUpdate: (updatedItemId, position, hasClickedArrows) => {
            const originalPosition = sliders.findIndex(item => item.id === updatedItemId);
            const originalItem = sliders[originalPosition];
            const tempSliders = sliders.slice();
            tempSliders.splice(originalPosition, 1);
            hasClickedArrows ? tempSliders.splice(position === 'Above' ? index - 1 : index + 1, 0, originalItem) : tempSliders.splice(position === 'Above' && index > originalPosition ? Math.max(index - 1, 0) : index, 0, originalItem);
            setSliders(tempSliders);
          },
          disableUpButton: index === 0,
          disableDownButton: index === sliders.length - 1,
          children: sliderComponent
        }, `discover-slider-${slider.id}-edit`);
      }

      if (!slider.enabled) {
        return null;
      }

      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        children: sliderComponent
      }, `discover-slider-${slider.id}`);
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Discover);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 67240:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7292);
/* harmony import */ var _app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(66234);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const GenreCard = ({
  image,
  url,
  name,
  canExpand = false
}) => {
  const {
    0: isHovered,
    1: setHovered
  } = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx((next_link__WEBPACK_IMPORTED_MODULE_1___default()), {
    href: url,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("a", {
      className: `relative flex h-32 items-center justify-center sm:h-36 ${canExpand ? 'w-full' : 'w-56 sm:w-72'} transform-gpu cursor-pointer p-8 shadow ring-1 transition duration-300 ease-in-out ${isHovered ? 'scale-105 bg-gray-700 bg-opacity-100 ring-gray-500' : 'scale-100 bg-gray-800 bg-opacity-80 ring-gray-700'} overflow-hidden rounded-xl bg-cover bg-center`,
      onMouseEnter: () => {
        setHovered(true);
      },
      onMouseLeave: () => setHovered(false),
      onKeyDown: e => {
        if (e.key === 'Enter') {
          setHovered(true);
        }
      },
      role: "link",
      tabIndex: 0,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        src: image,
        alt: "",
        layout: "fill",
        objectFit: "cover"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: `absolute inset-0 z-10 h-full w-full bg-gray-800 transition duration-300 ${isHovered ? 'bg-opacity-10' : 'bg-opacity-30'}`
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "relative z-20 w-full truncate whitespace-normal text-center text-2xl font-bold text-white sm:text-3xl",
        children: name
      })]
    })
  });
};

const GenreCardPlaceholder = () => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
    className: `relative h-32 w-56 animate-pulse rounded-xl bg-gray-700 sm:h-40 sm:w-72`
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_4__/* .withProperties */ .W)(GenreCard, {
  Placeholder: GenreCardPlaceholder
}));
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 69823:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43907);
/* harmony import */ var _app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93399);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_3__]);
swr__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const GenreTag = ({
  genreId,
  type
}) => {
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_3__["default"])(`/api/v1/genres/${type}`);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        className: "h-4 w-4"
      })
    });
  }

  const genre = data?.find(genre => genre.id === genreId);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    iconSvg: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__.RectangleStackIcon, {}),
    children: genre?.name
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GenreTag);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 81988:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43907);
/* harmony import */ var _app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93399);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_2__]);
swr__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];





const KeywordTag = ({
  keywordId
}) => {
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_2__["default"])(`/api/v1/keyword/${keywordId}`);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        className: "h-4 w-4"
      })
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_Tag__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    children: data?.name
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (KeywordTag);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 31627:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DC": () => (/* binding */ GenreSelector),
/* harmony export */   "l5": () => (/* binding */ WatchProviderSelector),
/* harmony export */   "oW": () => (/* binding */ KeywordSelector),
/* harmony export */   "tz": () => (/* binding */ CompanySelector)
/* harmony export */ });
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7292);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63145);
/* harmony import */ var _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(72134);
/* harmony import */ var _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38242);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1388);
/* harmony import */ var _heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(59476);
/* harmony import */ var _heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(99648);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_select_async__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(23618);
/* harmony import */ var react_select_async__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_select_async__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__, _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__, axios__WEBPACK_IMPORTED_MODULE_8__, swr__WEBPACK_IMPORTED_MODULE_13__]);
([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__, _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__, axios__WEBPACK_IMPORTED_MODULE_8__, swr__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);

















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.defineMessages)({
  searchKeywords: {
    "id": "components.Selector.searchKeywords",
    "defaultMessage": 'Search keywords…'
  },
  searchGenres: {
    "id": "components.Selector.searchGenres",
    "defaultMessage": 'Select genres…'
  },
  searchStudios: {
    "id": "components.Selector.searchStudios",
    "defaultMessage": 'Search studios…'
  },
  starttyping: {
    "id": "components.Selector.starttyping",
    "defaultMessage": 'Starting typing to search.'
  },
  nooptions: {
    "id": "components.Selector.nooptions",
    "defaultMessage": 'No results.'
  },
  showmore: {
    "id": "components.Selector.showmore",
    "defaultMessage": 'Show More'
  },
  showless: {
    "id": "components.Selector.showless",
    "defaultMessage": 'Show Less'
  }
});
const CompanySelector = ({
  defaultValue,
  isMulti,
  onChange
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    0: defaultDataValue,
    1: setDefaultDataValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    const loadDefaultCompany = async () => {
      if (!defaultValue) {
        return;
      }

      const response = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get(`/api/v1/studio/${defaultValue}`);
      const studio = response.data;
      setDefaultDataValue([{
        label: studio.name ?? '',
        value: studio.id ?? 0
      }]);
    };

    loadDefaultCompany();
  }, [defaultValue]);

  const loadCompanyOptions = async inputValue => {
    if (inputValue === '') {
      return [];
    }

    const results = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get('/api/v1/search/company', {
      params: {
        query: (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__/* .encodeURIExtraParams */ .p)(inputValue)
      }
    });
    return results.data.results.map(result => ({
      label: result.name,
      value: result.id
    }));
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_12___default()), {
    className: "react-select-container",
    classNamePrefix: "react-select",
    isMulti: isMulti,
    defaultValue: defaultDataValue,
    defaultOptions: true,
    cacheOptions: true,
    isClearable: true,
    noOptionsMessage: ({
      inputValue
    }) => inputValue === '' ? intl.formatMessage(messages.starttyping) : intl.formatMessage(messages.nooptions),
    loadOptions: loadCompanyOptions,
    placeholder: intl.formatMessage(messages.searchStudios),
    onChange: value => {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      onChange(value);
    }
  }, `company-selector-${defaultDataValue}`);
};
const GenreSelector = ({
  isMulti,
  defaultValue,
  onChange,
  type
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    0: defaultDataValue,
    1: setDefaultDataValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    const loadDefaultGenre = async () => {
      if (!defaultValue) {
        return;
      }

      const genres = defaultValue.split(',');
      const response = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get(`/api/v1/genres/${type}`);
      const genreData = genres.filter(genre => response.data.find(gd => gd.id === Number(genre))).map(g => response.data.find(gd => gd.id === Number(g))).map(g => ({
        label: g?.name ?? '',
        value: g?.id ?? 0
      }));
      setDefaultDataValue(genreData);
    };

    loadDefaultGenre();
  }, [defaultValue, type]);

  const loadGenreOptions = async inputValue => {
    const results = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get(`/api/v1/discover/genreslider/${type}`);
    return results.data.map(result => ({
      label: result.name,
      value: result.id
    })).filter(({
      label
    }) => label.toLowerCase().includes(inputValue.toLowerCase()));
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_12___default()), {
    className: "react-select-container",
    classNamePrefix: "react-select",
    defaultValue: isMulti ? defaultDataValue : defaultDataValue?.[0],
    defaultOptions: true,
    cacheOptions: true,
    isMulti: isMulti,
    loadOptions: loadGenreOptions,
    placeholder: intl.formatMessage(messages.searchGenres),
    onChange: value => {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      onChange(value);
    }
  }, `genre-select-${defaultDataValue}`);
};
const KeywordSelector = ({
  isMulti,
  defaultValue,
  onChange
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    0: defaultDataValue,
    1: setDefaultDataValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    const loadDefaultKeywords = async () => {
      if (!defaultValue) {
        return;
      }

      const keywords = await Promise.all(defaultValue.split(',').map(async keywordId => {
        const keyword = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get(`/api/v1/keyword/${keywordId}`);
        return keyword.data;
      }));
      setDefaultDataValue(keywords.map(keyword => ({
        label: keyword.name,
        value: keyword.id
      })));
    };

    loadDefaultKeywords();
  }, [defaultValue]);

  const loadKeywordOptions = async inputValue => {
    const results = await axios__WEBPACK_IMPORTED_MODULE_8__["default"].get('/api/v1/search/keyword', {
      params: {
        query: (0,_app_hooks_useDiscover__WEBPACK_IMPORTED_MODULE_4__/* .encodeURIExtraParams */ .p)(inputValue)
      }
    });
    return results.data.results.map(result => ({
      label: result.name,
      value: result.id
    }));
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx((react_select_async__WEBPACK_IMPORTED_MODULE_12___default()), {
    inputId: "data",
    isMulti: isMulti,
    className: "react-select-container",
    classNamePrefix: "react-select",
    noOptionsMessage: ({
      inputValue
    }) => inputValue === '' ? intl.formatMessage(messages.starttyping) : intl.formatMessage(messages.nooptions),
    defaultValue: defaultDataValue,
    loadOptions: loadKeywordOptions,
    placeholder: intl.formatMessage(messages.searchKeywords),
    onChange: value => {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      onChange(value);
    }
  }, `keyword-select-${defaultDataValue}`);
};
const WatchProviderSelector = ({
  type,
  onChange,
  region,
  activeProviders
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    currentSettings
  } = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)();
  const {
    0: showMore,
    1: setShowMore
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const {
    0: watchRegion,
    1: setWatchRegion
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(region ? region : currentSettings.region ? currentSettings.region : 'US');
  const {
    0: activeProvider,
    1: setActiveProvider
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(activeProviders ?? []);
  const {
    data,
    isLoading
  } = (0,swr__WEBPACK_IMPORTED_MODULE_13__["default"])(`/api/v1/watchproviders/${type === 'movie' ? 'movies' : 'tv'}?watchRegion=${watchRegion}`);
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    onChange(watchRegion, activeProvider); // removed onChange as a dependency as we only need to call it when the value(s) change
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [activeProvider, watchRegion]);
  const orderedData = (0,react__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => {
    if (!data) {
      return [];
    }

    return (0,lodash__WEBPACK_IMPORTED_MODULE_9__.orderBy)(data, ['display_priority'], ['asc']);
  }, [data]);

  const toggleProvider = id => {
    if (activeProvider.includes(id)) {
      setActiveProvider(activeProvider.filter(p => p !== id));
    } else {
      setActiveProvider([...activeProvider, id]);
    }
  };

  const initialProviders = orderedData.slice(0, 24);
  const otherProviders = orderedData.slice(24);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      value: watchRegion,
      name: "watchRegion",
      onChange: (_name, value) => {
        if (value !== watchRegion) {
          setActiveProvider([]);
        }

        setWatchRegion(value);
      },
      disableAll: true,
      watchProviders: true
    }), isLoading ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* .SmallLoadingSpinner */ .e, {}) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
      className: "grid",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
        className: "provider-icons grid gap-2",
        children: initialProviders.map(provider => {
          const isActive = activeProvider.includes(provider.id);
          return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
            content: provider.name,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
              className: `provider-container relative w-full cursor-pointer rounded-lg p-2 ring-1 ${isActive ? 'bg-gray-600 ring-indigo-500 hover:bg-gray-500' : 'bg-gray-700 ring-gray-500 hover:bg-gray-600'}`,
              onClick: () => toggleProvider(provider.id),
              onKeyDown: e => {
                if (e.key === 'Enter') {
                  toggleProvider(provider.id);
                }
              },
              role: "button",
              tabIndex: 0,
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                src: `https://image.tmdb.org/t/p/original${provider.logoPath}`,
                alt: "",
                layout: "responsive",
                width: "100%",
                height: "100%",
                className: "rounded-lg"
              }), isActive && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
                className: "pointer-events-none absolute -top-1 -left-1 flex items-center justify-center text-indigo-100 opacity-90",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__.CheckCircleIcon, {
                  className: "h-6 w-6"
                })
              })]
            })
          }, `prodiver-${provider.id}`);
        })
      }), showMore && otherProviders.length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
        className: "provider-icons relative top-2 grid gap-2",
        children: otherProviders.map(provider => {
          const isActive = activeProvider.includes(provider.id);
          return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
            content: provider.name,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("div", {
              className: `provider-container relative w-full cursor-pointer rounded-lg p-2 ring-1 transition ${isActive ? 'bg-gray-600 ring-indigo-500 hover:bg-gray-500' : 'bg-gray-700 ring-gray-500 hover:bg-gray-600'}`,
              onClick: () => toggleProvider(provider.id),
              onKeyDown: e => {
                if (e.key === 'Enter') {
                  toggleProvider(provider.id);
                }
              },
              role: "button",
              tabIndex: 0,
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                src: `https://image.tmdb.org/t/p/original${provider.logoPath}`,
                alt: "",
                layout: "responsive",
                width: "100%",
                height: "100%",
                className: "rounded-lg"
              }), isActive && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
                className: "pointer-events-none absolute -top-1 -left-1 flex items-center justify-center text-indigo-100 opacity-90",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__.CheckCircleIcon, {
                  className: "h-6 w-6"
                })
              })]
            })
          }, `prodiver-${provider.id}`);
        })
      }), otherProviders.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("button", {
        className: "relative top-4 flex items-center justify-center space-x-2 text-sm text-gray-400 transition hover:text-gray-200",
        type: "button",
        onClick: () => setShowMore(!showMore),
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
          className: "h-0.5 flex-1 bg-gray-600"
        }), showMore ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__.ArrowUpIcon, {
            className: "h-4 w-4"
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
            children: intl.formatMessage(messages.showless)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__.ArrowUpIcon, {
            className: "h-4 w-4"
          })]
        }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__.ArrowDownIcon, {
            className: "h-4 w-4"
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("span", {
            children: intl.formatMessage(messages.showmore)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_6__.ArrowDownIcon, {
            className: "h-4 w-4"
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
          className: "h-0.5 flex-1 bg-gray-600"
        })]
      })]
    })]
  });
};
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 73639:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Discover__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58264);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Discover__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_Discover__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const Index = () => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_app_components_Discover__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {});
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Index);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 59476:
/***/ ((module) => {

module.exports = require("@heroicons/react/20/solid");

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 2296:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 46517:
/***/ ((module) => {

module.exports = require("lodash");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 66405:
/***/ ((module) => {

module.exports = require("react-dom");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 30616:
/***/ ((module) => {

module.exports = require("react-popper-tooltip");

/***/ }),

/***/ 61929:
/***/ ((module) => {

module.exports = require("react-select");

/***/ }),

/***/ 23618:
/***/ ((module) => {

module.exports = require("react-select/async");

/***/ }),

/***/ 4417:
/***/ ((module) => {

module.exports = require("react-spring");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 75609:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 31856:
/***/ ((module) => {

module.exports = import("country-flag-icons");;

/***/ }),

/***/ 85049:
/***/ ((module) => {

module.exports = import("react-aria");;

/***/ }),

/***/ 44009:
/***/ ((module) => {

module.exports = import("react-intersection-observer");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ }),

/***/ 91448:
/***/ ((module) => {

module.exports = import("swr/infinite");;

/***/ }),

/***/ 9926:
/***/ ((module) => {

module.exports = import("zod");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,1388,61439,19998,80210,86799,13555,99073,7292,22796,72964,24115,42040,71473,61276,68229,33056,38242,63145,68402,72134,10591,11360,64468,31601,55535], () => (__webpack_exec__(73639)));
module.exports = __webpack_exports__;

})();