"use strict";
(() => {
var exports = {};
exports.id = 74765;
exports.ids = [74765];
exports.modules = {

/***/ 59147:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DD": () => (/* binding */ MediaType),
/* harmony export */   "Jp": () => (/* binding */ MediaStatus),
/* harmony export */   "pi": () => (/* binding */ MediaRequestStatus)
/* harmony export */ });
let MediaRequestStatus;

(function (MediaRequestStatus) {
  MediaRequestStatus[MediaRequestStatus["PENDING"] = 1] = "PENDING";
  MediaRequestStatus[MediaRequestStatus["APPROVED"] = 2] = "APPROVED";
  MediaRequestStatus[MediaRequestStatus["DECLINED"] = 3] = "DECLINED";
  MediaRequestStatus[MediaRequestStatus["FAILED"] = 4] = "FAILED";
})(MediaRequestStatus || (MediaRequestStatus = {}));

let MediaType;

(function (MediaType) {
  MediaType["MOVIE"] = "movie";
  MediaType["TV"] = "tv";
})(MediaType || (MediaType = {}));

let MediaStatus;

(function (MediaStatus) {
  MediaStatus[MediaStatus["UNKNOWN"] = 1] = "UNKNOWN";
  MediaStatus[MediaStatus["PENDING"] = 2] = "PENDING";
  MediaStatus[MediaStatus["PROCESSING"] = 3] = "PROCESSING";
  MediaStatus[MediaStatus["PARTIALLY_AVAILABLE"] = 4] = "PARTIALLY_AVAILABLE";
  MediaStatus[MediaStatus["AVAILABLE"] = 5] = "AVAILABLE";
})(MediaStatus || (MediaStatus = {}));

/***/ }),

/***/ 76631:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);



const Header = ({
  children,
  extraMargin = 0,
  subtext
}) => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    className: "mt-8 md:flex md:items-center md:justify-between",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: `min-w-0 flex-1 mx-${extraMargin}`,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
        className: "mb-4 truncate text-2xl font-bold leading-7 text-gray-100 sm:overflow-visible sm:text-4xl sm:leading-9 md:mb-0",
        "data-testid": "page-header",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
          className: "text-overseerr",
          children: children
        })
      }), subtext && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "mt-2 text-gray-400",
        children: subtext
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 48082:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7292);
/* harmony import */ var _app_components_IssueModal_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14422);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _server_constants_issue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(16981);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59147);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_intersection_observer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(44009);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_10__, swr__WEBPACK_IMPORTED_MODULE_12__]);
([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_10__, swr__WEBPACK_IMPORTED_MODULE_12__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.defineMessages)({
  openeduserdate: {
    "id": "components.IssueList.IssueItem.openeduserdate",
    "defaultMessage": '{date} by {user}'
  },
  seasons: {
    "id": "components.IssueList.IssueItem.seasons",
    "defaultMessage": '{seasonCount, plural, one {Season} other {Seasons}}'
  },
  episodes: {
    "id": "components.IssueList.IssueItem.episodes",
    "defaultMessage": '{episodeCount, plural, one {Episode} other {Episodes}}'
  },
  problemepisode: {
    "id": "components.IssueList.IssueItem.problemepisode",
    "defaultMessage": 'Affected Episode'
  },
  issuetype: {
    "id": "components.IssueList.IssueItem.issuetype",
    "defaultMessage": 'Type'
  },
  issuestatus: {
    "id": "components.IssueList.IssueItem.issuestatus",
    "defaultMessage": 'Status'
  },
  opened: {
    "id": "components.IssueList.IssueItem.opened",
    "defaultMessage": 'Opened'
  },
  viewissue: {
    "id": "components.IssueList.IssueItem.viewissue",
    "defaultMessage": 'View Issue'
  },
  unknownissuetype: {
    "id": "components.IssueList.IssueItem.unknownissuetype",
    "defaultMessage": 'Unknown'
  }
});

const isMovie = movie => {
  return movie.title !== undefined;
};

const IssueItem = ({
  issue
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .useUser */ .aF)();
  const {
    ref,
    inView
  } = (0,react_intersection_observer__WEBPACK_IMPORTED_MODULE_10__.useInView)({
    triggerOnce: true
  });
  const url = issue.media.mediaType === 'movie' ? `/api/v1/movie/${issue.media.tmdbId}` : `/api/v1/tv/${issue.media.tmdbId}`;
  const {
    data: title,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_12__["default"])(inView ? url : null);

  if (!title && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
      className: "h-64 w-full animate-pulse rounded-xl bg-gray-800 xl:h-28",
      ref: ref
    });
  }

  if (!title) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
      children: "uh oh"
    });
  }

  const issueOption = _app_components_IssueModal_constants__WEBPACK_IMPORTED_MODULE_3__/* .issueOptions.find */ .m.find(opt => opt.issueType === issue?.issueType);
  const problemSeasonEpisodeLine = [];

  if (!isMovie(title) && issue) {
    problemSeasonEpisodeLine.push( /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
        className: "card-field-name",
        children: intl.formatMessage(messages.seasons, {
          seasonCount: issue.problemSeason ? 1 : 0
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
        className: "mr-4 uppercase",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          children: issue.problemSeason > 0 ? issue.problemSeason : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].all */ .Z.all)
        })
      })]
    }));

    if (issue.problemSeason > 0) {
      problemSeasonEpisodeLine.push( /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
          className: "card-field-name",
          children: intl.formatMessage(messages.episodes, {
            episodeCount: issue.problemEpisode ? 1 : 0
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
          className: "uppercase",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            children: issue.problemEpisode > 0 ? issue.problemEpisode : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].all */ .Z.all)
          })
        })]
      }));
    }
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
    className: "relative flex w-full flex-col justify-between overflow-hidden rounded-xl bg-gray-800 py-4 text-gray-400 shadow-md ring-1 ring-gray-700 xl:h-28 xl:flex-row",
    children: [title.backdropPath && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "absolute inset-0 z-0 w-full bg-cover bg-center xl:w-2/3",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        src: `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${title.backdropPath}`,
        alt: "",
        layout: "fill",
        objectFit: "cover"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
        className: "absolute inset-0",
        style: {
          backgroundImage: 'linear-gradient(90deg, rgba(31, 41, 55, 0.47) 0%, rgba(31, 41, 55, 1) 100%)'
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "relative flex w-full flex-col justify-between overflow-hidden sm:flex-row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "relative z-10 flex w-full items-center overflow-hidden pl-4 pr-4 sm:pr-0 xl:w-7/12 2xl:w-2/3",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx((next_link__WEBPACK_IMPORTED_MODULE_9___default()), {
          href: issue.media.mediaType === _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaType.MOVIE */ .DD.MOVIE ? `/movie/${issue.media.tmdbId}` : `/tv/${issue.media.tmdbId}`,
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("a", {
            className: "relative h-auto w-12 flex-shrink-0 scale-100 transform-gpu overflow-hidden rounded-md transition duration-300 hover:scale-105",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
              src: title.posterPath ? `https://image.tmdb.org/t/p/w600_and_h900_bestv2${title.posterPath}` : '/images/overseerr_poster_not_found.png',
              alt: "",
              layout: "responsive",
              width: 600,
              height: 900,
              objectFit: "cover"
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "flex flex-col justify-center overflow-hidden pl-2 xl:pl-4",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "pt-0.5 text-xs text-white sm:pt-1",
            children: (isMovie(title) ? title.releaseDate : title.firstAirDate)?.slice(0, 4)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx((next_link__WEBPACK_IMPORTED_MODULE_9___default()), {
            href: issue.media.mediaType === _server_constants_media__WEBPACK_IMPORTED_MODULE_8__/* .MediaType.MOVIE */ .DD.MOVIE ? `/movie/${issue.media.tmdbId}` : `/tv/${issue.media.tmdbId}`,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("a", {
              className: "mr-2 min-w-0 truncate text-lg font-bold text-white hover:underline xl:text-xl",
              children: isMovie(title) ? title.title : title.name
            })
          }), problemSeasonEpisodeLine.length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "card-field",
            children: problemSeasonEpisodeLine.map((t, k) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              children: t
            }, k))
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "z-10 mt-4 ml-4 flex w-full flex-col justify-center overflow-hidden pr-4 text-sm sm:ml-2 sm:mt-0 xl:flex-1 xl:pr-0",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "card-field",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
            className: "card-field-name",
            children: intl.formatMessage(messages.issuestatus)
          }), issue.status === _server_constants_issue__WEBPACK_IMPORTED_MODULE_7__/* .IssueStatus.OPEN */ .d$.OPEN ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            badgeType: "warning",
            href: `/issues/${issue.id}`,
            children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].open */ .Z.open)
          }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            badgeType: "success",
            href: `/issues/${issue.id}`,
            children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].resolved */ .Z.resolved)
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "card-field",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
            className: "card-field-name",
            children: intl.formatMessage(messages.issuetype)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
            className: "flex truncate text-sm text-gray-300",
            children: intl.formatMessage(issueOption?.name ?? messages.unknownissuetype)
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
          className: "card-field",
          children: hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .Permission.VIEW_ISSUES */ .y3.VIEW_ISSUES], {
            type: 'or'
          }) ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "card-field-name",
              children: intl.formatMessage(messages.opened)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "flex truncate text-sm text-gray-300",
              children: intl.formatMessage(messages.openeduserdate, {
                date: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_11__.FormattedRelativeTime, {
                  value: Math.floor((new Date(issue.createdAt).getTime() - Date.now()) / 1000),
                  updateIntervalInSeconds: 1,
                  numeric: "auto"
                }),
                user: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx((next_link__WEBPACK_IMPORTED_MODULE_9___default()), {
                  href: `/users/${issue.createdBy.id}`,
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("a", {
                    className: "group flex items-center truncate",
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("img", {
                      src: issue.createdBy.avatar,
                      alt: "",
                      className: "avatar-sm ml-1.5 object-cover"
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
                      className: "truncate text-sm font-semibold group-hover:text-white group-hover:underline",
                      children: issue.createdBy.displayName
                    })]
                  })
                })
              })
            })]
          }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "card-field-name",
              children: intl.formatMessage(messages.opened)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "flex truncate text-sm text-gray-300",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_11__.FormattedRelativeTime, {
                value: Math.floor((new Date(issue.createdAt).getTime() - Date.now()) / 1000),
                updateIntervalInSeconds: 1,
                numeric: "auto"
              })
            })]
          })
        })]
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
      className: "z-10 mt-4 flex w-full flex-col justify-center pl-4 pr-4 xl:mt-0 xl:w-96 xl:items-end xl:pl-0",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
        className: "w-full",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx((next_link__WEBPACK_IMPORTED_MODULE_9___default()), {
          href: `/issues/${issue.id}`,
          passHref: true,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            as: "a",
            className: "w-full",
            buttonType: "primary",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_6__.EyeIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              children: intl.formatMessage(messages.viewissue)
            })]
          })
        })
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IssueItem);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 65771:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_Header__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76631);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74449);
/* harmony import */ var _app_components_IssueList_IssueItem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(48082);
/* harmony import */ var _app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27208);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_IssueList_IssueItem__WEBPACK_IMPORTED_MODULE_4__, swr__WEBPACK_IMPORTED_MODULE_11__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_IssueList_IssueItem__WEBPACK_IMPORTED_MODULE_4__, swr__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_10__.defineMessages)({
  issues: {
    "id": "components.IssueList.issues",
    "defaultMessage": 'Issues'
  },
  sortAdded: {
    "id": "components.IssueList.sortAdded",
    "defaultMessage": 'Most Recent'
  },
  sortModified: {
    "id": "components.IssueList.sortModified",
    "defaultMessage": 'Last Modified'
  },
  showallissues: {
    "id": "components.IssueList.showallissues",
    "defaultMessage": 'Show All Issues'
  }
});
var Filter;

(function (Filter) {
  Filter["ALL"] = "all";
  Filter["OPEN"] = "open";
  Filter["RESOLVED"] = "resolved";
})(Filter || (Filter = {}));

const IssueList = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_10__.useIntl)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_8__.useRouter)();
  const {
    0: currentFilter,
    1: setCurrentFilter
  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(Filter.OPEN);
  const {
    0: currentSort,
    1: setCurrentSort
  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)('added');
  const {
    0: currentPageSize,
    1: setCurrentPageSize
  } = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(10);
  const page = router.query.page ? Number(router.query.page) : 1;
  const pageIndex = page - 1;
  const updateQueryParams = (0,_app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_5__/* .useUpdateQueryParams */ .BA)({
    page: page.toString()
  });
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_11__["default"])(`/api/v1/issue?take=${currentPageSize}&skip=${pageIndex * currentPageSize}&filter=${currentFilter}&sort=${currentSort}`); // Restore last set filter values on component mount

  (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    const filterString = window.localStorage.getItem('il-filter-settings');

    if (filterString) {
      const filterSettings = JSON.parse(filterString);
      setCurrentFilter(filterSettings.currentFilter);
      setCurrentSort(filterSettings.currentSort);
      setCurrentPageSize(filterSettings.currentPageSize);
    } // If filter value is provided in query, use that instead


    if (Object.values(Filter).includes(router.query.filter)) {
      setCurrentFilter(router.query.filter);
    }
  }, [router.query.filter]); // Set filter values to local storage any time they are changed

  (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    window.localStorage.setItem('il-filter-settings', JSON.stringify({
      currentFilter,
      currentSort,
      currentPageSize
    }));
  }, [currentFilter, currentSort, currentPageSize]);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  const hasNextPage = data.pageInfo.pages > pageIndex + 1;
  const hasPrevPage = pageIndex > 0;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      title: intl.formatMessage(messages.issues)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "mb-4 flex flex-col justify-between lg:flex-row lg:items-end",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_Common_Header__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        children: intl.formatMessage(messages.issues)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
        className: "mt-2 flex flex-grow flex-col sm:flex-row lg:flex-grow-0",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "mb-2 flex flex-grow sm:mb-0 sm:mr-2 lg:flex-grow-0",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
            className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-sm text-gray-100",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__.FunnelIcon, {
              className: "h-6 w-6"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("select", {
            id: "filter",
            name: "filter",
            onChange: e => {
              setCurrentFilter(e.target.value);
              router.push({
                pathname: router.pathname,
                query: router.query.userId ? {
                  userId: router.query.userId
                } : {}
              });
            },
            value: currentFilter,
            className: "rounded-r-only",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
              value: "all",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].all */ .Z.all)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
              value: "open",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].open */ .Z.open)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
              value: "resolved",
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].resolved */ .Z.resolved)
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "mb-2 flex flex-grow sm:mb-0 lg:flex-grow-0",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
            className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-gray-100 sm:text-sm",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__.BarsArrowDownIcon, {
              className: "h-6 w-6"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("select", {
            id: "sort",
            name: "sort",
            onChange: e => {
              setCurrentSort(e.target.value);
              router.push({
                pathname: router.pathname,
                query: router.query.userId ? {
                  userId: router.query.userId
                } : {}
              });
            },
            value: currentSort,
            className: "rounded-r-only",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
              value: "added",
              children: intl.formatMessage(messages.sortAdded)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
              value: "modified",
              children: intl.formatMessage(messages.sortModified)
            })]
          })]
        })]
      })]
    }), data.results.map(issue => {
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
        className: "py-2",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_IssueList_IssueItem__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          issue: issue
        })
      }, `issue-item-${issue.id}`);
    }), data.results.length === 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "flex w-full flex-col items-center justify-center py-24 text-white",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
        className: "text-2xl text-gray-400",
        children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].noresults */ .Z.noresults)
      }), currentFilter !== Filter.ALL && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
        className: "mt-4",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          buttonType: "primary",
          onClick: () => setCurrentFilter(Filter.ALL),
          children: intl.formatMessage(messages.showallissues)
        })
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
      className: "actions",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("nav", {
        className: "mb-3 flex flex-col items-center space-y-3 sm:flex-row sm:space-y-0",
        "aria-label": "Pagination",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
          className: "hidden lg:flex lg:flex-1",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("p", {
            className: "text-sm",
            children: data.results.length > 0 && intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].showingresults */ .Z.showingresults, {
              from: pageIndex * currentPageSize + 1,
              to: data.results.length < currentPageSize ? pageIndex * currentPageSize + data.results.length : (pageIndex + 1) * currentPageSize,
              total: data.pageInfo.results,
              strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
                className: "font-medium",
                children: msg
              })
            })
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
          className: "flex justify-center sm:flex-1 sm:justify-start lg:justify-center",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
            className: "-mt-3 items-center truncate text-sm sm:mt-0",
            children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].resultsperpage */ .Z.resultsperpage, {
              pageSize: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("select", {
                id: "pageSize",
                name: "pageSize",
                onChange: e => {
                  setCurrentPageSize(Number(e.target.value));
                  router.push({
                    pathname: router.pathname,
                    query: router.query.userId ? {
                      userId: router.query.userId
                    } : {}
                  }).then(() => window.scrollTo(0, 0));
                },
                value: currentPageSize,
                className: "short inline",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
                  value: "5",
                  children: "5"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
                  value: "10",
                  children: "10"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
                  value: "25",
                  children: "25"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
                  value: "50",
                  children: "50"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
                  value: "100",
                  children: "100"
                })]
              })
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "flex flex-auto justify-center space-x-2 sm:flex-1 sm:justify-end",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            disabled: !hasPrevPage,
            onClick: () => updateQueryParams('page', (page - 1).toString()),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__.ChevronLeftIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].previous */ .Z.previous)
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            disabled: !hasNextPage,
            onClick: () => updateQueryParams('page', (page + 1).toString()),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].next */ .Z.next)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_7__.ChevronRightIcon, {})]
          })]
        })]
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IssueList);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 75691:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _useUser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86799);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_useUser__WEBPACK_IMPORTED_MODULE_2__]);
_useUser__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const useRouteGuard = (permission, options) => {
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
  const {
    user,
    hasPermission
  } = (0,_useUser__WEBPACK_IMPORTED_MODULE_2__/* .useUser */ .aF)();
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (user && !hasPermission(permission, options)) {
      router.push('/');
    }
  }, [user, permission, router, hasPermission, options]);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useRouteGuard);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 48109:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_IssueList__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65771);
/* harmony import */ var _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75691);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86799);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_IssueList__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__]);
([_app_components_IssueList__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const IssuePage = () => {
  (0,_app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.CREATE_ISSUES */ .y3.CREATE_ISSUES, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.VIEW_ISSUES */ .y3.VIEW_ISSUES], {
    type: 'or'
  });
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_IssueList__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {});
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IssuePage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 44009:
/***/ ((module) => {

module.exports = import("react-intersection-observer");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,1388,61439,19998,80210,86799,99073,7292,27208,14422], () => (__webpack_exec__(48109)));
module.exports = __webpack_exports__;

})();