"use strict";
(() => {
var exports = {};
exports.id = 26088;
exports.ids = [26088,64820];
exports.modules = {

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 85234:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43907);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(22796);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31645);
/* harmony import */ var _app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(84541);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80210);
/* harmony import */ var _app_utils_numberHelpers__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(49486);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(99648);
/* harmony import */ var cronstrue_i18n__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(99116);
/* harmony import */ var cronstrue_i18n__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(cronstrue_i18n__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_4__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_5__, _headlessui_react__WEBPACK_IMPORTED_MODULE_9__, axios__WEBPACK_IMPORTED_MODULE_12__, swr__WEBPACK_IMPORTED_MODULE_17__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_4__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_5__, _headlessui_react__WEBPACK_IMPORTED_MODULE_9__, axios__WEBPACK_IMPORTED_MODULE_12__, swr__WEBPACK_IMPORTED_MODULE_17__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }























const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.defineMessages)({
  jobsandcache: {
    "id": "components.Settings.SettingsJobsCache.jobsandcache",
    "defaultMessage": 'Jobs & Cache'
  },
  jobs: {
    "id": "components.Settings.SettingsJobsCache.jobs",
    "defaultMessage": 'Jobs'
  },
  jobsDescription: {
    "id": "components.Settings.SettingsJobsCache.jobsDescription",
    "defaultMessage": 'Overseerr performs certain maintenance tasks as regularly-scheduled jobs, but they can also be manually triggered below. Manually running a job will not alter its schedule.'
  },
  jobname: {
    "id": "components.Settings.SettingsJobsCache.jobname",
    "defaultMessage": 'Job Name'
  },
  jobtype: {
    "id": "components.Settings.SettingsJobsCache.jobtype",
    "defaultMessage": 'Type'
  },
  nextexecution: {
    "id": "components.Settings.SettingsJobsCache.nextexecution",
    "defaultMessage": 'Next Execution'
  },
  runnow: {
    "id": "components.Settings.SettingsJobsCache.runnow",
    "defaultMessage": 'Run Now'
  },
  canceljob: {
    "id": "components.Settings.SettingsJobsCache.canceljob",
    "defaultMessage": 'Cancel Job'
  },
  jobstarted: {
    "id": "components.Settings.SettingsJobsCache.jobstarted",
    "defaultMessage": '{jobname} started.'
  },
  jobcancelled: {
    "id": "components.Settings.SettingsJobsCache.jobcancelled",
    "defaultMessage": '{jobname} canceled.'
  },
  process: {
    "id": "components.Settings.SettingsJobsCache.process",
    "defaultMessage": 'Process'
  },
  command: {
    "id": "components.Settings.SettingsJobsCache.command",
    "defaultMessage": 'Command'
  },
  cache: {
    "id": "components.Settings.SettingsJobsCache.cache",
    "defaultMessage": 'Cache'
  },
  cacheDescription: {
    "id": "components.Settings.SettingsJobsCache.cacheDescription",
    "defaultMessage": 'Overseerr caches requests to external API endpoints to optimize performance and avoid making unnecessary API calls.'
  },
  cacheflushed: {
    "id": "components.Settings.SettingsJobsCache.cacheflushed",
    "defaultMessage": '{cachename} cache flushed.'
  },
  cachename: {
    "id": "components.Settings.SettingsJobsCache.cachename",
    "defaultMessage": 'Cache Name'
  },
  cachehits: {
    "id": "components.Settings.SettingsJobsCache.cachehits",
    "defaultMessage": 'Hits'
  },
  cachemisses: {
    "id": "components.Settings.SettingsJobsCache.cachemisses",
    "defaultMessage": 'Misses'
  },
  cachekeys: {
    "id": "components.Settings.SettingsJobsCache.cachekeys",
    "defaultMessage": 'Total Keys'
  },
  cacheksize: {
    "id": "components.Settings.SettingsJobsCache.cacheksize",
    "defaultMessage": 'Key Size'
  },
  cachevsize: {
    "id": "components.Settings.SettingsJobsCache.cachevsize",
    "defaultMessage": 'Value Size'
  },
  flushcache: {
    "id": "components.Settings.SettingsJobsCache.flushcache",
    "defaultMessage": 'Flush Cache'
  },
  unknownJob: {
    "id": "components.Settings.SettingsJobsCache.unknownJob",
    "defaultMessage": 'Unknown Job'
  },
  'plex-recently-added-scan': {
    "id": "components.Settings.SettingsJobsCache.plex-recently-added-scan",
    "defaultMessage": 'Plex Recently Added Scan'
  },
  'plex-full-scan': {
    "id": "components.Settings.SettingsJobsCache.plex-full-scan",
    "defaultMessage": 'Plex Full Library Scan'
  },
  'plex-watchlist-sync': {
    "id": "components.Settings.SettingsJobsCache.plex-watchlist-sync",
    "defaultMessage": 'Plex Watchlist Sync'
  },
  'plex-refresh-token': {
    "id": "components.Settings.SettingsJobsCache.plex-refresh-token",
    "defaultMessage": 'Plex Refresh Token'
  },
  'availability-sync': {
    "id": "components.Settings.SettingsJobsCache.availability-sync",
    "defaultMessage": 'Media Availability Sync'
  },
  'radarr-scan': {
    "id": "components.Settings.SettingsJobsCache.radarr-scan",
    "defaultMessage": 'Radarr Scan'
  },
  'sonarr-scan': {
    "id": "components.Settings.SettingsJobsCache.sonarr-scan",
    "defaultMessage": 'Sonarr Scan'
  },
  'download-sync': {
    "id": "components.Settings.SettingsJobsCache.download-sync",
    "defaultMessage": 'Download Sync'
  },
  'download-sync-reset': {
    "id": "components.Settings.SettingsJobsCache.download-sync-reset",
    "defaultMessage": 'Download Sync Reset'
  },
  'image-cache-cleanup': {
    "id": "components.Settings.SettingsJobsCache.image-cache-cleanup",
    "defaultMessage": 'Image Cache Cleanup'
  },
  editJobSchedule: {
    "id": "components.Settings.SettingsJobsCache.editJobSchedule",
    "defaultMessage": 'Modify Job'
  },
  jobScheduleEditSaved: {
    "id": "components.Settings.SettingsJobsCache.jobScheduleEditSaved",
    "defaultMessage": 'Job edited successfully!'
  },
  jobScheduleEditFailed: {
    "id": "components.Settings.SettingsJobsCache.jobScheduleEditFailed",
    "defaultMessage": 'Something went wrong while saving the job.'
  },
  editJobScheduleCurrent: {
    "id": "components.Settings.SettingsJobsCache.editJobScheduleCurrent",
    "defaultMessage": 'Current Frequency'
  },
  editJobSchedulePrompt: {
    "id": "components.Settings.SettingsJobsCache.editJobSchedulePrompt",
    "defaultMessage": 'New Frequency'
  },
  editJobScheduleSelectorHours: {
    "id": "components.Settings.SettingsJobsCache.editJobScheduleSelectorHours",
    "defaultMessage": 'Every {jobScheduleHours, plural, one {hour} other {{jobScheduleHours} hours}}'
  },
  editJobScheduleSelectorMinutes: {
    "id": "components.Settings.SettingsJobsCache.editJobScheduleSelectorMinutes",
    "defaultMessage": 'Every {jobScheduleMinutes, plural, one {minute} other {{jobScheduleMinutes} minutes}}'
  },
  editJobScheduleSelectorSeconds: {
    "id": "components.Settings.SettingsJobsCache.editJobScheduleSelectorSeconds",
    "defaultMessage": 'Every {jobScheduleSeconds, plural, one {second} other {{jobScheduleSeconds} seconds}}'
  },
  imagecache: {
    "id": "components.Settings.SettingsJobsCache.imagecache",
    "defaultMessage": 'Image Cache'
  },
  imagecacheDescription: {
    "id": "components.Settings.SettingsJobsCache.imagecacheDescription",
    "defaultMessage": 'When enabled in settings, Overseerr will proxy and cache images from pre-configured external sources. Cached images are saved into your config folder. You can find the files in <code>{appDataPath}/cache/images</code>.'
  },
  imagecachecount: {
    "id": "components.Settings.SettingsJobsCache.imagecachecount",
    "defaultMessage": 'Images Cached'
  },
  imagecachesize: {
    "id": "components.Settings.SettingsJobsCache.imagecachesize",
    "defaultMessage": 'Total Cache Size'
  }
});

const jobModalReducer = (state, action) => {
  switch (action.type) {
    case 'close':
      return _objectSpread(_objectSpread({}, state), {}, {
        isOpen: false
      });

    case 'open':
      return {
        isOpen: true,
        job: action.job,
        scheduleHours: 1,
        scheduleMinutes: 5,
        scheduleSeconds: 30
      };

    case 'set':
      return _objectSpread(_objectSpread({}, state), {}, {
        scheduleHours: action.hours ?? state.scheduleHours,
        scheduleMinutes: action.minutes ?? state.scheduleMinutes,
        scheduleSeconds: action.seconds ?? state.scheduleSeconds
      });
  }
};

const SettingsJobs = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    locale
  } = (0,_app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__.useToasts)();
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])('/api/v1/settings/jobs', {
    refreshInterval: 5000
  });
  const {
    data: appData
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])('/api/v1/status/appdata');
  const {
    data: cacheData,
    mutate: cacheRevalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])('/api/v1/settings/cache', {
    refreshInterval: 10000
  });
  const {
    0: jobModalState,
    1: dispatch
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useReducer)(jobModalReducer, {
    isOpen: false,
    scheduleHours: 1,
    scheduleMinutes: 5,
    scheduleSeconds: 30
  });
  const {
    0: isSaving,
    1: setIsSaving
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {});
  }

  const runJob = async job => {
    await axios__WEBPACK_IMPORTED_MODULE_12__["default"].post(`/api/v1/settings/jobs/${job.id}/run`);
    addToast(intl.formatMessage(messages.jobstarted, {
      jobname: intl.formatMessage(messages[job.id] ?? messages.unknownJob)
    }), {
      appearance: 'success',
      autoDismiss: true
    });
    revalidate();
  };

  const cancelJob = async job => {
    await axios__WEBPACK_IMPORTED_MODULE_12__["default"].post(`/api/v1/settings/jobs/${job.id}/cancel`);
    addToast(intl.formatMessage(messages.jobcancelled, {
      jobname: intl.formatMessage(messages[job.id] ?? messages.unknownJob)
    }), {
      appearance: 'error',
      autoDismiss: true
    });
    revalidate();
  };

  const flushCache = async cache => {
    await axios__WEBPACK_IMPORTED_MODULE_12__["default"].post(`/api/v1/settings/cache/${cache.id}/flush`);
    addToast(intl.formatMessage(messages.cacheflushed, {
      cachename: cache.name
    }), {
      appearance: 'success',
      autoDismiss: true
    });
    cacheRevalidate();
  };

  const scheduleJob = async () => {
    const jobScheduleCron = ['0', '0', '*', '*', '*', '*'];

    try {
      if (jobModalState.job?.interval === 'seconds') {
        jobScheduleCron.splice(0, 2, `*/${jobModalState.scheduleSeconds}`, '*');
      } else if (jobModalState.job?.interval === 'minutes') {
        jobScheduleCron[1] = `*/${jobModalState.scheduleMinutes}`;
      } else if (jobModalState.job?.interval === 'hours') {
        jobScheduleCron[2] = `*/${jobModalState.scheduleHours}`;
      } else {
        // jobs with interval: fixed should not be editable
        throw new Error();
      }

      setIsSaving(true);
      await axios__WEBPACK_IMPORTED_MODULE_12__["default"].post(`/api/v1/settings/jobs/${jobModalState.job.id}/schedule`, {
        schedule: jobScheduleCron.join(' ')
      });
      addToast(intl.formatMessage(messages.jobScheduleEditSaved), {
        appearance: 'success',
        autoDismiss: true
      });
      dispatch({
        type: 'close'
      });
      revalidate();
    } catch (e) {
      addToast(intl.formatMessage(messages.jobScheduleEditFailed), {
        appearance: 'error',
        autoDismiss: true
      });
    } finally {
      setIsSaving(false);
    }
  };

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.jobsandcache), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].settings */ .Z.settings)]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_9__.Transition, {
      as: react__WEBPACK_IMPORTED_MODULE_14__.Fragment,
      enter: "transition-opacity duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      show: jobModalState.isOpen,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.editJobSchedule),
        okText: isSaving ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].save */ .Z.save),
        onCancel: () => dispatch({
          type: 'close'
        }),
        okDisabled: isSaving,
        onOk: () => scheduleJob(),
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "section",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("form", {
            className: "mb-6",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("label", {
                className: "text-label",
                children: intl.formatMessage(messages.editJobScheduleCurrent)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
                className: "form-input-area mt-2 mb-1",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
                  children: jobModalState.job && cronstrue_i18n__WEBPACK_IMPORTED_MODULE_13___default().toString(jobModalState.job.cronSchedule, {
                    locale
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
                  className: "text-sm text-gray-500",
                  children: jobModalState.job?.cronSchedule
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("label", {
                htmlFor: "jobSchedule",
                className: "text-label",
                children: intl.formatMessage(messages.editJobSchedulePrompt)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
                className: "form-input-area",
                children: jobModalState.job?.interval === 'seconds' ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("select", {
                  name: "jobScheduleSeconds",
                  className: "inline",
                  value: jobModalState.scheduleSeconds,
                  onChange: e => dispatch({
                    type: 'set',
                    seconds: Number(e.target.value)
                  }),
                  children: [30, 45, 60].map(v => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("option", {
                    value: v,
                    children: intl.formatMessage(messages.editJobScheduleSelectorSeconds, {
                      jobScheduleSeconds: v
                    })
                  }, `jobScheduleSeconds-${v}`))
                }) : jobModalState.job?.interval === 'minutes' ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("select", {
                  name: "jobScheduleMinutes",
                  className: "inline",
                  value: jobModalState.scheduleMinutes,
                  onChange: e => dispatch({
                    type: 'set',
                    minutes: Number(e.target.value)
                  }),
                  children: [5, 10, 15, 20, 30, 60].map(v => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("option", {
                    value: v,
                    children: intl.formatMessage(messages.editJobScheduleSelectorMinutes, {
                      jobScheduleMinutes: v
                    })
                  }, `jobScheduleMinutes-${v}`))
                }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("select", {
                  name: "jobScheduleHours",
                  className: "inline",
                  value: jobModalState.scheduleHours,
                  onChange: e => dispatch({
                    type: 'set',
                    hours: Number(e.target.value)
                  }),
                  children: [1, 2, 3, 4, 6, 8, 12, 24, 48, 72].map(v => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("option", {
                    value: v,
                    children: intl.formatMessage(messages.editJobScheduleSelectorHours, {
                      jobScheduleHours: v
                    })
                  }, `jobScheduleHours-${v}`))
                })
              })]
            })]
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      className: "mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.jobs)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.jobsDescription)
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("thead", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("tr", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.jobname)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.jobtype)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.nextexecution)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {})]
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TBody */ .Z.TBody, {
          children: data?.map(job => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("tr", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
                className: "flex items-center text-sm leading-5 text-white",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  children: intl.formatMessage(messages[job.id] ?? messages.unknownJob)
                }), job.running && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                  className: "ml-2 h-5 w-5"
                })]
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                badgeType: job.type === 'process' ? 'primary' : 'warning',
                className: "uppercase",
                children: job.type === 'process' ? intl.formatMessage(messages.process) : intl.formatMessage(messages.command)
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
                className: "text-sm leading-5 text-white",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_15__.FormattedRelativeTime, {
                  value: Math.floor((new Date(job.nextExecutionTime).getTime() - Date.now()) / 1000),
                  updateIntervalInSeconds: 1,
                  numeric: "auto"
                })
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              alignText: "right",
              children: [job.interval !== 'fixed' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                className: "mr-2",
                buttonType: "warning",
                onClick: () => dispatch({
                  type: 'open',
                  job
                }),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_11__.PencilIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].edit */ .Z.edit)
                })]
              }), job.running ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                buttonType: "danger",
                onClick: () => cancelJob(job),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__.StopIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  children: intl.formatMessage(messages.canceljob)
                })]
              }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                buttonType: "primary",
                onClick: () => runJob(job),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__.PlayIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  children: intl.formatMessage(messages.runnow)
                })]
              })]
            })]
          }, `job-list-${job.id}`))
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.cache)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.cacheDescription)
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("thead", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("tr", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.cachename)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.cachehits)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.cachemisses)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.cachekeys)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.cacheksize)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.cachevsize)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {})]
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TBody */ .Z.TBody, {
          children: cacheData?.apiCaches.map(cache => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("tr", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: cache.name
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: intl.formatNumber(cache.stats.hits)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: intl.formatNumber(cache.stats.misses)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: intl.formatNumber(cache.stats.keys)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: (0,_app_utils_numberHelpers__WEBPACK_IMPORTED_MODULE_19__/* .formatBytes */ .t)(cache.stats.ksize)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: (0,_app_utils_numberHelpers__WEBPACK_IMPORTED_MODULE_19__/* .formatBytes */ .t)(cache.stats.vsize)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              alignText: "right",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                buttonType: "danger",
                onClick: () => flushCache(cache),
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__.TrashIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                  children: intl.formatMessage(messages.flushcache)
                })]
              })
            })]
          }, `cache-list-${cache.id}`))
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.imagecache)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.imagecacheDescription, {
          code: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("code", {
            className: "bg-opacity-50",
            children: msg
          }),
          appDataPath: appData ? appData.appDataPath : '/app/config'
        })
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("thead", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("tr", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.cachename)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.imagecachecount)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.imagecachesize)
            })]
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TBody */ .Z.TBody, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("tr", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: "The Movie Database (tmdb)"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: intl.formatNumber(cacheData?.imageCache.tmdb.imageCount ?? 0)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_6__/* ["default"].TD */ .Z.TD, {
              children: (0,_app_utils_numberHelpers__WEBPACK_IMPORTED_MODULE_19__/* .formatBytes */ .t)(cacheData?.imageCache.tmdb.size ?? 0)
            })]
          })
        })]
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsJobs);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 54353:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Settings_SettingsJobsCache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85234);
/* harmony import */ var _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91865);
/* harmony import */ var _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75691);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86799);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Settings_SettingsJobsCache__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__]);
([_app_components_Settings_SettingsJobsCache__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const SettingsMainPage = () => {
  (0,_app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__/* .Permission.ADMIN */ .y3.ADMIN);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Settings_SettingsJobsCache__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {})
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsMainPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 99116:
/***/ ((module) => {

module.exports = require("cronstrue/i18n");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 66405:
/***/ ((module) => {

module.exports = require("react-dom");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,1388,61439,19998,80210,86799,99073,7292,22796,33173,24115,35754,84541,31645], () => (__webpack_exec__(54353)));
module.exports = __webpack_exports__;

})();