"use strict";
(() => {
var exports = {};
exports.id = 16611;
exports.ids = [16611,64820];
exports.modules = {

/***/ 49665:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22796);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31645);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63145);
/* harmony import */ var _app_hooks_useDebouncedState__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29303);
/* harmony import */ var _app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(27208);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(80210);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(35635);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var copy_to_clipboard__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(68887);
/* harmony import */ var copy_to_clipboard__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(copy_to_clipboard__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__, _app_pages_error__WEBPACK_IMPORTED_MODULE_10__, _headlessui_react__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_18__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__, _app_pages_error__WEBPACK_IMPORTED_MODULE_10__, _headlessui_react__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_18__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_16__.defineMessages)({
  logs: {
    "id": "components.Settings.SettingsLogs.logs",
    "defaultMessage": 'Logs'
  },
  logsDescription: {
    "id": "components.Settings.SettingsLogs.logsDescription",
    "defaultMessage": 'You can also view these logs directly via <code>stdout</code>, or in <code>{appDataPath}/logs/overseerr.log</code>.'
  },
  time: {
    "id": "components.Settings.SettingsLogs.time",
    "defaultMessage": 'Timestamp'
  },
  level: {
    "id": "components.Settings.SettingsLogs.level",
    "defaultMessage": 'Severity'
  },
  label: {
    "id": "components.Settings.SettingsLogs.label",
    "defaultMessage": 'Label'
  },
  message: {
    "id": "components.Settings.SettingsLogs.message",
    "defaultMessage": 'Message'
  },
  filterDebug: {
    "id": "components.Settings.SettingsLogs.filterDebug",
    "defaultMessage": 'Debug'
  },
  filterInfo: {
    "id": "components.Settings.SettingsLogs.filterInfo",
    "defaultMessage": 'Info'
  },
  filterWarn: {
    "id": "components.Settings.SettingsLogs.filterWarn",
    "defaultMessage": 'Warning'
  },
  filterError: {
    "id": "components.Settings.SettingsLogs.filterError",
    "defaultMessage": 'Error'
  },
  showall: {
    "id": "components.Settings.SettingsLogs.showall",
    "defaultMessage": 'Show All Logs'
  },
  pauseLogs: {
    "id": "components.Settings.SettingsLogs.pauseLogs",
    "defaultMessage": 'Pause'
  },
  resumeLogs: {
    "id": "components.Settings.SettingsLogs.resumeLogs",
    "defaultMessage": 'Resume'
  },
  copyToClipboard: {
    "id": "components.Settings.SettingsLogs.copyToClipboard",
    "defaultMessage": 'Copy to Clipboard'
  },
  logDetails: {
    "id": "components.Settings.SettingsLogs.logDetails",
    "defaultMessage": 'Log Details'
  },
  extraData: {
    "id": "components.Settings.SettingsLogs.extraData",
    "defaultMessage": 'Additional Data'
  },
  copiedLogMessage: {
    "id": "components.Settings.SettingsLogs.copiedLogMessage",
    "defaultMessage": 'Copied log message to clipboard.'
  },
  viewdetails: {
    "id": "components.Settings.SettingsLogs.viewdetails",
    "defaultMessage": 'View Details'
  }
});

const SettingsLogs = () => {
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_14__.useRouter)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_16__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_17__.useToasts)();
  const {
    0: currentFilter,
    1: setCurrentFilter
  } = (0,react__WEBPACK_IMPORTED_MODULE_15__.useState)('debug');
  const {
    0: currentPageSize,
    1: setCurrentPageSize
  } = (0,react__WEBPACK_IMPORTED_MODULE_15__.useState)(25);
  const [searchFilter, debouncedSearchFilter, setSearchFilter] = (0,_app_hooks_useDebouncedState__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)('');
  const {
    0: refreshInterval,
    1: setRefreshInterval
  } = (0,react__WEBPACK_IMPORTED_MODULE_15__.useState)(5000);
  const {
    0: activeLog,
    1: setActiveLog
  } = (0,react__WEBPACK_IMPORTED_MODULE_15__.useState)({
    isOpen: false
  });
  const page = router.query.page ? Number(router.query.page) : 1;
  const pageIndex = page - 1;
  const updateQueryParams = (0,_app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_8__/* .useUpdateQueryParams */ .BA)({
    page: page.toString()
  });

  const toggleLogs = () => {
    setRefreshInterval(refreshInterval === 5000 ? 0 : 5000);
  };

  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_18__["default"])(`/api/v1/settings/logs?take=${currentPageSize}&skip=${pageIndex * currentPageSize}&filter=${currentFilter}${debouncedSearchFilter ? `&search=${debouncedSearchFilter}` : ''}`, {
    refreshInterval: refreshInterval,
    revalidateOnFocus: false
  });
  const {
    data: appData
  } = (0,swr__WEBPACK_IMPORTED_MODULE_18__["default"])('/api/v1/status/appdata');
  (0,react__WEBPACK_IMPORTED_MODULE_15__.useEffect)(() => {
    const filterString = window.localStorage.getItem('logs-display-settings');

    if (filterString) {
      const filterSettings = JSON.parse(filterString);
      setCurrentFilter(filterSettings.currentFilter);
      setCurrentPageSize(filterSettings.currentPageSize);
    }
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_15__.useEffect)(() => {
    window.localStorage.setItem('logs-display-settings', JSON.stringify({
      currentFilter,
      currentPageSize
    }));
  }, [currentFilter, currentPageSize]);

  const copyLogString = log => {
    copy_to_clipboard__WEBPACK_IMPORTED_MODULE_13___default()(`${log.timestamp} [${log.level}]${log.label ? `[${log.label}]` : ''}: ${log.message}${log.data ? `${JSON.stringify(log.data)}` : ''}`);
    addToast(intl.formatMessage(messages.copiedLogMessage), {
      appearance: 'success',
      autoDismiss: true
    });
  }; // check if there's no data and no errors in the table
  // so as to show a spinner inside the table and not refresh the whole component


  if (!data && error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_10__["default"], {
      statusCode: 500
    });
  }

  const hasNextPage = data?.pageInfo.pages ?? 0 > pageIndex + 1;
  const hasPrevPage = pageIndex > 0;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.logs), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].settings */ .Z.settings)]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_11__.Transition, {
      as: react__WEBPACK_IMPORTED_MODULE_15__.Fragment,
      enter: "transition-opacity duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      appear: true,
      show: activeLog.isOpen,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.logDetails),
        onCancel: () => setActiveLog({
          log: activeLog.log,
          isOpen: false
        }),
        cancelText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].close */ .Z.close),
        onOk: () => activeLog.log ? copyLogString(activeLog.log) : undefined,
        okText: intl.formatMessage(messages.copyToClipboard),
        okButtonType: "primary",
        children: activeLog && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "text-label",
              children: intl.formatMessage(messages.time)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "mb-1 text-sm font-medium leading-5 text-gray-400 sm:mt-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "flex max-w-lg items-center",
                children: intl.formatDate(activeLog.log?.timestamp, {
                  year: 'numeric',
                  month: 'short',
                  day: '2-digit',
                  hour: 'numeric',
                  minute: 'numeric',
                  second: 'numeric'
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "text-label",
              children: intl.formatMessage(messages.level)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "mb-1 text-sm font-medium leading-5 text-gray-400 sm:mt-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "flex max-w-lg items-center",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                  badgeType: activeLog.log?.level === 'error' ? 'danger' : activeLog.log?.level === 'warn' ? 'warning' : activeLog.log?.level === 'info' ? 'success' : 'default',
                  children: activeLog.log?.level.toUpperCase()
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "text-label",
              children: intl.formatMessage(messages.label)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "mb-1 text-sm font-medium leading-5 text-gray-400 sm:mt-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "flex max-w-lg items-center",
                children: activeLog.log?.label
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "text-label",
              children: intl.formatMessage(messages.message)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "col-span-2 mb-1 text-sm font-medium leading-5 text-gray-400 sm:mt-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "flex max-w-lg items-center",
                children: activeLog.log?.message
              })
            })]
          }), activeLog.log?.data && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "text-label",
              children: intl.formatMessage(messages.extraData)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "col-span-2 mb-1 text-sm font-medium leading-5 text-gray-400 sm:mt-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("code", {
                className: "block max-h-64 w-full overflow-auto whitespace-pre bg-gray-800 px-6 py-4 ring-1 ring-gray-700",
                children: JSON.stringify(activeLog.log?.data, null, ' ')
              })
            })]
          })]
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
      className: "mb-2",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.logs)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.logsDescription, {
          code: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("code", {
            className: "bg-opacity-50",
            children: msg
          }),
          appDataPath: appData ? appData.appDataPath : '/app/config'
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
        className: "mt-2 flex flex-grow flex-col sm:flex-grow-0 sm:flex-row sm:justify-end",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
          className: "mb-2 flex flex-grow sm:mb-0 sm:mr-2 md:flex-grow-0",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
            className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-sm text-gray-100",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.MagnifyingGlassIcon, {
              className: "h-6 w-6"
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("input", {
            type: "text",
            className: "rounded-r-only",
            value: searchFilter,
            onChange: e => setSearchFilter(e.target.value)
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
          className: "mb-2 flex flex-1 flex-row justify-between sm:mb-0 sm:flex-none",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            className: "mr-2 flex flex-grow",
            buttonType: refreshInterval ? 'default' : 'primary',
            onClick: () => toggleLogs(),
            children: [refreshInterval ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.PauseIcon, {}) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.PlayIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
              children: intl.formatMessage(refreshInterval ? messages.pauseLogs : messages.resumeLogs)
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "flex flex-grow",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
              className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-sm text-gray-100",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.FunnelIcon, {
                className: "h-6 w-6"
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("select", {
              id: "filter",
              name: "filter",
              onChange: e => {
                setCurrentFilter(e.target.value);
                router.push(router.pathname);
              },
              value: currentFilter,
              className: "rounded-r-only",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                value: "debug",
                children: intl.formatMessage(messages.filterDebug)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                value: "info",
                children: intl.formatMessage(messages.filterInfo)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                value: "warn",
                children: intl.formatMessage(messages.filterWarn)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                value: "error",
                children: intl.formatMessage(messages.filterError)
              })]
            })]
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("thead", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("tr", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.time)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.level)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.label)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TH */ .Z.TH, {
              children: intl.formatMessage(messages.message)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TH */ .Z.TH, {})]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TBody */ .Z.TBody, {
          children: [!data ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("tr", {
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TD */ .Z.TD, {
              colSpan: 5,
              noPadding: true,
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {})
            })
          }) : data.results.map((row, index) => {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("tr", {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TD */ .Z.TD, {
                className: "text-gray-300",
                children: intl.formatDate(row.timestamp, {
                  year: 'numeric',
                  month: 'short',
                  day: '2-digit',
                  hour: 'numeric',
                  minute: 'numeric',
                  second: 'numeric'
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TD */ .Z.TD, {
                className: "text-gray-300",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                  badgeType: row.level === 'error' ? 'danger' : row.level === 'warn' ? 'warning' : row.level === 'info' ? 'success' : 'default',
                  children: row.level.toUpperCase()
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TD */ .Z.TD, {
                className: "text-gray-300",
                children: row.label ?? ''
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TD */ .Z.TD, {
                className: "text-gray-300",
                children: row.message
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TD */ .Z.TD, {
                className: "-m-1 flex flex-wrap items-center justify-end",
                children: [row.data && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                  content: intl.formatMessage(messages.viewdetails),
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    buttonSize: "sm",
                    buttonType: "primary",
                    onClick: () => setActiveLog({
                      log: row,
                      isOpen: true
                    }),
                    className: "m-1",
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.DocumentMagnifyingGlassIcon, {
                      className: "icon-md"
                    })
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                  content: intl.formatMessage(messages.copyToClipboard),
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    buttonType: "primary",
                    buttonSize: "sm",
                    onClick: () => copyLogString(row),
                    className: "m-1",
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.ClipboardDocumentIcon, {
                      className: "icon-md"
                    })
                  })
                })]
              })]
            }, `log-list-${index}`);
          }), data?.results.length === 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("tr", {
            className: "relative h-24 p-2 text-white",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TD */ .Z.TD, {
              colSpan: 5,
              noPadding: true,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                className: "flex w-screen flex-col items-center justify-center p-6 md:w-full",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                  className: "text-base",
                  children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].noresults */ .Z.noresults)
                }), currentFilter !== 'debug' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "mt-4",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    buttonSize: "sm",
                    buttonType: "primary",
                    onClick: () => setCurrentFilter('debug'),
                    children: intl.formatMessage(messages.showall)
                  })
                })]
              })
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("tr", {
            className: "bg-gray-700",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_5__/* ["default"].TD */ .Z.TD, {
              colSpan: 5,
              noPadding: true,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("nav", {
                className: "flex w-screen flex-col items-center space-x-4 space-y-3 px-6 py-3 sm:flex-row sm:space-y-0 md:w-full",
                "aria-label": "Pagination",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "hidden lg:flex lg:flex-1",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("p", {
                    className: "text-sm",
                    children: (data?.results.length ?? 0) > 0 && intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].showingresults */ .Z.showingresults, {
                      from: pageIndex * currentPageSize + 1,
                      to: data?.results.length ?? 0 < currentPageSize ? pageIndex * currentPageSize + (data?.results.length ?? 0) : (pageIndex + 1) * currentPageSize,
                      total: data?.pageInfo.results ?? 0,
                      strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                        className: "font-medium",
                        children: msg
                      })
                    })
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "flex justify-center sm:flex-1 sm:justify-start md:justify-center",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                    className: "-mt-3 items-center text-sm sm:-ml-4 sm:mt-0 md:ml-0",
                    children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].resultsperpage */ .Z.resultsperpage, {
                      pageSize: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("select", {
                        id: "pageSize",
                        name: "pageSize",
                        onChange: e => {
                          setCurrentPageSize(Number(e.target.value));
                          router.push(router.pathname).then(() => window.scrollTo(0, 0));
                        },
                        value: currentPageSize,
                        className: "short inline",
                        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                          value: "10",
                          children: "10"
                        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                          value: "25",
                          children: "25"
                        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                          value: "50",
                          children: "50"
                        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                          value: "100",
                          children: "100"
                        })]
                      })
                    })
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                  className: "flex flex-auto justify-center space-x-2 sm:flex-1 sm:justify-end",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    disabled: !hasPrevPage,
                    onClick: () => updateQueryParams('page', (page - 1).toString()),
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.ChevronLeftIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                      children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].previous */ .Z.previous)
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                    disabled: !hasNextPage,
                    onClick: () => updateQueryParams('page', (page + 1).toString()),
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                      children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].next */ .Z.next)
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_12__.ChevronRightIcon, {})]
                  })]
                })]
              })
            })
          })]
        })]
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsLogs);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 29303:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/**
 * A hook to help with debouncing state
 *
 * This hook basically acts the same as useState except it is also
 * returning a deobuncedValue that can be used for things like
 * debouncing input into a search field
 *
 * @param initialValue Initial state value
 * @param debounceTime Debounce time in ms
 */

const useDebouncedState = (initialValue, debounceTime = 300) => {
  const {
    0: value,
    1: setValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialValue);
  const {
    0: finalValue,
    1: setFinalValue
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialValue);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const timeout = setTimeout(() => {
      setFinalValue(value);
    }, debounceTime);
    return () => {
      clearTimeout(timeout);
    };
  }, [value, debounceTime]);
  return [value, finalValue, setValue];
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDebouncedState);

/***/ }),

/***/ 4021:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91865);
/* harmony import */ var _app_components_Settings_SettingsLogs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(49665);
/* harmony import */ var _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75691);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86799);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLogs__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__]);
([_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLogs__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const SettingsLogsPage = () => {
  (0,_app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__/* .Permission.ADMIN */ .y3.ADMIN);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Settings_SettingsLogs__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {})
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsLogsPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 68887:
/***/ ((module) => {

module.exports = require("copy-to-clipboard");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 66405:
/***/ ((module) => {

module.exports = require("react-dom");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 30616:
/***/ ((module) => {

module.exports = require("react-popper-tooltip");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,1388,61439,19998,80210,86799,35635,99073,7292,22796,33173,63145,35754,27208,31645], () => (__webpack_exec__(4021)));
module.exports = __webpack_exports__;

})();