"use strict";
(() => {
var exports = {};
exports.id = 3463;
exports.ids = [3463,64820];
exports.modules = {

/***/ 22234:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_2__]);
swr__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];





const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_1__.defineMessages)({
  dockerVolumeMissingDescription: {
    "id": "components.AppDataWarning.dockerVolumeMissingDescription",
    "defaultMessage": 'The <code>{appDataPath}</code> volume mount was not configured properly. All data will be cleared when the container is stopped or restarted.'
  }
});

const AppDataWarning = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_1__.useIntl)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_2__["default"])('/api/v1/status/appdata');

  if (!data && !error) {
    return null;
  }

  if (!data) {
    return null;
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: !data.appData && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      title: intl.formatMessage(messages.dockerVolumeMissingDescription, {
        code: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("code", {
          className: "bg-opacity-50",
          children: msg
        }),
        appDataPath: data.appDataPath
      })
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AppDataWarning);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 58269:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_PlexLoginButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77867);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86799);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_PlexLoginButton__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__, axios__WEBPACK_IMPORTED_MODULE_2__]);
([_app_components_PlexLoginButton__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__, axios__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.defineMessages)({
  welcome: {
    "id": "components.Setup.welcome",
    "defaultMessage": 'Welcome to Overseerr'
  },
  signinMessage: {
    "id": "components.Setup.signinMessage",
    "defaultMessage": 'Get started by signing in with your Plex account'
  }
});

const LoginWithPlex = ({
  onComplete
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.useIntl)();
  const {
    0: authToken,
    1: setAuthToken
  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(undefined);
  const {
    user,
    revalidate
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .useUser */ .aF)(); // Effect that is triggered when the `authToken` comes back from the Plex OAuth
  // We take the token and attempt to login. If we get a success message, we will
  // ask swr to revalidate the user which _shouid_ come back with a valid user.

  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    const login = async () => {
      const response = await axios__WEBPACK_IMPORTED_MODULE_2__["default"].post('/api/v1/auth/plex', {
        authToken
      });

      if (response.data?.id) {
        revalidate();
      }
    };

    if (authToken) {
      login();
    }
  }, [authToken, revalidate]); // Effect that is triggered whenever `useUser`'s user changes. If we get a new
  // valid user, we call onComplete which will take us to the next step in Setup.

  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (user) {
      onComplete();
    }
  }, [user, onComplete]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("form", {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "mb-2 flex justify-center text-xl font-bold",
      children: intl.formatMessage(messages.welcome)
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "mb-2 flex justify-center pb-6 text-sm",
      children: intl.formatMessage(messages.signinMessage)
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "flex items-center justify-center",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_PlexLoginButton__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        onAuthToken: authToken => setAuthToken(authToken)
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoginWithPlex);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 57655:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);




const SetupSteps = ({
  stepNumber,
  description,
  active = false,
  completed = false,
  isLastStep = false
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("li", {
    className: "relative md:flex md:flex-1",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "flex items-center space-x-4 px-6 py-4 text-sm font-medium leading-5",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: `flex h-10 w-10 flex-shrink-0 items-center justify-center border-2
          ${active ? 'border-indigo-600 ' : 'border-white '}
          ${completed ? 'border-indigo-600 bg-indigo-600 ' : ''} rounded-full`,
        children: [completed && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__.CheckIcon, {
          className: "h-6 w-6 text-white"
        }), !completed && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("p", {
          className: active ? 'text-white' : 'text-indigo-200',
          children: stepNumber
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("p", {
        className: `text-sm font-medium leading-5 ${active ? 'text-white' : 'text-indigo-200'}`,
        children: description
      })]
    }), !isLastStep && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
      className: "absolute top-0 right-0 hidden h-full w-5 md:block",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("svg", {
        className: "h-full w-full text-gray-600",
        viewBox: "0 0 22 80",
        fill: "none",
        preserveAspectRatio: "none",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("path", {
          d: "M0 -2L20 40L0 82",
          vectorEffect: "non-scaling-stroke",
          stroke: "currentcolor",
          strokeLinejoin: "round"
        })
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SetupSteps);

/***/ }),

/***/ 55304:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_AppDataWarning__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22234);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19692);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Layout_LanguagePicker__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4551);
/* harmony import */ var _app_components_Settings_SettingsPlex__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28575);
/* harmony import */ var _app_components_Settings_SettingsServices__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(17004);
/* harmony import */ var _app_components_Setup_LoginWithPlex__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(58269);
/* harmony import */ var _app_components_Setup_SetupSteps__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(57655);
/* harmony import */ var _app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(84541);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(99648);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_AppDataWarning__WEBPACK_IMPORTED_MODULE_0__, _app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_3__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__, _app_components_Layout_LanguagePicker__WEBPACK_IMPORTED_MODULE_5__, _app_components_Settings_SettingsPlex__WEBPACK_IMPORTED_MODULE_6__, _app_components_Settings_SettingsServices__WEBPACK_IMPORTED_MODULE_7__, _app_components_Setup_LoginWithPlex__WEBPACK_IMPORTED_MODULE_8__, axios__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_15__]);
([_app_components_AppDataWarning__WEBPACK_IMPORTED_MODULE_0__, _app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_3__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__, _app_components_Layout_LanguagePicker__WEBPACK_IMPORTED_MODULE_5__, _app_components_Settings_SettingsPlex__WEBPACK_IMPORTED_MODULE_6__, _app_components_Settings_SettingsServices__WEBPACK_IMPORTED_MODULE_7__, _app_components_Setup_LoginWithPlex__WEBPACK_IMPORTED_MODULE_8__, axios__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_14__.defineMessages)({
  setup: {
    "id": "components.Setup.setup",
    "defaultMessage": 'Setup'
  },
  finish: {
    "id": "components.Setup.finish",
    "defaultMessage": 'Finish Setup'
  },
  finishing: {
    "id": "components.Setup.finishing",
    "defaultMessage": 'Finishing…'
  },
  continue: {
    "id": "components.Setup.continue",
    "defaultMessage": 'Continue'
  },
  loginwithplex: {
    "id": "components.Setup.loginwithplex",
    "defaultMessage": 'Sign in with Plex'
  },
  configureplex: {
    "id": "components.Setup.configureplex",
    "defaultMessage": 'Configure Plex'
  },
  configureservices: {
    "id": "components.Setup.configureservices",
    "defaultMessage": 'Configure Services'
  },
  tip: {
    "id": "components.Setup.tip",
    "defaultMessage": 'Tip'
  },
  scanbackground: {
    "id": "components.Setup.scanbackground",
    "defaultMessage": 'Scanning will run in the background. You can continue the setup process in the meantime.'
  }
});

const Setup = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_14__.useIntl)();
  const {
    0: isUpdating,
    1: setIsUpdating
  } = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)(false);
  const {
    0: currentStep,
    1: setCurrentStep
  } = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)(1);
  const {
    0: plexSettingsComplete,
    1: setPlexSettingsComplete
  } = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)(false);
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_12__.useRouter)();
  const {
    locale
  } = (0,_app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z)();

  const finishSetup = async () => {
    setIsUpdating(true);
    const response = await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post('/api/v1/settings/initialize');
    setIsUpdating(false);

    if (response.data.initialized) {
      await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post('/api/v1/settings/main', {
        locale
      });
      (0,swr__WEBPACK_IMPORTED_MODULE_15__.mutate)('/api/v1/settings/public');
      router.push('/');
    }
  };

  const {
    data: backdrops
  } = (0,swr__WEBPACK_IMPORTED_MODULE_15__["default"])('/api/v1/backdrops', {
    refreshInterval: 0,
    refreshWhenHidden: false,
    revalidateOnFocus: false
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
    className: "relative flex min-h-screen flex-col justify-center bg-gray-900 py-12",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      title: intl.formatMessage(messages.setup)
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      backgroundImages: backdrops?.map(backdrop => `https://image.tmdb.org/t/p/original${backdrop}`) ?? []
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
      className: "absolute top-4 right-4 z-50",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Layout_LanguagePicker__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
      className: "relative z-40 px-4 sm:mx-auto sm:w-full sm:max-w-4xl",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("img", {
        src: "/logo_stacked.svg",
        className: "mb-10 max-w-full sm:mx-auto sm:max-w-md",
        alt: "Logo"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_AppDataWarning__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("nav", {
        className: "relative z-50",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("ul", {
          className: "divide-y divide-gray-600 rounded-md border border-gray-600 bg-gray-800 bg-opacity-50 md:flex md:divide-y-0",
          style: {
            backdropFilter: 'blur(5px)'
          },
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Setup_SetupSteps__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
            stepNumber: 1,
            description: intl.formatMessage(messages.loginwithplex),
            active: currentStep === 1,
            completed: currentStep > 1
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Setup_SetupSteps__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
            stepNumber: 2,
            description: intl.formatMessage(messages.configureplex),
            active: currentStep === 2,
            completed: currentStep > 2
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Setup_SetupSteps__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
            stepNumber: 3,
            description: intl.formatMessage(messages.configureservices),
            active: currentStep === 3,
            isLastStep: true
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
        className: "mt-10 w-full rounded-md border border-gray-600 bg-gray-800 bg-opacity-50 p-4 text-white",
        children: [currentStep === 1 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Setup_LoginWithPlex__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
          onComplete: () => setCurrentStep(2)
        }), currentStep === 2 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Settings_SettingsPlex__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
            onComplete: () => setPlexSettingsComplete(true)
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
            className: "mt-4 text-sm text-gray-500",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
              className: "mr-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                children: intl.formatMessage(messages.tip)
              })
            }), intl.formatMessage(messages.scanbackground)]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
            className: "actions",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
              className: "flex justify-end",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                className: "ml-3 inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                  buttonType: "primary",
                  disabled: !plexSettingsComplete,
                  onClick: () => setCurrentStep(3),
                  children: intl.formatMessage(messages.continue)
                })
              })
            })
          })]
        }), currentStep === 3 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Settings_SettingsServices__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
            className: "actions",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
              className: "flex justify-end",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                className: "ml-3 inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                  buttonType: "primary",
                  onClick: () => finishSetup(),
                  disabled: isUpdating,
                  children: isUpdating ? intl.formatMessage(messages.finishing) : intl.formatMessage(messages.finish)
                })
              })
            })
          })]
        })]
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Setup);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 62309:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Setup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55304);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Setup__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_Setup__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const SetupPage = () => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_app_components_Setup__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {});
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SetupPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 92793:
/***/ ((module) => {

module.exports = require("bowser");

/***/ }),

/***/ 2296:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 46517:
/***/ ((module) => {

module.exports = require("lodash");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 66405:
/***/ ((module) => {

module.exports = require("react-dom");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 30616:
/***/ ((module) => {

module.exports = require("react-popper-tooltip");

/***/ }),

/***/ 61929:
/***/ ((module) => {

module.exports = require("react-select");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 75609:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,1388,61439,19998,80210,86799,13555,99073,7292,22796,63145,61903,84541,19692,75294,4551,17004,28575,77867], () => (__webpack_exec__(62309)));
module.exports = __webpack_exports__;

})();