"use strict";
(() => {
var exports = {};
exports.id = 62892;
exports.ids = [62892];
exports.modules = {

/***/ 76631:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);



const Header = ({
  children,
  extraMargin = 0,
  subtext
}) => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    className: "mt-8 md:flex md:items-center md:justify-between",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: `min-w-0 flex-1 mx-${extraMargin}`,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
        className: "mb-4 truncate text-2xl font-bold leading-7 text-gray-100 sm:overflow-visible sm:text-4xl sm:leading-9 md:mb-0",
        "data-testid": "page-header",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
          className: "text-overseerr",
          children: children
        })
      }), subtext && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "mt-2 text-gray-400",
        children: subtext
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 23810:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22796);
/* harmony import */ var _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33181);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80210);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__, _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_4__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__, _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.defineMessages)({
  userssaved: {
    "id": "components.UserList.userssaved",
    "defaultMessage": 'User permissions saved successfully!'
  },
  userfail: {
    "id": "components.UserList.userfail",
    "defaultMessage": 'Something went wrong while saving user permissions.'
  },
  edituser: {
    "id": "components.UserList.edituser",
    "defaultMessage": 'Edit User Permissions'
  }
});

const BulkEditModal = ({
  selectedUserIds,
  users,
  onCancel,
  onComplete,
  onSaving
}) => {
  const {
    user: currentUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .useUser */ .aF)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_7__.useToasts)();
  const {
    0: currentPermission,
    1: setCurrentPermission
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(0);
  const {
    0: isSaving,
    1: setIsSaving
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (onSaving) {
      onSaving(isSaving);
    }
  }, [isSaving, onSaving]);

  const updateUsers = async () => {
    try {
      setIsSaving(true);
      const {
        data: updated
      } = await axios__WEBPACK_IMPORTED_MODULE_4__["default"].put(`/api/v1/user`, {
        ids: selectedUserIds,
        permissions: currentPermission
      });

      if (onComplete) {
        onComplete(updated);
      }

      addToast(intl.formatMessage(messages.userssaved), {
        appearance: 'success',
        autoDismiss: true
      });
    } catch (e) {
      addToast(intl.formatMessage(messages.userfail), {
        appearance: 'error',
        autoDismiss: true
      });
    } finally {
      setIsSaving(false);
    }
  };

  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (users) {
      const selectedUsers = users.filter(u => selectedUserIds.includes(u.id));
      const {
        permissions: allPermissionsEqual
      } = selectedUsers.reduce(({
        permissions: aPerms
      }, {
        permissions: bPerms
      }) => {
        return {
          permissions: aPerms === bPerms ? aPerms : NaN
        };
      }, {
        permissions: selectedUsers[0].permissions
      });

      if (allPermissionsEqual) {
        setCurrentPermission(allPermissionsEqual);
      }
    }
  }, [users, selectedUserIds]);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
    title: intl.formatMessage(messages.edituser),
    onOk: () => {
      updateUsers();
    },
    okDisabled: isSaving,
    okText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].save */ .Z.save),
    onCancel: onCancel,
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("div", {
      className: "mb-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .ZP, {
        actingUser: currentUser,
        currentPermission: currentPermission,
        onUpdate: newPermission => setCurrentPermission(newPermission)
      })
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BulkEditModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 94830:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22796);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1388);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80210);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99648);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_4__, swr__WEBPACK_IMPORTED_MODULE_8__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_4__, swr__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);












const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.defineMessages)({
  importfromplex: {
    "id": "components.UserList.importfromplex",
    "defaultMessage": 'Import Plex Users'
  },
  importfromplexerror: {
    "id": "components.UserList.importfromplexerror",
    "defaultMessage": 'Something went wrong while importing Plex users.'
  },
  importedfromplex: {
    "id": "components.UserList.importedfromplex",
    "defaultMessage": '<strong>{userCount}</strong> Plex {userCount, plural, one {user} other {users}} imported successfully!'
  },
  user: {
    "id": "components.UserList.user",
    "defaultMessage": 'User'
  },
  nouserstoimport: {
    "id": "components.UserList.nouserstoimport",
    "defaultMessage": 'There are no Plex users to import.'
  },
  newplexsigninenabled: {
    "id": "components.UserList.newplexsigninenabled",
    "defaultMessage": 'The <strong>Enable New Plex Sign-In</strong> setting is currently enabled. Plex users with library access do not need to be imported in order to sign in.'
  }
});

const PlexImportModal = ({
  onCancel,
  onComplete
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.useIntl)();
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_7__.useToasts)();
  const {
    0: isImporting,
    1: setImporting
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const {
    0: selectedUsers,
    1: setSelectedUsers
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)([]);
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_8__["default"])(`/api/v1/settings/plex/users`, {
    revalidateOnMount: true
  });

  const importUsers = async () => {
    setImporting(true);

    try {
      const {
        data: createdUsers
      } = await axios__WEBPACK_IMPORTED_MODULE_4__["default"].post('/api/v1/user/import-from-plex', {
        plexIds: selectedUsers
      });

      if (!createdUsers.length) {
        throw new Error('No users were imported from Plex.');
      }

      addToast(intl.formatMessage(messages.importedfromplex, {
        userCount: createdUsers.length,
        strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("strong", {
          children: msg
        })
      }), {
        autoDismiss: true,
        appearance: 'success'
      });

      if (onComplete) {
        onComplete();
      }
    } catch (e) {
      addToast(intl.formatMessage(messages.importfromplexerror), {
        autoDismiss: true,
        appearance: 'error'
      });
    } finally {
      setImporting(false);
    }
  };

  const isSelectedUser = plexId => selectedUsers.includes(plexId);

  const isAllUsers = () => selectedUsers.length === data?.length;

  const toggleUser = plexId => {
    if (selectedUsers.includes(plexId)) {
      setSelectedUsers(users => users.filter(user => user !== plexId));
    } else {
      setSelectedUsers(users => [...users, plexId]);
    }
  };

  const toggleAllUsers = () => {
    if (data && selectedUsers.length >= 0 && !isAllUsers()) {
      setSelectedUsers(data.map(user => user.id));
    } else {
      setSelectedUsers([]);
    }
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    loading: !data && !error,
    title: intl.formatMessage(messages.importfromplex),
    onOk: () => {
      importUsers();
    },
    okDisabled: isImporting || !selectedUsers.length,
    okText: intl.formatMessage(isImporting ? _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].importing */ .Z.importing : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"]["import"] */ .Z["import"]),
    onCancel: onCancel,
    children: data?.length ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
      children: [settings.currentSettings.newPlexLogin && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.newplexsigninenabled, {
          strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("strong", {
            className: "font-semibold text-white",
            children: msg
          })
        }),
        type: "info"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
        className: "flex flex-col",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
          className: "-mx-4 sm:mx-0",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
            className: "inline-block min-w-full py-2 align-middle",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
              className: "overflow-hidden shadow sm:rounded-lg",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("table", {
                className: "min-w-full",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("thead", {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("tr", {
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("th", {
                      className: "w-16 bg-gray-500 px-4 py-3",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("span", {
                        role: "checkbox",
                        tabIndex: 0,
                        "aria-checked": isAllUsers(),
                        onClick: () => toggleAllUsers(),
                        onKeyDown: e => {
                          if (e.key === 'Enter' || e.key === 'Space') {
                            toggleAllUsers();
                          }
                        },
                        className: "relative inline-flex h-5 w-10 flex-shrink-0 cursor-pointer items-center justify-center pt-2 focus:outline-none",
                        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                          "aria-hidden": "true",
                          className: `${isAllUsers() ? 'bg-indigo-500' : 'bg-gray-800'} absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out`
                        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                          "aria-hidden": "true",
                          className: `${isAllUsers() ? 'translate-x-5' : 'translate-x-0'} absolute left-0 inline-block h-5 w-5 rounded-full border border-gray-200 bg-white shadow transition-transform duration-200 ease-in-out group-focus:border-blue-300 group-focus:ring`
                        })]
                      })
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("th", {
                      className: "bg-gray-500 px-1 py-3 text-left text-xs font-medium uppercase leading-4 tracking-wider text-gray-200 md:px-6",
                      children: intl.formatMessage(messages.user)
                    })]
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("tbody", {
                  className: "divide-y divide-gray-700 bg-gray-600",
                  children: data?.map(user => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("tr", {
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("td", {
                      className: "whitespace-nowrap px-4 py-4 text-sm font-medium leading-5 text-gray-100",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("span", {
                        role: "checkbox",
                        tabIndex: 0,
                        "aria-checked": isSelectedUser(user.id),
                        onClick: () => toggleUser(user.id),
                        onKeyDown: e => {
                          if (e.key === 'Enter' || e.key === 'Space') {
                            toggleUser(user.id);
                          }
                        },
                        className: "relative inline-flex h-5 w-10 flex-shrink-0 cursor-pointer items-center justify-center pt-2 focus:outline-none",
                        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                          "aria-hidden": "true",
                          className: `${isSelectedUser(user.id) ? 'bg-indigo-500' : 'bg-gray-800'} absolute mx-auto h-4 w-9 rounded-full transition-colors duration-200 ease-in-out`
                        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                          "aria-hidden": "true",
                          className: `${isSelectedUser(user.id) ? 'translate-x-5' : 'translate-x-0'} absolute left-0 inline-block h-5 w-5 rounded-full border border-gray-200 bg-white shadow transition-transform duration-200 ease-in-out group-focus:border-blue-300 group-focus:ring`
                        })]
                      })
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("td", {
                      className: "whitespace-nowrap px-1 py-4 text-sm font-medium leading-5 text-gray-100 md:px-6",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                        className: "flex items-center",
                        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("img", {
                          className: "h-10 w-10 flex-shrink-0 rounded-full",
                          src: user.thumb,
                          alt: ""
                        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                          className: "ml-4",
                          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                            className: "text-base font-bold leading-5",
                            children: user.username
                          }), user.username && user.username.toLowerCase() !== user.email && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                            className: "text-sm leading-5 text-gray-300",
                            children: user.email
                          })]
                        })]
                      })
                    })]
                  }, `user-${user.id}`))
                })]
              })
            })
          })
        })
      })]
    }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      title: intl.formatMessage(messages.nouserstoimport),
      type: "info"
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PlexImportModal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 85038:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_Header__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(76631);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22796);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(61903);
/* harmony import */ var _app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31645);
/* harmony import */ var _app_components_UserList_BulkEditModal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(23810);
/* harmony import */ var _app_components_UserList_PlexImportModal__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(94830);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(27208);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(80210);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _server_lib_permissions__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(44941);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_5__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_6__, _app_components_UserList_BulkEditModal__WEBPACK_IMPORTED_MODULE_9__, _app_components_UserList_PlexImportModal__WEBPACK_IMPORTED_MODULE_10__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_11__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__, _headlessui_react__WEBPACK_IMPORTED_MODULE_15__, axios__WEBPACK_IMPORTED_MODULE_18__, swr__WEBPACK_IMPORTED_MODULE_25__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_5__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_6__, _app_components_UserList_BulkEditModal__WEBPACK_IMPORTED_MODULE_9__, _app_components_UserList_PlexImportModal__WEBPACK_IMPORTED_MODULE_10__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_11__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__, _headlessui_react__WEBPACK_IMPORTED_MODULE_15__, axios__WEBPACK_IMPORTED_MODULE_18__, swr__WEBPACK_IMPORTED_MODULE_25__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






























const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_23__.defineMessages)({
  users: {
    "id": "components.UserList.users",
    "defaultMessage": 'Users'
  },
  userlist: {
    "id": "components.UserList.userlist",
    "defaultMessage": 'User List'
  },
  importfromplex: {
    "id": "components.UserList.importfromplex",
    "defaultMessage": 'Import Plex Users'
  },
  user: {
    "id": "components.UserList.user",
    "defaultMessage": 'User'
  },
  totalrequests: {
    "id": "components.UserList.totalrequests",
    "defaultMessage": 'Requests'
  },
  accounttype: {
    "id": "components.UserList.accounttype",
    "defaultMessage": 'Type'
  },
  role: {
    "id": "components.UserList.role",
    "defaultMessage": 'Role'
  },
  created: {
    "id": "components.UserList.created",
    "defaultMessage": 'Joined'
  },
  bulkedit: {
    "id": "components.UserList.bulkedit",
    "defaultMessage": 'Bulk Edit'
  },
  owner: {
    "id": "components.UserList.owner",
    "defaultMessage": 'Owner'
  },
  admin: {
    "id": "components.UserList.admin",
    "defaultMessage": 'Admin'
  },
  plexuser: {
    "id": "components.UserList.plexuser",
    "defaultMessage": 'Plex User'
  },
  deleteuser: {
    "id": "components.UserList.deleteuser",
    "defaultMessage": 'Delete User'
  },
  userdeleted: {
    "id": "components.UserList.userdeleted",
    "defaultMessage": 'User deleted successfully!'
  },
  userdeleteerror: {
    "id": "components.UserList.userdeleteerror",
    "defaultMessage": 'Something went wrong while deleting the user.'
  },
  deleteconfirm: {
    "id": "components.UserList.deleteconfirm",
    "defaultMessage": 'Are you sure you want to delete this user? All of their request data will be permanently removed.'
  },
  localuser: {
    "id": "components.UserList.localuser",
    "defaultMessage": 'Local User'
  },
  createlocaluser: {
    "id": "components.UserList.createlocaluser",
    "defaultMessage": 'Create Local User'
  },
  creating: {
    "id": "components.UserList.creating",
    "defaultMessage": 'Creating…'
  },
  create: {
    "id": "components.UserList.create",
    "defaultMessage": 'Create'
  },
  validationpasswordminchars: {
    "id": "components.UserList.validationpasswordminchars",
    "defaultMessage": 'Password is too short; should be a minimum of 8 characters'
  },
  usercreatedfailed: {
    "id": "components.UserList.usercreatedfailed",
    "defaultMessage": 'Something went wrong while creating the user.'
  },
  usercreatedfailedexisting: {
    "id": "components.UserList.usercreatedfailedexisting",
    "defaultMessage": 'The provided email address is already in use by another user.'
  },
  usercreatedsuccess: {
    "id": "components.UserList.usercreatedsuccess",
    "defaultMessage": 'User created successfully!'
  },
  displayName: {
    "id": "components.UserList.displayName",
    "defaultMessage": 'Display Name'
  },
  email: {
    "id": "components.UserList.email",
    "defaultMessage": 'Email Address'
  },
  password: {
    "id": "components.UserList.password",
    "defaultMessage": 'Password'
  },
  passwordinfodescription: {
    "id": "components.UserList.passwordinfodescription",
    "defaultMessage": 'Configure an application URL and enable email notifications to allow automatic password generation.'
  },
  autogeneratepassword: {
    "id": "components.UserList.autogeneratepassword",
    "defaultMessage": 'Automatically Generate Password'
  },
  autogeneratepasswordTip: {
    "id": "components.UserList.autogeneratepasswordTip",
    "defaultMessage": 'Email a server-generated password to the user'
  },
  validationEmail: {
    "id": "components.UserList.validationEmail",
    "defaultMessage": 'You must provide a valid email address'
  },
  sortCreated: {
    "id": "components.UserList.sortCreated",
    "defaultMessage": 'Join Date'
  },
  sortDisplayName: {
    "id": "components.UserList.sortDisplayName",
    "defaultMessage": 'Display Name'
  },
  sortRequests: {
    "id": "components.UserList.sortRequests",
    "defaultMessage": 'Request Count'
  },
  localLoginDisabled: {
    "id": "components.UserList.localLoginDisabled",
    "defaultMessage": 'The <strong>Enable Local Sign-In</strong> setting is currently disabled.'
  }
});

const UserList = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_23__.useIntl)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_21__.useRouter)();
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_24__.useToasts)();
  const {
    user: currentUser,
    hasPermission: currentHasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__/* .useUser */ .aF)();
  const {
    0: currentSort,
    1: setCurrentSort
  } = (0,react__WEBPACK_IMPORTED_MODULE_22__.useState)('displayname');
  const {
    0: currentPageSize,
    1: setCurrentPageSize
  } = (0,react__WEBPACK_IMPORTED_MODULE_22__.useState)(10);
  const page = router.query.page ? Number(router.query.page) : 1;
  const pageIndex = page - 1;
  const updateQueryParams = (0,_app_hooks_useUpdateQueryParams__WEBPACK_IMPORTED_MODULE_12__/* .useUpdateQueryParams */ .BA)({
    page: page.toString()
  });
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_25__["default"])(`/api/v1/user?take=${currentPageSize}&skip=${pageIndex * currentPageSize}&sort=${currentSort}`);
  const {
    0: isDeleting,
    1: setDeleting
  } = (0,react__WEBPACK_IMPORTED_MODULE_22__.useState)(false);
  const {
    0: showImportModal,
    1: setShowImportModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_22__.useState)(false);
  const {
    0: deleteModal,
    1: setDeleteModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_22__.useState)({
    isOpen: false
  });
  const {
    0: createModal,
    1: setCreateModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_22__.useState)({
    isOpen: false
  });
  const {
    0: showBulkEditModal,
    1: setShowBulkEditModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_22__.useState)(false);
  const {
    0: selectedUsers,
    1: setSelectedUsers
  } = (0,react__WEBPACK_IMPORTED_MODULE_22__.useState)([]);
  (0,react__WEBPACK_IMPORTED_MODULE_22__.useEffect)(() => {
    const filterString = window.localStorage.getItem('ul-filter-settings');

    if (filterString) {
      const filterSettings = JSON.parse(filterString);
      setCurrentSort(filterSettings.currentSort);
      setCurrentPageSize(filterSettings.currentPageSize);
    }
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_22__.useEffect)(() => {
    window.localStorage.setItem('ul-filter-settings', JSON.stringify({
      currentSort,
      currentPageSize
    }));
  }, [currentSort, currentPageSize]);

  const isUserPermsEditable = userId => userId !== 1 && userId !== currentUser?.id;

  const isAllUsersSelected = () => {
    return selectedUsers.length === data?.results.filter(user => user.id !== currentUser?.id).length;
  };

  const isUserSelected = userId => selectedUsers.includes(userId);

  const toggleAllUsers = () => {
    if (data && selectedUsers.length >= 0 && selectedUsers.length < data?.results.length - 1) {
      setSelectedUsers(data.results.filter(user => isUserPermsEditable(user.id)).map(u => u.id));
    } else {
      setSelectedUsers([]);
    }
  };

  const toggleUser = userId => {
    if (selectedUsers.includes(userId)) {
      setSelectedUsers(users => users.filter(u => u !== userId));
    } else {
      setSelectedUsers(users => [...users, userId]);
    }
  };

  const deleteUser = async () => {
    setDeleting(true);

    try {
      await axios__WEBPACK_IMPORTED_MODULE_18__["default"]["delete"](`/api/v1/user/${deleteModal.user?.id}`);
      addToast(intl.formatMessage(messages.userdeleted), {
        autoDismiss: true,
        appearance: 'success'
      });
      setDeleteModal({
        isOpen: false,
        user: deleteModal.user
      });
    } catch (e) {
      addToast(intl.formatMessage(messages.userdeleteerror), {
        autoDismiss: true,
        appearance: 'error'
      });
    } finally {
      setDeleting(false);
      revalidate();
    }
  };

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {});
  }

  const CreateUserSchema = yup__WEBPACK_IMPORTED_MODULE_26__.object().shape({
    email: yup__WEBPACK_IMPORTED_MODULE_26__.string().required(intl.formatMessage(messages.validationEmail)).email(intl.formatMessage(messages.validationEmail)),
    password: yup__WEBPACK_IMPORTED_MODULE_26__.lazy(value => !value ? yup__WEBPACK_IMPORTED_MODULE_26__.string() : yup__WEBPACK_IMPORTED_MODULE_26__.string().min(8, intl.formatMessage(messages.validationpasswordminchars)))
  });

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {});
  }

  const hasNextPage = data.pageInfo.pages > pageIndex + 1;
  const hasPrevPage = pageIndex > 0;
  const passwordGenerationEnabled = settings.currentSettings.applicationUrl && settings.currentSettings.emailEnabled;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
      title: intl.formatMessage(messages.users)
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_15__.Transition, {
      as: "div",
      enter: "transition-opacity duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      show: deleteModal.isOpen,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        onOk: () => deleteUser(),
        okText: isDeleting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__/* ["default"].deleting */ .Z.deleting) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__/* ["default"]["delete"] */ .Z["delete"]),
        okDisabled: isDeleting,
        okButtonType: "danger",
        onCancel: () => setDeleteModal({
          isOpen: false,
          user: deleteModal.user
        }),
        title: intl.formatMessage(messages.deleteuser),
        subTitle: deleteModal.user?.displayName,
        children: intl.formatMessage(messages.deleteconfirm)
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_15__.Transition, {
      as: "div",
      enter: "transition-opacity duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      show: createModal.isOpen,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(formik__WEBPACK_IMPORTED_MODULE_19__.Formik, {
        initialValues: {
          displayName: '',
          email: '',
          password: '',
          genpassword: false
        },
        validationSchema: CreateUserSchema,
        onSubmit: async values => {
          try {
            await axios__WEBPACK_IMPORTED_MODULE_18__["default"].post('/api/v1/user', {
              username: values.displayName,
              email: values.email,
              password: values.genpassword ? null : values.password
            });
            addToast(intl.formatMessage(messages.usercreatedsuccess), {
              appearance: 'success',
              autoDismiss: true
            });
            setCreateModal({
              isOpen: false
            });
          } catch (e) {
            addToast(intl.formatMessage(e.response.data.errors?.includes('USER_EXISTS') ? messages.usercreatedfailedexisting : messages.usercreatedfailed), {
              appearance: 'error',
              autoDismiss: true
            });
          } finally {
            revalidate();
          }
        },
        children: ({
          errors,
          touched,
          isSubmitting,
          values,
          isValid,
          setFieldValue,
          handleSubmit
        }) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
            title: intl.formatMessage(messages.createlocaluser),
            onOk: () => handleSubmit(),
            okText: isSubmitting ? intl.formatMessage(messages.creating) : intl.formatMessage(messages.create),
            okDisabled: isSubmitting || !isValid,
            okButtonType: "primary",
            onCancel: () => setCreateModal({
              isOpen: false
            }),
            children: [!settings.currentSettings.localLogin && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
              title: intl.formatMessage(messages.localLoginDisabled, {
                strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("strong", {
                  className: "font-semibold text-white",
                  children: msg
                })
              }),
              type: "warning"
            }), currentHasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__/* .Permission.ADMIN */ .y3.ADMIN) && !passwordGenerationEnabled && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
              title: intl.formatMessage(messages.passwordinfodescription),
              type: "info"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_19__.Form, {
              className: "section",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
                className: "form-row",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("label", {
                  htmlFor: "displayName",
                  className: "text-label",
                  children: intl.formatMessage(messages.displayName)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                  className: "form-input-area",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                    className: "form-input-field",
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(formik__WEBPACK_IMPORTED_MODULE_19__.Field, {
                      id: "displayName",
                      name: "displayName",
                      type: "text"
                    })
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
                className: "form-row",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("label", {
                  htmlFor: "email",
                  className: "text-label",
                  children: [intl.formatMessage(messages.email), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
                    className: "label-required",
                    children: "*"
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
                  className: "form-input-area",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                    className: "form-input-field",
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(formik__WEBPACK_IMPORTED_MODULE_19__.Field, {
                      id: "email",
                      name: "email",
                      type: "text",
                      inputMode: "email",
                      autoComplete: "off",
                      "data-1pignore": "true",
                      "data-lpignore": "true",
                      "data-bwignore": "true"
                    })
                  }), errors.email && touched.email && typeof errors.email === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                    className: "error",
                    children: errors.email
                  })]
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
                className: `form-row ${passwordGenerationEnabled ? '' : 'opacity-50'}`,
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("label", {
                  htmlFor: "genpassword",
                  className: "checkbox-label",
                  children: [intl.formatMessage(messages.autogeneratepassword), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
                    className: "label-tip",
                    children: intl.formatMessage(messages.autogeneratepasswordTip)
                  })]
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                  className: "form-input-area",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(formik__WEBPACK_IMPORTED_MODULE_19__.Field, {
                    type: "checkbox",
                    id: "genpassword",
                    name: "genpassword",
                    disabled: !passwordGenerationEnabled,
                    onClick: () => setFieldValue('password', '')
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
                className: `form-row ${values.genpassword ? 'opacity-50' : ''}`,
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("label", {
                  htmlFor: "password",
                  className: "text-label",
                  children: [intl.formatMessage(messages.password), !values.genpassword && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
                    className: "label-required",
                    children: "*"
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
                  className: "form-input-area",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                    className: "form-input-field",
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                      as: "field",
                      id: "password",
                      name: "password",
                      type: "password",
                      autoComplete: "new-password",
                      disabled: values.genpassword
                    })
                  }), errors.password && touched.password && typeof errors.password === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                    className: "error",
                    children: errors.password
                  })]
                })]
              })]
            })]
          });
        }
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_15__.Transition, {
      as: "div",
      enter: "transition-opacity duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      show: showBulkEditModal,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_UserList_BulkEditModal__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
        onCancel: () => setShowBulkEditModal(false),
        onComplete: () => {
          setShowBulkEditModal(false);
          revalidate();
        },
        selectedUserIds: selectedUsers,
        users: data.results
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_15__.Transition, {
      as: "div",
      enter: "transition-opacity duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      show: showImportModal,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_UserList_PlexImportModal__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
        onCancel: () => setShowImportModal(false),
        onComplete: () => {
          setShowImportModal(false);
          revalidate();
        }
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
      className: "flex flex-col justify-between lg:flex-row lg:items-end",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Header__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        children: intl.formatMessage(messages.userlist)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
        className: "mt-2 flex flex-grow flex-col lg:flex-grow-0 lg:flex-row",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
          className: "mb-2 flex flex-grow flex-col justify-between sm:flex-row lg:mb-0 lg:flex-grow-0",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
            className: "mb-2 flex-grow sm:mb-0 sm:mr-2",
            buttonType: "primary",
            onClick: () => setCreateModal({
              isOpen: true
            }),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16__.UserPlusIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
              children: intl.formatMessage(messages.createlocaluser)
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
            className: "flex-grow lg:mr-2",
            buttonType: "primary",
            onClick: () => setShowImportModal(true),
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16__.InboxArrowDownIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
              children: intl.formatMessage(messages.importfromplex)
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
          className: "mb-2 flex flex-grow lg:mb-0 lg:flex-grow-0",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
            className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-sm text-gray-100",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16__.BarsArrowDownIcon, {
              className: "h-6 w-6"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("select", {
            id: "sort",
            name: "sort",
            onChange: e => {
              setCurrentSort(e.target.value);
              router.push(router.pathname);
            },
            value: currentSort,
            className: "rounded-r-only",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("option", {
              value: "created",
              children: intl.formatMessage(messages.sortCreated)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("option", {
              value: "requests",
              children: intl.formatMessage(messages.sortRequests)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("option", {
              value: "displayname",
              children: intl.formatMessage(messages.sortDisplayName)
            })]
          })]
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("thead", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("tr", {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TH */ .Z.TH, {
            children: (data.results ?? []).length > 1 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("input", {
              type: "checkbox",
              id: "selectAll",
              name: "selectAll",
              checked: isAllUsersSelected(),
              onChange: () => {
                toggleAllUsers();
              }
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TH */ .Z.TH, {
            children: intl.formatMessage(messages.user)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TH */ .Z.TH, {
            children: intl.formatMessage(messages.totalrequests)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TH */ .Z.TH, {
            children: intl.formatMessage(messages.accounttype)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TH */ .Z.TH, {
            children: intl.formatMessage(messages.role)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TH */ .Z.TH, {
            children: intl.formatMessage(messages.created)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TH */ .Z.TH, {
            className: "text-right",
            children: (data.results ?? []).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
              buttonType: "warning",
              onClick: () => setShowBulkEditModal(true),
              disabled: selectedUsers.length === 0,
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16__.PencilIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
                children: intl.formatMessage(messages.bulkedit)
              })]
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TBody */ .Z.TBody, {
        children: [data?.results.map(user => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("tr", {
          "data-testid": "user-list-row",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TD */ .Z.TD, {
            children: isUserPermsEditable(user.id) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("input", {
              type: "checkbox",
              id: `user-list-select-${user.id}`,
              name: `user-list-select-${user.id}`,
              checked: isUserSelected(user.id),
              onChange: () => {
                toggleUser(user.id);
              }
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TD */ .Z.TD, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
              className: "flex items-center",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx((next_link__WEBPACK_IMPORTED_MODULE_20___default()), {
                href: `/users/${user.id}`,
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("a", {
                  className: "h-10 w-10 flex-shrink-0",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("img", {
                    className: "h-10 w-10 rounded-full object-cover",
                    src: user.avatar,
                    alt: ""
                  })
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
                className: "ml-4",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx((next_link__WEBPACK_IMPORTED_MODULE_20___default()), {
                  href: `/users/${user.id}`,
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("a", {
                    className: "text-base font-bold leading-5 transition duration-300 hover:underline",
                    "data-testid": "user-list-username-link",
                    children: user.displayName
                  })
                }), user.displayName.toLowerCase() !== user.email && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                  className: "text-sm leading-5 text-gray-300",
                  children: user.email
                })]
              })]
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TD */ .Z.TD, {
            children: user.id === currentUser?.id || currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__/* .Permission.REQUEST_VIEW */ .y3.REQUEST_VIEW], {
              type: 'or'
            }) ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx((next_link__WEBPACK_IMPORTED_MODULE_20___default()), {
              href: `/users/${user.id}/requests`,
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("a", {
                className: "text-sm leading-5 transition duration-300 hover:underline",
                children: user.requestCount
              })
            }) : user.requestCount
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TD */ .Z.TD, {
            children: user.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__/* .UserType.PLEX */ .FW.PLEX ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              badgeType: "warning",
              children: intl.formatMessage(messages.plexuser)
            }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              badgeType: "default",
              children: intl.formatMessage(messages.localuser)
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TD */ .Z.TD, {
            children: user.id === 1 ? intl.formatMessage(messages.owner) : (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_17__/* .hasPermission */ .F)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__/* .Permission.ADMIN */ .y3.ADMIN, user.permissions) ? intl.formatMessage(messages.admin) : intl.formatMessage(messages.user)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TD */ .Z.TD, {
            children: intl.formatDate(user.createdAt, {
              year: 'numeric',
              month: 'long',
              day: 'numeric'
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TD */ .Z.TD, {
            alignText: "right",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
              buttonType: "warning",
              disabled: user.id === 1 && currentUser?.id !== 1,
              className: "mr-2",
              onClick: () => router.push('/users/[userId]/settings', `/users/${user.id}/settings`),
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__/* ["default"].edit */ .Z.edit)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
              buttonType: "danger",
              disabled: user.id === 1 || currentUser?.id !== 1 && (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_17__/* .hasPermission */ .F)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_13__/* .Permission.ADMIN */ .y3.ADMIN, user.permissions),
              onClick: () => setDeleteModal({
                isOpen: true,
                user
              }),
              children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__/* ["default"]["delete"] */ .Z["delete"])
            })]
          })]
        }, `user-list-${user.id}`)), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("tr", {
          className: "bg-gray-700",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_app_components_Common_Table__WEBPACK_IMPORTED_MODULE_8__/* ["default"].TD */ .Z.TD, {
            colSpan: 8,
            noPadding: true,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("nav", {
              className: "flex w-screen flex-col items-center space-x-4 space-y-3 px-6 py-3 sm:flex-row sm:space-y-0 lg:w-full",
              "aria-label": "Pagination",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                className: "hidden lg:flex lg:flex-1",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("p", {
                  className: "text-sm",
                  children: data.results.length > 0 && intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__/* ["default"].showingresults */ .Z.showingresults, {
                    from: pageIndex * currentPageSize + 1,
                    to: data.results.length < currentPageSize ? pageIndex * currentPageSize + data.results.length : (pageIndex + 1) * currentPageSize,
                    total: data.pageInfo.results,
                    strong: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
                      className: "font-medium",
                      children: msg
                    })
                  })
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
                className: "flex justify-center sm:flex-1 sm:justify-start lg:justify-center",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
                  className: "-mt-3 items-center text-sm sm:-ml-4 sm:mt-0 lg:ml-0",
                  children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__/* ["default"].resultsperpage */ .Z.resultsperpage, {
                    pageSize: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("select", {
                      id: "pageSize",
                      name: "pageSize",
                      onChange: e => {
                        setCurrentPageSize(Number(e.target.value));
                        router.push(router.pathname).then(() => window.scrollTo(0, 0));
                      },
                      value: currentPageSize,
                      className: "short inline",
                      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("option", {
                        value: "5",
                        children: "5"
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("option", {
                        value: "10",
                        children: "10"
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("option", {
                        value: "25",
                        children: "25"
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("option", {
                        value: "50",
                        children: "50"
                      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("option", {
                        value: "100",
                        children: "100"
                      })]
                    })
                  })
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
                className: "flex flex-auto justify-center space-x-2 sm:flex-1 sm:justify-end",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                  disabled: !hasPrevPage,
                  onClick: () => updateQueryParams('page', (page - 1).toString()),
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16__.ChevronLeftIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
                    children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__/* ["default"].previous */ .Z.previous)
                  })]
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                  disabled: !hasNextPage,
                  onClick: () => updateQueryParams('page', (page + 1).toString()),
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("span", {
                    children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_14__/* ["default"].next */ .Z.next)
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_16__.ChevronRightIcon, {})]
                })]
              })]
            })
          })
        })]
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserList);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 75691:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _useUser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86799);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_useUser__WEBPACK_IMPORTED_MODULE_2__]);
_useUser__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const useRouteGuard = (permission, options) => {
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
  const {
    user,
    hasPermission
  } = (0,_useUser__WEBPACK_IMPORTED_MODULE_2__/* .useUser */ .aF)();
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (user && !hasPermission(permission, options)) {
      router.push('/');
    }
  }, [user, permission, router, hasPermission, options]);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useRouteGuard);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 15534:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_UserList__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85038);
/* harmony import */ var _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75691);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86799);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_UserList__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__]);
([_app_components_UserList__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const UsersPage = () => {
  (0,_app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_2__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_UserList__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {});
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UsersPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 2296:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 66405:
/***/ ((module) => {

module.exports = require("react-dom");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 75609:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,1388,61439,19998,80210,86799,13555,99073,7292,22796,61903,27208,33181,31645], () => (__webpack_exec__(15534)));
module.exports = __webpack_exports__;

})();