"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRepository = void 0;
require("reflect-metadata");
const typeorm_1 = require("typeorm");
const devConfig = {
    type: 'sqlite',
    database: process.env.CONFIG_DIRECTORY
        ? `${process.env.CONFIG_DIRECTORY}/db/db.sqlite3`
        : 'config/db/db.sqlite3',
    synchronize: true,
    migrationsRun: false,
    logging: false,
    enableWAL: true,
    entities: ['server/entity/**/*.ts'],
    migrations: ['server/migration/**/*.ts'],
    subscribers: ['server/subscriber/**/*.ts'],
};
const prodConfig = {
    type: 'sqlite',
    database: process.env.CONFIG_DIRECTORY
        ? `${process.env.CONFIG_DIRECTORY}/db/db.sqlite3`
        : 'config/db/db.sqlite3',
    synchronize: false,
    migrationsRun: false,
    logging: false,
    enableWAL: true,
    entities: ['dist/entity/**/*.js'],
    migrations: ['dist/migration/**/*.js'],
    subscribers: ['dist/subscriber/**/*.js'],
};
const dataSource = new typeorm_1.DataSource(process.env.NODE_ENV !== 'production' ? devConfig : prodConfig);
const getRepository = (target) => {
    return dataSource.getRepository(target);
};
exports.getRepository = getRepository;
exports.default = dataSource;
