"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
const media_1 = require("../constants/media");
const datasource_1 = require("../datasource");
const typeorm_1 = require("typeorm");
const MediaRequest_1 = require("./MediaRequest");
let SeasonRequest = class SeasonRequest {
    constructor(init) {
        Object.assign(this, init);
    }
    async handleRemoveParent() {
        const mediaRequestRepository = (0, datasource_1.getRepository)(MediaRequest_1.MediaRequest);
        const requestToBeDeleted = await mediaRequestRepository.findOneOrFail({
            where: { id: this.request.id },
        });
        if (requestToBeDeleted.seasons.length === 0) {
            await mediaRequestRepository.delete({ id: this.request.id });
        }
    }
};
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], SeasonRequest.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], SeasonRequest.prototype, "seasonNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int', default: media_1.MediaRequestStatus.PENDING }),
    __metadata("design:type", Number)
], SeasonRequest.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => MediaRequest_1.MediaRequest, (request) => request.seasons, {
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", MediaRequest_1.MediaRequest)
], SeasonRequest.prototype, "request", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], SeasonRequest.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], SeasonRequest.prototype, "updatedAt", void 0);
__decorate([
    (0, typeorm_1.AfterRemove)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SeasonRequest.prototype, "handleRemoveParent", null);
SeasonRequest = __decorate([
    (0, typeorm_1.Entity)(),
    __metadata("design:paramtypes", [Object])
], SeasonRequest);
exports.default = SeasonRequest;
