"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaSubscriber = void 0;
const themoviedb_1 = __importDefault(require("../api/themoviedb"));
const media_1 = require("../constants/media");
const datasource_1 = require("../datasource");
const Media_1 = __importDefault(require("../entity/Media"));
const MediaRequest_1 = require("../entity/MediaRequest");
const Season_1 = __importDefault(require("../entity/Season"));
const notifications_1 = __importStar(require("../lib/notifications"));
const logger_1 = __importDefault(require("../logger"));
const lodash_1 = require("lodash");
const typeorm_1 = require("typeorm");
let MediaSubscriber = class MediaSubscriber {
    async notifyAvailableMovie(entity, dbEntity, is4k) {
        if (entity[is4k ? 'status4k' : 'status'] === media_1.MediaStatus.AVAILABLE &&
            dbEntity[is4k ? 'status4k' : 'status'] !== media_1.MediaStatus.AVAILABLE) {
            if (entity.mediaType === media_1.MediaType.MOVIE) {
                const requestRepository = (0, datasource_1.getRepository)(MediaRequest_1.MediaRequest);
                const relatedRequests = await requestRepository.find({
                    where: {
                        media: {
                            id: entity.id,
                        },
                        is4k,
                        status: (0, typeorm_1.Not)(media_1.MediaRequestStatus.DECLINED),
                    },
                });
                if (relatedRequests.length > 0) {
                    const tmdb = new themoviedb_1.default();
                    try {
                        const movie = await tmdb.getMovie({ movieId: entity.tmdbId });
                        relatedRequests.forEach((request) => {
                            notifications_1.default.sendNotification(notifications_1.Notification.MEDIA_AVAILABLE, {
                                event: `${is4k ? '4K ' : ''}Movie Request Now Available`,
                                notifyAdmin: false,
                                notifySystem: true,
                                notifyUser: request.requestedBy,
                                subject: `${movie.title}${movie.release_date
                                    ? ` (${movie.release_date.slice(0, 4)})`
                                    : ''}`,
                                message: (0, lodash_1.truncate)(movie.overview, {
                                    length: 500,
                                    separator: /\s/,
                                    omission: '…',
                                }),
                                media: entity,
                                image: `https://image.tmdb.org/t/p/w600_and_h900_bestv2${movie.poster_path}`,
                                request,
                            });
                        });
                    }
                    catch (e) {
                        logger_1.default.error('Something went wrong sending media notification(s)', {
                            label: 'Notifications',
                            errorMessage: e.message,
                            mediaId: entity.id,
                        });
                    }
                }
            }
        }
    }
    async notifyAvailableSeries(entity, dbEntity, is4k) {
        const seasonRepository = (0, datasource_1.getRepository)(Season_1.default);
        const newAvailableSeasons = entity.seasons
            .filter((season) => season[is4k ? 'status4k' : 'status'] === media_1.MediaStatus.AVAILABLE)
            .map((season) => season.seasonNumber);
        const oldSeasonIds = dbEntity.seasons.map((season) => season.id);
        const oldSeasons = await seasonRepository.findBy({ id: (0, typeorm_1.In)(oldSeasonIds) });
        const oldAvailableSeasons = oldSeasons
            .filter((season) => season[is4k ? 'status4k' : 'status'] === media_1.MediaStatus.AVAILABLE)
            .map((season) => season.seasonNumber);
        const changedSeasons = newAvailableSeasons.filter((seasonNumber) => !oldAvailableSeasons.includes(seasonNumber));
        if (changedSeasons.length > 0) {
            const tmdb = new themoviedb_1.default();
            const requestRepository = (0, datasource_1.getRepository)(MediaRequest_1.MediaRequest);
            const processedSeasons = [];
            for (const changedSeasonNumber of changedSeasons) {
                const requests = await requestRepository.find({
                    where: {
                        media: {
                            id: entity.id,
                        },
                        is4k,
                        status: (0, typeorm_1.Not)(media_1.MediaRequestStatus.DECLINED),
                    },
                });
                const request = requests.find((request) => 
                // Check if the season is complete AND it contains the current season that was just marked available
                request.seasons.every((season) => newAvailableSeasons.includes(season.seasonNumber)) &&
                    request.seasons.some((season) => season.seasonNumber === changedSeasonNumber));
                if (request && !processedSeasons.includes(changedSeasonNumber)) {
                    processedSeasons.push(...request.seasons.map((season) => season.seasonNumber));
                    try {
                        const tv = await tmdb.getTvShow({ tvId: entity.tmdbId });
                        notifications_1.default.sendNotification(notifications_1.Notification.MEDIA_AVAILABLE, {
                            event: `${is4k ? '4K ' : ''}Series Request Now Available`,
                            subject: `${tv.name}${tv.first_air_date ? ` (${tv.first_air_date.slice(0, 4)})` : ''}`,
                            message: (0, lodash_1.truncate)(tv.overview, {
                                length: 500,
                                separator: /\s/,
                                omission: '…',
                            }),
                            notifyAdmin: false,
                            notifySystem: true,
                            notifyUser: request.requestedBy,
                            image: `https://image.tmdb.org/t/p/w600_and_h900_bestv2${tv.poster_path}`,
                            media: entity,
                            extra: [
                                {
                                    name: 'Requested Seasons',
                                    value: request.seasons
                                        .map((season) => season.seasonNumber)
                                        .join(', '),
                                },
                            ],
                            request,
                        });
                    }
                    catch (e) {
                        logger_1.default.error('Something went wrong sending media notification(s)', {
                            label: 'Notifications',
                            errorMessage: e.message,
                            mediaId: entity.id,
                        });
                    }
                }
            }
        }
    }
    async updateChildRequestStatus(event, is4k) {
        const requestRepository = (0, datasource_1.getRepository)(MediaRequest_1.MediaRequest);
        const requests = await requestRepository.find({
            where: { media: { id: event.id } },
        });
        for (const request of requests) {
            if (request.is4k === is4k &&
                request.status === media_1.MediaRequestStatus.PENDING) {
                request.status = media_1.MediaRequestStatus.APPROVED;
                await requestRepository.save(request);
            }
        }
    }
    beforeUpdate(event) {
        if (!event.entity) {
            return;
        }
        if (event.entity.mediaType === media_1.MediaType.MOVIE &&
            event.entity.status === media_1.MediaStatus.AVAILABLE) {
            this.notifyAvailableMovie(event.entity, event.databaseEntity, false);
        }
        if (event.entity.mediaType === media_1.MediaType.MOVIE &&
            event.entity.status4k === media_1.MediaStatus.AVAILABLE) {
            this.notifyAvailableMovie(event.entity, event.databaseEntity, true);
        }
        if (event.entity.mediaType === media_1.MediaType.TV &&
            (event.entity.status === media_1.MediaStatus.AVAILABLE ||
                event.entity.status === media_1.MediaStatus.PARTIALLY_AVAILABLE)) {
            this.notifyAvailableSeries(event.entity, event.databaseEntity, false);
        }
        if (event.entity.mediaType === media_1.MediaType.TV &&
            (event.entity.status4k === media_1.MediaStatus.AVAILABLE ||
                event.entity.status4k === media_1.MediaStatus.PARTIALLY_AVAILABLE)) {
            this.notifyAvailableSeries(event.entity, event.databaseEntity, true);
        }
        if (event.entity.status === media_1.MediaStatus.AVAILABLE &&
            event.databaseEntity.status === media_1.MediaStatus.PENDING) {
            this.updateChildRequestStatus(event.entity, false);
        }
        if (event.entity.status4k === media_1.MediaStatus.AVAILABLE &&
            event.databaseEntity.status4k === media_1.MediaStatus.PENDING) {
            this.updateChildRequestStatus(event.entity, true);
        }
    }
    listenTo() {
        return Media_1.default;
    }
};
MediaSubscriber = __decorate([
    (0, typeorm_1.EventSubscriber)()
], MediaSubscriber);
exports.MediaSubscriber = MediaSubscriber;
