import React, { ElementType, Ref } from 'react';
import { Props } from '../../types.js';
import { PropsForFeatures, RefProp, HasDisplayName } from '../../utils/render.js';
declare let DEFAULT_TABS_TAG: React.ExoticComponent<{
    children?: React.ReactNode;
}>;
interface TabsRenderPropArg {
    selectedIndex: number;
}
export type TabGroupProps<TTag extends ElementType> = Props<TTag, TabsRenderPropArg> & {
    defaultIndex?: number;
    onChange?: (index: number) => void;
    selectedIndex?: number;
    vertical?: boolean;
    manual?: boolean;
};
declare function GroupFn<TTag extends ElementType = typeof DEFAULT_TABS_TAG>(props: TabGroupProps<TTag>, ref: Ref<HTMLElement>): JSX.Element;
declare let DEFAULT_LIST_TAG: "div";
interface ListRenderPropArg {
    selectedIndex: number;
}
type ListPropsWeControl = 'role' | 'aria-orientation';
export type TabListProps<TTag extends ElementType> = Props<TTag, ListRenderPropArg, ListPropsWeControl> & {};
declare function ListFn<TTag extends ElementType = typeof DEFAULT_LIST_TAG>(props: TabListProps<TTag>, ref: Ref<HTMLElement>): React.ReactElement<any, string | React.JSXElementConstructor<any>> | null;
declare let DEFAULT_TAB_TAG: "button";
interface TabRenderPropArg {
    selected: boolean;
}
type TabPropsWeControl = 'role' | 'aria-controls' | 'aria-selected' | 'tabIndex';
export type TabProps<TTag extends ElementType> = Props<TTag, TabRenderPropArg, TabPropsWeControl> & {};
declare function TabFn<TTag extends ElementType = typeof DEFAULT_TAB_TAG>(props: TabProps<TTag>, ref: Ref<HTMLElement>): React.ReactElement<any, string | React.JSXElementConstructor<any>> | null;
declare let DEFAULT_PANELS_TAG: "div";
interface PanelsRenderPropArg {
    selectedIndex: number;
}
export type TabPanelsProps<TTag extends ElementType> = Props<TTag, PanelsRenderPropArg>;
declare function PanelsFn<TTag extends ElementType = typeof DEFAULT_PANELS_TAG>(props: TabPanelsProps<TTag>, ref: Ref<HTMLElement>): React.ReactElement<any, string | React.JSXElementConstructor<any>> | null;
declare let DEFAULT_PANEL_TAG: "div";
interface PanelRenderPropArg {
    selected: boolean;
}
type PanelPropsWeControl = 'role' | 'aria-labelledby';
declare let PanelRenderFeatures: number;
export type TabPanelProps<TTag extends ElementType> = Props<TTag, PanelRenderPropArg, PanelPropsWeControl> & PropsForFeatures<typeof PanelRenderFeatures>;
declare function PanelFn<TTag extends ElementType = typeof DEFAULT_PANEL_TAG>(props: TabPanelProps<TTag>, ref: Ref<HTMLElement>): JSX.Element | null;
interface ComponentTab extends HasDisplayName {
    <TTag extends ElementType = typeof DEFAULT_TAB_TAG>(props: TabProps<TTag> & RefProp<typeof TabFn>): JSX.Element;
}
interface ComponentTabGroup extends HasDisplayName {
    <TTag extends ElementType = typeof DEFAULT_TABS_TAG>(props: TabGroupProps<TTag> & RefProp<typeof GroupFn>): JSX.Element;
}
interface ComponentTabList extends HasDisplayName {
    <TTag extends ElementType = typeof DEFAULT_LIST_TAG>(props: TabListProps<TTag> & RefProp<typeof ListFn>): JSX.Element;
}
interface ComponentTabPanels extends HasDisplayName {
    <TTag extends ElementType = typeof DEFAULT_PANELS_TAG>(props: TabPanelsProps<TTag> & RefProp<typeof PanelsFn>): JSX.Element;
}
interface ComponentTabPanel extends HasDisplayName {
    <TTag extends ElementType = typeof DEFAULT_PANEL_TAG>(props: TabPanelProps<TTag> & RefProp<typeof PanelFn>): JSX.Element;
}
export declare let Tab: ComponentTab & {
    Group: ComponentTabGroup;
    List: ComponentTabList;
    Panels: ComponentTabPanels;
    Panel: ComponentTabPanel;
};
export {};
