import { AriaTabProps, AriaTabPanelProps, AriaTabListProps } from "@react-types/tabs";
import { DOMAttributes, FocusableElement } from "@react-types/shared";
import { RefObject } from "react";
import { TabListState } from "@react-stately/tabs";
export interface TabAria {
    /** Props for the tab element. */
    tabProps: DOMAttributes;
    /** Whether the tab is currently selected. */
    isSelected: boolean;
    /** Whether the tab is disabled. */
    isDisabled: boolean;
}
/**
 * Provides the behavior and accessibility implementation for a tab.
 * When selected, the associated tab panel is shown.
 */
export function useTab<T>(props: AriaTabProps, state: TabListState<T>, ref: RefObject<FocusableElement>): TabAria;
export interface TabPanelAria {
    /** Props for the tab panel element. */
    tabPanelProps: DOMAttributes;
}
/**
 * Provides the behavior and accessibility implementation for a tab panel. A tab panel is a container for
 * the contents of a tab, and is shown when the tab is selected.
 */
export function useTabPanel<T>(props: AriaTabPanelProps, state: TabListState<T>, ref: RefObject<Element>): TabPanelAria;
export interface TabListAria {
    /** Props for the tablist container. */
    tabListProps: DOMAttributes;
}
/**
 * Provides the behavior and accessibility implementation for a tab list.
 * Tabs organize content into multiple sections and allow users to navigate between them.
 */
export function useTabList<T>(props: AriaTabListProps<T>, state: TabListState<T>, ref: RefObject<HTMLElement>): TabListAria;
export type { AriaTabListProps, AriaTabPanelProps, AriaTabProps } from '@react-types/tabs';

//# sourceMappingURL=types.d.ts.map
