import { InteractsWithHeaders } from './interacts-with-headers';
export declare class Request extends InteractsWithHeaders {
    /**
     * The wrapped request instance.
     */
    private readonly request;
    /**
     * Create a new instance for the given `request`.
     *
     * @param {Object} request
     */
    constructor(request: any);
    /**
     * Returns the client IP address.
     *
     * @returns {String|undefined}
     */
    getClientIp(): string | undefined;
    /**
     * Returns the IP address if available in the HTTP request headers.
     *
     * @returns {String|undefined}
     */
    fromHeaders(): string | undefined;
    /**
     * Determine whether a valid IP address is available in the “x-forwarded-for” HTTP header.
     *
     * @returns {Boolean}
     */
    hasIpInForwardedFor(): boolean;
    /**
     * Returns the IP address if available from the “x-forwarded-for” HTTP header.
     *
     * @returns {String|undefined}
     */
    getFromForwardedFor(): string | undefined;
    /**
     * Determine whether the request IP comes from the given header `name`.
     *
     * @param {String} name - the header name
     *
     * @returns {Boolean}
     */
    hasIpInHeader(name: string): boolean;
    /**
     * Returns the first IP address from the `name`d header.
     *
     * @param {String} name
     *
     * @returns {String|undefined}
     */
    ipInHeader(name: string): string | undefined;
    /**
     * Returns the first valid IP address from the list of IP address candidates.
     *
     * @param {Array} ips
     *
     * @returns {String|undefined}
     */
    findIp(ips?: string[]): string | undefined;
    /**
     * Returns the plain IP v4 address without the port number.
     *
     * @param {String} ip
     *
     * @returns {String}
     */
    removePortFrom(ip: string): string;
    /**
     * Returns the IP address if available in the request connection.
     *
     * @returns {String|undefined}
     */
    fromConnection(): string | undefined;
    /**
     * Determine whether the request has a `connection` object assigned.
     *
     * @returns {Boolean}
     */
    hasConnection(): boolean;
    /**
     * Returns the IP address if available in the request socket.
     *
     * @returns {String|undefined}
     */
    fromSocket(): string | undefined;
    /**
     * Determine whether the request has a `socket` object assigned.
     *
     * @returns {Boolean}
     */
    hasSocket(): boolean;
    /**
     * Returns the IP address if available in the request info object.
     *
     * @returns {String|undefined}
     */
    fromInfo(): string | undefined;
    /**
     * Determine whether the request has an `info` object assigned.
     *
     * @returns {Boolean}
     */
    hasInfo(): boolean;
    /**
     * Returns the IP address if available from the raw request object. The
     * `raw` request object is typically available in web frameworks like
     * Fastify or hapi providing the original Node.js request instance.
     *
     * @returns {String|undefined}
     */
    fromRaw(): string | undefined;
    /**
     * Determine whether the request has a `requestContext` object assigned.
     *
     * @returns {Boolean}
     */
    hasRaw(): boolean;
    /**
     * Returns the raw request object.
     *
     * @returns {Object}
     */
    raw(): object | undefined;
    /**
     * Returns the IP address if available in the request context. The request
     * context is typically available in serverless functions, like AWS Lambda.
     *
     * @returns {String|undefined}
     */
    fromRequestContext(): string | undefined;
    /**
     * Determine whether the request has a `requestContext` object assigned.
     *
     * @returns {Boolean}
     */
    hasRequestContext(): boolean;
    /**
     * Returns the request context.
     *
     * @returns {*}
     */
    requestContext(): any;
    /**
     * Determine whether it’s a valid `ip` address.
     *
     * @param {String} ip
     *
     * @returns {Boolean}
     */
    isIp(ip?: string): boolean;
    /**
     * Determine whether the given `ip` address is a valid IP v4 address.
     *
     * @param {String} ip
     *
     * @returns {Boolean}
     */
    isIpv4(ip?: string): boolean;
    /**
     * Determine whether the given `ip` address is a valid IP v4 address.
     *
     * @param {String} ip
     *
     * @returns {Boolean}
     */
    isIpv6(ip?: string): boolean;
}
