import { Ace } from "ace-builds";
import Editor = Ace.Editor;
import * as PropTypes from "prop-types";
import * as React from "react";
import { IAceOptions, IAnnotation, ICommand, IEditorProps, IMarker } from "./types";
interface IAceEditorClass extends Editor {
    [index: string]: any;
    $options?: any;
}
export interface ISplitEditorProps {
    [index: string]: any;
    name?: string;
    style?: object;
    /** For available modes see https://github.com/thlorenz/brace/tree/master/mode */
    mode?: string;
    /** For available themes see https://github.com/thlorenz/brace/tree/master/theme */
    theme?: string;
    height?: string;
    width?: string;
    className?: string;
    fontSize?: number | string;
    showGutter?: boolean;
    showPrintMargin?: boolean;
    highlightActiveLine?: boolean;
    focus?: boolean;
    splits: number;
    debounceChangePeriod?: number;
    cursorStart?: number;
    wrapEnabled?: boolean;
    readOnly?: boolean;
    minLines?: number;
    maxLines?: number;
    enableBasicAutocompletion?: boolean | string[];
    enableLiveAutocompletion?: boolean | string[];
    tabSize?: number;
    value?: string[];
    defaultValue?: string[];
    scrollMargin?: number[];
    orientation?: string;
    onSelectionChange?: (value: any, event?: any) => void;
    onCursorChange?: (value: any, event?: any) => void;
    onInput?: (event?: any) => void;
    onLoad?: (editor: IEditorProps) => void;
    onBeforeLoad?: (ace: any) => void;
    onChange?: (value: string[], event?: any) => void;
    onSelection?: (selectedText: string, event?: any) => void;
    onCopy?: (value: string) => void;
    onPaste?: (value: string) => void;
    onFocus?: (value: Event) => void;
    onBlur?: (value: Event) => void;
    onScroll?: (editor: IEditorProps) => void;
    editorProps?: IEditorProps;
    setOptions?: IAceOptions;
    keyboardHandler?: string;
    commands?: ICommand[];
    annotations?: IAnnotation[][];
    markers?: IMarker[][];
}
export default class SplitComponent extends React.Component<ISplitEditorProps, undefined> {
    [index: string]: any;
    static propTypes: PropTypes.ValidationMap<ISplitEditorProps>;
    static defaultProps: Partial<ISplitEditorProps>;
    editor: IAceEditorClass;
    refEditor: HTMLElement;
    silent: boolean;
    split: IAceEditorClass;
    splitEditor: IAceEditorClass;
    debounce: (fn: any, delay: number) => (...args: any) => void;
    constructor(props: ISplitEditorProps);
    isInShadow(node: HTMLElement): boolean;
    componentDidMount(): void;
    componentDidUpdate(prevProps: ISplitEditorProps): void;
    componentWillUnmount(): void;
    onChange(event: any): void;
    onSelectionChange(event: any): void;
    onCursorChange(event: any): void;
    onFocus(event: any): void;
    onInput(event: any): void;
    onBlur(event: any): void;
    onCopy(text: string): void;
    onPaste(text: string): void;
    onScroll(): void;
    handleOptions(props: ISplitEditorProps, editor: IAceEditorClass): void;
    handleMarkers(markers: IMarker[], editor: IAceEditorClass): void;
    updateRef(item: HTMLElement): void;
    render(): JSX.Element;
}
export {};
