"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var editorOptions_1 = require("./editorOptions");
var ace = (0, editorOptions_1.getAceInstance)();
var ace_builds_1 = require("ace-builds");
var ext_split_1 = require("ace-builds/src-noconflict/ext-split");
var PropTypes = require("prop-types");
var React = require("react");
var isEqual = require("lodash.isequal");
var get = require("lodash.get");
var SplitComponent = /** @class */ (function (_super) {
    __extends(SplitComponent, _super);
    function SplitComponent(props) {
        var _this = _super.call(this, props) || this;
        editorOptions_1.editorEvents.forEach(function (method) {
            _this[method] = _this[method].bind(_this);
        });
        _this.debounce = editorOptions_1.debounce;
        return _this;
    }
    SplitComponent.prototype.isInShadow = function (node) {
        var parent = node && node.parentNode;
        while (parent) {
            if (parent.toString() === "[object ShadowRoot]") {
                return true;
            }
            parent = parent.parentNode;
        }
        return false;
    };
    SplitComponent.prototype.componentDidMount = function () {
        var _this = this;
        var _a = this.props, className = _a.className, onBeforeLoad = _a.onBeforeLoad, mode = _a.mode, focus = _a.focus, theme = _a.theme, fontSize = _a.fontSize, value = _a.value, defaultValue = _a.defaultValue, cursorStart = _a.cursorStart, showGutter = _a.showGutter, wrapEnabled = _a.wrapEnabled, showPrintMargin = _a.showPrintMargin, _b = _a.scrollMargin, scrollMargin = _b === void 0 ? [0, 0, 0, 0] : _b, keyboardHandler = _a.keyboardHandler, onLoad = _a.onLoad, commands = _a.commands, annotations = _a.annotations, markers = _a.markers, splits = _a.splits;
        this.editor = ace.edit(this.refEditor);
        if (this.isInShadow(this.refEditor)) {
            this.editor.renderer.attachToShadowRoot();
        }
        this.editor.setTheme("ace/theme/".concat(theme));
        if (onBeforeLoad) {
            onBeforeLoad(ace);
        }
        var editorProps = Object.keys(this.props.editorProps);
        var split = new ext_split_1.Split(this.editor.container, "ace/theme/".concat(theme), splits);
        this.editor.env.split = split;
        this.splitEditor = split.getEditor(0);
        this.split = split;
        // in a split scenario we don't want a print margin for the entire application
        this.editor.setShowPrintMargin(false);
        this.editor.renderer.setShowGutter(false);
        // get a list of possible options to avoid 'misspelled option errors'
        var availableOptions = this.splitEditor.$options;
        if (this.props.debounceChangePeriod) {
            this.onChange = this.debounce(this.onChange, this.props.debounceChangePeriod);
        }
        split.forEach(function (editor, index) {
            for (var i = 0; i < editorProps.length; i++) {
                editor[editorProps[i]] = _this.props.editorProps[editorProps[i]];
            }
            var defaultValueForEditor = get(defaultValue, index);
            var valueForEditor = get(value, index, "");
            editor.session.setUndoManager(new ace.UndoManager());
            editor.setTheme("ace/theme/".concat(theme));
            editor.renderer.setScrollMargin(scrollMargin[0], scrollMargin[1], scrollMargin[2], scrollMargin[3]);
            editor.getSession().setMode("ace/mode/".concat(mode));
            editor.setFontSize(fontSize);
            editor.renderer.setShowGutter(showGutter);
            editor.getSession().setUseWrapMode(wrapEnabled);
            editor.setShowPrintMargin(showPrintMargin);
            editor.on("focus", _this.onFocus);
            editor.on("blur", _this.onBlur);
            editor.on("input", _this.onInput);
            editor.on("copy", _this.onCopy);
            editor.on("paste", _this.onPaste);
            editor.on("change", _this.onChange);
            editor
                .getSession()
                .selection.on("changeSelection", _this.onSelectionChange);
            editor.getSession().selection.on("changeCursor", _this.onCursorChange);
            editor.session.on("changeScrollTop", _this.onScroll);
            editor.setValue(defaultValueForEditor === undefined
                ? valueForEditor
                : defaultValueForEditor, cursorStart);
            var newAnnotations = get(annotations, index, []);
            var newMarkers = get(markers, index, []);
            editor.getSession().setAnnotations(newAnnotations);
            if (newMarkers && newMarkers.length > 0) {
                _this.handleMarkers(newMarkers, editor);
            }
            for (var i = 0; i < editorOptions_1.editorOptions.length; i++) {
                var option = editorOptions_1.editorOptions[i];
                if (availableOptions.hasOwnProperty(option)) {
                    editor.setOption(option, _this.props[option]);
                }
                else if (_this.props[option]) {
                    console.warn("ReaceAce: editor option ".concat(option, " was activated but not found. Did you need to import a related tool or did you possibly mispell the option?"));
                }
            }
            _this.handleOptions(_this.props, editor);
            if (Array.isArray(commands)) {
                commands.forEach(function (command) {
                    if (typeof command.exec === "string") {
                        editor.commands.bindKey(command.bindKey, command.exec);
                    }
                    else {
                        editor.commands.addCommand(command);
                    }
                });
            }
            if (keyboardHandler) {
                editor.setKeyboardHandler("ace/keyboard/" + keyboardHandler);
            }
        });
        if (className) {
            this.refEditor.className += " " + className;
        }
        if (focus) {
            this.splitEditor.focus();
        }
        var sp = this.editor.env.split;
        sp.setOrientation(this.props.orientation === "below" ? sp.BELOW : sp.BESIDE);
        sp.resize(true);
        if (onLoad) {
            onLoad(sp);
        }
    };
    SplitComponent.prototype.componentDidUpdate = function (prevProps) {
        var _this = this;
        var oldProps = prevProps;
        var nextProps = this.props;
        var split = this.editor.env.split;
        if (nextProps.splits !== oldProps.splits) {
            split.setSplits(nextProps.splits);
        }
        if (nextProps.orientation !== oldProps.orientation) {
            split.setOrientation(nextProps.orientation === "below" ? split.BELOW : split.BESIDE);
        }
        split.forEach(function (editor, index) {
            if (nextProps.mode !== oldProps.mode) {
                editor.getSession().setMode("ace/mode/" + nextProps.mode);
            }
            if (nextProps.keyboardHandler !== oldProps.keyboardHandler) {
                if (nextProps.keyboardHandler) {
                    editor.setKeyboardHandler("ace/keyboard/" + nextProps.keyboardHandler);
                }
                else {
                    editor.setKeyboardHandler(null);
                }
            }
            if (nextProps.fontSize !== oldProps.fontSize) {
                editor.setFontSize(nextProps.fontSize);
            }
            if (nextProps.wrapEnabled !== oldProps.wrapEnabled) {
                editor.getSession().setUseWrapMode(nextProps.wrapEnabled);
            }
            if (nextProps.showPrintMargin !== oldProps.showPrintMargin) {
                editor.setShowPrintMargin(nextProps.showPrintMargin);
            }
            if (nextProps.showGutter !== oldProps.showGutter) {
                editor.renderer.setShowGutter(nextProps.showGutter);
            }
            for (var i = 0; i < editorOptions_1.editorOptions.length; i++) {
                var option = editorOptions_1.editorOptions[i];
                if (nextProps[option] !== oldProps[option]) {
                    editor.setOption(option, nextProps[option]);
                }
            }
            if (!isEqual(nextProps.setOptions, oldProps.setOptions)) {
                _this.handleOptions(nextProps, editor);
            }
            var nextValue = get(nextProps.value, index, "");
            if (editor.getValue() !== nextValue) {
                // editor.setValue is a synchronous function call, change event is emitted before setValue return.
                _this.silent = true;
                var pos = editor.session.selection.toJSON();
                editor.setValue(nextValue, nextProps.cursorStart);
                editor.session.selection.fromJSON(pos);
                _this.silent = false;
            }
            var newAnnotations = get(nextProps.annotations, index, []);
            var oldAnnotations = get(oldProps.annotations, index, []);
            if (!isEqual(newAnnotations, oldAnnotations)) {
                editor.getSession().setAnnotations(newAnnotations);
            }
            var newMarkers = get(nextProps.markers, index, []);
            var oldMarkers = get(oldProps.markers, index, []);
            if (!isEqual(newMarkers, oldMarkers) && Array.isArray(newMarkers)) {
                _this.handleMarkers(newMarkers, editor);
            }
        });
        if (nextProps.className !== oldProps.className) {
            var appliedClasses = this.refEditor.className;
            var appliedClassesArray_1 = appliedClasses.trim().split(" ");
            var oldClassesArray = oldProps.className.trim().split(" ");
            oldClassesArray.forEach(function (oldClass) {
                var index = appliedClassesArray_1.indexOf(oldClass);
                appliedClassesArray_1.splice(index, 1);
            });
            this.refEditor.className =
                " " + nextProps.className + " " + appliedClassesArray_1.join(" ");
        }
        if (nextProps.theme !== oldProps.theme) {
            split.setTheme("ace/theme/" + nextProps.theme);
        }
        if (nextProps.focus && !oldProps.focus) {
            this.splitEditor.focus();
        }
        if (nextProps.height !== this.props.height ||
            nextProps.width !== this.props.width) {
            this.editor.resize();
        }
    };
    SplitComponent.prototype.componentWillUnmount = function () {
        this.editor.destroy();
        this.editor = null;
    };
    SplitComponent.prototype.onChange = function (event) {
        if (this.props.onChange && !this.silent) {
            var value_1 = [];
            this.editor.env.split.forEach(function (editor) {
                value_1.push(editor.getValue());
            });
            this.props.onChange(value_1, event);
        }
    };
    SplitComponent.prototype.onSelectionChange = function (event) {
        if (this.props.onSelectionChange) {
            var value_2 = [];
            this.editor.env.split.forEach(function (editor) {
                value_2.push(editor.getSelection());
            });
            this.props.onSelectionChange(value_2, event);
        }
    };
    SplitComponent.prototype.onCursorChange = function (event) {
        if (this.props.onCursorChange) {
            var value_3 = [];
            this.editor.env.split.forEach(function (editor) {
                value_3.push(editor.getSelection());
            });
            this.props.onCursorChange(value_3, event);
        }
    };
    SplitComponent.prototype.onFocus = function (event) {
        if (this.props.onFocus) {
            this.props.onFocus(event);
        }
    };
    SplitComponent.prototype.onInput = function (event) {
        if (this.props.onInput) {
            this.props.onInput(event);
        }
    };
    SplitComponent.prototype.onBlur = function (event) {
        if (this.props.onBlur) {
            this.props.onBlur(event);
        }
    };
    SplitComponent.prototype.onCopy = function (text) {
        if (this.props.onCopy) {
            this.props.onCopy(text);
        }
    };
    SplitComponent.prototype.onPaste = function (text) {
        if (this.props.onPaste) {
            this.props.onPaste(text);
        }
    };
    SplitComponent.prototype.onScroll = function () {
        if (this.props.onScroll) {
            this.props.onScroll(this.editor);
        }
    };
    SplitComponent.prototype.handleOptions = function (props, editor) {
        var setOptions = Object.keys(props.setOptions);
        for (var y = 0; y < setOptions.length; y++) {
            editor.setOption(setOptions[y], props.setOptions[setOptions[y]]);
        }
    };
    SplitComponent.prototype.handleMarkers = function (markers, editor) {
        // remove foreground markers
        var currentMarkers = editor.getSession().getMarkers(true);
        for (var i in currentMarkers) {
            if (currentMarkers.hasOwnProperty(i)) {
                editor.getSession().removeMarker(currentMarkers[i].id);
            }
        }
        // remove background markers
        currentMarkers = editor.getSession().getMarkers(false);
        for (var i in currentMarkers) {
            if (currentMarkers.hasOwnProperty(i)) {
                editor.getSession().removeMarker(currentMarkers[i].id);
            }
        }
        // add new markers
        markers.forEach(function (_a) {
            var startRow = _a.startRow, startCol = _a.startCol, endRow = _a.endRow, endCol = _a.endCol, className = _a.className, type = _a.type, _b = _a.inFront, inFront = _b === void 0 ? false : _b;
            var range = new ace_builds_1.Range(startRow, startCol, endRow, endCol);
            editor
                .getSession()
                .addMarker(range, className, type, inFront);
        });
    };
    SplitComponent.prototype.updateRef = function (item) {
        this.refEditor = item;
    };
    SplitComponent.prototype.render = function () {
        var _a = this.props, name = _a.name, width = _a.width, height = _a.height, style = _a.style;
        var divStyle = __assign({ width: width, height: height }, style);
        return React.createElement("div", { ref: this.updateRef, id: name, style: divStyle });
    };
    SplitComponent.propTypes = {
        className: PropTypes.string,
        debounceChangePeriod: PropTypes.number,
        defaultValue: PropTypes.arrayOf(PropTypes.string),
        focus: PropTypes.bool,
        fontSize: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
        height: PropTypes.string,
        mode: PropTypes.string,
        name: PropTypes.string,
        onBlur: PropTypes.func,
        onChange: PropTypes.func,
        onCopy: PropTypes.func,
        onFocus: PropTypes.func,
        onInput: PropTypes.func,
        onLoad: PropTypes.func,
        onPaste: PropTypes.func,
        onScroll: PropTypes.func,
        orientation: PropTypes.string,
        showGutter: PropTypes.bool,
        splits: PropTypes.number,
        theme: PropTypes.string,
        value: PropTypes.arrayOf(PropTypes.string),
        width: PropTypes.string,
        onSelectionChange: PropTypes.func,
        onCursorChange: PropTypes.func,
        onBeforeLoad: PropTypes.func,
        minLines: PropTypes.number,
        maxLines: PropTypes.number,
        readOnly: PropTypes.bool,
        highlightActiveLine: PropTypes.bool,
        tabSize: PropTypes.number,
        showPrintMargin: PropTypes.bool,
        cursorStart: PropTypes.number,
        editorProps: PropTypes.object,
        setOptions: PropTypes.object,
        style: PropTypes.object,
        scrollMargin: PropTypes.array,
        annotations: PropTypes.array,
        markers: PropTypes.array,
        keyboardHandler: PropTypes.string,
        wrapEnabled: PropTypes.bool,
        enableBasicAutocompletion: PropTypes.oneOfType([
            PropTypes.bool,
            PropTypes.array
        ]),
        enableLiveAutocompletion: PropTypes.oneOfType([
            PropTypes.bool,
            PropTypes.array
        ]),
        commands: PropTypes.array
    };
    SplitComponent.defaultProps = {
        name: "ace-editor",
        focus: false,
        orientation: "beside",
        splits: 2,
        mode: "",
        theme: "",
        height: "500px",
        width: "500px",
        value: [],
        fontSize: 12,
        showGutter: true,
        onChange: null,
        onPaste: null,
        onLoad: null,
        onScroll: null,
        minLines: null,
        maxLines: null,
        readOnly: false,
        highlightActiveLine: true,
        showPrintMargin: true,
        tabSize: 4,
        cursorStart: 1,
        editorProps: {},
        style: {},
        scrollMargin: [0, 0, 0, 0],
        setOptions: {},
        wrapEnabled: false,
        enableBasicAutocompletion: false,
        enableLiveAutocompletion: false
    };
    return SplitComponent;
}(React.Component));
exports.default = SplitComponent;
//# sourceMappingURL=split.js.map