// Generated by CoffeeScript 1.6.3
var deepClone, deepDelete, deepExtend, deepFromFlat, deepKeys, deepMapValues, isPlainObject, mapKeys, mapValues, _;

_ = require('underscore');

module.exports = {
  deepKeys: deepKeys = function(obj) {
    if (!isPlainObject(obj)) {
      throw new Error("deepKeys must be called on an object, not '" + obj + "'");
    }
    return _.flatten(_.map(obj, function(v, k) {
      if (isPlainObject(v) && !_.isEmpty(v)) {
        return _.map(deepKeys(v), function(subkey) {
          return "" + k + "." + subkey;
        });
      } else {
        return [k];
      }
    }));
  },
  deepClone: deepClone = function(object) {
    var type, _i, _len, _ref;
    if (object == null) {
      return object;
    }
    if (object instanceof Boolean && object.valueOf() === false) {
      return new Boolean();
    }
    _ref = [Date, Number, String, Boolean];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      type = _ref[_i];
      if (object instanceof type) {
        return new type(object);
      }
    }
    if (_(object).isArray()) {
      return _(object).map(deepClone);
    }
    if (!_(object).isObject()) {
      return object;
    }
    if (object.nodeType && _(object.cloneNode).isFunction()) {
      return object.cloneNode(true);
    }
    if (object.constructor !== {}.constructor) {
      return object;
    }
    return mapValues(object, deepClone);
  },
  deepHas: function(obj, keys) {
    var helper;
    helper = function(obj, keys) {
      if ((keys.length === 0) || (!_.isObject(obj))) {
        return false;
      } else if (keys.length === 1) {
        return _.first(keys) in obj;
      } else {
        return helper(obj[_.first(keys)], _.rest(keys));
      }
    };
    return helper(obj, _.isArray(keys) ? keys : keys.split('.'));
  },
  deepOmit: function(obj, keys) {
    var deepOmitOne;
    if (!isPlainObject(obj)) {
      throw new Error("deepOmit must be called on an object, not '" + obj + "'");
    }
    deepOmitOne = function(obj, key) {
      var helper;
      helper = function(obj, key_arr) {
        switch (false) {
          case !_.isEmpty(key_arr):
            return obj;
          case key_arr.length !== 1:
            return _.omit(obj, _.first(key_arr));
          case !!isPlainObject(obj[_.first(key_arr)]):
            return obj;
          default:
            return _.extend({}, obj, _.object([_.first(key_arr)], [helper(obj[_.first(key_arr)], _.rest(key_arr))]));
        }
      };
      return helper(obj, key.split('.'));
    };
    return _.reduce(keys, deepOmitOne, obj);
  },
  deepPick: (function() {
    var deepGet;
    deepGet = function(obj, key) {
      var helper;
      helper = function(obj, key_arr) {
        if (key_arr.length === 1) {
          return obj != null ? obj[_.first(key_arr)] : void 0;
        } else {
          return helper(obj[_.first(key_arr)], _.rest(key_arr));
        }
      };
      return helper(obj, key.split('.'));
    };
    return function(obj, keys) {
      var flat_new_obj;
      if (!isPlainObject(obj)) {
        throw new Error("deepPick must be called on an object, not '" + obj + "'");
      }
      flat_new_obj = _.reduce(keys, function(new_obj, key) {
        var val;
        val = deepGet(obj, key);
        if (val !== void 0) {
          new_obj[key] = val;
        }
        return new_obj;
      }, {});
      return deepFromFlat(flat_new_obj);
    };
  })(),
  deepDelete: deepDelete = function(obj, key) {
    if ((key == null) || (obj == null)) {
      return;
    }
    if (!_(key).isArray()) {
      key = key.split('.');
    }
    if (key.length === 1) {
      delete obj[key];
      return;
    }
    return deepDelete(obj[key[0]], key.slice(1, key.length));
  },
  deepExtend: deepExtend = function(obj, ext, mutate) {
    return _.reduce(ext, function(acc, val, key) {
      acc[key] = (key in obj) && isPlainObject(obj[key]) && isPlainObject(val) ? deepExtend(obj[key], val) : val;
      return acc;
    }, mutate ? obj : _.clone(obj));
  },
  isPlainObject: isPlainObject = function(value) {
    return (value != null ? value.constructor : void 0) === {}.constructor;
  },
  deepToFlat: function(obj) {
    var recurse, res;
    res = {};
    recurse = function(obj, current) {
      var key, newKey, value, _results;
      _results = [];
      for (key in obj) {
        value = obj[key];
        newKey = (current ? current + "." + key : key);
        if (value && isPlainObject(value)) {
          _results.push(recurse(value, newKey));
        } else {
          _results.push(res[newKey] = value);
        }
      }
      return _results;
    };
    recurse(obj);
    return res;
  },
  deepFromFlat: deepFromFlat = function(o) {
    var k, key, oo, part, parts, t;
    oo = {};
    t = void 0;
    parts = void 0;
    part = void 0;
    for (k in o) {
      t = oo;
      parts = k.split(".");
      key = parts.pop();
      while (parts.length) {
        part = parts.shift();
        if (part === "__proto__" || part === "constructor" || part === "prototype") {
          continue;
        }
        t = t[part] = t[part] || {};
      }
      t[key] = o[k];
    }
    return oo;
  },
  mapValues: mapValues = function(obj, f_val) {
    if (!isPlainObject(obj)) {
      throw new Error("mapValues must be called on an object, not '" + obj + "'");
    }
    return _.object(_.keys(obj), _.map(obj, f_val));
  },
  deepMapValues: deepMapValues = function(obj, f) {
    if (!isPlainObject(obj)) {
      throw new Error("deepMapValues must be called on an object, not '" + obj + "'");
    }
    return mapValues(obj, function(v, k) {
      if (isPlainObject(v)) {
        return deepMapValues(v, function(subv, subk) {
          return f(subv, "" + k + "." + subk);
        });
      } else {
        return f(v, k);
      }
    });
  },
  mapKeys: mapKeys = function(obj, f_val) {
    if (!isPlainObject(obj)) {
      throw new Error("mapKeys must be called on an object, not '" + obj + "'");
    }
    return _.object(_.map(obj, function(v, k) {
      return f_val(k, v);
    }), _.values(obj));
  }
};
