"use strict";
exports.id = 11360;
exports.ids = [11360];
exports.modules = {

/***/ 11360:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61276);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_spring__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4417);
/* harmony import */ var react_spring__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_spring__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









var Direction;

(function (Direction) {
  Direction[Direction["RIGHT"] = 0] = "RIGHT";
  Direction[Direction["LEFT"] = 1] = "LEFT";
})(Direction || (Direction = {}));

const Slider = ({
  sliderKey,
  items,
  isLoading,
  isEmpty = false,
  emptyMessage,
  placeholder = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"].Placeholder */ .Z.Placeholder, {})
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.useIntl)();
  const containerRef = (0,react__WEBPACK_IMPORTED_MODULE_4__.useRef)(null);
  const {
    0: scrollPos,
    1: setScrollPos
  } = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)({
    isStart: true,
    isEnd: false
  });
  const handleScroll = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
    const scrollWidth = containerRef.current?.scrollWidth ?? 0;
    const clientWidth = containerRef.current?.getBoundingClientRect().width ?? 0;
    const scrollPosition = containerRef.current?.scrollLeft ?? 0;

    if (!items || items?.length === 0) {
      setScrollPos({
        isStart: true,
        isEnd: true
      });
    } else if (clientWidth >= scrollWidth) {
      setScrollPos({
        isStart: true,
        isEnd: true
      });
    } else if (scrollPosition >= (containerRef.current?.scrollWidth ?? 0) - clientWidth) {
      setScrollPos({
        isStart: false,
        isEnd: true
      });
    } else if (scrollPosition > 0) {
      setScrollPos({
        isStart: false,
        isEnd: false
      });
    } else {
      setScrollPos({
        isStart: true,
        isEnd: false
      });
    }
  }, [items]); // eslint-disable-next-line react-hooks/exhaustive-deps

  const debouncedScroll = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_3__.debounce)(() => handleScroll(), 50), [handleScroll]);
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    const handleResize = () => {
      debouncedScroll();
    };

    window.addEventListener('resize', handleResize, {
      passive: true
    });
    return () => {
      window.removeEventListener('resize', handleResize);
    };
  }, [debouncedScroll]);
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    handleScroll();
  }, [items, handleScroll]);

  const onScroll = () => {
    debouncedScroll();
  };

  const [, setX] = (0,react_spring__WEBPACK_IMPORTED_MODULE_6__.useSpring)(() => ({
    from: {
      x: 0
    },
    to: {
      x: 0
    },
    onChange: results => {
      if (containerRef.current) {
        containerRef.current.scrollLeft = results.value.x;
      }
    }
  }));

  const slide = direction => {
    const clientWidth = containerRef.current?.getBoundingClientRect().width ?? 0;
    const cardWidth = containerRef.current?.firstElementChild?.getBoundingClientRect().width ?? 0;
    const scrollPosition = containerRef.current?.scrollLeft ?? 0;
    const visibleItems = Math.floor(clientWidth / cardWidth);
    const scrollOffset = scrollPosition % cardWidth;

    if (direction === Direction.LEFT) {
      const newX = Math.max(scrollPosition - scrollOffset - visibleItems * cardWidth, 0);
      setX.start({
        from: {
          x: scrollPosition
        },
        to: {
          x: newX
        },
        onChange: results => {
          if (containerRef.current) {
            containerRef.current.scrollLeft = results.value.x;
          }
        },
        reset: true,
        config: {
          friction: 60,
          tension: 500,
          velocity: 20
        }
      });

      if (newX === 0) {
        setScrollPos({
          isStart: true,
          isEnd: false
        });
      } else {
        setScrollPos({
          isStart: false,
          isEnd: false
        });
      }
    } else if (direction === Direction.RIGHT) {
      const newX = Math.min(scrollPosition - scrollOffset + visibleItems * cardWidth, containerRef.current?.scrollWidth ?? 0 - clientWidth);
      setX.start({
        from: {
          x: scrollPosition
        },
        to: {
          x: newX
        },
        onChange: results => {
          if (containerRef.current) {
            containerRef.current.scrollLeft = results.value.x;
          }
        },
        reset: true,
        config: {
          friction: 60,
          tension: 500,
          velocity: 20
        }
      });

      if (newX >= (containerRef.current?.scrollWidth ?? 0) - clientWidth) {
        setScrollPos({
          isStart: false,
          isEnd: true
        });
      } else {
        setScrollPos({
          isStart: false,
          isEnd: false
        });
      }
    }
  };

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "relative",
    "data-testid": "media-slider",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "absolute right-0 -mt-10 flex text-gray-400",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("button", {
        className: `${scrollPos.isStart ? 'text-gray-800' : 'hover:text-white'}`,
        onClick: () => slide(Direction.LEFT),
        disabled: scrollPos.isStart,
        type: "button",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__.ChevronLeftIcon, {
          className: "h-6 w-6"
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("button", {
        className: `${scrollPos.isEnd ? 'text-gray-800' : 'hover:text-white'}`,
        onClick: () => slide(Direction.RIGHT),
        disabled: scrollPos.isEnd,
        type: "button",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_2__.ChevronRightIcon, {
          className: "h-6 w-6"
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "hide-scrollbar relative -my-2 -ml-4 -mr-4 overflow-y-auto overflow-x-scroll overscroll-x-contain whitespace-nowrap px-2 py-2",
      ref: containerRef,
      onScroll: onScroll,
      children: [items?.map((item, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "inline-block px-2 align-top",
        children: item
      }, `${sliderKey}-${index}`)), isLoading && [...Array(10)].map((_item, i) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "inline-block px-2 align-top",
        children: placeholder
      }, `placeholder-${i}`)), isEmpty && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "mt-16 mb-16 text-center font-medium text-gray-400",
        children: emptyMessage ? emptyMessage : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_1__/* ["default"].noresults */ .Z.noresults)
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Slider);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;