"use strict";
exports.id = 13555;
exports.ids = [13555];
exports.modules = {

/***/ 13555:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);




const Alert = ({
  title,
  children,
  type
}) => {
  let design = {
    bgColor: 'border border-yellow-500 backdrop-blur bg-yellow-400 bg-opacity-20',
    titleColor: 'text-yellow-100',
    textColor: 'text-yellow-300',
    svg: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__.ExclamationTriangleIcon, {
      className: "h-5 w-5"
    })
  };

  switch (type) {
    case 'info':
      design = {
        bgColor: 'border border-indigo-500 backdrop-blur bg-indigo-400 bg-opacity-20',
        titleColor: 'text-gray-100',
        textColor: 'text-gray-300',
        svg: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__.InformationCircleIcon, {
          className: "h-5 w-5"
        })
      };
      break;

    case 'error':
      design = {
        bgColor: 'bg-red-600',
        titleColor: 'text-red-100',
        textColor: 'text-red-300',
        svg: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__.XCircleIcon, {
          className: "h-5 w-5"
        })
      };
      break;
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
    className: `mb-4 rounded-md p-4 ${design.bgColor}`,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "flex",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
        className: `flex-shrink-0 ${design.titleColor}`,
        children: design.svg
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "ml-3",
        children: [title && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
          className: `text-sm font-medium ${design.titleColor}`,
          children: title
        }), children && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
          className: `mt-2 text-sm first:mt-0 ${design.textColor}`,
          children: children
        })]
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Alert);

/***/ })

};
;