"use strict";
exports.id = 22796;
exports.ids = [22796];
exports.modules = {

/***/ 22796:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7292);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_hooks_useClickOutside__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12965);
/* harmony import */ var _app_hooks_useLockBodyScroll__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(57366);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80210);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(61185);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(66405);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_1__, _headlessui_react__WEBPACK_IMPORTED_MODULE_6__]);
([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_1__, _headlessui_react__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);












const Modal = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default().forwardRef(({
  title,
  subTitle,
  onCancel,
  onOk,
  cancelText,
  okText,
  okDisabled = false,
  cancelButtonType = 'default',
  okButtonType = 'primary',
  children,
  disableScrollLock,
  backgroundClickable = true,
  secondaryButtonType = 'default',
  secondaryDisabled = false,
  onSecondary,
  secondaryText,
  tertiaryButtonType = 'default',
  tertiaryDisabled = false,
  tertiaryText,
  loading = false,
  onTertiary,
  backdrop
}, parentRef) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const modalRef = (0,react__WEBPACK_IMPORTED_MODULE_7__.useRef)(null);
  (0,_app_hooks_useClickOutside__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(modalRef, () => {
    if (onCancel && backgroundClickable) {
      onCancel();
    }
  });
  (0,_app_hooks_useLockBodyScroll__WEBPACK_IMPORTED_MODULE_4__/* .useLockBodyScroll */ .N)(true, disableScrollLock);
  return /*#__PURE__*/react_dom__WEBPACK_IMPORTED_MODULE_8___default().createPortal( /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_6__.Transition.Child, {
    appear: true,
    as: "div",
    className: "fixed top-0 bottom-0 left-0 right-0 z-50 flex h-full w-full items-center justify-center bg-gray-800 bg-opacity-70",
    enter: "transition-opacity duration-300",
    enterFrom: "opacity-0",
    enterTo: "opacity-100",
    leave: "transition-opacity duration-300",
    leaveFrom: "opacity-100",
    leaveTo: "opacity-0",
    ref: parentRef,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_6__.Transition, {
      appear: true,
      as: react__WEBPACK_IMPORTED_MODULE_7__.Fragment,
      enter: "transition duration-300",
      enterFrom: "opacity-0 scale-75",
      enterTo: "opacity-100 scale-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      show: loading,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
        style: {
          position: 'absolute'
        },
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {})
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_6__.Transition, {
      className: "hide-scrollbar relative inline-block w-full overflow-auto bg-gray-800 px-4 pt-4 pb-4 text-left align-bottom shadow-xl ring-1 ring-gray-700 transition-all sm:my-8 sm:max-w-3xl sm:rounded-lg sm:align-middle",
      role: "dialog",
      "aria-modal": "true",
      "aria-labelledby": "modal-headline",
      style: {
        maxHeight: 'calc(100% - env(safe-area-inset-top) * 2)'
      },
      appear: true,
      as: "div",
      enter: "transition duration-300",
      enterFrom: "opacity-0 scale-75",
      enterTo: "opacity-100 scale-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      show: !loading,
      ref: modalRef,
      children: [backdrop && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
        className: "absolute top-0 left-0 right-0 z-0 h-64 max-h-full w-full",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          alt: "",
          src: backdrop,
          layout: "fill",
          objectFit: "cover",
          priority: true
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
          className: "absolute inset-0",
          style: {
            backgroundImage: 'linear-gradient(180deg, rgba(31, 41, 55, 0.75) 0%, rgba(31, 41, 55, 1) 100%)'
          }
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
        className: "relative -mx-4 overflow-x-hidden px-4 pt-0.5 sm:flex sm:items-center",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
          className: `mt-3 truncate text-center text-white sm:mt-0 sm:text-left`,
          children: (title || subTitle) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
            className: "flex flex-col space-y-1",
            children: [title && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("span", {
              className: "text-overseerr truncate pb-0.5 text-2xl font-bold leading-6",
              id: "modal-headline",
              "data-testid": "modal-title",
              children: title
            }), subTitle && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("span", {
              className: "truncate text-lg font-semibold leading-6 text-gray-200",
              id: "modal-headline",
              "data-testid": "modal-title",
              children: subTitle
            })]
          })
        })
      }), children && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
        className: `relative mt-4 text-sm leading-5 text-gray-300 ${!(onCancel || onOk || onSecondary || onTertiary) ? 'mb-3' : ''}`,
        children: children
      }), (onCancel || onOk || onSecondary || onTertiary) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
        className: "relative mt-5 flex flex-row-reverse justify-center sm:mt-4 sm:justify-start",
        children: [typeof onOk === 'function' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          buttonType: okButtonType,
          onClick: onOk,
          className: "ml-3",
          disabled: okDisabled,
          "data-testid": "modal-ok-button",
          children: okText ? okText : 'Ok'
        }), typeof onSecondary === 'function' && secondaryText && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          buttonType: secondaryButtonType,
          onClick: onSecondary,
          className: "ml-3",
          disabled: secondaryDisabled,
          "data-testid": "modal-secondary-button",
          children: secondaryText
        }), typeof onTertiary === 'function' && tertiaryText && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          buttonType: tertiaryButtonType,
          onClick: onTertiary,
          className: "ml-3",
          disabled: tertiaryDisabled,
          children: tertiaryText
        }), typeof onCancel === 'function' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          buttonType: cancelButtonType,
          onClick: onCancel,
          className: "ml-3 sm:ml-0",
          "data-testid": "modal-cancel-button",
          children: cancelText ? cancelText : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].cancel */ .Z.cancel)
        })]
      })]
    })]
  }), document.body);
});
Modal.displayName = 'Modal';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Modal);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12965:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/**
 * useClickOutside
 *
 * Simple hook to add an event listener to the body and allow a callback to
 * be triggered when clicking outside of the target ref
 *
 * @param ref Any HTML Element ref
 * @param callback Callback triggered when clicking outside of ref element
 */

const useClickOutside = (ref, callback) => {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const handleBodyClick = e => {
      if (ref.current && !ref.current.contains(e.target)) {
        callback(e);
      }
    };

    document.body.addEventListener('click', handleBodyClick, {
      capture: true
    });
    return () => {
      document.body.removeEventListener('click', handleBodyClick);
    };
  }, [ref, callback]);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useClickOutside);

/***/ }),

/***/ 57366:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "N": () => (/* binding */ useLockBodyScroll)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/**
 * Hook to lock the body scroll whenever a component is mounted or
 * whenever isLocked is set to true.
 *
 * You can pass in true always to cause a lock on mount/dismount of the component
 * using this hook.
 *
 * @param isLocked Toggle the scroll lock
 * @param disabled Disables the entire hook (allows conditional skipping of the lock)
 */

const useLockBodyScroll = (isLocked, disabled) => {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const originalOverflowStyle = window.getComputedStyle(document.body).overflow;
    const originalTouchActionStyle = window.getComputedStyle(document.body).touchAction;

    if (isLocked && !disabled) {
      document.body.style.overflow = 'hidden';
      document.body.style.touchAction = 'none';
    }

    return () => {
      if (!disabled) {
        document.body.style.overflow = originalOverflowStyle;
        document.body.style.touchAction = originalTouchActionStyle;
      }
    };
  }, [isLocked, disabled]);
};

/***/ })

};
;