"use strict";
exports.id = 33181;
exports.ids = [33181];
exports.modules = {

/***/ 33181:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ZP": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony exports messages, PermissionEdit */
/* harmony import */ var _app_components_PermissionOption__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(74339);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86799);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_PermissionOption__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__]);
([_app_components_PermissionOption__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.defineMessages)({
  admin: {
    "id": "components.PermissionEdit.admin",
    "defaultMessage": 'Admin'
  },
  adminDescription: {
    "id": "components.PermissionEdit.adminDescription",
    "defaultMessage": 'Full administrator access. Bypasses all other permission checks.'
  },
  users: {
    "id": "components.PermissionEdit.users",
    "defaultMessage": 'Manage Users'
  },
  usersDescription: {
    "id": "components.PermissionEdit.usersDescription",
    "defaultMessage": 'Grant permission to manage users. Users with this permission cannot modify users with or grant the Admin privilege.'
  },
  managerequests: {
    "id": "components.PermissionEdit.managerequests",
    "defaultMessage": 'Manage Requests'
  },
  managerequestsDescription: {
    "id": "components.PermissionEdit.managerequestsDescription",
    "defaultMessage": 'Grant permission to manage media requests. All requests made by a user with this permission will be automatically approved.'
  },
  request: {
    "id": "components.PermissionEdit.request",
    "defaultMessage": 'Request'
  },
  requestDescription: {
    "id": "components.PermissionEdit.requestDescription",
    "defaultMessage": 'Grant permission to submit requests for non-4K media.'
  },
  requestMovies: {
    "id": "components.PermissionEdit.requestMovies",
    "defaultMessage": 'Request Movies'
  },
  requestMoviesDescription: {
    "id": "components.PermissionEdit.requestMoviesDescription",
    "defaultMessage": 'Grant permission to submit requests for non-4K movies.'
  },
  requestTv: {
    "id": "components.PermissionEdit.requestTv",
    "defaultMessage": 'Request Series'
  },
  requestTvDescription: {
    "id": "components.PermissionEdit.requestTvDescription",
    "defaultMessage": 'Grant permission to submit requests for non-4K series.'
  },
  autoapprove: {
    "id": "components.PermissionEdit.autoapprove",
    "defaultMessage": 'Auto-Approve'
  },
  autoapproveDescription: {
    "id": "components.PermissionEdit.autoapproveDescription",
    "defaultMessage": 'Grant automatic approval for all non-4K media requests.'
  },
  autoapproveMovies: {
    "id": "components.PermissionEdit.autoapproveMovies",
    "defaultMessage": 'Auto-Approve Movies'
  },
  autoapproveMoviesDescription: {
    "id": "components.PermissionEdit.autoapproveMoviesDescription",
    "defaultMessage": 'Grant automatic approval for non-4K movie requests.'
  },
  autoapproveSeries: {
    "id": "components.PermissionEdit.autoapproveSeries",
    "defaultMessage": 'Auto-Approve Series'
  },
  autoapproveSeriesDescription: {
    "id": "components.PermissionEdit.autoapproveSeriesDescription",
    "defaultMessage": 'Grant automatic approval for non-4K series requests.'
  },
  autoapprove4k: {
    "id": "components.PermissionEdit.autoapprove4k",
    "defaultMessage": 'Auto-Approve 4K'
  },
  autoapprove4kDescription: {
    "id": "components.PermissionEdit.autoapprove4kDescription",
    "defaultMessage": 'Grant automatic approval for all 4K media requests.'
  },
  autoapprove4kMovies: {
    "id": "components.PermissionEdit.autoapprove4kMovies",
    "defaultMessage": 'Auto-Approve 4K Movies'
  },
  autoapprove4kMoviesDescription: {
    "id": "components.PermissionEdit.autoapprove4kMoviesDescription",
    "defaultMessage": 'Grant automatic approval for 4K movie requests.'
  },
  autoapprove4kSeries: {
    "id": "components.PermissionEdit.autoapprove4kSeries",
    "defaultMessage": 'Auto-Approve 4K Series'
  },
  autoapprove4kSeriesDescription: {
    "id": "components.PermissionEdit.autoapprove4kSeriesDescription",
    "defaultMessage": 'Grant automatic approval for 4K series requests.'
  },
  request4k: {
    "id": "components.PermissionEdit.request4k",
    "defaultMessage": 'Request 4K'
  },
  request4kDescription: {
    "id": "components.PermissionEdit.request4kDescription",
    "defaultMessage": 'Grant permission to submit requests for 4K media.'
  },
  request4kMovies: {
    "id": "components.PermissionEdit.request4kMovies",
    "defaultMessage": 'Request 4K Movies'
  },
  request4kMoviesDescription: {
    "id": "components.PermissionEdit.request4kMoviesDescription",
    "defaultMessage": 'Grant permission to submit requests for 4K movies.'
  },
  request4kTv: {
    "id": "components.PermissionEdit.request4kTv",
    "defaultMessage": 'Request 4K Series'
  },
  request4kTvDescription: {
    "id": "components.PermissionEdit.request4kTvDescription",
    "defaultMessage": 'Grant permission to submit requests for 4K series.'
  },
  advancedrequest: {
    "id": "components.PermissionEdit.advancedrequest",
    "defaultMessage": 'Advanced Requests'
  },
  advancedrequestDescription: {
    "id": "components.PermissionEdit.advancedrequestDescription",
    "defaultMessage": 'Grant permission to modify advanced media request options.'
  },
  autorequest: {
    "id": "components.PermissionEdit.autorequest",
    "defaultMessage": 'Auto-Request'
  },
  autorequestDescription: {
    "id": "components.PermissionEdit.autorequestDescription",
    "defaultMessage": 'Grant permission to automatically submit requests for non-4K media via Plex Watchlist.'
  },
  autorequestMovies: {
    "id": "components.PermissionEdit.autorequestMovies",
    "defaultMessage": 'Auto-Request Movies'
  },
  autorequestMoviesDescription: {
    "id": "components.PermissionEdit.autorequestMoviesDescription",
    "defaultMessage": 'Grant permission to automatically submit requests for non-4K movies via Plex Watchlist.'
  },
  autorequestSeries: {
    "id": "components.PermissionEdit.autorequestSeries",
    "defaultMessage": 'Auto-Request Series'
  },
  autorequestSeriesDescription: {
    "id": "components.PermissionEdit.autorequestSeriesDescription",
    "defaultMessage": 'Grant permission to automatically submit requests for non-4K series via Plex Watchlist.'
  },
  viewrequests: {
    "id": "components.PermissionEdit.viewrequests",
    "defaultMessage": 'View Requests'
  },
  viewrequestsDescription: {
    "id": "components.PermissionEdit.viewrequestsDescription",
    "defaultMessage": 'Grant permission to view media requests submitted by other users.'
  },
  manageissues: {
    "id": "components.PermissionEdit.manageissues",
    "defaultMessage": 'Manage Issues'
  },
  manageissuesDescription: {
    "id": "components.PermissionEdit.manageissuesDescription",
    "defaultMessage": 'Grant permission to manage media issues.'
  },
  createissues: {
    "id": "components.PermissionEdit.createissues",
    "defaultMessage": 'Report Issues'
  },
  createissuesDescription: {
    "id": "components.PermissionEdit.createissuesDescription",
    "defaultMessage": 'Grant permission to report media issues.'
  },
  viewissues: {
    "id": "components.PermissionEdit.viewissues",
    "defaultMessage": 'View Issues'
  },
  viewissuesDescription: {
    "id": "components.PermissionEdit.viewissuesDescription",
    "defaultMessage": 'Grant permission to view media issues reported by other users.'
  },
  viewrecent: {
    "id": "components.PermissionEdit.viewrecent",
    "defaultMessage": 'View Recently Added'
  },
  viewrecentDescription: {
    "id": "components.PermissionEdit.viewrecentDescription",
    "defaultMessage": 'Grant permission to view the list of recently added media.'
  },
  viewwatchlists: {
    "id": "components.PermissionEdit.viewwatchlists",
    "defaultMessage": 'View Plex Watchlists'
  },
  viewwatchlistsDescription: {
    "id": "components.PermissionEdit.viewwatchlistsDescription",
    "defaultMessage": "Grant permission to view other users' Plex Watchlists."
  }
});
const PermissionEdit = ({
  actingUser,
  currentUser,
  currentPermission,
  onUpdate
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.useIntl)();
  const permissionList = [{
    id: 'admin',
    name: intl.formatMessage(messages.admin),
    description: intl.formatMessage(messages.adminDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.ADMIN */ .y3.ADMIN
  }, {
    id: 'users',
    name: intl.formatMessage(messages.users),
    description: intl.formatMessage(messages.usersDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS
  }, {
    id: 'managerequest',
    name: intl.formatMessage(messages.managerequests),
    description: intl.formatMessage(messages.managerequestsDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS,
    children: [{
      id: 'advancedrequest',
      name: intl.formatMessage(messages.advancedrequest),
      description: intl.formatMessage(messages.advancedrequestDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_ADVANCED */ .y3.REQUEST_ADVANCED
    }, {
      id: 'viewrequests',
      name: intl.formatMessage(messages.viewrequests),
      description: intl.formatMessage(messages.viewrequestsDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_VIEW */ .y3.REQUEST_VIEW
    }, {
      id: 'viewrecent',
      name: intl.formatMessage(messages.viewrecent),
      description: intl.formatMessage(messages.viewrecentDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.RECENT_VIEW */ .y3.RECENT_VIEW
    }, {
      id: 'viewwatchlists',
      name: intl.formatMessage(messages.viewwatchlists),
      description: intl.formatMessage(messages.viewwatchlistsDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.WATCHLIST_VIEW */ .y3.WATCHLIST_VIEW
    }]
  }, {
    id: 'request',
    name: intl.formatMessage(messages.request),
    description: intl.formatMessage(messages.requestDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST */ .y3.REQUEST,
    children: [{
      id: 'request-movies',
      name: intl.formatMessage(messages.requestMovies),
      description: intl.formatMessage(messages.requestMoviesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_MOVIE */ .y3.REQUEST_MOVIE
    }, {
      id: 'request-tv',
      name: intl.formatMessage(messages.requestTv),
      description: intl.formatMessage(messages.requestTvDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_TV */ .y3.REQUEST_TV
    }]
  }, {
    id: 'autoapprove',
    name: intl.formatMessage(messages.autoapprove),
    description: intl.formatMessage(messages.autoapproveDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE */ .y3.AUTO_APPROVE,
    requires: [{
      permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST */ .y3.REQUEST]
    }],
    children: [{
      id: 'autoapprovemovies',
      name: intl.formatMessage(messages.autoapproveMovies),
      description: intl.formatMessage(messages.autoapproveMoviesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_MOVIE */ .y3.AUTO_APPROVE_MOVIE,
      requires: [{
        permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST */ .y3.REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_MOVIE */ .y3.REQUEST_MOVIE],
        type: 'or'
      }]
    }, {
      id: 'autoapprovetv',
      name: intl.formatMessage(messages.autoapproveSeries),
      description: intl.formatMessage(messages.autoapproveSeriesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_TV */ .y3.AUTO_APPROVE_TV,
      requires: [{
        permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST */ .y3.REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_TV */ .y3.REQUEST_TV],
        type: 'or'
      }]
    }]
  }, {
    id: 'autorequest',
    name: intl.formatMessage(messages.autorequest),
    description: intl.formatMessage(messages.autorequestDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_REQUEST */ .y3.AUTO_REQUEST,
    requires: [{
      permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST */ .y3.REQUEST]
    }],
    children: [{
      id: 'autorequestmovies',
      name: intl.formatMessage(messages.autorequestMovies),
      description: intl.formatMessage(messages.autorequestMoviesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_REQUEST_MOVIE */ .y3.AUTO_REQUEST_MOVIE,
      requires: [{
        permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST */ .y3.REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_MOVIE */ .y3.REQUEST_MOVIE],
        type: 'or'
      }]
    }, {
      id: 'autorequesttv',
      name: intl.formatMessage(messages.autorequestSeries),
      description: intl.formatMessage(messages.autorequestSeriesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_REQUEST_TV */ .y3.AUTO_REQUEST_TV,
      requires: [{
        permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST */ .y3.REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_TV */ .y3.REQUEST_TV],
        type: 'or'
      }]
    }]
  }, {
    id: 'request4k',
    name: intl.formatMessage(messages.request4k),
    description: intl.formatMessage(messages.request4kDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K,
    children: [{
      id: 'request4k-movies',
      name: intl.formatMessage(messages.request4kMovies),
      description: intl.formatMessage(messages.request4kMoviesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K_MOVIE */ .y3.REQUEST_4K_MOVIE
    }, {
      id: 'request4k-tv',
      name: intl.formatMessage(messages.request4kTv),
      description: intl.formatMessage(messages.request4kTvDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K_TV */ .y3.REQUEST_4K_TV
    }]
  }, {
    id: 'autoapprove4k',
    name: intl.formatMessage(messages.autoapprove4k),
    description: intl.formatMessage(messages.autoapprove4kDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K */ .y3.AUTO_APPROVE_4K,
    requires: [{
      permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K]
    }],
    children: [{
      id: 'autoapprove4k-movies',
      name: intl.formatMessage(messages.autoapprove4kMovies),
      description: intl.formatMessage(messages.autoapprove4kMoviesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K_MOVIE */ .y3.AUTO_APPROVE_4K_MOVIE,
      requires: [{
        permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K_MOVIE */ .y3.REQUEST_4K_MOVIE],
        type: 'or'
      }]
    }, {
      id: 'autoapprove4k-tv',
      name: intl.formatMessage(messages.autoapprove4kSeries),
      description: intl.formatMessage(messages.autoapprove4kSeriesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K_TV */ .y3.AUTO_APPROVE_4K_TV,
      requires: [{
        permissions: [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K_TV */ .y3.REQUEST_4K_TV],
        type: 'or'
      }]
    }]
  }, {
    id: 'manageissues',
    name: intl.formatMessage(messages.manageissues),
    description: intl.formatMessage(messages.manageissuesDescription),
    permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_ISSUES */ .y3.MANAGE_ISSUES,
    children: [{
      id: 'createissues',
      name: intl.formatMessage(messages.createissues),
      description: intl.formatMessage(messages.createissuesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.CREATE_ISSUES */ .y3.CREATE_ISSUES
    }, {
      id: 'viewissues',
      name: intl.formatMessage(messages.viewissues),
      description: intl.formatMessage(messages.viewissuesDescription),
      permission: _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.VIEW_ISSUES */ .y3.VIEW_ISSUES
    }]
  }];
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: permissionList.map(permissionItem => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_app_components_PermissionOption__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      option: permissionItem,
      actingUser: actingUser,
      currentUser: currentUser,
      currentPermission: currentPermission,
      onUpdate: newPermission => onUpdate(newPermission)
    }, `permission-option-${permissionItem.id}`))
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PermissionEdit);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 74339:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86799);
/* harmony import */ var _server_lib_permissions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__]);
([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const PermissionOption = ({
  option,
  actingUser,
  currentUser,
  currentPermission,
  onUpdate,
  parent
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const autoApprovePermissions = [_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE */ .y3.AUTO_APPROVE, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_MOVIE */ .y3.AUTO_APPROVE_MOVIE, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_TV */ .y3.AUTO_APPROVE_TV, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K */ .y3.AUTO_APPROVE_4K, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K_MOVIE */ .y3.AUTO_APPROVE_4K_MOVIE, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K_TV */ .y3.AUTO_APPROVE_4K_TV];
  let disabled = false;
  let checked = (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_2__/* .hasPermission */ .F)(option.permission, currentPermission);

  if ( // Permissions for user ID 1 (Plex server owner) cannot be changed
  currentUser && currentUser.id === 1 || // Admin permission automatically bypasses/grants all other permissions
  option.permission !== _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.ADMIN */ .y3.ADMIN && (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_2__/* .hasPermission */ .F)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.ADMIN */ .y3.ADMIN, currentPermission) || // Manage Requests permission automatically grants all Auto-Approve permissions
  autoApprovePermissions.includes(option.permission) && (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_2__/* .hasPermission */ .F)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, currentPermission) || // Selecting a parent permission automatically selects all children
  !!parent?.permission && (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_2__/* .hasPermission */ .F)(parent.permission, currentPermission)) {
    disabled = true;
    checked = true;
  }

  if ( // Only the owner can modify the Admin permission
  actingUser?.id !== 1 && option.permission === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.ADMIN */ .y3.ADMIN) {
    disabled = true;
  }

  if ( // Some permissions are dependent on others; check requirements are fulfilled
  option.requires && !option.requires.every(requirement => (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_2__/* .hasPermission */ .F)(requirement.permissions, currentPermission, {
    type: requirement.type ?? 'and'
  })) || // Request 4K and Auto-Approve 4K require both 4K movie & 4K series requests to be enabled
  (option.permission === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K */ .y3.REQUEST_4K || option.permission === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K */ .y3.AUTO_APPROVE_4K) && (!settings.currentSettings.movie4kEnabled || !settings.currentSettings.series4kEnabled) || // Request 4K Movie and Auto-Approve 4K Movie require 4K movie requests to be enabled
  (option.permission === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K_MOVIE */ .y3.REQUEST_4K_MOVIE || option.permission === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K_MOVIE */ .y3.AUTO_APPROVE_4K_MOVIE) && !settings.currentSettings.movie4kEnabled || // Request 4K Series and Auto-Approve 4K Series require 4K series requests to be enabled
  (option.permission === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.REQUEST_4K_TV */ .y3.REQUEST_4K_TV || option.permission === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.AUTO_APPROVE_4K_TV */ .y3.AUTO_APPROVE_4K_TV) && !settings.currentSettings.series4kEnabled) {
    disabled = true;
    checked = false;
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: `relative mt-4 flex items-start first:mt-0 ${disabled ? 'opacity-50' : ''}`,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "flex h-6 items-center",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("input", {
          id: option.id,
          name: "permissions",
          type: "checkbox",
          disabled: disabled,
          onChange: () => {
            onUpdate((0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_2__/* .hasPermission */ .F)(option.permission, currentPermission) ? currentPermission - option.permission : currentPermission + option.permission);
          },
          checked: checked
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "ml-3 text-sm leading-6",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("label", {
          htmlFor: option.id,
          className: "block",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "flex flex-col",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("span", {
              className: "font-medium text-white",
              children: option.name
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("span", {
              className: "font-normal text-gray-400",
              children: option.description
            })]
          })
        })
      })]
    }), (option.children ?? []).map(child => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      className: "mt-4 pl-10",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(PermissionOption, {
        option: child,
        currentPermission: currentPermission,
        onUpdate: newPermission => onUpdate(newPermission),
        parent: option
      })
    }, `permission-child-${child.id}`))]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PermissionOption);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;