"use strict";
exports.id = 38242;
exports.ids = [38242];
exports.modules = {

/***/ 38242:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "p": () => (/* binding */ encodeURIExtraParams)
/* harmony export */ });
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59147);
/* harmony import */ var swr_infinite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91448);
/* harmony import */ var _useSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1388);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr_infinite__WEBPACK_IMPORTED_MODULE_1__, _useSettings__WEBPACK_IMPORTED_MODULE_2__]);
([swr_infinite__WEBPACK_IMPORTED_MODULE_1__, _useSettings__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




const extraEncodes = [[/\(/g, '%28'], [/\)/g, '%29'], [/!/g, '%21'], [/\*/g, '%2A']];
const encodeURIExtraParams = string => {
  let finalString = encodeURIComponent(string);
  extraEncodes.forEach(encode => {
    finalString = finalString.replace(encode[0], encode[1]);
  });
  return finalString;
};

const useDiscover = (endpoint, options, {
  hideAvailable = true
} = {}) => {
  const settings = (0,_useSettings__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)();
  const {
    data,
    error,
    size,
    setSize,
    isValidating
  } = (0,swr_infinite__WEBPACK_IMPORTED_MODULE_1__["default"])((pageIndex, previousPageData) => {
    if (previousPageData && pageIndex + 1 > previousPageData.totalPages) {
      return null;
    }

    const params = _objectSpread({
      page: pageIndex + 1
    }, options);

    const finalQueryString = Object.keys(params).map(paramKey => `${paramKey}=${encodeURIExtraParams(params[paramKey])}`).join('&');
    return `${endpoint}?${finalQueryString}`;
  }, {
    initialSize: 3
  });
  const isLoadingInitialData = !data && !error;
  const isLoadingMore = isLoadingInitialData || size > 0 && !!data && typeof data[size - 1] === 'undefined' && isValidating;

  const fetchMore = () => {
    setSize(size + 1);
  };

  let titles = (data ?? []).reduce((a, v) => [...a, ...v.results], []);

  if (settings.currentSettings.hideAvailable && hideAvailable) {
    titles = titles.filter(i => (i.mediaType === 'movie' || i.mediaType === 'tv') && i.mediaInfo?.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_0__/* .MediaStatus.AVAILABLE */ .Jp.AVAILABLE && i.mediaInfo?.status !== _server_constants_media__WEBPACK_IMPORTED_MODULE_0__/* .MediaStatus.PARTIALLY_AVAILABLE */ .Jp.PARTIALLY_AVAILABLE);
  }

  const isEmpty = !isLoadingInitialData && titles?.length === 0;
  const isReachingEnd = isEmpty || !!data && (data[data?.length - 1]?.results.length ?? 0) < 20 || !!data && (data[data?.length - 1]?.totalResults ?? 0) < 41;
  return {
    isLoadingInitialData,
    isLoadingMore,
    fetchMore,
    isEmpty,
    isReachingEnd,
    error,
    titles,
    firstResultData: data?.[0]
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useDiscover);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;