"use strict";
exports.id = 44422;
exports.ids = [44422];
exports.modules = {

/***/ 6913:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_ConfirmButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10591);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var ua_parser_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(59621);
/* harmony import */ var ua_parser_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(ua_parser_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);








const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.defineMessages)({
  operatingsystem: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.operatingsystem",
    "defaultMessage": 'Operating System'
  },
  browser: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.browser",
    "defaultMessage": 'Browser'
  },
  engine: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.engine",
    "defaultMessage": 'Engine'
  },
  deletesubscription: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.deletesubscription",
    "defaultMessage": 'Delete Subscription'
  },
  unknown: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.unknown",
    "defaultMessage": 'Unknown'
  },
  activesubscription: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.activesubscription",
    "defaultMessage": 'Active Subscription'
  }
});

const DeviceItem = ({
  deletePushSubscriptionFromBackend,
  device,
  subEndpoint
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.useIntl)();
  const parsedUserAgent = (0,ua_parser_js__WEBPACK_IMPORTED_MODULE_5__.UAParser)(device.userAgent);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "relative flex w-full flex-col justify-between overflow-hidden rounded-xl bg-gray-800 py-4 text-gray-400 shadow-md ring-1 ring-gray-700 xl:h-28 xl:flex-row",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "relative flex w-full flex-col justify-between overflow-hidden sm:flex-row",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "relative z-10 flex w-full items-center overflow-hidden pl-4 pr-4 sm:pr-0 xl:w-7/12 2xl:w-2/3",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "relative h-auto w-12 flex-shrink-0 scale-100 transform-gpu overflow-hidden rounded-md transition duration-300 hover:scale-105",
          children: parsedUserAgent.device.type === 'mobile' ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_3__.DevicePhoneMobileIcon, {}) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_3__.ComputerDesktopIcon, {})
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex flex-col justify-center overflow-hidden pl-2 xl:pl-4",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
            className: "pt-0.5 text-xs font-medium text-white sm:pt-1",
            children: device.createdAt ? intl.formatDate(device.createdAt, {
              year: 'numeric',
              month: 'long',
              day: 'numeric'
            }) : 'N/A'
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
            className: "mr-2 min-w-0 truncate text-lg font-bold text-white hover:underline xl:text-xl",
            children: device.userAgent && parsedUserAgent.device.model ? parsedUserAgent.device.model : intl.formatMessage(messages.unknown)
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "z-10 mt-4 ml-4 flex w-full flex-col justify-center overflow-hidden pr-4 text-sm sm:ml-2 sm:mt-0 xl:flex-1 xl:pr-0",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "card-field",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
            className: "card-field-name",
            children: intl.formatMessage(messages.operatingsystem)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
            className: "flex truncate text-sm text-gray-300",
            children: device.userAgent ? parsedUserAgent.os.name : 'N/A'
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "card-field",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
            className: "card-field-name",
            children: intl.formatMessage(messages.browser)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
            className: "flex truncate text-sm text-gray-300",
            children: device.userAgent ? parsedUserAgent.browser.name : 'N/A'
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "card-field",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
            className: "card-field-name",
            children: intl.formatMessage(messages.engine)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
            className: "flex truncate text-sm text-gray-300",
            children: device.userAgent ? parsedUserAgent.engine.name : 'N/A'
          })]
        })]
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
      className: "z-10 mt-4 flex w-full flex-col justify-center space-y-2 pl-4 pr-4 xl:mt-0 xl:w-96 xl:items-end xl:pl-0",
      children: subEndpoint === device.endpoint ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        buttonType: "primary",
        className: "w-full",
        disabled: true,
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_3__.LockClosedIcon, {}), ' ', /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
          children: intl.formatMessage(messages.activesubscription)
        })]
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_app_components_Common_ConfirmButton__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        onClick: () => deletePushSubscriptionFromBackend(device.endpoint),
        confirmText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].areyousure */ .Z.areyousure),
        className: "w-full",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_3__.TrashIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
          children: intl.formatMessage(messages.deletesubscription)
        })]
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DeviceItem);

/***/ }),

/***/ 77222:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95909);
/* harmony import */ var _app_components_UserProfile_UserSettings_UserNotificationSettings_UserNotificationsWebPush_DeviceItem__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6913);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80210);
/* harmony import */ var _app_utils_pushSubscriptionHelpers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(61046);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, _app_utils_pushSubscriptionHelpers__WEBPACK_IMPORTED_MODULE_8__, axios__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_17__]);
([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, _app_utils_pushSubscriptionHelpers__WEBPACK_IMPORTED_MODULE_8__, axios__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_17__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.defineMessages)({
  webpushsettingssaved: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.webpushsettingssaved",
    "defaultMessage": 'Web push notification settings saved successfully!'
  },
  webpushsettingsfailed: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.webpushsettingsfailed",
    "defaultMessage": 'Web push notification settings failed to save.'
  },
  enablewebpush: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.enablewebpush",
    "defaultMessage": 'Enable web push'
  },
  disablewebpush: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.disablewebpush",
    "defaultMessage": 'Disable web push'
  },
  managedevices: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.managedevices",
    "defaultMessage": 'Manage Devices'
  },
  type: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.type",
    "defaultMessage": 'type'
  },
  created: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.created",
    "defaultMessage": 'Created'
  },
  device: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.device",
    "defaultMessage": 'Device'
  },
  subscriptiondeleted: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.subscriptiondeleted",
    "defaultMessage": 'Subscription deleted.'
  },
  subscriptiondeleteerror: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.subscriptiondeleteerror",
    "defaultMessage": 'Something went wrong while deleting the user subscription.'
  },
  nodevicestoshow: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.nodevicestoshow",
    "defaultMessage": 'You have no web push subscriptions to show.'
  },
  webpushhasbeenenabled: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.webpushhasbeenenabled",
    "defaultMessage": 'Web push has been enabled.'
  },
  webpushhasbeendisabled: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.webpushhasbeendisabled",
    "defaultMessage": 'Web push has been disabled.'
  },
  enablingwebpusherror: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.enablingwebpusherror",
    "defaultMessage": 'Something went wrong while enabling web push.'
  },
  disablingwebpusherror: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.UserNotificationsWebPush.disablingwebpusherror",
    "defaultMessage": 'Something went wrong while disabling web push.'
  }
});

const UserWebPushSettings = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__.useToasts)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_13__.useRouter)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    currentSettings
  } = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)();
  const {
    0: webPushEnabled,
    1: setWebPushEnabled
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const {
    0: subEndpoint,
    1: setSubEndpoint
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(null);
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])(user ? `/api/v1/user/${user?.id}/settings/notifications` : null);
  const {
    data: dataDevices,
    mutate: revalidateDevices
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])(`/api/v1/user/${user?.id}/pushSubscriptions`, {
    revalidateOnMount: true
  }); // Subscribes to the push manager
  // Will only add to the database if subscribing for the first time

  const enablePushNotifications = async () => {
    try {
      const isSubscribed = await (0,_app_utils_pushSubscriptionHelpers__WEBPACK_IMPORTED_MODULE_8__/* .subscribeToPushNotifications */ .rR)(user?.id, currentSettings);

      if (isSubscribed) {
        localStorage.setItem('pushNotificationsEnabled', 'true');
        setWebPushEnabled(true);
        addToast(intl.formatMessage(messages.webpushhasbeenenabled), {
          appearance: 'success',
          autoDismiss: true
        });
      } else {
        throw new Error('Subscription failed');
      }
    } catch (error) {
      addToast(intl.formatMessage(messages.enablingwebpusherror), {
        appearance: 'error',
        autoDismiss: true
      });
    } finally {
      revalidateDevices();
    }
  }; // Unsubscribes from the push manager
  // Deletes/disables corresponding push subscription from database


  const disablePushNotifications = async endpoint => {
    try {
      await (0,_app_utils_pushSubscriptionHelpers__WEBPACK_IMPORTED_MODULE_8__/* .unsubscribeToPushNotifications */ .ax)(user?.id, endpoint);
      localStorage.setItem('pushNotificationsEnabled', 'false');
      setWebPushEnabled(false);
      addToast(intl.formatMessage(messages.webpushhasbeendisabled), {
        autoDismiss: true,
        appearance: 'success'
      });
    } catch (error) {
      addToast(intl.formatMessage(messages.disablingwebpusherror), {
        autoDismiss: true,
        appearance: 'error'
      });
    } finally {
      revalidateDevices();
    }
  };

  const deletePushSubscriptionFromBackend = async endpoint => {
    try {
      await axios__WEBPACK_IMPORTED_MODULE_11__["default"]["delete"](`/api/v1/user/${user?.id}/pushSubscription/${encodeURIComponent(endpoint)}`);
      addToast(intl.formatMessage(messages.subscriptiondeleted), {
        autoDismiss: true,
        appearance: 'success'
      });
    } catch (error) {
      addToast(intl.formatMessage(messages.subscriptiondeleteerror), {
        autoDismiss: true,
        appearance: 'error'
      });
    } finally {
      revalidateDevices();
    }
  };

  (0,react__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    const verifyWebPush = async () => {
      const enabled = await (0,_app_utils_pushSubscriptionHelpers__WEBPACK_IMPORTED_MODULE_8__/* .verifyPushSubscription */ .hR)(user?.id, currentSettings);
      setWebPushEnabled(enabled);
    };

    if (user?.id) {
      verifyWebPush();
    }
  }, [user?.id, currentSettings]);
  (0,react__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    const getSubscriptionEndpoint = async () => {
      if ('serviceWorker' in navigator && 'PushManager' in window) {
        const {
          subscription
        } = await (0,_app_utils_pushSubscriptionHelpers__WEBPACK_IMPORTED_MODULE_8__/* .getPushSubscription */ .U2)();

        if (subscription) {
          setSubEndpoint(subscription.endpoint);
        } else {
          setSubEndpoint(null);
        }
      }
    };

    getSubscriptionEndpoint();
  }, [webPushEnabled]);
  const sortedDevices = (0,react__WEBPACK_IMPORTED_MODULE_14__.useMemo)(() => {
    if (!dataDevices || !subEndpoint) {
      return dataDevices;
    }

    return [...dataDevices].sort((a, b) => {
      if (a.endpoint === subEndpoint) {
        return -1;
      }

      if (b.endpoint === subEndpoint) {
        return 1;
      }

      const dateA = a.createdAt ? new Date(a.createdAt).getTime() : 0;
      const dateB = b.createdAt ? new Date(b.createdAt).getTime() : 0;
      return dateB - dateA;
    });
  }, [dataDevices, subEndpoint]);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Formik, {
      initialValues: {
        types: data?.notificationTypes.webpush ?? _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__/* .ALL_NOTIFICATIONS */ .rK
      },
      enableReinitialize: true,
      onSubmit: async values => {
        try {
          await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post(`/api/v1/user/${user?.id}/settings/notifications`, {
            pgpKey: data?.pgpKey,
            discordId: data?.discordId,
            pushbulletAccessToken: data?.pushbulletAccessToken,
            pushoverApplicationToken: data?.pushoverApplicationToken,
            pushoverUserKey: data?.pushoverUserKey,
            telegramChatId: data?.telegramChatId,
            telegramSendSilently: data?.telegramSendSilently,
            notificationTypes: {
              webpush: values.types
            }
          });
          (0,swr__WEBPACK_IMPORTED_MODULE_17__.mutate)('/api/v1/settings/public');
          addToast(intl.formatMessage(messages.webpushsettingssaved), {
            appearance: 'success',
            autoDismiss: true
          });
        } catch (e) {
          addToast(intl.formatMessage(messages.webpushsettingsfailed), {
            appearance: 'error',
            autoDismiss: true
          });
        } finally {
          revalidate();
        }
      },
      children: ({
        errors,
        touched,
        isSubmitting,
        isValid,
        values,
        setFieldValue,
        setFieldTouched
      }) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_12__.Form, {
          className: "section",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP, {
            user: user,
            currentTypes: values.types,
            onUpdate: newTypes => {
              setFieldValue('types', newTypes);
              setFieldTouched('types');
            },
            error: errors.types && touched.types ? errors.types : undefined
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
            className: "actions",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
              className: "flex justify-end",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "ml-3 inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  buttonType: `${webPushEnabled ? 'danger' : 'primary'}`,
                  type: "button",
                  onClick: () => webPushEnabled ? disablePushNotifications() : enablePushNotifications(),
                  children: [webPushEnabled ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__.CloudArrowDownIcon, {}) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__.CloudArrowUpIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                    children: webPushEnabled ? intl.formatMessage(messages.disablewebpush) : intl.formatMessage(messages.enablewebpush)
                  })]
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                className: "ml-3 inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  buttonType: "primary",
                  type: "submit",
                  disabled: isSubmitting || !isValid,
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("span", {
                    children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].save */ .Z.save)
                  })]
                })
              })]
            })
          })]
        });
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsxs)("div", {
      className: "mt-10 mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.managedevices)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
        className: "section",
        children: sortedDevices?.length ? sortedDevices.map(device => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx("div", {
          className: "py-2",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_UserProfile_UserSettings_UserNotificationSettings_UserNotificationsWebPush_DeviceItem__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
            deletePushSubscriptionFromBackend: deletePushSubscriptionFromBackend,
            device: device,
            subEndpoint: subEndpoint
          })
        }, `device-list-${device.endpoint}`)) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_18__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            title: intl.formatMessage(messages.nodevicestoshow),
            type: "info"
          })
        })
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserWebPushSettings);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12965:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/**
 * useClickOutside
 *
 * Simple hook to add an event listener to the body and allow a callback to
 * be triggered when clicking outside of the target ref
 *
 * @param ref Any HTML Element ref
 * @param callback Callback triggered when clicking outside of ref element
 */

const useClickOutside = (ref, callback) => {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const handleBodyClick = e => {
      if (ref.current && !ref.current.contains(e.target)) {
        callback(e);
      }
    };

    document.body.addEventListener('click', handleBodyClick, {
      capture: true
    });
    return () => {
      document.body.removeEventListener('click', handleBodyClick);
    };
  }, [ref, callback]);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useClickOutside);

/***/ })

};
;