"use strict";
exports.id = 51873;
exports.ids = [51873];
exports.modules = {

/***/ 51873:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19692);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_ProgressCircle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(72964);
/* harmony import */ var _app_components_RequestCard__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31601);
/* harmony import */ var _app_components_Slider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11360);
/* harmony import */ var _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(33056);
/* harmony import */ var _app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(96157);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(86799);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(35635);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_0__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestCard__WEBPACK_IMPORTED_MODULE_4__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_5__, _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_6__, _app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_7__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__, _app_pages_error__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_15__]);
([_app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_0__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestCard__WEBPACK_IMPORTED_MODULE_4__, _app_components_Slider__WEBPACK_IMPORTED_MODULE_5__, _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_6__, _app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_7__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__, _app_pages_error__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_14__.defineMessages)({
  recentrequests: {
    "id": "components.UserProfile.recentrequests",
    "defaultMessage": 'Recent Requests'
  },
  limit: {
    "id": "components.UserProfile.limit",
    "defaultMessage": '{remaining} of {limit}'
  },
  requestsperdays: {
    "id": "components.UserProfile.requestsperdays",
    "defaultMessage": '{limit} remaining'
  },
  unlimited: {
    "id": "components.UserProfile.unlimited",
    "defaultMessage": 'Unlimited'
  },
  totalrequests: {
    "id": "components.UserProfile.totalrequests",
    "defaultMessage": 'Total Requests'
  },
  pastdays: {
    "id": "components.UserProfile.pastdays",
    "defaultMessage": '{type} (past {days} days)'
  },
  movierequests: {
    "id": "components.UserProfile.movierequests",
    "defaultMessage": 'Movie Requests'
  },
  seriesrequest: {
    "id": "components.UserProfile.seriesrequest",
    "defaultMessage": 'Series Requests'
  },
  recentlywatched: {
    "id": "components.UserProfile.recentlywatched",
    "defaultMessage": 'Recently Watched'
  },
  plexwatchlist: {
    "id": "components.UserProfile.plexwatchlist",
    "defaultMessage": 'Plex Watchlist'
  },
  emptywatchlist: {
    "id": "components.UserProfile.emptywatchlist",
    "defaultMessage": 'Media added to your <PlexWatchlistSupportLink>Plex Watchlist</PlexWatchlistSupportLink> will appear here.'
  }
});

const UserProfile = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_14__.useIntl)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_12__.useRouter)();
  const {
    user,
    error
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    user: currentUser,
    hasPermission: currentHasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .useUser */ .aF)();
  const {
    0: availableTitles,
    1: setAvailableTitles
  } = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)({});
  const {
    data: requests,
    error: requestError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_15__["default"])(user && (user.id === currentUser?.id || currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.REQUEST_VIEW */ .y3.REQUEST_VIEW], {
    type: 'or'
  })) ? `/api/v1/user/${user?.id}/requests?take=10&skip=0` : null);
  const {
    data: quota
  } = (0,swr__WEBPACK_IMPORTED_MODULE_15__["default"])(user && (user.id === currentUser?.id || currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS], {
    type: 'and'
  })) ? `/api/v1/user/${user.id}/quota` : null);
  const {
    data: watchData,
    error: watchDataError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_15__["default"])(user?.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .UserType.PLEX */ .FW.PLEX && (user.id === currentUser?.id || currentHasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.ADMIN */ .y3.ADMIN)) ? `/api/v1/user/${user.id}/watch_data` : null);
  const {
    data: watchlistItems,
    error: watchlistError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_15__["default"])(user?.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .UserType.PLEX */ .FW.PLEX && (user.id === currentUser?.id || currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.WATCHLIST_VIEW */ .y3.WATCHLIST_VIEW], {
    type: 'or'
  })) ? `/api/v1/user/${user.id}/watchlist` : null, {
    revalidateOnMount: true
  });
  const updateAvailableTitles = (0,react__WEBPACK_IMPORTED_MODULE_13__.useCallback)((requestId, mediaTitle) => {
    setAvailableTitles(titles => _objectSpread(_objectSpread({}, titles), {}, {
      [requestId]: mediaTitle
    }));
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
    setAvailableTitles({});
  }, [user?.id]);

  if (!user && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  if (!user) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_9__["default"], {
      statusCode: 404
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      title: user.displayName
    }), Object.keys(availableTitles).length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
      className: "absolute left-0 right-0 -top-16 z-0 h-96",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        isDarker: true,
        backgroundImages: Object.values(availableTitles).filter(media => media.backdropPath).map(media => `https://image.tmdb.org/t/p/w1920_and_h800_multi_faces/${media.backdropPath}`).slice(0, 6)
      }, user.id)
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      user: user
    }), quota && (user.id === currentUser?.id || currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS], {
      type: 'and'
    })) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
      className: "relative z-40",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("dl", {
        className: "mt-5 grid grid-cols-1 gap-5 lg:grid-cols-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: "overflow-hidden rounded-lg bg-gray-800 bg-opacity-50 px-4 py-5 shadow ring-1 ring-gray-700 sm:p-6",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("dt", {
            className: "truncate text-sm font-bold text-gray-300",
            children: intl.formatMessage(messages.totalrequests)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("dd", {
            className: "mt-1 text-3xl font-semibold text-white",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx((next_link__WEBPACK_IMPORTED_MODULE_11___default()), {
              href: user.id === currentUser?.id ? '/profile/requests?filter=all' : `/users/${user?.id}/requests?filter=all`,
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("a", {
                children: intl.formatNumber(user.requestCount)
              })
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: `overflow-hidden rounded-lg bg-gray-800 bg-opacity-50 px-4 py-5 shadow ring-1 ${quota.movie.restricted ? 'bg-gradient-to-t from-red-900 to-transparent ring-red-500' : 'ring-gray-700'} sm:p-6`,
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("dt", {
            className: `truncate text-sm font-bold ${quota.movie.restricted ? 'text-red-500' : 'text-gray-300'}`,
            children: quota.movie.limit ? intl.formatMessage(messages.pastdays, {
              type: intl.formatMessage(messages.movierequests),
              days: quota?.movie.days
            }) : intl.formatMessage(messages.movierequests)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("dd", {
            className: `mt-1 flex items-center text-sm ${quota.movie.restricted ? 'text-red-500' : 'text-white'}`,
            children: quota.movie.limit ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_ProgressCircle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                progress: Math.round((quota?.movie.remaining ?? 0) / (quota?.movie.limit ?? 1) * 100),
                useHeatLevel: true,
                className: "mr-2 h-8 w-8"
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                children: intl.formatMessage(messages.requestsperdays, {
                  limit: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                    className: "text-3xl font-semibold",
                    children: intl.formatMessage(messages.limit, {
                      remaining: quota.movie.remaining,
                      limit: quota.movie.limit
                    })
                  })
                })
              })]
            }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
              className: "text-3xl font-semibold",
              children: intl.formatMessage(messages.unlimited)
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: `overflow-hidden rounded-lg bg-gray-800 bg-opacity-50 px-4 py-5 shadow ring-1 ${quota.tv.restricted ? 'bg-gradient-to-t from-red-900 to-transparent ring-red-500' : 'ring-gray-700'} sm:p-6`,
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("dt", {
            className: `truncate text-sm font-bold ${quota.tv.restricted ? 'text-red-500' : 'text-gray-300'}`,
            children: quota.tv.limit ? intl.formatMessage(messages.pastdays, {
              type: intl.formatMessage(messages.seriesrequest),
              days: quota?.tv.days
            }) : intl.formatMessage(messages.seriesrequest)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("dd", {
            className: `mt-1 flex items-center text-sm ${quota.tv.restricted ? 'text-red-500' : 'text-white'}`,
            children: quota.tv.limit ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_ProgressCircle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                progress: Math.round((quota?.tv.remaining ?? 0) / (quota?.tv.limit ?? 1) * 100),
                useHeatLevel: true,
                className: "mr-2 h-8 w-8"
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                children: intl.formatMessage(messages.requestsperdays, {
                  limit: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                    className: "text-3xl font-semibold",
                    children: intl.formatMessage(messages.limit, {
                      remaining: quota.tv.remaining,
                      limit: quota.tv.limit
                    })
                  })
                })
              })]
            }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
              className: "text-3xl font-semibold",
              children: intl.formatMessage(messages.unlimited)
            })
          })]
        })]
      })
    }), (user.id === currentUser?.id || currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.REQUEST_VIEW */ .y3.REQUEST_VIEW], {
      type: 'or'
    })) && (!requests || !!requests.results.length) && !requestError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
        className: "slider-header",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx((next_link__WEBPACK_IMPORTED_MODULE_11___default()), {
          href: user.id === currentUser?.id ? '/profile/requests?filter=all' : `/users/${user?.id}/requests?filter=all`,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("a", {
            className: "slider-title",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
              children: intl.formatMessage(messages.recentrequests)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__.ArrowRightCircleIcon, {})]
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        sliderKey: "requests",
        isLoading: !requests,
        items: (requests?.results ?? []).map(request => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_RequestCard__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          request: request,
          onTitleData: updateAvailableTitles
        }, `request-slider-item-${request.id}`)),
        placeholder: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_RequestCard__WEBPACK_IMPORTED_MODULE_4__/* ["default"].Placeholder */ .Z.Placeholder, {})
      })]
    }), user.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .UserType.PLEX */ .FW.PLEX && (user.id === currentUser?.id || currentHasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.MANAGE_REQUESTS */ .y3.MANAGE_REQUESTS, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.WATCHLIST_VIEW */ .y3.WATCHLIST_VIEW], {
      type: 'or'
    })) && (!watchlistItems || !!watchlistItems.results.length || user.id === currentUser?.id && (user.settings?.watchlistSyncMovies || user.settings?.watchlistSyncTv)) && !watchlistError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
        className: "slider-header",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx((next_link__WEBPACK_IMPORTED_MODULE_11___default()), {
          href: user.id === currentUser?.id ? '/profile/watchlist' : `/users/${user?.id}/watchlist`,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("a", {
            className: "slider-title",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
              children: intl.formatMessage(messages.plexwatchlist)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_10__.ArrowRightCircleIcon, {})]
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        sliderKey: "watchlist",
        isLoading: !watchlistItems,
        isEmpty: !!watchlistItems && watchlistItems.results.length === 0,
        emptyMessage: intl.formatMessage(messages.emptywatchlist, {
          PlexWatchlistSupportLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("a", {
            href: "https://support.plex.tv/articles/universal-watchlist/",
            className: "text-white transition duration-300 hover:underline",
            target: "_blank",
            rel: "noreferrer",
            children: msg
          })
        }),
        items: watchlistItems?.results.map(item => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
          id: item.tmdbId,
          tmdbId: item.tmdbId,
          type: item.mediaType
        }, `watchlist-slider-item-${item.ratingKey}`))
      })]
    }), user.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .UserType.PLEX */ .FW.PLEX && (user.id === currentUser?.id || currentHasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.ADMIN */ .y3.ADMIN)) && (!watchData || !!watchData.recentlyWatched.length) && !watchDataError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
        className: "slider-header",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
          className: "slider-title",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
            children: intl.formatMessage(messages.recentlywatched)
          })
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Slider__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        sliderKey: "media",
        isLoading: !watchData,
        items: watchData?.recentlyWatched.map(item => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
          id: item.id,
          tmdbId: item.tmdbId,
          tvdbId: item.tvdbId,
          type: item.mediaType
        }, `media-slider-item-${item.id}`))
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserProfile);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;