"use strict";
exports.id = 54546;
exports.ids = [54546];
exports.modules = {

/***/ 54546:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_SettingsTabs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33173);
/* harmony import */ var _app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(96157);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80210);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(35635);
/* harmony import */ var _server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(44941);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_Common_SettingsTabs__WEBPACK_IMPORTED_MODULE_3__, _app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, _app_pages_error__WEBPACK_IMPORTED_MODULE_8__, swr__WEBPACK_IMPORTED_MODULE_12__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_Common_SettingsTabs__WEBPACK_IMPORTED_MODULE_3__, _app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, _app_pages_error__WEBPACK_IMPORTED_MODULE_8__, swr__WEBPACK_IMPORTED_MODULE_12__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.defineMessages)({
  menuGeneralSettings: {
    "id": "components.UserProfile.UserSettings.menuGeneralSettings",
    "defaultMessage": 'General'
  },
  menuChangePass: {
    "id": "components.UserProfile.UserSettings.menuChangePass",
    "defaultMessage": 'Password'
  },
  menuNotifications: {
    "id": "components.UserProfile.UserSettings.menuNotifications",
    "defaultMessage": 'Notifications'
  },
  menuPermissions: {
    "id": "components.UserProfile.UserSettings.menuPermissions",
    "defaultMessage": 'Permissions'
  },
  unauthorizedDescription: {
    "id": "components.UserProfile.UserSettings.unauthorizedDescription",
    "defaultMessage": "You do not have permission to modify this user's settings."
  }
});

const UserSettings = ({
  children
}) => {
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_10__.useRouter)();
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)();
  const {
    user: currentUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__/* .useUser */ .aF)();
  const {
    user,
    error
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    data
  } = (0,swr__WEBPACK_IMPORTED_MODULE_12__["default"])(user ? `/api/v1/user/${user?.id}/settings/notifications` : null);

  if (!user && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  if (!user) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_8__["default"], {
      statusCode: 500
    });
  }

  const settingsRoutes = [{
    text: intl.formatMessage(messages.menuGeneralSettings),
    route: '/settings/main',
    regex: /\/settings(\/main)?$/
  }, {
    text: intl.formatMessage(messages.menuChangePass),
    route: '/settings/password',
    regex: /\/settings\/password/,
    hidden: !settings.currentSettings.localLogin && !(0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .hasPermission */ .F)(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.ADMIN */ .y.ADMIN, currentUser?.permissions ?? 0) || currentUser?.id !== 1 && currentUser?.id !== user?.id && (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .hasPermission */ .F)(_server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.ADMIN */ .y.ADMIN, user?.permissions ?? 0)
  }, {
    text: intl.formatMessage(messages.menuNotifications),
    route: data?.emailEnabled ? '/settings/notifications/email' : data?.webPushEnabled ? '/settings/notifications/webpush' : data?.discordEnabled ? '/settings/notifications/discord' : '/settings/notifications/pushbullet',
    regex: /\/settings\/notifications/
  }, {
    text: intl.formatMessage(messages.menuPermissions),
    route: '/settings/permissions',
    regex: /\/settings\/permissions/,
    requiredPermission: _server_lib_permissions__WEBPACK_IMPORTED_MODULE_9__/* .Permission.MANAGE_USERS */ .y.MANAGE_USERS,
    hidden: currentUser?.id !== 1 && currentUser?.id === user.id
  }];

  if (currentUser?.id !== 1 && user.id === 1) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        title: [intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].usersettings */ .Z.usersettings), user.displayName]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        user: user,
        isSettingsPage: true
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
        className: "mt-6",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.unauthorizedDescription),
          type: "error"
        })
      })]
    });
  }

  settingsRoutes.forEach(settingsRoute => {
    settingsRoute.route = router.asPath.includes('/profile') ? `/profile${settingsRoute.route}` : `/users/${user.id}${settingsRoute.route}`;
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      title: [intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].usersettings */ .Z.usersettings), user.displayName]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_UserProfile_ProfileHeader__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      user: user,
      isSettingsPage: true
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
      className: "mt-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_SettingsTabs__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        settingsRoutes: settingsRoutes
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
      className: "mt-10 text-white",
      children: children
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserSettings);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;