"use strict";
exports.id = 57058;
exports.ids = [57058];
exports.modules = {

/***/ 57058:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_extlogos_discord_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23970);
/* harmony import */ var _app_assets_extlogos_pushbullet_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(72832);
/* harmony import */ var _app_assets_extlogos_pushover_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13943);
/* harmony import */ var _app_assets_extlogos_telegram_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37159);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_SettingsTabs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(33173);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80210);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(35635);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_5__, _app_components_Common_SettingsTabs__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, _app_pages_error__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_13__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_5__, _app_components_Common_SettingsTabs__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, _app_pages_error__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);

















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.defineMessages)({
  notifications: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.notifications",
    "defaultMessage": 'Notifications'
  },
  notificationsettings: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.notificationsettings",
    "defaultMessage": 'Notification Settings'
  },
  email: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.email",
    "defaultMessage": 'Email'
  },
  webpush: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.webpush",
    "defaultMessage": 'Web Push'
  }
});

const UserNotificationSettings = ({
  children
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.useIntl)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_11__.useRouter)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_13__["default"])(user ? `/api/v1/user/${user?.id}/settings/notifications` : null);
  const settingsRoutes = [{
    text: intl.formatMessage(messages.email),
    content: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("span", {
      className: "flex items-center",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__.EnvelopeIcon, {
        className: "mr-2 h-4"
      }), intl.formatMessage(messages.email)]
    }),
    route: '/settings/notifications/email',
    regex: /\/settings\/notifications\/email/,
    hidden: !data?.emailEnabled
  }, {
    text: intl.formatMessage(messages.webpush),
    content: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("span", {
      className: "flex items-center",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__.CloudIcon, {
        className: "mr-2 h-4"
      }), intl.formatMessage(messages.webpush)]
    }),
    route: '/settings/notifications/webpush',
    regex: /\/settings\/notifications\/webpush/,
    hidden: !data?.webPushEnabled
  }, {
    text: 'Discord',
    content: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("span", {
      className: "flex items-center",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_assets_extlogos_discord_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        className: "mr-2 h-4"
      }), "Discord"]
    }),
    route: '/settings/notifications/discord',
    regex: /\/settings\/notifications\/discord/,
    hidden: !data?.discordEnabled
  }, {
    text: 'Pushbullet',
    content: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("span", {
      className: "flex items-center",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_assets_extlogos_pushbullet_svg__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        className: "mr-2 h-4"
      }), "Pushbullet"]
    }),
    route: '/settings/notifications/pushbullet',
    regex: /\/settings\/notifications\/pushbullet/
  }, {
    text: 'Pushover',
    content: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("span", {
      className: "flex items-center",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_assets_extlogos_pushover_svg__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        className: "mr-2 h-4"
      }), "Pushover"]
    }),
    route: '/settings/notifications/pushover',
    regex: /\/settings\/notifications\/pushover/
  }, {
    text: 'Telegram',
    content: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)("span", {
      className: "flex items-center",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_assets_extlogos_telegram_svg__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        className: "mr-2 h-4"
      }), "Telegram"]
    }),
    route: '/settings/notifications/telegram',
    regex: /\/settings\/notifications\/telegram/,
    hidden: !data?.telegramEnabled || !data?.telegramBotUsername
  }];
  settingsRoutes.forEach(settingsRoute => {
    settingsRoute.route = router.asPath.includes('/profile') ? `/profile${settingsRoute.route}` : `/users/${user?.id}${settingsRoute.route}`;
  });

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_9__["default"], {
      statusCode: 500
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.notifications), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].usersettings */ .Z.usersettings), user?.displayName]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
      className: "mb-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.notificationsettings)
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx(_app_components_Common_SettingsTabs__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
      tabType: "button",
      settingsRoutes: settingsRoutes
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_14__.jsx("div", {
      className: "section",
      children: children
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserNotificationSettings);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;