"use strict";
exports.id = 61276;
exports.ids = [61276];
exports.modules = {

/***/ 2268:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43907);
/* harmony import */ var _heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59476);
/* harmony import */ var _heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59147);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);







const StatusBadgeMini = ({
  status,
  is4k = false,
  inProgress = false,
  shrink = false
}) => {
  const badgeStyle = [`rounded-full bg-opacity-80 shadow-md ${shrink ? 'w-4 sm:w-5 border p-0' : 'w-5 ring-1 p-0.5'}`];
  let indicatorIcon;

  switch (status) {
    case _server_constants_media__WEBPACK_IMPORTED_MODULE_3__/* .MediaStatus.PROCESSING */ .Jp.PROCESSING:
      badgeStyle.push('bg-indigo-500 border-indigo-400 ring-indigo-400 text-indigo-100');
      indicatorIcon = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.ClockIcon, {});
      break;

    case _server_constants_media__WEBPACK_IMPORTED_MODULE_3__/* .MediaStatus.AVAILABLE */ .Jp.AVAILABLE:
      badgeStyle.push('bg-green-500 border-green-400 ring-green-400 text-green-100');
      indicatorIcon = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_heroicons_react_20_solid__WEBPACK_IMPORTED_MODULE_1__.CheckCircleIcon, {});
      break;

    case _server_constants_media__WEBPACK_IMPORTED_MODULE_3__/* .MediaStatus.PENDING */ .Jp.PENDING:
      badgeStyle.push('bg-yellow-500 border-yellow-400 ring-yellow-400 text-yellow-100');
      indicatorIcon = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.BellIcon, {});
      break;

    case _server_constants_media__WEBPACK_IMPORTED_MODULE_3__/* .MediaStatus.PARTIALLY_AVAILABLE */ .Jp.PARTIALLY_AVAILABLE:
      badgeStyle.push('bg-green-500 border-green-400 ring-green-400 text-green-100');
      indicatorIcon = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.MinusSmallIcon, {});
      break;

    case _server_constants_media__WEBPACK_IMPORTED_MODULE_3__/* .MediaStatus.DELETED */ .Jp.DELETED:
      badgeStyle.push('bg-red-500 border-red-400 ring-red-400 text-red-100');
      indicatorIcon = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.TrashIcon, {});
      break;
  }

  if (inProgress) {
    indicatorIcon = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: `relative inline-flex whitespace-nowrap rounded-full border-gray-700 text-xs font-semibold leading-5 ring-gray-700 ${shrink ? '' : 'ring-1'}`,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      className: badgeStyle.join(' '),
      children: indicatorIcon
    }), is4k && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("span", {
      className: "pl-1 pr-2 text-gray-200",
      children: "4K"
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StatusBadgeMini);

/***/ }),

/***/ 51712:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(99648);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([axios__WEBPACK_IMPORTED_MODULE_3__, swr__WEBPACK_IMPORTED_MODULE_5__]);
([axios__WEBPACK_IMPORTED_MODULE_3__, swr__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.defineMessages)({
  mediaerror: {
    "id": "components.TitleCard.mediaerror",
    "defaultMessage": '{mediaType} Not Found'
  },
  tmdbid: {
    "id": "components.TitleCard.tmdbid",
    "defaultMessage": 'TMDB ID'
  },
  tvdbid: {
    "id": "components.TitleCard.tvdbid",
    "defaultMessage": 'TheTVDB ID'
  },
  cleardata: {
    "id": "components.TitleCard.cleardata",
    "defaultMessage": 'Clear Data'
  }
});

const Error = ({
  id,
  tmdbId,
  tvdbId,
  type,
  canExpand
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_4__.useIntl)();

  const deleteMedia = async () => {
    await axios__WEBPACK_IMPORTED_MODULE_3__["default"]["delete"](`/api/v1/media/${id}`);
    (0,swr__WEBPACK_IMPORTED_MODULE_5__.mutate)('/api/v1/media?filter=allavailable&take=20&sort=mediaAdded');
    (0,swr__WEBPACK_IMPORTED_MODULE_5__.mutate)('/api/v1/request?filter=all&take=10&sort=modified&skip=0');
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
    className: canExpand ? 'w-full' : 'w-36 sm:w-36 md:w-44',
    "data-testid": "title-card",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
      className: "relative transform-gpu cursor-default overflow-hidden rounded-xl bg-gray-800 bg-cover shadow outline-none ring-1 ring-gray-700  transition duration-300",
      style: {
        paddingBottom: '150%'
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "absolute inset-0 h-full w-full overflow-hidden",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "absolute left-0 right-0 flex items-center justify-between p-2",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
            className: `pointer-events-none z-40 rounded-full shadow ${type === 'movie' ? 'bg-blue-500' : 'bg-purple-600'}`,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
              className: "flex h-4 items-center px-2 py-2 text-center text-xs font-medium uppercase tracking-wider text-white sm:h-5",
              children: type === 'movie' ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_1__/* ["default"].movie */ .Z.movie) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_1__/* ["default"].tvshow */ .Z.tvshow)
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
            className: "pointer-events-none z-40",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
              className: "flex h-4 w-4 items-center justify-center rounded-full bg-green-400 text-white shadow sm:h-5 sm:w-5",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.CheckIcon, {
                className: "h-3 w-3 sm:h-4 sm:w-4"
              })
            })
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "flex h-full w-full items-end",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: "px-2 pb-11 text-white",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("h1", {
              className: "whitespace-normal text-xl font-bold leading-tight",
              style: {
                WebkitLineClamp: 3,
                display: '-webkit-box',
                overflow: 'hidden',
                WebkitBoxOrient: 'vertical',
                wordBreak: 'break-word'
              },
              "data-testid": "title-card-title",
              children: intl.formatMessage(messages.mediaerror, {
                mediaType: intl.formatMessage(type === 'movie' ? _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_1__/* ["default"].movie */ .Z.movie : _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_1__/* ["default"].tvshow */ .Z.tvshow)
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "whitespace-normal text-xs",
              style: {
                WebkitLineClamp: 3,
                display: '-webkit-box',
                overflow: 'hidden',
                WebkitBoxOrient: 'vertical',
                wordBreak: 'break-word'
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
                  className: "mr-2 font-bold text-gray-400",
                  children: intl.formatMessage(messages.tmdbid)
                }), tmdbId]
              }), !!tvdbId && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "mt-2 flex items-center sm:mt-1",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
                  className: "mr-2 font-bold text-gray-400",
                  children: intl.formatMessage(messages.tvdbid)
                }), tvdbId]
              })]
            })]
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
          className: "absolute bottom-0 left-0 right-0 flex justify-between px-2 py-2",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            buttonType: "danger",
            buttonSize: "sm",
            onClick: e => {
              e.preventDefault();
              deleteMedia();
            },
            className: "h-7 w-full",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.TrashIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("span", {
              children: intl.formatMessage(messages.cleardata)
            })]
          })
        })]
      })
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Error);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 81239:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);


const Placeholder = ({
  canExpand = false
}) => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    className: `relative animate-pulse rounded-xl bg-gray-700 ${canExpand ? 'w-full' : 'w-36 sm:w-36 md:w-44'}`,
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
      className: "w-full",
      style: {
        paddingBottom: '150%'
      }
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Placeholder);

/***/ }),

/***/ 61276:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43907);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7292);
/* harmony import */ var _app_components_Common_StatusBadgeMini__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2268);
/* harmony import */ var _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(42040);
/* harmony import */ var _app_components_TitleCard_ErrorCard__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(51712);
/* harmony import */ var _app_components_TitleCard_Placeholder__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81239);
/* harmony import */ var _app_hooks_useIsTouch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(67394);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(80210);
/* harmony import */ var _app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(66234);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _server_constants_media__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(59147);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__, _app_components_TitleCard_ErrorCard__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__, _headlessui_react__WEBPACK_IMPORTED_MODULE_10__]);
([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__, _app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__, _app_components_TitleCard_ErrorCard__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__, _headlessui_react__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




















const TitleCard = ({
  id,
  image,
  summary,
  year,
  title,
  status,
  mediaType,
  inProgress = false,
  canExpand = false
}) => {
  const isTouch = (0,_app_hooks_useIsTouch__WEBPACK_IMPORTED_MODULE_7__/* .useIsTouch */ .P)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .useUser */ .aF)();
  const {
    0: isUpdating,
    1: setIsUpdating
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const {
    0: currentStatus,
    1: setCurrentStatus
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(status);
  const {
    0: showDetail,
    1: setShowDetail
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const {
    0: showRequestModal,
    1: setShowRequestModal
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false); // Just to get the year from the date

  if (year) {
    year = year.slice(0, 4);
  }

  (0,react__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    setCurrentStatus(status);
  }, [status]);
  const requestComplete = (0,react__WEBPACK_IMPORTED_MODULE_14__.useCallback)(newStatus => {
    setCurrentStatus(newStatus);
    setShowRequestModal(false);
  }, []);
  const requestUpdating = (0,react__WEBPACK_IMPORTED_MODULE_14__.useCallback)(status => setIsUpdating(status), []);
  const closeModal = (0,react__WEBPACK_IMPORTED_MODULE_14__.useCallback)(() => setShowRequestModal(false), []);
  const showRequestButton = hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.REQUEST */ .y3.REQUEST, mediaType === 'movie' || mediaType === 'collection' ? _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.REQUEST_MOVIE */ .y3.REQUEST_MOVIE : _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_8__/* .Permission.REQUEST_TV */ .y3.REQUEST_TV], {
    type: 'or'
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
    className: canExpand ? 'w-full' : 'w-36 sm:w-36 md:w-44',
    "data-testid": "title-card",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_RequestModal__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      tmdbId: id,
      show: showRequestModal,
      type: mediaType === 'movie' ? 'movie' : mediaType === 'collection' ? 'collection' : 'tv',
      onComplete: requestComplete,
      onUpdating: requestUpdating,
      onCancel: closeModal
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
      className: `relative transform-gpu cursor-default overflow-hidden rounded-xl bg-gray-800 bg-cover outline-none ring-1 transition duration-300 ${showDetail ? 'scale-105 shadow-lg ring-gray-500' : 'scale-100 shadow ring-gray-700'}`,
      style: {
        paddingBottom: '150%'
      },
      onMouseEnter: () => {
        if (!isTouch) {
          setShowDetail(true);
        }
      },
      onMouseLeave: () => setShowDetail(false),
      onClick: () => setShowDetail(true),
      onKeyDown: e => {
        if (e.key === 'Enter') {
          setShowDetail(true);
        }
      },
      role: "link",
      tabIndex: 0,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
        className: "absolute inset-0 h-full w-full overflow-hidden",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          className: "absolute inset-0 h-full w-full",
          alt: "",
          src: image ? `https://image.tmdb.org/t/p/w300_and_h450_face${image}` : `/images/overseerr_poster_not_found_logo_top.png`,
          layout: "fill",
          objectFit: "cover"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: "absolute left-0 right-0 flex items-center justify-between p-2",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
            className: `pointer-events-none z-40 rounded-full border bg-opacity-80 shadow-md ${mediaType === 'movie' || mediaType === 'collection' ? 'border-blue-500 bg-blue-600' : 'border-purple-600 bg-purple-600'}`,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
              className: "flex h-4 items-center px-2 py-2 text-center text-xs font-medium uppercase tracking-wider text-white sm:h-5",
              children: mediaType === 'movie' ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].movie */ .Z.movie) : mediaType === 'collection' ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].collection */ .Z.collection) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].tvshow */ .Z.tvshow)
            })
          }), currentStatus && currentStatus !== _server_constants_media__WEBPACK_IMPORTED_MODULE_12__/* .MediaStatus.UNKNOWN */ .Jp.UNKNOWN && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
            className: "pointer-events-none z-40 flex items-center",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_StatusBadgeMini__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
              status: currentStatus,
              inProgress: inProgress,
              shrink: true
            })
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_10__.Transition, {
          as: react__WEBPACK_IMPORTED_MODULE_14__.Fragment,
          show: isUpdating,
          enter: "transition-opacity ease-in-out duration-300",
          enterFrom: "opacity-0",
          enterTo: "opacity-100",
          leave: "transition-opacity ease-in-out duration-300",
          leaveFrom: "opacity-100",
          leaveTo: "opacity-0",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
            className: "absolute inset-0 z-40 flex items-center justify-center rounded-xl bg-gray-800 bg-opacity-75 text-white",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_assets_spinner_svg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
              className: "h-10 w-10"
            })
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_10__.Transition, {
          as: react__WEBPACK_IMPORTED_MODULE_14__.Fragment,
          show: !image || showDetail || showRequestModal,
          enter: "transition-opacity",
          enterFrom: "opacity-0",
          enterTo: "opacity-100",
          leave: "transition-opacity",
          leaveFrom: "opacity-100",
          leaveTo: "opacity-0",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
            className: "absolute inset-0 overflow-hidden rounded-xl",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx((next_link__WEBPACK_IMPORTED_MODULE_13___default()), {
              href: mediaType === 'movie' ? `/movie/${id}` : mediaType === 'collection' ? `/collection/${id}` : `/tv/${id}`,
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("a", {
                className: "absolute inset-0 h-full w-full cursor-pointer overflow-hidden text-left",
                style: {
                  background: 'linear-gradient(180deg, rgba(45, 55, 72, 0.4) 0%, rgba(45, 55, 72, 0.9) 100%)'
                },
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                  className: "flex h-full w-full items-end",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
                    className: `px-2 text-white ${!showRequestButton || currentStatus && currentStatus !== _server_constants_media__WEBPACK_IMPORTED_MODULE_12__/* .MediaStatus.UNKNOWN */ .Jp.UNKNOWN && currentStatus !== _server_constants_media__WEBPACK_IMPORTED_MODULE_12__/* .MediaStatus.DELETED */ .Jp.DELETED ? 'pb-2' : 'pb-11'}`,
                    children: [year && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                      className: "text-sm font-medium",
                      children: year
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("h1", {
                      className: "whitespace-normal text-xl font-bold leading-tight",
                      style: {
                        WebkitLineClamp: 3,
                        display: '-webkit-box',
                        overflow: 'hidden',
                        WebkitBoxOrient: 'vertical',
                        wordBreak: 'break-word'
                      },
                      "data-testid": "title-card-title",
                      children: title
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                      className: "whitespace-normal text-xs",
                      style: {
                        WebkitLineClamp: !showRequestButton || currentStatus && currentStatus !== _server_constants_media__WEBPACK_IMPORTED_MODULE_12__/* .MediaStatus.UNKNOWN */ .Jp.UNKNOWN && currentStatus !== _server_constants_media__WEBPACK_IMPORTED_MODULE_12__/* .MediaStatus.DELETED */ .Jp.DELETED ? 5 : 3,
                        display: '-webkit-box',
                        overflow: 'hidden',
                        WebkitBoxOrient: 'vertical',
                        wordBreak: 'break-word'
                      },
                      children: summary
                    })]
                  })
                })
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
              className: "absolute bottom-0 left-0 right-0 flex justify-between px-2 py-2",
              children: showRequestButton && (!currentStatus || currentStatus === _server_constants_media__WEBPACK_IMPORTED_MODULE_12__/* .MediaStatus.UNKNOWN */ .Jp.UNKNOWN || currentStatus === _server_constants_media__WEBPACK_IMPORTED_MODULE_12__/* .MediaStatus.DELETED */ .Jp.DELETED) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                buttonType: "primary",
                buttonSize: "sm",
                onClick: e => {
                  e.preventDefault();
                  setShowRequestModal(true);
                },
                className: "h-7 w-full",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_11__.ArrowDownTrayIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                  children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_9__/* ["default"].request */ .Z.request)
                })]
              })
            })]
          })
        })]
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_17__/* .withProperties */ .W)(TitleCard, {
  Placeholder: _app_components_TitleCard_Placeholder__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z,
  ErrorCard: _app_components_TitleCard_ErrorCard__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z
}));
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 67394:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "P": () => (/* binding */ useIsTouch)
/* harmony export */ });
/* harmony import */ var _app_context_InteractionContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71473);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const useIsTouch = () => {
  const {
    isTouch
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(_app_context_InteractionContext__WEBPACK_IMPORTED_MODULE_0__/* .InteractionContext */ .s);
  return isTouch ?? false;
};

/***/ }),

/***/ 66234:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "W": () => (/* binding */ withProperties)
/* harmony export */ });
/**
 * Helps type objects with an arbitrary number of properties that are
 * usually being defined at export.
 *
 * @param component Main object you want to apply properties to
 * @param properties Object of properties you want to type on the main component
 */
function withProperties(component, properties) {
  Object.keys(properties).forEach(key => {
    Object.assign(component, {
      [key]: properties[key]
    });
  });
  return component;
}

/***/ })

};
;