"use strict";
exports.id = 61492;
exports.ids = [61492];
exports.modules = {

/***/ 61492:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "P": () => (/* binding */ OpenPgpLink),
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61903);
/* harmony import */ var _app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(75294);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_11__]);
([axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.defineMessages)({
  validationSmtpHostRequired: {
    "id": "components.Settings.Notifications.validationSmtpHostRequired",
    "defaultMessage": 'You must provide a valid hostname or IP address'
  },
  validationSmtpPortRequired: {
    "id": "components.Settings.Notifications.validationSmtpPortRequired",
    "defaultMessage": 'You must provide a valid port number'
  },
  agentenabled: {
    "id": "components.Settings.Notifications.agentenabled",
    "defaultMessage": 'Enable Agent'
  },
  emailsender: {
    "id": "components.Settings.Notifications.emailsender",
    "defaultMessage": 'Sender Address'
  },
  smtpHost: {
    "id": "components.Settings.Notifications.smtpHost",
    "defaultMessage": 'SMTP Host'
  },
  smtpPort: {
    "id": "components.Settings.Notifications.smtpPort",
    "defaultMessage": 'SMTP Port'
  },
  encryption: {
    "id": "components.Settings.Notifications.encryption",
    "defaultMessage": 'Encryption Method'
  },
  encryptionTip: {
    "id": "components.Settings.Notifications.encryptionTip",
    "defaultMessage": 'In most cases, Implicit TLS uses port 465 and STARTTLS uses port 587'
  },
  encryptionNone: {
    "id": "components.Settings.Notifications.encryptionNone",
    "defaultMessage": 'None'
  },
  encryptionDefault: {
    "id": "components.Settings.Notifications.encryptionDefault",
    "defaultMessage": 'Use STARTTLS if available'
  },
  encryptionOpportunisticTls: {
    "id": "components.Settings.Notifications.encryptionOpportunisticTls",
    "defaultMessage": 'Always use STARTTLS'
  },
  encryptionImplicitTls: {
    "id": "components.Settings.Notifications.encryptionImplicitTls",
    "defaultMessage": 'Use Implicit TLS'
  },
  authUser: {
    "id": "components.Settings.Notifications.authUser",
    "defaultMessage": 'SMTP Username'
  },
  authPass: {
    "id": "components.Settings.Notifications.authPass",
    "defaultMessage": 'SMTP Password'
  },
  emailsettingssaved: {
    "id": "components.Settings.Notifications.emailsettingssaved",
    "defaultMessage": 'Email notification settings saved successfully!'
  },
  emailsettingsfailed: {
    "id": "components.Settings.Notifications.emailsettingsfailed",
    "defaultMessage": 'Email notification settings failed to save.'
  },
  toastEmailTestSending: {
    "id": "components.Settings.Notifications.toastEmailTestSending",
    "defaultMessage": 'Sending email test notification…'
  },
  toastEmailTestSuccess: {
    "id": "components.Settings.Notifications.toastEmailTestSuccess",
    "defaultMessage": 'Email test notification sent!'
  },
  toastEmailTestFailed: {
    "id": "components.Settings.Notifications.toastEmailTestFailed",
    "defaultMessage": 'Email test notification failed to send.'
  },
  allowselfsigned: {
    "id": "components.Settings.Notifications.allowselfsigned",
    "defaultMessage": 'Allow Self-Signed Certificates'
  },
  senderName: {
    "id": "components.Settings.Notifications.senderName",
    "defaultMessage": 'Sender Name'
  },
  validationEmail: {
    "id": "components.Settings.Notifications.validationEmail",
    "defaultMessage": 'You must provide a valid email address'
  },
  pgpPrivateKey: {
    "id": "components.Settings.Notifications.pgpPrivateKey",
    "defaultMessage": 'PGP Private Key'
  },
  pgpPrivateKeyTip: {
    "id": "components.Settings.Notifications.pgpPrivateKeyTip",
    "defaultMessage": 'Sign encrypted email messages using <OpenPgpLink>OpenPGP</OpenPgpLink>'
  },
  validationPgpPrivateKey: {
    "id": "components.Settings.Notifications.validationPgpPrivateKey",
    "defaultMessage": 'You must provide a valid PGP private key'
  },
  pgpPassword: {
    "id": "components.Settings.Notifications.pgpPassword",
    "defaultMessage": 'PGP Password'
  },
  pgpPasswordTip: {
    "id": "components.Settings.Notifications.pgpPasswordTip",
    "defaultMessage": 'Sign encrypted email messages using <OpenPgpLink>OpenPGP</OpenPgpLink>'
  },
  validationPgpPassword: {
    "id": "components.Settings.Notifications.validationPgpPassword",
    "defaultMessage": 'You must provide a PGP password'
  }
});
function OpenPgpLink(msg) {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("a", {
    href: "https://www.openpgp.org/",
    target: "_blank",
    rel: "noreferrer",
    children: msg
  });
}

const NotificationsEmail = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const {
    addToast,
    removeToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__.useToasts)();
  const {
    0: isTesting,
    1: setIsTesting
  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_11__["default"])('/api/v1/settings/notifications/email');
  const NotificationsEmailSchema = yup__WEBPACK_IMPORTED_MODULE_12__.object().shape({
    emailFrom: yup__WEBPACK_IMPORTED_MODULE_12__.string().when('enabled', {
      is: true,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable().required(intl.formatMessage(messages.validationEmail)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable()
    }).email(intl.formatMessage(messages.validationEmail)),
    smtpHost: yup__WEBPACK_IMPORTED_MODULE_12__.string().when('enabled', {
      is: true,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable().required(intl.formatMessage(messages.validationSmtpHostRequired)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable()
    }).matches(/^(((([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])):((([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))@)?(([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])$/i, intl.formatMessage(messages.validationSmtpHostRequired)),
    smtpPort: yup__WEBPACK_IMPORTED_MODULE_12__.number().when('enabled', {
      is: true,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.number().nullable().required(intl.formatMessage(messages.validationSmtpPortRequired)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.number().nullable()
    }),
    pgpPrivateKey: yup__WEBPACK_IMPORTED_MODULE_12__.string().when('pgpPassword', {
      is: value => !!value,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable().required(intl.formatMessage(messages.validationPgpPrivateKey)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable()
    }).matches(/-----BEGIN PGP PRIVATE KEY BLOCK-----.+-----END PGP PRIVATE KEY BLOCK-----/, intl.formatMessage(messages.validationPgpPrivateKey)),
    pgpPassword: yup__WEBPACK_IMPORTED_MODULE_12__.string().when('pgpPrivateKey', {
      is: value => !!value,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable().required(intl.formatMessage(messages.validationPgpPassword)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable()
    })
  }, [['pgpPrivateKey', 'pgpPassword']]);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Formik, {
    initialValues: {
      enabled: data.enabled,
      emailFrom: data.options.emailFrom,
      smtpHost: data.options.smtpHost,
      smtpPort: data.options.smtpPort ?? 587,
      encryption: data.options.secure ? 'implicit' : data.options.requireTls ? 'opportunistic' : data.options.ignoreTls ? 'none' : 'default',
      authUser: data.options.authUser,
      authPass: data.options.authPass,
      allowSelfSigned: data.options.allowSelfSigned,
      senderName: data.options.senderName,
      pgpPrivateKey: data.options.pgpPrivateKey,
      pgpPassword: data.options.pgpPassword
    },
    validationSchema: NotificationsEmailSchema,
    onSubmit: async values => {
      try {
        await axios__WEBPACK_IMPORTED_MODULE_6__["default"].post('/api/v1/settings/notifications/email', {
          enabled: values.enabled,
          options: {
            emailFrom: values.emailFrom,
            smtpHost: values.smtpHost,
            smtpPort: Number(values.smtpPort),
            secure: values.encryption === 'implicit',
            ignoreTls: values.encryption === 'none',
            requireTls: values.encryption === 'opportunistic',
            authUser: values.authUser,
            authPass: values.authPass,
            allowSelfSigned: values.allowSelfSigned,
            senderName: values.senderName,
            pgpPrivateKey: values.pgpPrivateKey,
            pgpPassword: values.pgpPassword
          }
        });
        (0,swr__WEBPACK_IMPORTED_MODULE_11__.mutate)('/api/v1/settings/public');
        addToast(intl.formatMessage(messages.emailsettingssaved), {
          appearance: 'success',
          autoDismiss: true
        });
      } catch (e) {
        addToast(intl.formatMessage(messages.emailsettingsfailed), {
          appearance: 'error',
          autoDismiss: true
        });
      } finally {
        revalidate();
      }
    },
    children: ({
      errors,
      touched,
      isSubmitting,
      values,
      isValid
    }) => {
      const testSettings = async () => {
        setIsTesting(true);
        let toastId;

        try {
          addToast(intl.formatMessage(messages.toastEmailTestSending), {
            autoDismiss: false,
            appearance: 'info'
          }, id => {
            toastId = id;
          });
          await axios__WEBPACK_IMPORTED_MODULE_6__["default"].post('/api/v1/settings/notifications/email/test', {
            enabled: true,
            options: {
              emailFrom: values.emailFrom,
              smtpHost: values.smtpHost,
              smtpPort: Number(values.smtpPort),
              secure: values.encryption === 'implicit',
              ignoreTls: values.encryption === 'none',
              requireTls: values.encryption === 'opportunistic',
              authUser: values.authUser,
              authPass: values.authPass,
              allowSelfSigned: values.allowSelfSigned,
              senderName: values.senderName,
              pgpPrivateKey: values.pgpPrivateKey,
              pgpPassword: values.pgpPassword
            }
          });

          if (toastId) {
            removeToast(toastId);
          }

          addToast(intl.formatMessage(messages.toastEmailTestSuccess), {
            autoDismiss: true,
            appearance: 'success'
          });
        } catch (e) {
          if (toastId) {
            removeToast(toastId);
          }

          addToast(intl.formatMessage(messages.toastEmailTestFailed), {
            autoDismiss: true,
            appearance: 'error'
          });
        } finally {
          setIsTesting(false);
        }
      };

      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_7__.Form, {
        className: "section",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "enabled",
            className: "checkbox-label",
            children: [intl.formatMessage(messages.agentenabled), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-required",
              children: "*"
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
              type: "checkbox",
              id: "enabled",
              name: "enabled"
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("label", {
            htmlFor: "senderName",
            className: "text-label",
            children: intl.formatMessage(messages.senderName)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "senderName",
                name: "senderName",
                type: "text"
              })
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "emailFrom",
            className: "text-label",
            children: [intl.formatMessage(messages.emailsender), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-required",
              children: "*"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "emailFrom",
                name: "emailFrom",
                type: "text",
                inputMode: "email",
                autoComplete: "off",
                "data-1pignore": "true",
                "data-lpignore": "true",
                "data-bwignore": "true"
              })
            }), errors.emailFrom && touched.emailFrom && typeof errors.emailFrom === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.emailFrom
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "smtpHost",
            className: "text-label",
            children: [intl.formatMessage(messages.smtpHost), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-required",
              children: "*"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "smtpHost",
                name: "smtpHost",
                type: "text",
                inputMode: "url",
                autoComplete: "off",
                "data-1pignore": "true",
                "data-lpignore": "true",
                "data-bwignore": "true"
              })
            }), errors.smtpHost && touched.smtpHost && typeof errors.smtpHost === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.smtpHost
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "smtpPort",
            className: "text-label",
            children: [intl.formatMessage(messages.smtpPort), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-required",
              children: "*"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
              id: "smtpPort",
              name: "smtpPort",
              type: "text",
              inputMode: "numeric",
              className: "short",
              autoComplete: "off",
              "data-1pignore": "true",
              "data-lpignore": "true",
              "data-bwignore": "true"
            }), errors.smtpPort && touched.smtpPort && typeof errors.smtpPort === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.smtpPort
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "encryption",
            className: "text-label",
            children: [intl.formatMessage(messages.encryption), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-required",
              children: "*"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.encryptionTip)
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                as: "select",
                id: "encryption",
                name: "encryption",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
                  value: "none",
                  children: intl.formatMessage(messages.encryptionNone)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
                  value: "default",
                  children: intl.formatMessage(messages.encryptionDefault)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
                  value: "opportunistic",
                  children: intl.formatMessage(messages.encryptionOpportunisticTls)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
                  value: "implicit",
                  children: intl.formatMessage(messages.encryptionImplicitTls)
                })]
              })
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("label", {
            htmlFor: "allowSelfSigned",
            className: "checkbox-label",
            children: intl.formatMessage(messages.allowselfsigned)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
              type: "checkbox",
              id: "allowSelfSigned",
              name: "allowSelfSigned"
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("label", {
            htmlFor: "authUser",
            className: "text-label",
            children: intl.formatMessage(messages.authUser)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "authUser",
                name: "authUser",
                type: "text",
                autoComplete: "off",
                "data-1pignore": "true",
                "data-lpignore": "true",
                "data-bwignore": "true"
              })
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("label", {
            htmlFor: "authPass",
            className: "text-label",
            children: intl.formatMessage(messages.authPass)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                as: "field",
                id: "authPass",
                name: "authPass"
              })
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "pgpPrivateKey",
            className: "text-label",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "mr-2",
              children: intl.formatMessage(messages.pgpPrivateKey)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
              badgeType: "advanced"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.pgpPrivateKeyTip, {
                OpenPgpLink: OpenPgpLink
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                as: "field",
                id: "pgpPrivateKey",
                name: "pgpPrivateKey",
                type: "textarea",
                rows: "10",
                className: "font-mono text-xs",
                autoComplete: "off",
                "data-1pignore": "true",
                "data-lpignore": "true",
                "data-bwignore": "true"
              })
            }), errors.pgpPrivateKey && touched.pgpPrivateKey && typeof errors.pgpPrivateKey === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.pgpPrivateKey
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "pgpPassword",
            className: "text-label",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "mr-2",
              children: intl.formatMessage(messages.pgpPassword)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
              badgeType: "advanced"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.pgpPasswordTip, {
                OpenPgpLink: OpenPgpLink
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                as: "field",
                id: "pgpPassword",
                name: "pgpPassword",
                autoComplete: "off",
                "data-1pignore": "true",
                "data-lpignore": "true",
                "data-bwignore": "true"
              })
            }), errors.pgpPassword && touched.pgpPassword && typeof errors.pgpPassword === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.pgpPassword
            })]
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
          className: "actions",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "flex justify-end",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "warning",
                disabled: isSubmitting || !isValid || isTesting,
                onClick: e => {
                  e.preventDefault();
                  testSettings();
                },
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__.BeakerIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
                  children: isTesting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__/* ["default"].testing */ .Z.testing) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__/* ["default"].test */ .Z.test)
                })]
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "primary",
                type: "submit",
                disabled: isSubmitting || !isValid || isTesting,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
                  children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__/* ["default"].save */ .Z.save)
                })]
              })
            })]
          })
        })]
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsEmail);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;