exports.id = 72134;
exports.ids = [72134];
exports.modules = {

/***/ 72134:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var country_flag_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31856);
/* harmony import */ var country_flag_icons_3x2_flags_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(32851);
/* harmony import */ var country_flag_icons_3x2_flags_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(country_flag_icons_3x2_flags_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__, _headlessui_react__WEBPACK_IMPORTED_MODULE_1__, country_flag_icons__WEBPACK_IMPORTED_MODULE_3__, swr__WEBPACK_IMPORTED_MODULE_8__]);
([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__, _headlessui_react__WEBPACK_IMPORTED_MODULE_1__, country_flag_icons__WEBPACK_IMPORTED_MODULE_3__, swr__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_7__.defineMessages)({
  regionDefault: {
    "id": "components.RegionSelector.regionDefault",
    "defaultMessage": 'All Regions'
  },
  regionServerDefault: {
    "id": "components.RegionSelector.regionServerDefault",
    "defaultMessage": 'Default ({region})'
  }
});

const RegionSelector = ({
  name,
  value,
  isUserSetting = false,
  disableAll = false,
  watchProviders = false,
  onChange
}) => {
  const {
    currentSettings
  } = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_7__.useIntl)();
  const {
    data: regions
  } = (0,swr__WEBPACK_IMPORTED_MODULE_8__["default"])(watchProviders ? '/api/v1/watchproviders/regions' : '/api/v1/regions');
  const {
    0: selectedRegion,
    1: setSelectedRegion
  } = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(null);
  const allRegion = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => ({
    iso_3166_1: 'all',
    english_name: 'All'
  }), []);
  const sortedRegions = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => {
    regions?.forEach(region => {
      region.name = intl.formatDisplayName(region.iso_3166_1, {
        type: 'region',
        fallback: 'none'
      }) ?? region.english_name;
    });
    return (0,lodash__WEBPACK_IMPORTED_MODULE_5__.sortBy)(regions, 'name');
  }, [intl, regions]);

  const regionName = regionCode => sortedRegions?.find(region => region.iso_3166_1 === regionCode)?.name ?? regionCode;

  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (regions && value) {
      if (value === 'all') {
        setSelectedRegion(allRegion);
      } else {
        const matchedRegion = regions.find(region => region.iso_3166_1 === value);
        setSelectedRegion(matchedRegion ?? null);
      }
    }
  }, [value, regions, allRegion]);
  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (onChange && regions) {
      if (selectedRegion) {
        onChange(name, selectedRegion.iso_3166_1);
      } else {
        onChange(name, '');
      }
    }
  }, [onChange, selectedRegion, name, regions]);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
    className: "z-40 w-full",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Listbox, {
      as: "div",
      value: selectedRegion,
      onChange: setSelectedRegion,
      children: ({
        open
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "relative",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
          className: "inline-block w-full rounded-md shadow-sm",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Listbox.Button, {
            className: "focus:shadow-outline-blue relative flex w-full cursor-default items-center rounded-md border border-gray-500 bg-gray-700 py-2 pl-3 pr-10 text-left text-white transition duration-150 ease-in-out focus:border-blue-300 focus:outline-none sm:text-sm sm:leading-5",
            children: [(selectedRegion && (0,country_flag_icons__WEBPACK_IMPORTED_MODULE_3__.hasFlag)(selectedRegion?.iso_3166_1) || isUserSetting && !selectedRegion && currentSettings.region && (0,country_flag_icons__WEBPACK_IMPORTED_MODULE_3__.hasFlag)(currentSettings.region)) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
              className: "mr-2 h-4 overflow-hidden text-base leading-4",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                className: `flag:${selectedRegion ? selectedRegion.iso_3166_1 : currentSettings.region}`
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
              className: "block truncate",
              children: selectedRegion && selectedRegion.iso_3166_1 !== 'all' ? regionName(selectedRegion.iso_3166_1) : isUserSetting && selectedRegion?.iso_3166_1 !== 'all' ? intl.formatMessage(messages.regionServerDefault, {
                region: currentSettings.region ? regionName(currentSettings.region) : intl.formatMessage(messages.regionDefault)
              }) : intl.formatMessage(messages.regionDefault)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
              className: "pointer-events-none absolute inset-y-0 right-0 flex items-center pr-2 text-gray-500",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.ChevronDownIcon, {
                className: "h-5 w-5"
              })
            })]
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Transition, {
          show: open,
          leave: "transition-opacity ease-in duration-100",
          leaveFrom: "opacity-100",
          leaveTo: "opacity-0",
          className: "absolute mt-1 w-full rounded-md bg-gray-800 shadow-lg",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Listbox.Options, {
            static: true,
            className: "shadow-xs max-h-60 overflow-auto rounded-md py-1 text-base leading-6 focus:outline-none sm:text-sm sm:leading-5",
            children: [isUserSetting && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Listbox.Option, {
              value: null,
              children: ({
                selected,
                active
              }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: `${active ? 'bg-indigo-600 text-white' : 'text-gray-300'} relative flex cursor-default select-none items-center py-2 pl-8 pr-4`,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: "mr-2 text-base",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                    className: (0,country_flag_icons__WEBPACK_IMPORTED_MODULE_3__.hasFlag)(currentSettings.region) ? `flag:${currentSettings.region}` : 'pr-6'
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: `${selected ? 'font-semibold' : 'font-normal'} block truncate`,
                  children: intl.formatMessage(messages.regionServerDefault, {
                    region: currentSettings.region ? regionName(currentSettings.region) : intl.formatMessage(messages.regionDefault)
                  })
                }), selected && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: `${active ? 'text-white' : 'text-indigo-600'} absolute inset-y-0 left-0 flex items-center pl-1.5`,
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.CheckIcon, {
                    className: "h-5 w-5"
                  })
                })]
              })
            }), !disableAll && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Listbox.Option, {
              value: isUserSetting ? allRegion : null,
              children: ({
                selected,
                active
              }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: `${active ? 'bg-indigo-600 text-white' : 'text-gray-300'} relative cursor-default select-none py-2 pl-8 pr-4`,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: `${selected ? 'font-semibold' : 'font-normal'} block truncate pl-8`,
                  children: intl.formatMessage(messages.regionDefault)
                }), selected && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: `${active ? 'text-white' : 'text-indigo-600'} absolute inset-y-0 left-0 flex items-center pl-1.5`,
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.CheckIcon, {
                    className: "h-5 w-5"
                  })
                })]
              })
            }), sortedRegions?.map(region => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Listbox.Option, {
              value: region,
              children: ({
                selected,
                active
              }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: `${active ? 'bg-indigo-600 text-white' : 'text-gray-300'} relative flex cursor-default select-none items-center py-2 pl-8 pr-4`,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: "mr-2 text-base",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                    className: (0,country_flag_icons__WEBPACK_IMPORTED_MODULE_3__.hasFlag)(region.iso_3166_1) ? `flag:${region.iso_3166_1}` : 'pr-6'
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: `${selected ? 'font-semibold' : 'font-normal'} block truncate`,
                  children: regionName(region.iso_3166_1)
                }), selected && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: `${active ? 'text-white' : 'text-indigo-600'} absolute inset-y-0 left-0 flex items-center pl-1.5`,
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_2__.CheckIcon, {
                    className: "h-5 w-5"
                  })
                })]
              })
            }, region.iso_3166_1))]
          })
        })]
      })
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RegionSelector);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 32851:
/***/ (() => {



/***/ })

};
;