"use strict";
exports.id = 72964;
exports.ids = [72964];
exports.modules = {

/***/ 72964:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);




const ProgressCircle = ({
  className,
  progress = 0,
  useHeatLevel
}) => {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  let color = '';
  let emptyColor = 'text-gray-300';

  if (useHeatLevel) {
    color = 'text-green-500';

    if (progress <= 50) {
      color = 'text-yellow-500';
    }

    if (progress <= 10) {
      color = 'text-red-500';
    }

    if (progress === 0) {
      emptyColor = 'text-red-600';
    }
  }

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (ref && ref.current) {
      const radius = ref.current?.r.baseVal.value;
      const circumference = (radius ?? 0) * 2 * Math.PI;
      const offset = circumference - progress / 100 * circumference;
      ref.current.style.strokeDashoffset = `${offset}`;
      ref.current.style.strokeDasharray = `${circumference} ${circumference}`;
    }
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("svg", {
    className: `${className} ${color}`,
    viewBox: "0 0 24 24",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("circle", {
      className: `${emptyColor} opacity-30`,
      stroke: "currentColor",
      strokeWidth: "3",
      fill: "transparent",
      r: "10",
      cx: "12",
      cy: "12"
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("circle", {
      style: {
        transition: '0.35s stroke-dashoffset',
        transform: 'rotate(-90deg)',
        transformOrigin: '50% 50%'
      },
      ref: ref,
      stroke: "currentColor",
      strokeWidth: "3",
      fill: "transparent",
      r: "10",
      cx: "12",
      cy: "12"
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProgressCircle);

/***/ })

};
;