"use strict";
exports.id = 75294;
exports.ids = [75294];
exports.modules = {

/***/ 75294:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63145);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80210);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_3__.defineMessages)({
  advancedTooltip: {
    "id": "components.Settings.advancedTooltip",
    "defaultMessage": 'Incorrectly configuring this setting may result in broken functionality'
  },
  experimentalTooltip: {
    "id": "components.Settings.experimentalTooltip",
    "defaultMessage": 'Enabling this setting may result in unexpected application behavior'
  },
  restartrequiredTooltip: {
    "id": "components.Settings.restartrequiredTooltip",
    "defaultMessage": 'Overseerr must be restarted for changes to this setting to take effect'
  }
});

const SettingsBadge = ({
  badgeType,
  className
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_3__.useIntl)();

  switch (badgeType) {
    case 'advanced':
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        content: intl.formatMessage(messages.advancedTooltip),
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          badgeType: "danger",
          className: className,
          children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].advanced */ .Z.advanced)
        })
      });

    case 'experimental':
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        content: intl.formatMessage(messages.experimentalTooltip),
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          badgeType: "warning",
          children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].experimental */ .Z.experimental)
        })
      });

    case 'restartRequired':
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        content: intl.formatMessage(messages.restartrequiredTooltip),
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          badgeType: "primary",
          className: className,
          children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_2__/* ["default"].restartRequired */ .Z.restartRequired)
        })
      });

    default:
      return null;
  }
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsBadge);

/***/ })

};
;