"use strict";
exports.id = 86957;
exports.ids = [86957];
exports.modules = {

/***/ 86957:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);




const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_1__.defineMessages)({
  movieRequests: {
    "id": "components.QuotaSelector.movieRequests",
    "defaultMessage": '{quotaLimit} <quotaUnits>{movies} per {quotaDays} {days}</quotaUnits>'
  },
  tvRequests: {
    "id": "components.QuotaSelector.tvRequests",
    "defaultMessage": '{quotaLimit} <quotaUnits>{seasons} per {quotaDays} {days}</quotaUnits>'
  },
  movies: {
    "id": "components.QuotaSelector.movies",
    "defaultMessage": '{count, plural, one {movie} other {movies}}'
  },
  seasons: {
    "id": "components.QuotaSelector.seasons",
    "defaultMessage": '{count, plural, one {season} other {seasons}}'
  },
  days: {
    "id": "components.QuotaSelector.days",
    "defaultMessage": '{count, plural, one {day} other {days}}'
  },
  unlimited: {
    "id": "components.QuotaSelector.unlimited",
    "defaultMessage": 'Unlimited'
  }
});

const QuotaSelector = ({
  mediaType,
  dayFieldName,
  limitFieldName,
  defaultDays = 7,
  defaultLimit = 0,
  dayOverride,
  limitOverride,
  isDisabled = false,
  onChange
}) => {
  const initialDays = defaultDays ?? 7;
  const initialLimit = defaultLimit ?? 0;
  const {
    0: quotaDays,
    1: setQuotaDays
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialDays);
  const {
    0: quotaLimit,
    1: setQuotaLimit
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialLimit);
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_1__.useIntl)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    onChange(dayFieldName, quotaDays);
  }, [dayFieldName, onChange, quotaDays]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    onChange(limitFieldName, quotaLimit);
  }, [limitFieldName, onChange, quotaLimit]);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
    className: `${isDisabled ? 'opacity-50' : ''}`,
    children: intl.formatMessage(mediaType === 'movie' ? messages.movieRequests : messages.tvRequests, {
      quotaLimit: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("select", {
        className: "short inline",
        value: limitOverride ?? quotaLimit,
        onChange: e => setQuotaLimit(Number(e.target.value)),
        disabled: isDisabled,
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("option", {
          value: "0",
          children: intl.formatMessage(messages.unlimited)
        }), [...Array(100)].map((_item, i) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("option", {
          value: i + 1,
          children: i + 1
        }, `${mediaType}-limit-${i + 1}`))]
      }),
      quotaDays: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("select", {
        className: "short inline",
        value: dayOverride ?? quotaDays,
        onChange: e => setQuotaDays(Number(e.target.value)),
        disabled: isDisabled,
        children: [...Array(100)].map((_item, i) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("option", {
          value: i + 1,
          children: i + 1
        }, `${mediaType}-days-${i + 1}`))
      }),
      movies: intl.formatMessage(messages.movies, {
        count: quotaLimit
      }),
      seasons: intl.formatMessage(messages.seasons, {
        count: quotaLimit
      }),
      days: intl.formatMessage(messages.days, {
        count: quotaDays
      }),
      quotaUnits: function quotaUnits(msg) {
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("span", {
          className: limitOverride || quotaLimit ? '' : 'hidden',
          children: msg
        });
      }
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().memo(QuotaSelector));

/***/ })

};
;