"use strict";
exports.id = 96911;
exports.ids = [96911];
exports.modules = {

/***/ 96911:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74449);
/* harmony import */ var _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(33181);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(80210);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35635);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__, _app_pages_error__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_14__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__, _app_pages_error__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_14__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.defineMessages)({
  toastSettingsSuccess: {
    "id": "components.UserProfile.UserSettings.UserPermissions.toastSettingsSuccess",
    "defaultMessage": 'Permissions saved successfully!'
  },
  toastSettingsFailure: {
    "id": "components.UserProfile.UserSettings.UserPermissions.toastSettingsFailure",
    "defaultMessage": 'Something went wrong while saving settings.'
  },
  permissions: {
    "id": "components.UserProfile.UserSettings.UserPermissions.permissions",
    "defaultMessage": 'Permissions'
  },
  unauthorizedDescription: {
    "id": "components.UserProfile.UserSettings.UserPermissions.unauthorizedDescription",
    "defaultMessage": 'You cannot modify your own permissions.'
  }
});

const UserPermissions = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__.useToasts)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_11__.useRouter)();
  const {
    user: currentUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .useUser */ .aF)();
  const {
    user,
    revalidate: revalidateUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_14__["default"])(user ? `/api/v1/user/${user?.id}/settings/permissions` : null);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_7__["default"], {
      statusCode: 500
    });
  }

  if (currentUser?.id !== 1 && currentUser?.id === user?.id) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.Fragment, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
        className: "mb-6",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("h3", {
          className: "heading",
          children: intl.formatMessage(messages.permissions)
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.unauthorizedDescription),
        type: "error"
      })]
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.permissions), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].usersettings */ .Z.usersettings), user?.displayName]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
      className: "mb-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.permissions)
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(formik__WEBPACK_IMPORTED_MODULE_10__.Formik, {
      initialValues: {
        currentPermissions: data?.permissions
      },
      enableReinitialize: true,
      onSubmit: async values => {
        try {
          await axios__WEBPACK_IMPORTED_MODULE_9__["default"].post(`/api/v1/user/${user?.id}/settings/permissions`, {
            permissions: values.currentPermissions ?? 0
          });
          addToast(intl.formatMessage(messages.toastSettingsSuccess), {
            autoDismiss: true,
            appearance: 'success'
          });
        } catch (e) {
          addToast(intl.formatMessage(messages.toastSettingsFailure), {
            autoDismiss: true,
            appearance: 'error'
          });
        } finally {
          revalidate();
          revalidateUser();
        }
      },
      children: ({
        isSubmitting,
        setFieldValue,
        values
      }) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_10__.Form, {
          className: "section",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
            className: "max-w-3xl",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .ZP, {
              actingUser: currentUser,
              currentUser: user,
              currentPermission: values.currentPermissions ?? 0,
              onUpdate: newPermission => setFieldValue('currentPermissions', newPermission)
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
            className: "actions",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
              className: "flex justify-end",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                className: "ml-3 inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  buttonType: "primary",
                  type: "submit",
                  disabled: isSubmitting,
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                    children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].save */ .Z.save)
                  })]
                })
              })
            })
          })]
        });
      }
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserPermissions);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;