"use strict";
(() => {
var exports = {};
exports.id = 83459;
exports.ids = [83459,64820];
exports.modules = {

/***/ 69240:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Common_Accordion)
});

// UNUSED EXPORTS: AccordionContent

// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(16689);
;// CONCATENATED MODULE: external "react-animate-height"
const external_react_animate_height_namespaceObject = require("react-animate-height");
var external_react_animate_height_default = /*#__PURE__*/__webpack_require__.n(external_react_animate_height_namespaceObject);
// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
;// CONCATENATED MODULE: ./src/components/Common/Accordion/index.tsx



const AccordionContent = ({
  isOpen,
  children
}) => {
  return /*#__PURE__*/jsx_runtime_.jsx((external_react_animate_height_default()), {
    height: isOpen ? 'auto' : 0,
    children: children
  });
};

const Accordion = ({
  single,
  atLeastOne,
  initialOpenIndexes,
  children
}) => {
  const initialState = initialOpenIndexes || atLeastOne && [0] || [];
  const {
    0: openIndexes,
    1: setOpenIndexes
  } = (0,external_react_.useState)(initialState);

  const close = index => {
    const openCount = openIndexes.length;
    const newListOfIndexes = atLeastOne && openCount === 1 && openIndexes.includes(index) ? openIndexes : openIndexes.filter(i => i !== index);
    setOpenIndexes(newListOfIndexes);
  };

  const open = index => {
    const newListOfIndexes = single ? [index] : [...openIndexes, index];
    setOpenIndexes(newListOfIndexes);
  };

  const handleItemClick = index => {
    const action = openIndexes.includes(index) ? 'closing' : 'opening';

    if (action === 'closing') {
      close(index);
    } else {
      open(index);
    }
  };

  return children({
    openIndexes: openIndexes,
    handleClick: handleItemClick,
    AccordionContent
  });
};

/* harmony default export */ const Common_Accordion = (Accordion);

/***/ }),

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 64896:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61903);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1388);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_4__]);
([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.defineMessages)({
  email: {
    "id": "components.Login.email",
    "defaultMessage": 'Email Address'
  },
  password: {
    "id": "components.Login.password",
    "defaultMessage": 'Password'
  },
  validationemailrequired: {
    "id": "components.Login.validationemailrequired",
    "defaultMessage": 'You must provide a valid email address'
  },
  validationpasswordrequired: {
    "id": "components.Login.validationpasswordrequired",
    "defaultMessage": 'You must provide a password'
  },
  loginerror: {
    "id": "components.Login.loginerror",
    "defaultMessage": 'Something went wrong while trying to sign in.'
  },
  signingin: {
    "id": "components.Login.signingin",
    "defaultMessage": 'Signing In…'
  },
  signin: {
    "id": "components.Login.signin",
    "defaultMessage": 'Sign In'
  },
  forgotpassword: {
    "id": "components.Login.forgotpassword",
    "defaultMessage": 'Forgot Password?'
  }
});

const LocalLogin = ({
  revalidate
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.useIntl)();
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)();
  const {
    0: loginError,
    1: setLoginError
  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(null);
  const LoginSchema = yup__WEBPACK_IMPORTED_MODULE_9__.object().shape({
    email: yup__WEBPACK_IMPORTED_MODULE_9__.string().email().required(intl.formatMessage(messages.validationemailrequired)),
    password: yup__WEBPACK_IMPORTED_MODULE_9__.string().required(intl.formatMessage(messages.validationpasswordrequired))
  });
  const passwordResetEnabled = settings.currentSettings.applicationUrl && settings.currentSettings.emailEnabled;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Formik, {
    initialValues: {
      email: '',
      password: ''
    },
    validationSchema: LoginSchema,
    onSubmit: async values => {
      try {
        await axios__WEBPACK_IMPORTED_MODULE_4__["default"].post('/api/v1/auth/local', {
          email: values.email,
          password: values.password
        });
      } catch (e) {
        setLoginError(intl.formatMessage(messages.loginerror));
      } finally {
        revalidate();
      }
    },
    children: ({
      errors,
      touched,
      isSubmitting,
      isValid
    }) => {
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.Fragment, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_5__.Form, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("label", {
              htmlFor: "email",
              className: "text-label",
              children: intl.formatMessage(messages.email)
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
              className: "mt-1 mb-2 sm:col-span-2 sm:mt-0",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(formik__WEBPACK_IMPORTED_MODULE_5__.Field, {
                  id: "email",
                  name: "email",
                  type: "text",
                  inputMode: "email",
                  "data-testid": "email"
                })
              }), errors.email && touched.email && typeof errors.email === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
                className: "error",
                children: errors.email
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("label", {
              htmlFor: "password",
              className: "text-label",
              children: intl.formatMessage(messages.password)
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
              className: "mt-1 mb-2 sm:col-span-2 sm:mt-0",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  as: "field",
                  id: "password",
                  name: "password",
                  type: "password",
                  autoComplete: "current-password",
                  "data-testid": "password",
                  "data-1pignore": "false",
                  "data-lpignore": "false",
                  "data-bwignore": "false"
                })
              }), errors.password && touched.password && typeof errors.password === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
                className: "error",
                children: errors.password
              })]
            }), loginError && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
              className: "mt-1 mb-2 sm:col-span-2 sm:mt-0",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
                className: "error",
                children: loginError
              })
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("div", {
            className: "mt-8 border-t border-gray-700 pt-5",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
              className: "flex flex-row-reverse justify-between",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("span", {
                className: "inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                  buttonType: "primary",
                  type: "submit",
                  disabled: isSubmitting || !isValid,
                  "data-testid": "local-signin-button",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__.ArrowLeftOnRectangleIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("span", {
                    children: isSubmitting ? intl.formatMessage(messages.signingin) : intl.formatMessage(messages.signin)
                  })]
                })
              }), passwordResetEnabled && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("span", {
                className: "inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx((next_link__WEBPACK_IMPORTED_MODULE_6___default()), {
                  href: "/resetpassword",
                  passHref: true,
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                    as: "a",
                    buttonType: "ghost",
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_3__.LifebuoyIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx("span", {
                      children: intl.formatMessage(messages.forgotpassword)
                    })]
                  })
                })
              })]
            })
          })]
        })
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LocalLogin);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 52466:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Accordion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69240);
/* harmony import */ var _app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19692);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Layout_LanguagePicker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4551);
/* harmony import */ var _app_components_Login_LocalLogin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(64896);
/* harmony import */ var _app_components_PlexLoginButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77867);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(86799);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(99648);
/* harmony import */ var next_dist_client_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(69898);
/* harmony import */ var next_dist_client_router__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_dist_client_router__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_1__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_Layout_LanguagePicker__WEBPACK_IMPORTED_MODULE_3__, _app_components_Login_LocalLogin__WEBPACK_IMPORTED_MODULE_4__, _app_components_PlexLoginButton__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, _headlessui_react__WEBPACK_IMPORTED_MODULE_8__, axios__WEBPACK_IMPORTED_MODULE_10__, swr__WEBPACK_IMPORTED_MODULE_14__]);
([_app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_1__, _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_Layout_LanguagePicker__WEBPACK_IMPORTED_MODULE_3__, _app_components_Login_LocalLogin__WEBPACK_IMPORTED_MODULE_4__, _app_components_PlexLoginButton__WEBPACK_IMPORTED_MODULE_5__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__, _headlessui_react__WEBPACK_IMPORTED_MODULE_8__, axios__WEBPACK_IMPORTED_MODULE_10__, swr__WEBPACK_IMPORTED_MODULE_14__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_13__.defineMessages)({
  signin: {
    "id": "components.Login.signin",
    "defaultMessage": 'Sign In'
  },
  signinheader: {
    "id": "components.Login.signinheader",
    "defaultMessage": 'Sign in to continue'
  },
  signinwithplex: {
    "id": "components.Login.signinwithplex",
    "defaultMessage": 'Use your Plex account'
  },
  signinwithoverseerr: {
    "id": "components.Login.signinwithoverseerr",
    "defaultMessage": 'Use your {applicationTitle} account'
  }
});

const Login = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_13__.useIntl)();
  const {
    0: error,
    1: setError
  } = (0,react__WEBPACK_IMPORTED_MODULE_12__.useState)('');
  const {
    0: isProcessing,
    1: setProcessing
  } = (0,react__WEBPACK_IMPORTED_MODULE_12__.useState)(false);
  const {
    0: authToken,
    1: setAuthToken
  } = (0,react__WEBPACK_IMPORTED_MODULE_12__.useState)(undefined);
  const {
    user,
    revalidate
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_7__/* .useUser */ .aF)();
  const router = (0,next_dist_client_router__WEBPACK_IMPORTED_MODULE_11__.useRouter)();
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(); // Effect that is triggered when the `authToken` comes back from the Plex OAuth
  // We take the token and attempt to sign in. If we get a success message, we will
  // ask swr to revalidate the user which _should_ come back with a valid user.

  (0,react__WEBPACK_IMPORTED_MODULE_12__.useEffect)(() => {
    const login = async () => {
      setProcessing(true);

      try {
        const response = await axios__WEBPACK_IMPORTED_MODULE_10__["default"].post('/api/v1/auth/plex', {
          authToken
        });

        if (response.data?.id) {
          revalidate();
        }
      } catch (e) {
        setError(e.response.data.message);
        setAuthToken(undefined);
        setProcessing(false);
      }
    };

    if (authToken) {
      login();
    }
  }, [authToken, revalidate]); // Effect that is triggered whenever `useUser`'s user changes. If we get a new
  // valid user, we redirect the user to the home page as the login was successful.

  (0,react__WEBPACK_IMPORTED_MODULE_12__.useEffect)(() => {
    if (user) {
      router.push('/');
    }
  }, [user, router]);
  const {
    data: backdrops
  } = (0,swr__WEBPACK_IMPORTED_MODULE_14__["default"])('/api/v1/backdrops', {
    refreshInterval: 0,
    refreshWhenHidden: false,
    revalidateOnFocus: false
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
    className: "relative flex min-h-screen flex-col bg-gray-900 py-14",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      title: intl.formatMessage(messages.signin)
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_ImageFader__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      backgroundImages: backdrops?.map(backdrop => `https://image.tmdb.org/t/p/original${backdrop}`) ?? []
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
      className: "absolute top-4 right-4 z-50",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Layout_LanguagePicker__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
      className: "relative z-40 mt-10 flex flex-col items-center px-4 sm:mx-auto sm:w-full sm:max-w-md",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("img", {
        src: "/logo_stacked.svg",
        className: "mb-10 max-w-full",
        alt: "Logo"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("h2", {
        className: "mt-2 text-center text-3xl font-extrabold leading-9 text-gray-100",
        children: intl.formatMessage(messages.signinheader)
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
      className: "relative z-50 mt-8 sm:mx-auto sm:w-full sm:max-w-md",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
        className: "bg-gray-800 bg-opacity-50 shadow sm:rounded-lg",
        style: {
          backdropFilter: 'blur(5px)'
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.Fragment, {
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_8__.Transition, {
            as: "div",
            show: !!error,
            enter: "transition-opacity duration-300",
            enterFrom: "opacity-0",
            enterTo: "opacity-100",
            leave: "transition-opacity duration-300",
            leaveFrom: "opacity-100",
            leaveTo: "opacity-0",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
              className: "mb-4 rounded-md bg-red-600 p-4",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
                className: "flex",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
                  className: "flex-shrink-0",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_9__.XCircleIcon, {
                    className: "h-5 w-5 text-red-300"
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
                  className: "ml-3",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("h3", {
                    className: "text-sm font-medium text-red-300",
                    children: error
                  })
                })]
              })
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_Accordion__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            single: true,
            atLeastOne: true,
            children: ({
              openIndexes,
              handleClick,
              AccordionContent
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.Fragment, {
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("button", {
                className: `w-full cursor-default bg-gray-800 bg-opacity-70 py-2 text-center text-sm font-bold text-gray-400 transition-colors duration-200 focus:outline-none sm:rounded-t-lg ${openIndexes.includes(0) && 'text-indigo-500'} ${settings.currentSettings.localLogin && 'hover:cursor-pointer hover:bg-gray-700'}`,
                onClick: () => handleClick(0),
                disabled: !settings.currentSettings.localLogin,
                children: intl.formatMessage(messages.signinwithplex)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(AccordionContent, {
                isOpen: openIndexes.includes(0),
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
                  className: "px-10 py-8",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_PlexLoginButton__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    isProcessing: isProcessing,
                    onAuthToken: authToken => setAuthToken(authToken)
                  })
                })
              }), settings.currentSettings.localLogin && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("button", {
                  className: `w-full cursor-default bg-gray-800 bg-opacity-70 py-2 text-center text-sm font-bold text-gray-400 transition-colors duration-200 hover:cursor-pointer hover:bg-gray-700 focus:outline-none ${openIndexes.includes(1) ? 'text-indigo-500' : 'sm:rounded-b-lg'}`,
                  onClick: () => handleClick(1),
                  children: intl.formatMessage(messages.signinwithoverseerr, {
                    applicationTitle: settings.currentSettings.applicationTitle
                  })
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(AccordionContent, {
                  isOpen: openIndexes.includes(1),
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
                    className: "px-10 py-8",
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Login_LocalLogin__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                      revalidate: revalidate
                    })
                  })
                })]
              })]
            })
          })]
        })
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Login);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12965:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/**
 * useClickOutside
 *
 * Simple hook to add an event listener to the body and allow a callback to
 * be triggered when clicking outside of the target ref
 *
 * @param ref Any HTML Element ref
 * @param callback Callback triggered when clicking outside of ref element
 */

const useClickOutside = (ref, callback) => {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const handleBodyClick = e => {
      if (ref.current && !ref.current.contains(e.target)) {
        callback(e);
      }
    };

    document.body.addEventListener('click', handleBodyClick, {
      capture: true
    });
    return () => {
      document.body.removeEventListener('click', handleBodyClick);
    };
  }, [ref, callback]);
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useClickOutside);

/***/ }),

/***/ 37467:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Login__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52466);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Login__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_Login__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const LoginPage = () => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_app_components_Login__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {});
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoginPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 92793:
/***/ ((module) => {

module.exports = require("bowser");

/***/ }),

/***/ 2296:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 75609:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,15278,1388,19998,80210,86799,7292,61903,84541,19692,4551,77867], () => (__webpack_exec__(37467)));
module.exports = __webpack_exports__;

})();