"use strict";
(() => {
var exports = {};
exports.id = 549;
exports.ids = [549,64820];
exports.modules = {

/***/ 55742:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95909);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_13__]);
([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_13__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);

















const JSONEditor = next_dynamic__WEBPACK_IMPORTED_MODULE_8___default()(() => __webpack_require__.e(/* import() */ 61212).then(__webpack_require__.bind(__webpack_require__, 61212)), {
  ssr: false,
  loadableGenerated: {
    modules: ["../components/Settings/Notifications/NotificationsWebhook/index.tsx -> " + '@app/components/JSONEditor']
  }
});
const defaultPayload = {
  notification_type: '{{notification_type}}',
  event: '{{event}}',
  subject: '{{subject}}',
  message: '{{message}}',
  image: '{{image}}',
  '{{media}}': {
    media_type: '{{media_type}}',
    tmdbId: '{{media_tmdbid}}',
    tvdbId: '{{media_tvdbid}}',
    status: '{{media_status}}',
    status4k: '{{media_status4k}}'
  },
  '{{request}}': {
    request_id: '{{request_id}}',
    requestedBy_email: '{{requestedBy_email}}',
    requestedBy_username: '{{requestedBy_username}}',
    requestedBy_avatar: '{{requestedBy_avatar}}',
    requestedBy_settings_discordId: '{{requestedBy_settings_discordId}}',
    requestedBy_settings_telegramChatId: '{{requestedBy_settings_telegramChatId}}'
  },
  '{{issue}}': {
    issue_id: '{{issue_id}}',
    issue_type: '{{issue_type}}',
    issue_status: '{{issue_status}}',
    reportedBy_email: '{{reportedBy_email}}',
    reportedBy_username: '{{reportedBy_username}}',
    reportedBy_avatar: '{{reportedBy_avatar}}',
    reportedBy_settings_discordId: '{{reportedBy_settings_discordId}}',
    reportedBy_settings_telegramChatId: '{{reportedBy_settings_telegramChatId}}'
  },
  '{{comment}}': {
    comment_message: '{{comment_message}}',
    commentedBy_email: '{{commentedBy_email}}',
    commentedBy_username: '{{commentedBy_username}}',
    commentedBy_avatar: '{{commentedBy_avatar}}',
    commentedBy_settings_discordId: '{{commentedBy_settings_discordId}}',
    commentedBy_settings_telegramChatId: '{{commentedBy_settings_telegramChatId}}'
  },
  '{{extra}}': []
};
const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.defineMessages)({
  agentenabled: {
    "id": "components.Settings.Notifications.NotificationsWebhook.agentenabled",
    "defaultMessage": 'Enable Agent'
  },
  webhookUrl: {
    "id": "components.Settings.Notifications.NotificationsWebhook.webhookUrl",
    "defaultMessage": 'Webhook URL'
  },
  authheader: {
    "id": "components.Settings.Notifications.NotificationsWebhook.authheader",
    "defaultMessage": 'Authorization Header'
  },
  validationJsonPayloadRequired: {
    "id": "components.Settings.Notifications.NotificationsWebhook.validationJsonPayloadRequired",
    "defaultMessage": 'You must provide a valid JSON payload'
  },
  webhooksettingssaved: {
    "id": "components.Settings.Notifications.NotificationsWebhook.webhooksettingssaved",
    "defaultMessage": 'Webhook notification settings saved successfully!'
  },
  webhooksettingsfailed: {
    "id": "components.Settings.Notifications.NotificationsWebhook.webhooksettingsfailed",
    "defaultMessage": 'Webhook notification settings failed to save.'
  },
  toastWebhookTestSending: {
    "id": "components.Settings.Notifications.NotificationsWebhook.toastWebhookTestSending",
    "defaultMessage": 'Sending webhook test notification…'
  },
  toastWebhookTestSuccess: {
    "id": "components.Settings.Notifications.NotificationsWebhook.toastWebhookTestSuccess",
    "defaultMessage": 'Webhook test notification sent!'
  },
  toastWebhookTestFailed: {
    "id": "components.Settings.Notifications.NotificationsWebhook.toastWebhookTestFailed",
    "defaultMessage": 'Webhook test notification failed to send.'
  },
  resetPayload: {
    "id": "components.Settings.Notifications.NotificationsWebhook.resetPayload",
    "defaultMessage": 'Reset to Default'
  },
  resetPayloadSuccess: {
    "id": "components.Settings.Notifications.NotificationsWebhook.resetPayloadSuccess",
    "defaultMessage": 'JSON payload reset successfully!'
  },
  customJson: {
    "id": "components.Settings.Notifications.NotificationsWebhook.customJson",
    "defaultMessage": 'JSON Payload'
  },
  templatevariablehelp: {
    "id": "components.Settings.Notifications.NotificationsWebhook.templatevariablehelp",
    "defaultMessage": 'Template Variable Help'
  },
  validationWebhookUrl: {
    "id": "components.Settings.Notifications.NotificationsWebhook.validationWebhookUrl",
    "defaultMessage": 'You must provide a valid URL'
  },
  validationTypes: {
    "id": "components.Settings.Notifications.NotificationsWebhook.validationTypes",
    "defaultMessage": 'You must select at least one notification type'
  }
});

const NotificationsWebhook = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_11__.useIntl)();
  const {
    addToast,
    removeToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_12__.useToasts)();
  const {
    0: isTesting,
    1: setIsTesting
  } = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_13__["default"])('/api/v1/settings/notifications/webhook');
  const NotificationsWebhookSchema = yup__WEBPACK_IMPORTED_MODULE_14__.object().shape({
    webhookUrl: yup__WEBPACK_IMPORTED_MODULE_14__.string().when('enabled', {
      is: true,
      then: yup__WEBPACK_IMPORTED_MODULE_14__.string().nullable().required(intl.formatMessage(messages.validationWebhookUrl)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_14__.string().nullable()
    }).matches( // eslint-disable-next-line no-useless-escape
    /^(https?:)?\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i, intl.formatMessage(messages.validationWebhookUrl)),
    jsonPayload: yup__WEBPACK_IMPORTED_MODULE_14__.string().when('enabled', {
      is: true,
      then: yup__WEBPACK_IMPORTED_MODULE_14__.string().nullable().required(intl.formatMessage(messages.validationJsonPayloadRequired)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_14__.string().nullable()
    }).test('validate-json', intl.formatMessage(messages.validationJsonPayloadRequired), value => {
      try {
        JSON.parse(value ?? '');
        return true;
      } catch (e) {
        return false;
      }
    })
  });

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Formik, {
    initialValues: {
      enabled: data.enabled,
      types: data.types,
      webhookUrl: data.options.webhookUrl,
      jsonPayload: data.options.jsonPayload,
      authHeader: data.options.authHeader
    },
    validationSchema: NotificationsWebhookSchema,
    onSubmit: async values => {
      try {
        await axios__WEBPACK_IMPORTED_MODULE_6__["default"].post('/api/v1/settings/notifications/webhook', {
          enabled: values.enabled,
          types: values.types,
          options: {
            webhookUrl: values.webhookUrl,
            jsonPayload: JSON.stringify(values.jsonPayload),
            authHeader: values.authHeader
          }
        });
        addToast(intl.formatMessage(messages.webhooksettingssaved), {
          appearance: 'success',
          autoDismiss: true
        });
      } catch (e) {
        addToast(intl.formatMessage(messages.webhooksettingsfailed), {
          appearance: 'error',
          autoDismiss: true
        });
      } finally {
        revalidate();
      }
    },
    children: ({
      errors,
      touched,
      isSubmitting,
      values,
      isValid,
      setFieldValue,
      setFieldTouched
    }) => {
      const resetPayload = () => {
        setFieldValue('jsonPayload', JSON.stringify(defaultPayload, undefined, '    '));
        addToast(intl.formatMessage(messages.resetPayloadSuccess), {
          appearance: 'info',
          autoDismiss: true
        });
      };

      const testSettings = async () => {
        setIsTesting(true);
        let toastId;

        try {
          addToast(intl.formatMessage(messages.toastWebhookTestSending), {
            autoDismiss: false,
            appearance: 'info'
          }, id => {
            toastId = id;
          });
          await axios__WEBPACK_IMPORTED_MODULE_6__["default"].post('/api/v1/settings/notifications/webhook/test', {
            enabled: true,
            types: values.types,
            options: {
              webhookUrl: values.webhookUrl,
              jsonPayload: JSON.stringify(values.jsonPayload),
              authHeader: values.authHeader
            }
          });

          if (toastId) {
            removeToast(toastId);
          }

          addToast(intl.formatMessage(messages.toastWebhookTestSuccess), {
            autoDismiss: true,
            appearance: 'success'
          });
        } catch (e) {
          if (toastId) {
            removeToast(toastId);
          }

          addToast(intl.formatMessage(messages.toastWebhookTestFailed), {
            autoDismiss: true,
            appearance: 'error'
          });
        } finally {
          setIsTesting(false);
        }
      };

      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_7__.Form, {
        className: "section",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("label", {
            htmlFor: "enabled",
            className: "checkbox-label",
            children: [intl.formatMessage(messages.agentenabled), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
              className: "label-required",
              children: "*"
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
              type: "checkbox",
              id: "enabled",
              name: "enabled"
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("label", {
            htmlFor: "webhookUrl",
            className: "text-label",
            children: [intl.formatMessage(messages.webhookUrl), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
              className: "label-required",
              children: "*"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "webhookUrl",
                name: "webhookUrl",
                type: "text",
                inputMode: "url"
              })
            }), errors.webhookUrl && touched.webhookUrl && typeof errors.webhookUrl === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
              className: "error",
              children: errors.webhookUrl
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("label", {
            htmlFor: "authHeader",
            className: "text-label",
            children: intl.formatMessage(messages.authheader)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "authHeader",
                name: "authHeader",
                type: "text"
              })
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("label", {
            htmlFor: "webhook-json-payload",
            className: "text-label",
            children: [intl.formatMessage(messages.customJson), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
              className: "label-required",
              children: "*"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(JSONEditor, {
                name: "webhook-json-payload",
                onUpdate: value => setFieldValue('jsonPayload', value),
                value: values.jsonPayload,
                onBlur: () => setFieldTouched('jsonPayload')
              })
            }), errors.jsonPayload && touched.jsonPayload && typeof errors.jsonPayload === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
              className: "error",
              children: errors.jsonPayload
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
              className: "mt-2",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonSize: "sm",
                onClick: e => {
                  e.preventDefault();
                  resetPayload();
                },
                className: "mr-2",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_5__.ArrowPathIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                  children: intl.formatMessage(messages.resetPayload)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx((next_link__WEBPACK_IMPORTED_MODULE_9___default()), {
                href: "https://docs.overseerr.dev/using-overseerr/notifications/webhooks#template-variables",
                passHref: true,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                  as: "a",
                  buttonSize: "sm",
                  target: "_blank",
                  rel: "noreferrer",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_5__.QuestionMarkCircleIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                    children: intl.formatMessage(messages.templatevariablehelp)
                  })]
                })
              })]
            })]
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP, {
          currentTypes: values.enabled ? values.types : 0,
          onUpdate: newTypes => {
            setFieldValue('types', newTypes);
            setFieldTouched('types');

            if (newTypes) {
              setFieldValue('enabled', true);
            }
          },
          error: values.enabled && !values.types && touched.types ? intl.formatMessage(messages.validationTypes) : undefined
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("div", {
          className: "actions",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
            className: "flex justify-end",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "warning",
                disabled: isSubmitting || !isValid || isTesting,
                onClick: e => {
                  e.preventDefault();
                  testSettings();
                },
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4__.BeakerIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                  children: isTesting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].testing */ .Z.testing) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].test */ .Z.test)
                })]
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "primary",
                type: "submit",
                disabled: isSubmitting || !isValid || isTesting || values.enabled && !values.types,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx("span", {
                  children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].save */ .Z.save)
                })]
              })
            })]
          })
        })]
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsWebhook);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 76596:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Settings_Notifications_NotificationsWebhook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55742);
/* harmony import */ var _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91865);
/* harmony import */ var _app_components_Settings_SettingsNotifications__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26433);
/* harmony import */ var _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(75691);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86799);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Settings_Notifications_NotificationsWebhook__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__, _app_components_Settings_SettingsNotifications__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__]);
([_app_components_Settings_Notifications_NotificationsWebhook__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__, _app_components_Settings_SettingsNotifications__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const NotificationsPage = () => {
  (0,_app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .Permission.ADMIN */ .y3.ADMIN);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Settings_SettingsNotifications__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Settings_Notifications_NotificationsWebhook__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {})
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 16098:
/***/ ((module) => {

module.exports = require("ace-builds/src-noconflict/ace");

/***/ }),

/***/ 817:
/***/ ((module) => {

module.exports = require("ace-builds/src-noconflict/mode-json");

/***/ }),

/***/ 82631:
/***/ ((module) => {

module.exports = require("ace-builds/src-noconflict/theme-dracula");

/***/ }),

/***/ 2296:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 46517:
/***/ ((module) => {

module.exports = require("lodash");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 95832:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/loadable.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 78692:
/***/ ((module) => {

module.exports = require("react-ace");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 75609:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,5152,1388,61439,19998,80210,86799,33173,17969,92012,35754,26433], () => (__webpack_exec__(76596)));
module.exports = __webpack_exports__;

})();