"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const settings_1 = require("../../lib/settings");
const email_templates_1 = __importDefault(require("email-templates"));
const nodemailer_1 = __importDefault(require("nodemailer"));
const url_1 = require("url");
const openpgpEncrypt_1 = require("./openpgpEncrypt");
class PreparedEmail extends email_templates_1.default {
    constructor(settings, pgpKey) {
        const { applicationUrl } = (0, settings_1.getSettings)().main;
        const transport = nodemailer_1.default.createTransport({
            name: applicationUrl ? new url_1.URL(applicationUrl).hostname : undefined,
            host: settings.options.smtpHost,
            port: settings.options.smtpPort,
            secure: settings.options.secure,
            ignoreTLS: settings.options.ignoreTls,
            requireTLS: settings.options.requireTls,
            tls: settings.options.allowSelfSigned
                ? {
                    rejectUnauthorized: false,
                }
                : undefined,
            auth: settings.options.authUser && settings.options.authPass
                ? {
                    user: settings.options.authUser,
                    pass: settings.options.authPass,
                }
                : undefined,
        });
        if (pgpKey) {
            transport.use('stream', (0, openpgpEncrypt_1.openpgpEncrypt)({
                signingKey: settings.options.pgpPrivateKey,
                password: settings.options.pgpPassword,
                encryptionKeys: [pgpKey],
            }));
        }
        super({
            message: {
                from: {
                    name: settings.options.senderName,
                    address: settings.options.emailFrom,
                },
            },
            send: true,
            transport: transport,
        });
    }
}
exports.default = PreparedEmail;
