"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const issue_1 = require("../../../constants/issue");
const datasource_1 = require("../../../datasource");
const User_1 = require("../../../entity/User");
const settings_1 = require("../../../lib/settings");
const logger_1 = __importDefault(require("../../../logger"));
const axios_1 = __importDefault(require("axios"));
const __1 = require("..");
const agent_1 = require("./agent");
var EmbedColors;
(function (EmbedColors) {
    EmbedColors[EmbedColors["DEFAULT"] = 0] = "DEFAULT";
    EmbedColors[EmbedColors["AQUA"] = 1752220] = "AQUA";
    EmbedColors[EmbedColors["GREEN"] = 3066993] = "GREEN";
    EmbedColors[EmbedColors["BLUE"] = 3447003] = "BLUE";
    EmbedColors[EmbedColors["PURPLE"] = 10181046] = "PURPLE";
    EmbedColors[EmbedColors["GOLD"] = 15844367] = "GOLD";
    EmbedColors[EmbedColors["ORANGE"] = 15105570] = "ORANGE";
    EmbedColors[EmbedColors["RED"] = 15158332] = "RED";
    EmbedColors[EmbedColors["GREY"] = 9807270] = "GREY";
    EmbedColors[EmbedColors["DARKER_GREY"] = 8359053] = "DARKER_GREY";
    EmbedColors[EmbedColors["NAVY"] = 3426654] = "NAVY";
    EmbedColors[EmbedColors["DARK_AQUA"] = 1146986] = "DARK_AQUA";
    EmbedColors[EmbedColors["DARK_GREEN"] = 2067276] = "DARK_GREEN";
    EmbedColors[EmbedColors["DARK_BLUE"] = 2123412] = "DARK_BLUE";
    EmbedColors[EmbedColors["DARK_PURPLE"] = 7419530] = "DARK_PURPLE";
    EmbedColors[EmbedColors["DARK_GOLD"] = 12745742] = "DARK_GOLD";
    EmbedColors[EmbedColors["DARK_ORANGE"] = 11027200] = "DARK_ORANGE";
    EmbedColors[EmbedColors["DARK_RED"] = 10038562] = "DARK_RED";
    EmbedColors[EmbedColors["DARK_GREY"] = 9936031] = "DARK_GREY";
    EmbedColors[EmbedColors["LIGHT_GREY"] = 12370112] = "LIGHT_GREY";
    EmbedColors[EmbedColors["DARK_NAVY"] = 2899536] = "DARK_NAVY";
    EmbedColors[EmbedColors["LUMINOUS_VIVID_PINK"] = 16580705] = "LUMINOUS_VIVID_PINK";
    EmbedColors[EmbedColors["DARK_VIVID_PINK"] = 12320855] = "DARK_VIVID_PINK";
})(EmbedColors || (EmbedColors = {}));
class DiscordAgent extends agent_1.BaseAgent {
    getSettings() {
        if (this.settings) {
            return this.settings;
        }
        const settings = (0, settings_1.getSettings)();
        return settings.notifications.agents.discord;
    }
    buildEmbed(type, payload) {
        const { applicationUrl } = (0, settings_1.getSettings)().main;
        let color = EmbedColors.DARK_PURPLE;
        const fields = [];
        if (payload.request) {
            fields.push({
                name: 'Requested By',
                value: payload.request.requestedBy.displayName,
                inline: true,
            });
            let status = '';
            switch (type) {
                case __1.Notification.MEDIA_PENDING:
                    color = EmbedColors.ORANGE;
                    status = 'Pending Approval';
                    break;
                case __1.Notification.MEDIA_APPROVED:
                case __1.Notification.MEDIA_AUTO_APPROVED:
                    color = EmbedColors.PURPLE;
                    status = 'Processing';
                    break;
                case __1.Notification.MEDIA_AVAILABLE:
                    color = EmbedColors.GREEN;
                    status = 'Available';
                    break;
                case __1.Notification.MEDIA_DECLINED:
                    color = EmbedColors.RED;
                    status = 'Declined';
                    break;
                case __1.Notification.MEDIA_FAILED:
                    color = EmbedColors.RED;
                    status = 'Failed';
                    break;
            }
            if (status) {
                fields.push({
                    name: 'Request Status',
                    value: status,
                    inline: true,
                });
            }
        }
        else if (payload.comment) {
            fields.push({
                name: `Comment from ${payload.comment.user.displayName}`,
                value: payload.comment.message,
                inline: false,
            });
        }
        else if (payload.issue) {
            fields.push({
                name: 'Reported By',
                value: payload.issue.createdBy.displayName,
                inline: true,
            }, {
                name: 'Issue Type',
                value: issue_1.IssueTypeName[payload.issue.issueType],
                inline: true,
            }, {
                name: 'Issue Status',
                value: payload.issue.status === issue_1.IssueStatus.OPEN ? 'Open' : 'Resolved',
                inline: true,
            });
            switch (type) {
                case __1.Notification.ISSUE_CREATED:
                case __1.Notification.ISSUE_REOPENED:
                    color = EmbedColors.RED;
                    break;
                case __1.Notification.ISSUE_COMMENT:
                    color = EmbedColors.ORANGE;
                    break;
                case __1.Notification.ISSUE_RESOLVED:
                    color = EmbedColors.GREEN;
                    break;
            }
        }
        for (const extra of payload.extra ?? []) {
            fields.push({
                name: extra.name,
                value: extra.value,
                inline: true,
            });
        }
        const url = applicationUrl
            ? payload.issue
                ? `${applicationUrl}/issues/${payload.issue.id}`
                : payload.media
                    ? `${applicationUrl}/${payload.media.mediaType}/${payload.media.tmdbId}`
                    : undefined
            : undefined;
        return {
            title: payload.subject,
            url,
            description: payload.message,
            color,
            timestamp: new Date().toISOString(),
            author: payload.event
                ? {
                    name: payload.event,
                }
                : undefined,
            fields,
            thumbnail: {
                url: payload.image,
            },
        };
    }
    shouldSend() {
        const settings = this.getSettings();
        if (settings.enabled && settings.options.webhookUrl) {
            return true;
        }
        return false;
    }
    async send(type, payload) {
        const settings = this.getSettings();
        if (!payload.notifySystem ||
            !(0, __1.hasNotificationType)(type, settings.types ?? 0)) {
            return true;
        }
        logger_1.default.debug('Sending Discord notification', {
            label: 'Notifications',
            type: __1.Notification[type],
            subject: payload.subject,
        });
        const userMentions = [];
        try {
            if (settings.options.enableMentions) {
                if (payload.notifyUser) {
                    if (payload.notifyUser.settings?.hasNotificationType(settings_1.NotificationAgentKey.DISCORD, type) &&
                        payload.notifyUser.settings.discordId) {
                        userMentions.push(`<@${payload.notifyUser.settings.discordId}>`);
                    }
                }
                if (payload.notifyAdmin) {
                    const userRepository = (0, datasource_1.getRepository)(User_1.User);
                    const users = await userRepository.find();
                    userMentions.push(...users
                        .filter((user) => user.settings?.hasNotificationType(settings_1.NotificationAgentKey.DISCORD, type) &&
                        user.settings.discordId &&
                        (0, __1.shouldSendAdminNotification)(type, user, payload))
                        .map((user) => `<@${user.settings?.discordId}>`));
                }
            }
            await axios_1.default.post(settings.options.webhookUrl, {
                username: settings.options.botUsername
                    ? settings.options.botUsername
                    : (0, settings_1.getSettings)().main.applicationTitle,
                avatar_url: settings.options.botAvatarUrl,
                embeds: [this.buildEmbed(type, payload)],
                content: userMentions.join(' '),
            });
            return true;
        }
        catch (e) {
            logger_1.default.error('Error sending Discord notification', {
                label: 'Notifications',
                type: __1.Notification[type],
                subject: payload.subject,
                errorMessage: e.message,
                response: e.response?.data,
            });
            return false;
        }
    }
}
exports.default = DiscordAgent;
