import { AriaButtonProps } from "@react-types/button";
import { AriaListBoxOptions } from "@react-aria/listbox";
import { AriaSelectProps } from "@react-types/select";
import { DOMAttributes, FocusableElement, KeyboardDelegate } from "@react-types/shared";
import React, { RefObject, ReactNode } from "react";
import { SelectState } from "@react-stately/select";
export interface AriaSelectOptions<T> extends AriaSelectProps<T> {
    /**
     * An optional keyboard delegate implementation for type to select,
     * to override the default.
     */
    keyboardDelegate?: KeyboardDelegate;
}
export interface SelectAria<T> {
    /** Props for the label element. */
    labelProps: DOMAttributes;
    /** Props for the popup trigger element. */
    triggerProps: AriaButtonProps;
    /** Props for the element representing the selected value. */
    valueProps: DOMAttributes;
    /** Props for the popup. */
    menuProps: AriaListBoxOptions<T>;
    /** Props for the select's description element, if any. */
    descriptionProps: DOMAttributes;
    /** Props for the select's error message element, if any. */
    errorMessageProps: DOMAttributes;
}
/**
 * Provides the behavior and accessibility implementation for a select component.
 * A select displays a collapsible list of options and allows a user to select one of them.
 * @param props - Props for the select.
 * @param state - State for the select, as returned by `useListState`.
 */
export function useSelect<T>(props: AriaSelectOptions<T>, state: SelectState<T>, ref: RefObject<FocusableElement>): SelectAria<T>;
export interface AriaHiddenSelectProps {
    /**
     * Describes the type of autocomplete functionality the input should provide if any. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefautocomplete).
     */
    autoComplete?: string;
    /** The text label for the select. */
    label?: ReactNode;
    /** HTML form input name. */
    name?: string;
    /** Sets the disabled state of the select and input. */
    isDisabled?: boolean;
}
export interface HiddenSelectProps<T> extends AriaHiddenSelectProps {
    /** State for the select. */
    state: SelectState<T>;
    /** A ref to the trigger element. */
    triggerRef: RefObject<FocusableElement>;
}
/**
 * Provides the behavior and accessibility implementation for a hidden `<select>` element, which
 * can be used in combination with `useSelect` to support browser form autofill, mobile form
 * navigation, and native HTML form submission.
 */
export function useHiddenSelect<T>(props: AriaHiddenSelectProps, state: SelectState<T>, triggerRef: RefObject<FocusableElement>): {
    containerProps: {
        'aria-hidden': boolean;
        id?: string;
        role?: React.AriaRole;
        tabIndex?: number;
        style?: React.CSSProperties;
        className?: string;
        'aria-activedescendant'?: string;
        'aria-atomic'?: boolean | "false" | "true";
        'aria-autocomplete'?: "inline" | "both" | "none" | "list";
        'aria-busy'?: boolean | "false" | "true";
        'aria-checked'?: boolean | "mixed" | "false" | "true";
        'aria-colcount'?: number;
        'aria-colindex'?: number;
        'aria-colspan'?: number;
        'aria-controls'?: string;
        'aria-current'?: boolean | "location" | "time" | "false" | "page" | "true" | "step" | "date";
        'aria-describedby'?: string;
        'aria-details'?: string;
        'aria-disabled'?: boolean | "false" | "true";
        'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup";
        'aria-errormessage'?: string;
        'aria-expanded'?: boolean | "false" | "true";
        'aria-flowto'?: string;
        'aria-grabbed'?: boolean | "false" | "true";
        'aria-haspopup'?: boolean | "grid" | "dialog" | "menu" | "false" | "listbox" | "true" | "tree";
        'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling";
        'aria-keyshortcuts'?: string;
        'aria-label'?: string;
        'aria-labelledby'?: string;
        'aria-level'?: number;
        'aria-live'?: "off" | "assertive" | "polite";
        'aria-modal'?: boolean | "false" | "true";
        'aria-multiline'?: boolean | "false" | "true";
        'aria-multiselectable'?: boolean | "false" | "true";
        'aria-orientation'?: "horizontal" | "vertical";
        'aria-owns'?: string;
        'aria-placeholder'?: string;
        'aria-posinset'?: number;
        'aria-pressed'?: boolean | "mixed" | "false" | "true";
        'aria-readonly'?: boolean | "false" | "true";
        'aria-relevant'?: "all" | "text" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals";
        'aria-required'?: boolean | "false" | "true";
        'aria-roledescription'?: string;
        'aria-rowcount'?: number;
        'aria-rowindex'?: number;
        'aria-rowspan'?: number;
        'aria-selected'?: boolean | "false" | "true";
        'aria-setsize'?: number;
        'aria-sort'?: "none" | "other" | "ascending" | "descending";
        'aria-valuemax'?: number;
        'aria-valuemin'?: number;
        'aria-valuenow'?: number;
        'aria-valuetext'?: string;
        children?: React.ReactNode;
        dangerouslySetInnerHTML?: {
            __html: string;
        };
        onCopy?: React.ClipboardEventHandler<FocusableElement>;
        onCopyCapture?: React.ClipboardEventHandler<FocusableElement>;
        onCut?: React.ClipboardEventHandler<FocusableElement>;
        onCutCapture?: React.ClipboardEventHandler<FocusableElement>;
        onPaste?: React.ClipboardEventHandler<FocusableElement>;
        onPasteCapture?: React.ClipboardEventHandler<FocusableElement>;
        onCompositionEnd?: React.CompositionEventHandler<FocusableElement>;
        onCompositionEndCapture?: React.CompositionEventHandler<FocusableElement>;
        onCompositionStart?: React.CompositionEventHandler<FocusableElement>;
        onCompositionStartCapture?: React.CompositionEventHandler<FocusableElement>;
        onCompositionUpdate?: React.CompositionEventHandler<FocusableElement>;
        onCompositionUpdateCapture?: React.CompositionEventHandler<FocusableElement>;
        onFocus?: React.FocusEventHandler<FocusableElement>;
        onFocusCapture?: React.FocusEventHandler<FocusableElement>;
        onBlur?: React.FocusEventHandler<FocusableElement>;
        onBlurCapture?: React.FocusEventHandler<FocusableElement>;
        onChange?: React.FormEventHandler<FocusableElement>;
        onChangeCapture?: React.FormEventHandler<FocusableElement>;
        onBeforeInput?: React.FormEventHandler<FocusableElement>;
        onBeforeInputCapture?: React.FormEventHandler<FocusableElement>;
        onInput?: React.FormEventHandler<FocusableElement>;
        onInputCapture?: React.FormEventHandler<FocusableElement>;
        onReset?: React.FormEventHandler<FocusableElement>;
        onResetCapture?: React.FormEventHandler<FocusableElement>;
        onSubmit?: React.FormEventHandler<FocusableElement>;
        onSubmitCapture?: React.FormEventHandler<FocusableElement>;
        onInvalid?: React.FormEventHandler<FocusableElement>;
        onInvalidCapture?: React.FormEventHandler<FocusableElement>;
        onLoad?: React.ReactEventHandler<FocusableElement>;
        onLoadCapture?: React.ReactEventHandler<FocusableElement>;
        onError?: React.ReactEventHandler<FocusableElement>;
        onErrorCapture?: React.ReactEventHandler<FocusableElement>;
        onKeyDown?: React.KeyboardEventHandler<FocusableElement>;
        onKeyDownCapture?: React.KeyboardEventHandler<FocusableElement>;
        onKeyPress?: React.KeyboardEventHandler<FocusableElement>;
        onKeyPressCapture?: React.KeyboardEventHandler<FocusableElement>;
        onKeyUp?: React.KeyboardEventHandler<FocusableElement>;
        onKeyUpCapture?: React.KeyboardEventHandler<FocusableElement>;
        onAbort?: React.ReactEventHandler<FocusableElement>;
        onAbortCapture?: React.ReactEventHandler<FocusableElement>;
        onCanPlay?: React.ReactEventHandler<FocusableElement>;
        onCanPlayCapture?: React.ReactEventHandler<FocusableElement>;
        onCanPlayThrough?: React.ReactEventHandler<FocusableElement>;
        onCanPlayThroughCapture?: React.ReactEventHandler<FocusableElement>;
        onDurationChange?: React.ReactEventHandler<FocusableElement>;
        onDurationChangeCapture?: React.ReactEventHandler<FocusableElement>;
        onEmptied?: React.ReactEventHandler<FocusableElement>;
        onEmptiedCapture?: React.ReactEventHandler<FocusableElement>;
        onEncrypted?: React.ReactEventHandler<FocusableElement>;
        onEncryptedCapture?: React.ReactEventHandler<FocusableElement>;
        onEnded?: React.ReactEventHandler<FocusableElement>;
        onEndedCapture?: React.ReactEventHandler<FocusableElement>;
        onLoadedData?: React.ReactEventHandler<FocusableElement>;
        onLoadedDataCapture?: React.ReactEventHandler<FocusableElement>;
        onLoadedMetadata?: React.ReactEventHandler<FocusableElement>;
        onLoadedMetadataCapture?: React.ReactEventHandler<FocusableElement>;
        onLoadStart?: React.ReactEventHandler<FocusableElement>;
        onLoadStartCapture?: React.ReactEventHandler<FocusableElement>;
        onPause?: React.ReactEventHandler<FocusableElement>;
        onPauseCapture?: React.ReactEventHandler<FocusableElement>;
        onPlay?: React.ReactEventHandler<FocusableElement>;
        onPlayCapture?: React.ReactEventHandler<FocusableElement>;
        onPlaying?: React.ReactEventHandler<FocusableElement>;
        onPlayingCapture?: React.ReactEventHandler<FocusableElement>;
        onProgress?: React.ReactEventHandler<FocusableElement>;
        onProgressCapture?: React.ReactEventHandler<FocusableElement>;
        onRateChange?: React.ReactEventHandler<FocusableElement>;
        onRateChangeCapture?: React.ReactEventHandler<FocusableElement>;
        onSeeked?: React.ReactEventHandler<FocusableElement>;
        onSeekedCapture?: React.ReactEventHandler<FocusableElement>;
        onSeeking?: React.ReactEventHandler<FocusableElement>;
        onSeekingCapture?: React.ReactEventHandler<FocusableElement>;
        onStalled?: React.ReactEventHandler<FocusableElement>;
        onStalledCapture?: React.ReactEventHandler<FocusableElement>;
        onSuspend?: React.ReactEventHandler<FocusableElement>;
        onSuspendCapture?: React.ReactEventHandler<FocusableElement>;
        onTimeUpdate?: React.ReactEventHandler<FocusableElement>;
        onTimeUpdateCapture?: React.ReactEventHandler<FocusableElement>;
        onVolumeChange?: React.ReactEventHandler<FocusableElement>;
        onVolumeChangeCapture?: React.ReactEventHandler<FocusableElement>;
        onWaiting?: React.ReactEventHandler<FocusableElement>;
        onWaitingCapture?: React.ReactEventHandler<FocusableElement>;
        onAuxClick?: React.MouseEventHandler<FocusableElement>;
        onAuxClickCapture?: React.MouseEventHandler<FocusableElement>;
        onClick?: React.MouseEventHandler<FocusableElement>;
        onClickCapture?: React.MouseEventHandler<FocusableElement>;
        onContextMenu?: React.MouseEventHandler<FocusableElement>;
        onContextMenuCapture?: React.MouseEventHandler<FocusableElement>;
        onDoubleClick?: React.MouseEventHandler<FocusableElement>;
        onDoubleClickCapture?: React.MouseEventHandler<FocusableElement>;
        onDrag?: React.DragEventHandler<FocusableElement>;
        onDragCapture?: React.DragEventHandler<FocusableElement>;
        onDragEnd?: React.DragEventHandler<FocusableElement>;
        onDragEndCapture?: React.DragEventHandler<FocusableElement>;
        onDragEnter?: React.DragEventHandler<FocusableElement>;
        onDragEnterCapture?: React.DragEventHandler<FocusableElement>;
        onDragExit?: React.DragEventHandler<FocusableElement>;
        onDragExitCapture?: React.DragEventHandler<FocusableElement>;
        onDragLeave?: React.DragEventHandler<FocusableElement>;
        onDragLeaveCapture?: React.DragEventHandler<FocusableElement>;
        onDragOver?: React.DragEventHandler<FocusableElement>;
        onDragOverCapture?: React.DragEventHandler<FocusableElement>;
        onDragStart?: React.DragEventHandler<FocusableElement>;
        onDragStartCapture?: React.DragEventHandler<FocusableElement>;
        onDrop?: React.DragEventHandler<FocusableElement>;
        onDropCapture?: React.DragEventHandler<FocusableElement>;
        onMouseDown?: React.MouseEventHandler<FocusableElement>;
        onMouseDownCapture?: React.MouseEventHandler<FocusableElement>;
        onMouseEnter?: React.MouseEventHandler<FocusableElement>;
        onMouseLeave?: React.MouseEventHandler<FocusableElement>;
        onMouseMove?: React.MouseEventHandler<FocusableElement>;
        onMouseMoveCapture?: React.MouseEventHandler<FocusableElement>;
        onMouseOut?: React.MouseEventHandler<FocusableElement>;
        onMouseOutCapture?: React.MouseEventHandler<FocusableElement>;
        onMouseOver?: React.MouseEventHandler<FocusableElement>;
        onMouseOverCapture?: React.MouseEventHandler<FocusableElement>;
        onMouseUp?: React.MouseEventHandler<FocusableElement>;
        onMouseUpCapture?: React.MouseEventHandler<FocusableElement>;
        onSelect?: React.ReactEventHandler<FocusableElement>;
        onSelectCapture?: React.ReactEventHandler<FocusableElement>;
        onTouchCancel?: React.TouchEventHandler<FocusableElement>;
        onTouchCancelCapture?: React.TouchEventHandler<FocusableElement>;
        onTouchEnd?: React.TouchEventHandler<FocusableElement>;
        onTouchEndCapture?: React.TouchEventHandler<FocusableElement>;
        onTouchMove?: React.TouchEventHandler<FocusableElement>;
        onTouchMoveCapture?: React.TouchEventHandler<FocusableElement>;
        onTouchStart?: React.TouchEventHandler<FocusableElement>;
        onTouchStartCapture?: React.TouchEventHandler<FocusableElement>;
        onPointerDown?: React.PointerEventHandler<FocusableElement>;
        onPointerDownCapture?: React.PointerEventHandler<FocusableElement>;
        onPointerMove?: React.PointerEventHandler<FocusableElement>;
        onPointerMoveCapture?: React.PointerEventHandler<FocusableElement>;
        onPointerUp?: React.PointerEventHandler<FocusableElement>;
        onPointerUpCapture?: React.PointerEventHandler<FocusableElement>;
        onPointerCancel?: React.PointerEventHandler<FocusableElement>;
        onPointerCancelCapture?: React.PointerEventHandler<FocusableElement>;
        onPointerEnter?: React.PointerEventHandler<FocusableElement>;
        onPointerEnterCapture?: React.PointerEventHandler<FocusableElement>;
        onPointerLeave?: React.PointerEventHandler<FocusableElement>;
        onPointerLeaveCapture?: React.PointerEventHandler<FocusableElement>;
        onPointerOver?: React.PointerEventHandler<FocusableElement>;
        onPointerOverCapture?: React.PointerEventHandler<FocusableElement>;
        onPointerOut?: React.PointerEventHandler<FocusableElement>;
        onPointerOutCapture?: React.PointerEventHandler<FocusableElement>;
        onGotPointerCapture?: React.PointerEventHandler<FocusableElement>;
        onGotPointerCaptureCapture?: React.PointerEventHandler<FocusableElement>;
        onLostPointerCapture?: React.PointerEventHandler<FocusableElement>;
        onLostPointerCaptureCapture?: React.PointerEventHandler<FocusableElement>;
        onScroll?: React.UIEventHandler<FocusableElement>;
        onScrollCapture?: React.UIEventHandler<FocusableElement>;
        onWheel?: React.WheelEventHandler<FocusableElement>;
        onWheelCapture?: React.WheelEventHandler<FocusableElement>;
        onAnimationStart?: React.AnimationEventHandler<FocusableElement>;
        onAnimationStartCapture?: React.AnimationEventHandler<FocusableElement>;
        onAnimationEnd?: React.AnimationEventHandler<FocusableElement>;
        onAnimationEndCapture?: React.AnimationEventHandler<FocusableElement>;
        onAnimationIteration?: React.AnimationEventHandler<FocusableElement>;
        onAnimationIterationCapture?: React.AnimationEventHandler<FocusableElement>;
        onTransitionEnd?: React.TransitionEventHandler<FocusableElement>;
        onTransitionEndCapture?: React.TransitionEventHandler<FocusableElement>;
    };
    inputProps: {
        type: string;
        tabIndex: number;
        style: {
            fontSize: number;
        };
        onFocus: () => void;
        disabled: boolean;
    };
    selectProps: {
        tabIndex: number;
        autoComplete: string;
        disabled: boolean;
        name: string;
        size: number;
        value: React.Key;
        onChange: (e: React.ChangeEvent<HTMLSelectElement>) => void;
    };
};
/**
 * Renders a hidden native `<select>` element, which can be used to support browser
 * form autofill, mobile form navigation, and native form submission.
 */
export function HiddenSelect<T>(props: HiddenSelectProps<T>): JSX.Element;

//# sourceMappingURL=types.d.ts.map
