export declare class InteractsWithHeaders {
    /**
     * The wrapped request instance.
     */
    private readonly _headers;
    /**
     * Create a new instance for the given `request`.
     *
     * @param {Object} headers
     */
    constructor(headers: any);
    /**
     * Returns the request headers.
     *
     * @param {Object} requestHeaders
     *
     * @returns {Object}
     */
    private asMap;
    /**
     * Returns the lowercased string of `str`.
     *
     * @param {String} str
     *
     * @returns {String}
     */
    lower(str: string): string;
    /**
     * Returns the request headers.
     *
     * @returns {Map}
     */
    headers(): Map<string, string>;
    /**
     * Determine whether the request comes with headers.
     *
     * @returns {Boolean}
     */
    hasHeaders(): boolean;
    /**
     * Returns a request header if available, undefined otherwise.
     *
     * @param {String} name - the header name
     *
     * @returns {String}
     */
    header(name: string): string | undefined;
}
