'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.InteractsWithHeaders = void 0;
class InteractsWithHeaders {
    /**
     * Create a new instance for the given `request`.
     *
     * @param {Object} headers
     */
    constructor(headers) {
        this._headers = this.asMap(headers || {});
    }
    /**
     * Returns the request headers.
     *
     * @param {Object} requestHeaders
     *
     * @returns {Object}
     */
    asMap(requestHeaders) {
        const headers = new Map();
        Object.keys(requestHeaders).forEach(name => {
            const value = requestHeaders[name];
            headers.set(this.lower(name), value ? this.lower(value) : value);
        });
        return headers;
    }
    /**
     * Returns the lowercased string of `str`.
     *
     * @param {String} str
     *
     * @returns {String}
     */
    lower(str) {
        return String(str).toLowerCase();
    }
    /**
     * Returns the request headers.
     *
     * @returns {Map}
     */
    headers() {
        return this._headers;
    }
    /**
     * Determine whether the request comes with headers.
     *
     * @returns {Boolean}
     */
    hasHeaders() {
        return this.headers().size > 0;
    }
    /**
     * Returns a request header if available, undefined otherwise.
     *
     * @param {String} name - the header name
     *
     * @returns {String}
     */
    header(name) {
        return this.headers().get(name);
    }
}
exports.InteractsWithHeaders = InteractsWithHeaders;
