import _objectWithoutPropertiesLoose from '@babel/runtime/helpers/objectWithoutPropertiesLoose';
import _extends from '@babel/runtime/helpers/extends';
import * as React from 'react';
import { useEffect, useRef, useCallback, useState } from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';

var clamp = function clamp(num, lower, upper) {
  num = num <= upper ? num : upper;
  num = num >= lower ? num : lower;
  return num;
};

var createQueue = function createQueue() {
  var isRunning = false;
  var pending = [];
  var next = function next() {
    isRunning = true;
    var cb = pending.shift();
    if (cb) {
      return cb(next);
    }
    isRunning = false;
  };
  var clear = function clear() {
    isRunning = false;
    pending = [];
  };
  var enqueue = function enqueue(cb) {
    pending.push(cb);
    if (!isRunning && pending.length === 1) {
      next();
    }
  };
  return {
    clear: clear,
    enqueue: enqueue
  };
};

var createTimeout = function createTimeout() {
  var handle;
  var cancel = function cancel() {
    if (handle) {
      window.cancelAnimationFrame(handle);
    }
  };
  var schedule = function schedule(callback, delay) {
    var deltaTime;
    var start;
    var frame = function frame(time) {
      start = start || time;
      deltaTime = time - start;
      if (deltaTime > delay) {
        callback();
        return;
      }
      handle = window.requestAnimationFrame(frame);
    };
    handle = window.requestAnimationFrame(frame);
  };
  return {
    cancel: cancel,
    schedule: schedule
  };
};

var increment = function increment(progress) {
  var amount = 0;
  if (progress >= 0 && progress < 0.2) {
    amount = 0.1;
  } else if (progress >= 0.2 && progress < 0.5) {
    amount = 0.04;
  } else if (progress >= 0.5 && progress < 0.8) {
    amount = 0.02;
  } else if (progress >= 0.8 && progress < 0.99) {
    amount = 0.005;
  }
  return clamp(progress + amount, 0, 0.994);
};

// Hat-tip:
var useEffectOnce = function useEffectOnce(effect) {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  useEffect(effect, []);
};

var incrementParameter = function incrementParameter(num) {
  return ++num % 1000000;
};
var useUpdate = function useUpdate() {
  var _useState = useState(0),
    setState = _useState[1];
  return useCallback(function () {
    return setState(incrementParameter);
  }, []);
};
var useGetSetState = function useGetSetState( /* istanbul ignore next */
initialState) {
  if (initialState === void 0) {
    initialState = {};
  }
  var update = useUpdate();
  var state = useRef(_extends({}, initialState));
  var get = useCallback(function () {
    return state.current;
  }, []);
  var set = useCallback(function (patch) {
    if (!patch) {
      return;
    }
    Object.assign(state.current, patch);
    update();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return [get, set];
};

// Hat-tip:
var useFirstMountState = function useFirstMountState() {
  var isFirst = useRef(true);
  if (isFirst.current) {
    isFirst.current = false;
    return true;
  }
  return isFirst.current;
};
var useUpdateEffect = function useUpdateEffect(effect, deps) {
  var isFirstMount = useFirstMountState();
  useEffect(function () {
    if (!isFirstMount) {
      return effect();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, deps);
};

/* istanbul ignore next */
var noop = function noop() {
  return undefined;
};
var initialState = {
  isFinished: true,
  progress: 0,
  sideEffect: noop
};
var useNProgress = function useNProgress(_temp) {
  var _ref = _temp === void 0 ? {} : _temp,
    _ref$animationDuratio = _ref.animationDuration,
    animationDuration = _ref$animationDuratio === void 0 ? 200 : _ref$animationDuratio,
    _ref$incrementDuratio = _ref.incrementDuration,
    incrementDuration = _ref$incrementDuratio === void 0 ? 800 : _ref$incrementDuratio,
    _ref$isAnimating = _ref.isAnimating,
    isAnimating = _ref$isAnimating === void 0 ? false : _ref$isAnimating,
    _ref$minimum = _ref.minimum,
    minimum = _ref$minimum === void 0 ? 0.08 : _ref$minimum;
  var _useGetSetState = useGetSetState(initialState),
    get = _useGetSetState[0],
    setState = _useGetSetState[1];
  var queue = useRef(null);
  var timeout = useRef(null);
  useEffectOnce(function () {
    queue.current = createQueue();
    timeout.current = createTimeout();
  });
  var cleanup = useCallback(function () {
    var _timeout$current, _queue$current;
    (_timeout$current = timeout.current) == null ? void 0 : _timeout$current.cancel();
    (_queue$current = queue.current) == null ? void 0 : _queue$current.clear();
  }, []);
  var set = useCallback(function (n) {
    var _queue$current4;
    n = clamp(n, minimum, 1);
    if (n === 1) {
      var _queue$current2, _queue$current3;
      cleanup();
      (_queue$current2 = queue.current) == null ? void 0 : _queue$current2.enqueue(function (next) {
        setState({
          progress: n,
          sideEffect: function sideEffect() {
            var _timeout$current2;
            return (_timeout$current2 = timeout.current) == null ? void 0 : _timeout$current2.schedule(next, animationDuration);
          }
        });
      });
      (_queue$current3 = queue.current) == null ? void 0 : _queue$current3.enqueue(function () {
        setState({
          isFinished: true,
          sideEffect: cleanup
        });
      });
      return;
    }
    (_queue$current4 = queue.current) == null ? void 0 : _queue$current4.enqueue(function (next) {
      setState({
        isFinished: false,
        progress: n,
        sideEffect: function sideEffect() {
          var _timeout$current3;
          return (_timeout$current3 = timeout.current) == null ? void 0 : _timeout$current3.schedule(next, animationDuration);
        }
      });
    });
  }, [animationDuration, cleanup, minimum, queue, setState, timeout]);
  var trickle = useCallback(function () {
    set(increment(get().progress));
  }, [get, set]);
  var start = useCallback(function () {
    var work = function work() {
      var _queue$current5;
      trickle();
      (_queue$current5 = queue.current) == null ? void 0 : _queue$current5.enqueue(function (next) {
        var _timeout$current4;
        (_timeout$current4 = timeout.current) == null ? void 0 : _timeout$current4.schedule(function () {
          work();
          next();
        }, incrementDuration);
      });
    };
    work();
  }, [incrementDuration, queue, timeout, trickle]);
  var savedTrickle = useRef(noop);
  var sideEffect = get().sideEffect;
  useEffect(function () {
    savedTrickle.current = trickle;
  });
  useEffectOnce(function () {
    if (isAnimating) {
      start();
    }
    return cleanup;
  });
  useUpdateEffect(function () {
    get().sideEffect();
  }, [get, sideEffect]);
  useUpdateEffect(function () {
    if (!isAnimating) {
      set(1);
    } else {
      setState(_extends({}, initialState, {
        sideEffect: start
      }));
    }
  }, [isAnimating, set, setState, start]);
  return {
    animationDuration: animationDuration,
    isFinished: get().isFinished,
    progress: get().progress
  };
};

var _excluded = ["children"];
var NProgress = function NProgress(_ref) {
  var children = _ref.children,
    restProps = _objectWithoutPropertiesLoose(_ref, _excluded);
  var renderProps = useNProgress(restProps);
  return children(renderProps);
};

function withNProgress(BaseComponent) {
  var WithNProgress = function WithNProgress(props) {
    var hookProps = useNProgress(props);
    return /*#__PURE__*/React.createElement(BaseComponent, _extends({}, props, hookProps));
  };
  hoistNonReactStatics(WithNProgress, BaseComponent);
  return WithNProgress;
}

export { NProgress, useNProgress, withNProgress };
//# sourceMappingURL=react-nprogress.esm.js.map
