var TOKENIZE_POLICY = {
  characters: {
    tokenizeString: null,
    isAtomic: function isAtomic(str) {
      return str.length <= 1;
    }
  },
  words: {
    tokenizeString: function tokenizeString(str) {
      return str.match(/(\s*\S[\S\xA0]*)/g);
    },
    isAtomic: function isAtomic(str) {
      return (/^\s*[\S\xA0]*\s*$/.test(str)
      );
    }
  }
};

export default TOKENIZE_POLICY;